// HardCopyHistoryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "HardCopyHistoryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHardCopyHistoryDlg dialog


CHardCopyHistoryDlg::CHardCopyHistoryDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CHardCopyHistoryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHardCopyHistoryDlg)
	//}}AFX_DATA_INIT
	m_api=0;
	m_doc_copy=0;
	m_mode=APL_SHOW_REV_HISTORY;
}


void CHardCopyHistoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHardCopyHistoryDlg)
	DDX_Control(pDX, IDC_LIST_BORDER, m_border_ctrl);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHardCopyHistoryDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CHardCopyHistoryDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHardCopyHistoryDlg message handlers

BOOL CHardCopyHistoryDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	RECT rect={5,5,10,10};
	m_border_ctrl.GetWindowRect(&rect);
	ScreenToClient(&rect); 
		
	m_list_ctrl.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SHOWSELALWAYS,rect,this,IDS_HARD_COPY_HISTORY_CTRL);
	
	m_border_ctrl.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_list_ctrl.MoveWindow(&rect);

	ListView_SetExtendedListViewStyle(m_list_ctrl.m_hWnd,
		ListView_GetExtendedListViewStyle(m_list_ctrl.m_hWnd)
			|LVS_EX_UNDERLINECOLD|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);

	AddAnchor(IDS_HARD_COPY_HISTORY_CTRL,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);

	int count=0,i;
	CRect list_ctrl_rect;
	m_list_ctrl.GetWindowRect(list_ctrl_rect);
	int list_ctrl_width=list_ctrl_rect.Width();
	if(m_mode==APL_SHOW_REV_HISTORY)
	{
		SetWindowText( APL_T("     "));
		i=m_list_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT,(int)list_ctrl_width/4);count++;
		m_list_ctrl.SetColumnDate(i);
		m_list_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT,(int)list_ctrl_width/4);count++;
		m_list_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT,(int)list_ctrl_width/6);count++;
		m_list_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT,(int)list_ctrl_width/6);count++;
		m_list_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT,(int)list_ctrl_width/6);count++;
		UpdateDocRevHistory();
	}
	else
	{
		SetWindowText( APL_T("    "));
		i=m_list_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT,(int)list_ctrl_width/4);count++;
		m_list_ctrl.SetColumnDate(i);
		m_list_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT,(int)list_ctrl_width/4);count++;
		m_list_ctrl.InsertColumn(count,  APL_T(". "), LVCFMT_LEFT,(int)list_ctrl_width/4);count++;
		m_list_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT,(int)list_ctrl_width/4);count++;
		UpdateOwnersHistory();
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CHardCopyHistoryDlg::UpdateDocRevHistory()
{
	if(!m_doc_copy) return;
	
	CString buf;
	COleDateTime dt;

	CaplAttrValue tst_values[1];
	aplExtent ext;
	int i;
	CaplInstance *inst;

	tst_values[0].value.Set(m_doc_copy);
	tst_values[0].attr=m_api->m_doc_mgr.a_doc_copy_rev_change_hard_copy;

	m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_doc_mgr.e_doc_copy_rev_change,1,&tst_values[0],ext,true);
	if(ext.GetSize())
	{
		CaplLoadData ld(&m_api->m_data,DEF_SOURCE);
		for(i=0;i<ext.GetSize();i++)
		{
			ld.AddQuery(0,ext[i],true);
		}
		ld.AddQuery(_T('d'),0,0,m_api->m_doc_mgr.a_doc_copy_rev_change_doc_change,true,true);
		ld.LoadEx();
	}

	LockWindowUpdate();
	m_list_ctrl.DeleteAllItems();
	for(i=0;i<ext.GetSize();i++)
	{
		if(!ext[i]) continue;
		int new_item=m_list_ctrl.InsertItem(0, APL_T("<  >"));
		m_list_ctrl.SetItemData(new_item,(long)ext[i]);
		
		m_api->m_data.GetAttr(ext[i],m_api->m_doc_mgr.a_doc_copy_rev_change_apply_date,buf);
		if(buf!=_T(""))
		{
			aplString2Date(buf,dt);
			buf=dt.Format(_T("%d.%m.%Y %H:%M:%S"));
			m_list_ctrl.SetItemText(new_item,0,buf);
		}
		buf= APL_T("<  >");
		m_api->m_data.GetAttr(ext[i],m_api->m_doc_mgr.a_doc_copy_rev_change_author,inst);
		if(inst) m_api->m_appr_mgr.GetPersonName(inst,buf);
		m_list_ctrl.SetItemText(new_item,1,buf);
		CaplInstance *doc_chg=0;
		m_api->m_data.GetAttr(ext[i],m_api->m_doc_mgr.a_doc_copy_rev_change_doc_change,doc_chg);
		if(doc_chg) 
		{
			buf=_T("");
			m_api->m_data.GetAttr(doc_chg,m_api->m_change_mgr.a_chng_item_id,buf);
			m_list_ctrl.SetItemText(new_item,2,buf);
			buf=_T("");
			m_api->m_data.GetAttr(doc_chg,m_api->m_change_mgr.a_avc_old_rev,inst);
			if(inst) m_api->m_data.GetAttr(inst,m_api->m_doc_mgr.a_apl_doc_rev_id,buf);
			m_list_ctrl.SetItemText(new_item,3,buf);
			buf=_T("");
			m_api->m_data.GetAttr(doc_chg,m_api->m_change_mgr.a_avc_new_rev,inst);
			if(inst) m_api->m_data.GetAttr(inst,m_api->m_doc_mgr.a_apl_doc_rev_id,buf);
			m_list_ctrl.SetItemText(new_item,4,buf);
		}
	}
	if(m_list_ctrl.GetItemCount()) 
	{
		m_list_ctrl.SetItemSortState(0,ASCENDING);
		m_list_ctrl.SortColumn(0,false);
	}
	UnlockWindowUpdate();
	if(!ext.GetSize())
	{
		AfxMessageBox( APL_T("     !"));
	}

}

void CHardCopyHistoryDlg::UpdateOwnersHistory()
{
	if(!m_doc_copy) return;
	
	CString buf;
	COleDateTime dt;

	CaplAttrValue tst_values[1];
	aplExtent ext;
	int i;
	CaplInstance *inst;

	tst_values[0].value.Set(m_doc_copy);
	tst_values[0].attr=m_api->m_doc_mgr.a_doc_copy_owner_change_hard_copy;

	m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_doc_mgr.e_doc_copy_owner_change,1,&tst_values[0],ext,true);
	if(ext.GetSize())
	{
		CaplLoadData ld(&m_api->m_data,DEF_SOURCE);
		for(i=0;i<ext.GetSize();i++)
		{
			ld.AddQuery(0,ext[i],true);
		}
		ld.LoadEx();
	}

	LockWindowUpdate();
	m_list_ctrl.DeleteAllItems();
	for(i=0;i<ext.GetSize();i++)
	{
		if(!ext[i]) continue;
		int new_item=m_list_ctrl.InsertItem(0, APL_T("<  >"));
		m_list_ctrl.SetItemData(new_item,(long)ext[i]);
		
		m_api->m_data.GetAttr(ext[i],m_api->m_doc_mgr.a_doc_copy_owner_change_hand_date,buf);
		if(buf!=_T(""))
		{
			aplString2Date(buf,dt);
			buf=dt.Format(_T("%d.%m.%Y %H:%M:%S"));
			m_list_ctrl.SetItemText(new_item,0,buf);
		}
		m_api->m_data.GetAttr(ext[i],m_api->m_doc_mgr.a_doc_copy_owner_change_basis,buf);
		m_list_ctrl.SetItemText(new_item,1,buf);
		buf= APL_T("<  >");
		m_api->m_data.GetAttr(ext[i],m_api->m_doc_mgr.a_doc_copy_owner_change_new_owner,inst);
		if(inst) m_api->m_appr_mgr.GetPersonName(inst,buf);
		m_list_ctrl.SetItemText(new_item,2,buf);
		buf=_T("");
		m_api->m_data.GetAttr(ext[i],m_api->m_doc_mgr.a_doc_copy_owner_change_new_place_of_use,inst);
		if(inst) m_api->m_data.GetAttr(inst,m_api->m_appr_mgr.a_org_name,buf); 
		m_list_ctrl.SetItemText(new_item,3,buf);
	}
	if(m_list_ctrl.GetItemCount()) 
	{
		m_list_ctrl.SetItemSortState(0,ASCENDING);
		m_list_ctrl.SortColumn(0,false);
	}
	UnlockWindowUpdate();

}
