// ListCtrl4MessageItems.cpp : implementation file
//

#include "stdafx.h"
#include "ListCtrl4MessageItems.h"
#include "MessageDlg.h"

// CListCtrl4MessageItems



CListCtrl4MessageItems::CListCtrl4MessageItemsOleDataSource::CListCtrl4MessageItemsOleDataSource()
{
	m_inst_stor_doc=0;
	m_api=0;

}
void CListCtrl4MessageItems::CListCtrl4MessageItemsOleDataSource::SetDelayFile(LPCTSTR fname, CaplAPI *api, CaplInstance *inst_stor_doc)
{
	if(0==fname || 0==api || 0==inst_stor_doc) return;
	m_api=api;
	m_inst_stor_doc=inst_stor_doc;

	//UINT cf_fn=RegisterClipboardFormat(CFSTR_FILENAME);	
	UINT cf_fc=RegisterClipboardFormat(CFSTR_FILECONTENTS);	
	UINT cf_fd=RegisterClipboardFormat(CFSTR_FILEDESCRIPTOR);

	DelayRenderData(cf_fc);

	STGMEDIUM stm;
	memset((void far *)&stm,0,sizeof(stm));
	stm.tymed = TYMED_HGLOBAL;

	FORMATETC fe;
	memset((void far *)&fe,0,sizeof(fe));
	fe.tymed = TYMED_HGLOBAL;            
	fe.cfFormat=cf_fc;
	fe.lindex = -1;            
	fe.dwAspect = DVASPECT_CONTENT;


	HGLOBAL              hg;
	FILEGROUPDESCRIPTOR  *pfgd;

	hg = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE|GMEM_ZEROINIT, sizeof(FILEGROUPDESCRIPTOR)+sizeof(FILEDESCRIPTOR));
	if(hg)
	{
		pfgd = (FILEGROUPDESCRIPTOR*)GlobalLock(hg);
		if(pfgd)
		{
			int   i=0;
			pfgd->cItems = 1;
			pfgd->fgd[i].dwFlags = FD_ATTRIBUTES;
			pfgd->fgd[i].dwFileAttributes = FILE_ATTRIBUTE_NORMAL;
			_strcpy(pfgd->fgd[i].cFileName,LPCTSTR(fname));
			fe.cfFormat=cf_fd;
			stm.hGlobal = hg;
			GlobalUnlock(hg);	
			CacheData(0, &stm, &fe);
			m_FileName=fname;
		}
	}

}

BOOL CListCtrl4MessageItems::CListCtrl4MessageItemsOleDataSource::OnRenderData( LPFORMATETC lpFormatEtc, LPSTGMEDIUM lpStgMedium )
{
	//if(m_FileName==_T("")) return FALSE;
	
	//AfxMessageBox(_T("OnRenderData"));
	//UINT cf_fn=RegisterClipboardFormat(CFSTR_FILENAME);	
	UINT cf_fc=RegisterClipboardFormat(CFSTR_FILECONTENTS);
	//Beep(1000,100);
	if((lpFormatEtc==0)||(lpStgMedium==0)) return FALSE;
	if(lpFormatEtc->cfFormat!=cf_fc) return FALSE;
	if((lpFormatEtc->tymed&TYMED_HGLOBAL)==0) return FALSE;

	CWnd *pWndPopupOwner=AfxGetMainWnd();
	if(pWndPopupOwner==0) return TRUE;

	CWnd *oldFW= GetForegroundWindow();
	pWndPopupOwner->SetForegroundWindow();

	long flen=0;
	if(!m_api->m_data.NET_GetBlobSize(m_inst_stor_doc,m_api->m_doc_mgr.a_apl_stored_document_source,flen))return FALSE;
	if(flen<=0) return FALSE;

	lpStgMedium->tymed = TYMED_HGLOBAL;
	HGLOBAL hGlobal;
	hGlobal = GlobalAlloc(GHND | GMEM_SHARE, flen);
	if(hGlobal)
	{
		void *buf= GlobalLock(hGlobal);
		if(buf)
		{
			m_api->m_data.NET_LoadBlob2Memory(m_inst_stor_doc,m_api->m_doc_mgr.a_apl_stored_document_source,(BYTE*)buf,flen);
			GlobalUnlock(hGlobal);
			lpStgMedium->hGlobal=hGlobal;
		}
    }
	if(0!=oldFW) oldFW->SetForegroundWindow();
	return TRUE;
}



IMPLEMENT_DYNAMIC(CListCtrl4MessageItems, CListCtrl)

CListCtrl4MessageItems::CListCtrl4MessageItems()
{
	m_mes_dlg=0;
	m_item4drag=0;

}

CListCtrl4MessageItems::~CListCtrl4MessageItems()
{
}


BEGIN_MESSAGE_MAP(CListCtrl4MessageItems, CListCtrl)
	ON_WM_DROPFILES()
	ON_WM_KEYUP()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
END_MESSAGE_MAP()

// CListCtrl4MessageItems message handlers

void CListCtrl4MessageItems::OnDropFiles(HDROP hDropInfo)
{
	// TODO: Add your message handler code here and/or call default
    const UINT n=DragQueryFile(hDropInfo,-1,NULL,0);//   
    CStringArray array_files;
    for (UINT i=0;i<n; i++) {//   
        CString strFile;
        DragQueryFile(hDropInfo,i,strFile.GetBufferSetLength(MAX_PATH+1),MAX_PATH);
        strFile.ReleaseBuffer();
        array_files.Add(strFile);
    }
    DragFinish(hDropInfo);
	CListCtrl::OnDropFiles(hDropInfo);

	if(m_mes_dlg!=0) m_mes_dlg->AddFiles(array_files);
}

void CListCtrl4MessageItems::SelectAll()
{
	for(int i=0; i<GetItemCount(); ++i)
	{
		SetItemState(i,LVIS_SELECTED,LVIS_SELECTED);
	}
}
void CListCtrl4MessageItems::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default
// 	if (nChar==VK_MULTIPLY)
// 		SwapSelection();
	if (nChar==0x041 && GetKeyState(VK_LCONTROL)!=0)
		SelectAll();

	CListCtrl::OnKeyUp(nChar, nRepCnt, nFlags);
}


void CListCtrl4MessageItems::OnLButtonDown(UINT nFlags, CPoint point)
{
	CListCtrl::OnLButtonDown(nFlags, point);
	if(1==GetSelectedCount())
	{
		//int index=HitTest(point,0);//LVHT_ONITEMLABEL|LVHT_ONITEMICON);
		int index= GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
		if(index>=0)
		{
			m_item4drag= (CaplInstance*)GetItemData(index);
		}
	}
}

void CListCtrl4MessageItems::OnLButtonUp(UINT nFlags, CPoint point)
{
	m_item4drag=0;
	CListCtrl::OnLButtonUp(nFlags, point);
}

void CListCtrl4MessageItems::OnMouseMove(UINT nFlags, CPoint point)
{
	CListCtrl::OnMouseMove(nFlags, point);

	if(nFlags&MK_LBUTTON)
	{
		if(0!=m_item4drag)
		{
			CaplAPI *m_api=m_mes_dlg->m_api;
			if(m_api->m_data.IsKindOf(m_item4drag,m_api->m_doc_mgr.e_doc)) m_api->m_data.GetAttr(m_item4drag,m_api->m_doc_mgr.a_apl_doc_active,m_item4drag);
			if(m_api->m_data.IsKindOf(m_item4drag,m_api->m_doc_mgr.e_apl_doc_rev)) m_api->m_data.GetAttr(m_item4drag,m_api->m_doc_mgr.a_apl_doc_rev_access_form,m_item4drag);
			if(!m_api->m_data.IsKindOf(m_item4drag,m_api->m_doc_mgr.e_apl_stored_document))
			{
				m_item4drag=0;
				return;
			}
			CString buf,fname;
			m_api->m_data.GetAttr(m_item4drag,m_api->m_doc_mgr.a_apl_stored_document_file_name,buf);
			int i=buf.ReverseFind(_T('\\'));
			if(i>=0) fname=buf.Right(buf.GetLength()-(i+1));
			else fname=buf;

			CListCtrl4MessageItemsOleDataSource *pDataSource = new CListCtrl4MessageItemsOleDataSource;
			/*    
			HGLOBAL hMem;
			hMem=GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE|GMEM_ZEROINIT,sizeof(TCHAR)*(text.GetLength()+1));
			if (hMem)
			{
				TCHAR *xxx=(TCHAR*)GlobalLock(hMem);
				memcpy(xxx,LPCTSTR(text),sizeof(TCHAR)*(text.GetLength()+1));		
				GlobalUnlock(hMem);
				pDataSource->CacheGlobalData(CF_TEXT, hMem);
				//pDataSource->SetClipboard();
				pDataSource->DoDragDrop();
				delete pDataSource;
			}*/

			pDataSource->SetDelayFile(LPCTSTR(fname),m_api,m_item4drag);
			pDataSource->DoDragDrop();
			delete pDataSource;			
			m_item4drag=0;
		}
	}
}