// OptionDlg.cpp : implementation file
//

#include "stdafx.h"
#include "OptionDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptionDlg dialog


COptionDlg::COptionDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(COptionDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptionDlg)
	//}}AFX_DATA_INIT
	m_api=0;
	m_option=0;
	m_name=_T("");
	m_inst=0;
}


void COptionDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptionDlg)
	DDX_Control(pDX, IDC_SEL_INST_BTN, m_sel_inst_btn);
	DDX_Control(pDX, IDC_VALUE, m_value_ctrl);
	DDX_Control(pDX, IDC_TYPE, m_type_ctrl);
	DDX_Control(pDX, IDC_NAME, m_name_ctrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptionDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(COptionDlg)
	ON_BN_CLICKED(IDC_SEL_INST_BTN, OnSelInstBtn)
	ON_CBN_SELCHANGE(IDC_TYPE, OnSelchangeType)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptionDlg message handlers

BOOL COptionDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	m_type_ctrl.InsertString(OPT_TYPE_STRING, APL_T(""));
	m_type_ctrl.InsertString(OPT_TYPE_INT, APL_T(" "));
	m_type_ctrl.InsertString(OPT_TYPE_REAL, APL_T(" "));
	m_type_ctrl.InsertString(OPT_TYPE_INST, APL_T("   "));

	if(m_option) 
	{
		m_api->GetItemName(m_option,m_name);
		m_name_ctrl.SetWindowText(m_name);

		if(m_api->m_data.IsKindOf(m_option,m_api->m_options_mgr.e_str))
		{
			m_api->m_data.GetAttr(m_option,m_api->m_options_mgr.a_str_value,m_str_value);
			m_type_ctrl.SetCurSel(OPT_TYPE_STRING);	
		}
		else if(m_api->m_data.IsKindOf(m_option,m_api->m_options_mgr.e_int))
		{
			int ival;
			m_api->m_data.GetAttr(m_option,m_api->m_options_mgr.a_int_value,ival);
			m_str_value.Format(_T("%i"),ival);
			m_type_ctrl.SetCurSel(OPT_TYPE_INT);	
		}
		else if (m_api->m_data.IsKindOf(m_option, m_api->m_options_mgr.e_double))
		{
			double dval(0.);
			m_api->m_data.GetAttr(m_option, m_api->m_options_mgr.a_double_value, dval);
			m_str_value.Format(_T("%g"), dval);
			m_type_ctrl.SetCurSel(OPT_TYPE_REAL);
		}
		else if(m_api->m_data.IsKindOf(m_option,m_api->m_options_mgr.e_inst))
		{
			m_api->m_data.GetAttr(m_option,m_api->m_options_mgr.a_inst_value,m_inst);
			if(m_inst)
			{
				m_api->GetItemName(m_inst,m_str_value);
			}
			m_type_ctrl.SetCurSel(OPT_TYPE_INST);
		}
	
		m_value_ctrl.SetWindowText(m_str_value);
		m_type_ctrl.EnableWindow(FALSE);
		//m_name_ctrl.SetReadOnly();
	}
	else 
	{
		m_name_ctrl.SetWindowText(m_name);
		m_type_ctrl.SetCurSel(OPT_TYPE_STRING);
	}
	OnSelchangeType(); 
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void COptionDlg::OnOK() 
{
	// TODO: Add extra validation here
	int i;
	CString type,val;
	CString buf;

	m_name_ctrl.GetWindowText(buf);
	buf.TrimRight(); buf.TrimLeft();
	if(buf.IsEmpty()) 
	{
		AfxMessageBox( APL_T(" \"\"  !")); 
		m_name_ctrl.SetFocus();
		return;
	}

	m_value_ctrl.GetWindowText(val);
	val.TrimRight(); val.TrimLeft();

	int sel_type=m_type_ctrl.GetCurSel();
	if(sel_type<OPT_TYPE_INST)//  
	{
		if(val.IsEmpty())
		{
			AfxMessageBox( APL_T(" \"\"  !")); 
			m_value_ctrl.SetFocus();
			return;
		}
		if(sel_type==OPT_TYPE_INT)
		{
			for(i=0;i<val.GetLength();i++)
			{
				if (!_isdigit(val[i]) && val[i]!=_T('-'))
				{
					AfxMessageBox( APL_T("     !")); 
					m_value_ctrl.SetFocus();
					return;
				}
			}
		}
		else if (sel_type == OPT_TYPE_REAL)
		{
			CString sTest = val.MakeLower();
			for (i = 0; i < sTest.GetLength(); i++)
			{
				if (!_isdigit(sTest[i]) && sTest[i] !=_T('-') && sTest[i]!=_T('.') && sTest[i]!=_T('e'))
				{
					AfxMessageBox(APL_T("     !"));
					m_value_ctrl.SetFocus();
					return;
				}
			}
		}
	}
	else if(sel_type==OPT_TYPE_INST)//
	{
		if(m_inst==0)
		{
			AfxMessageBox( APL_T("   !")); 
			m_sel_inst_btn.SetFocus();
			return;
		}
	}

	if(m_option)
	{
		CaplInstance *oldInst=0;
		if(sel_type==OPT_TYPE_INST)
			m_api->m_data.GetAttr(m_option,m_api->m_options_mgr.a_inst_value,oldInst);
		if(sel_type<OPT_TYPE_INST)
		{
			if(sel_type==OPT_TYPE_STRING) 
				m_api->m_data.GetAttr(m_option,m_api->m_options_mgr.a_str_name,m_name);
			else if(sel_type==OPT_TYPE_INT) 
				m_api->m_data.GetAttr(m_option,m_api->m_options_mgr.a_int_name,m_name);
			else if (sel_type == OPT_TYPE_REAL)
				m_api->m_data.GetAttr(m_option, m_api->m_options_mgr.a_double_name, m_name);
			if((m_name==buf)&&(val==m_str_value)) 
				CaplTranslateDialog::OnCancel(); //   
		}
		else
		{
			m_api->m_data.GetAttr(m_option,m_api->m_options_mgr.a_inst_name,m_name);
			if((m_name==buf)&&(m_inst==oldInst)) 
				CaplTranslateDialog::OnCancel(); //   
		}

		if(m_name!=buf)//  
		{
			CaplInstance *inst=m_api->m_options_mgr.FindOptionBN(buf);
			if(inst!=0)
			{
				AfxMessageBox( APL_T("   \n(    )!"),
					MB_OK|MB_ICONSTOP); 
				return;
			}
			// 
			int i=m_api->m_options_mgr.m_params.Find(m_name);
			m_api->m_options_mgr.m_params.Remove(i);

			if(m_api->m_data.IsKindOf(m_option,m_api->m_options_mgr.e_str))
			{
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_str_name,buf);
			}
			else if(m_api->m_data.IsKindOf(m_option,m_api->m_options_mgr.e_int))
			{
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_int_name,buf);
			}
			else if (m_api->m_data.IsKindOf(m_option, m_api->m_options_mgr.e_double))
			{
				m_api->m_data.PutAttr(m_option, m_api->m_options_mgr.a_double_name, buf);
			}
			else if(m_api->m_data.IsKindOf(m_option,m_api->m_options_mgr.e_inst))
			{
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_inst_name,buf);
			}
			m_name=buf;
			m_api->m_options_mgr.m_params.Add(m_name,(long)m_option);
		}
		if(val!=m_str_value || m_inst!=oldInst)//  
		{
			if(m_api->m_data.IsKindOf(m_option,m_api->m_options_mgr.e_str))
			{
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_str_value,val);
			}
			else if(m_api->m_data.IsKindOf(m_option,m_api->m_options_mgr.e_int))
			{
				int ival=_atoi(LPCTSTR(val));
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_int_value,ival);
			}
			else if (m_api->m_data.IsKindOf(m_option, m_api->m_options_mgr.e_double))
			{
				double dval = __atof(LPCTSTR(val));
				m_api->m_data.PutAttr(m_option, m_api->m_options_mgr.a_double_value, dval);
			}
			else if(m_api->m_data.IsKindOf(m_option,m_api->m_options_mgr.e_inst))
			{
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_inst_value,m_inst);
			}
		}
	}
	else // 
	{
		//  
		CaplInstance *inst=m_api->m_options_mgr.FindOptionBN(buf);
		if(inst!=0)
		{
			AfxMessageBox( APL_T("   !")); 
			return;
		}
		else
		{
			if(sel_type==OPT_TYPE_STRING)//
			{
				m_option=m_api->m_data.CreateInstance(m_api->m_options_mgr.e_str);
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_str_name,buf);
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_str_value,val);
			}
			else if(sel_type==OPT_TYPE_INT)// 
			{
				m_option=m_api->m_data.CreateInstance(m_api->m_options_mgr.e_int);
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_int_name,buf);
				int ival=_atoi(LPCTSTR(val));
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_int_value,ival);
			}
			else if (sel_type == OPT_TYPE_REAL)// 
			{
				m_option = m_api->m_data.CreateInstance(m_api->m_options_mgr.e_double);
				m_api->m_data.PutAttr(m_option, m_api->m_options_mgr.a_double_name, buf);
				double dval = __atof(LPCTSTR(val));
				m_api->m_data.PutAttr(m_option, m_api->m_options_mgr.a_double_value, dval);
			}
			else if(sel_type==OPT_TYPE_INST)
			{
				m_option=m_api->m_data.CreateInstance(m_api->m_options_mgr.e_inst);
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_inst_name,buf);
				m_api->m_data.PutAttr(m_option,m_api->m_options_mgr.a_inst_value,m_inst);
			}
			m_api->m_options_mgr.m_params.Add(buf,(long)m_option);
		}
	}
	CaplTranslateDialog::OnOK();
}


void COptionDlg::OnSelInstBtn() 
{
	CaplInstance *inst=m_api->m_bp_mgr.SelectInstance(APL_MODE_SELECT_PRD|
		APL_MODE_SELECT_PDF|APL_MODE_SELECT_PRDINST|APL_MODE_SELECT_LOT|
		APL_MODE_SELECT_PERSON|APL_MODE_SELECT_ORG|APL_MODE_SELECT_BP);
	if(inst)
	{
		m_inst=inst;
		m_api->GetItemName(m_inst,m_str_value);
		m_value_ctrl.SetWindowText(m_str_value);	
	}
	
}

void COptionDlg::OnSelchangeType() 
{
	int cur_sel=m_type_ctrl.GetCurSel();
	CRect btn_rect;
	m_sel_inst_btn.GetWindowRect(btn_rect);
	CRect val_rect;
	m_value_ctrl.GetWindowRect(val_rect);
	if(cur_sel<OPT_TYPE_INST)//  
	{
		m_value_ctrl.SetReadOnly(FALSE);
		m_sel_inst_btn.ShowWindow(SW_HIDE);
		val_rect.right=btn_rect.right;
		ScreenToClient(&val_rect);
		m_value_ctrl.MoveWindow(val_rect);
	}
	else//
	{
		m_value_ctrl.SetReadOnly(TRUE);
		m_sel_inst_btn.ShowWindow(SW_SHOW);
		val_rect.right=btn_rect.left-5;
		ScreenToClient(&val_rect);
		m_value_ctrl.MoveWindow(val_rect);
		if(m_inst) 
		{
			m_api->GetItemName(m_inst,m_str_value);
			m_value_ctrl.SetWindowText(m_str_value);
		}
	}
	
}
