#pragma once

#include "InstPropertyCtrl.h"

// CQueryTableItemsView view

class CQueryTableItemsView : public CView
{
	DECLARE_DYNCREATE(CQueryTableItemsView)

protected:
	CQueryTableItemsView();           // protected constructor used by dynamic creation

	// Attributes
	CInstPropertyCtrl	m_ListCtrl;
	CaplTAggr<SItemColumnData*,SItemColumnData*,APLAGGR_LIST_OR_AUTOKILLREF> m_Items;

	long	m_DlgId;
	bool	m_load_from_bd;

	COleDropTarget	m_OleDropTarget;
public:

	// Operations
public:
//	bool Paste(COleDataObject *pDataObject);
	bool CopyToClipboard();
	void ShowItemProperties(CaplInstance* Item);
// 	void ShowCreateDialog(CaplEntity* pEntity);
	void ShowEmptyList();
	bool UpdateTable(aplExtent &extent);

	CaplAPI* m_api;
	UINT m_Mode;

	CaplInstance *GetCurInst();

	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CClassifierTableItemsView)
public:
	virtual void OnInitialUpdate();
	virtual BOOL OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point);
	virtual DROPEFFECT OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	virtual void OnDragLeave();
	virtual DROPEFFECT OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL

	// Implementation
protected:
	virtual ~CQueryTableItemsView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	COleDataSource* PrepareDatasource(CaplInstance *Inst);
	//{{AFX_MSG(CClassifierTableItemsView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
// 	afx_msg void OnAddItem();
//	afx_msg void OnCopyItem();
// 	afx_msg void OnAddItemWForm();
// 	afx_msg void OnShowPropInForm();
// 	afx_msg void OnShowFiltrProp();
// 	afx_msg void OnShowByFiltr();
// 	afx_msg void OnUpdateFiltr(CCmdUI* pCmdUI);
// 	afx_msg void OnUpdateAddItem(CCmdUI* pCmdUI);
//	afx_msg void OnUpdateCopyItem(CCmdUI* pCmdUI);
// 	afx_msg void OnUpdateAddItemWF(CCmdUI* pCmdUI);
	afx_msg void OnTimer(UINT nIDEvent);
// 	afx_msg void OnFindAdd();
// 	afx_msg void OnItemDelete();
	afx_msg void OnItemProperties();
	afx_msg void OnListCtrlDblClick(NMHDR *pNMHDR, LRESULT *pResult);
// 	afx_msg void OnEntProduct();
// 	afx_msg void OnEntBp();
// 	afx_msg void OnEntBpinst();
// 	afx_msg void OnEntCateg();
// 	afx_msg void OnEntChange();
// 	afx_msg void OnEntDocument();
// 	afx_msg void OnEntFolder();
// 	afx_msg void OnEntLot();
// 	afx_msg void OnEntOrg();
// 	afx_msg void OnEntPerson();
// 	afx_msg void OnEntPrdinst();
// 	afx_msg void OnEntProductVersion();
// 	afx_msg void OnEntProjet();
// 	afx_msg void OnUpdateEntChange(CCmdUI* pCmdUI);
// 	afx_msg void OnUpdateEntProjet(CCmdUI* pCmdUI);
// 	afx_msg void OnUpdateEntPerson(CCmdUI* pCmdUI);
// 	afx_msg void OnUpdateEntOrg(CCmdUI* pCmdUI);
// 	afx_msg void OnUpdateEntCateg(CCmdUI* pCmdUI);
	afx_msg void OnColumnSetup();
	afx_msg void OnColumnCharactSetup();
	afx_msg void OnUpdateColumnSetup(CCmdUI* pCmdUI);
// 	afx_msg void OnUpdateFindAdd(CCmdUI* pCmdUI);
// 	afx_msg void OnUpdateItemDelete(CCmdUI* pCmdUI);
	afx_msg void OnUpdateItemProperties(CCmdUI* pCmdUI);
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
// 	afx_msg void OnEditPaste();
// 	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnBegindrag(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnUpdateItemView(CCmdUI* pCmdUI);
	afx_msg void OnItemView();
	afx_msg void OnUpdateItemUndoCheckout(CCmdUI* pCmdUI);
//	afx_msg void OnUpdateItemEdit(CCmdUI* pCmdUI);
//	afx_msg void OnItemUndoCheckout();
//	afx_msg void OnItemEdit();
//	afx_msg void OnUpdateItemCheckout(CCmdUI* pCmdUI);
// 	afx_msg void OnItemCheckout();
// 	afx_msg void OnItemCheckin();
// 	afx_msg void OnUpdateItemCheckin(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	aplExtent m_ExtCurr;
	aplExtent m_all_el_charact;
	TArrElValChar *m_list_char;
public:
	afx_msg void OnContextMenu(CWnd* /*pWnd*/, CPoint /*point*/);
};


