// ShowOpt.cpp: implementation of the CShowOpt class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "apl_api.h"
#include "ShowOptDlg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CShowOpt::CShowOpt()
{
	m_showbpinst_id=TRUE;
	m_showbpinst_name=TRUE;
	m_showbpinst_date=TRUE;

	m_showbpres_id=TRUE;
	m_showbpres_type=TRUE;
	m_showbpres_object=TRUE;
	m_showbpres_amount=TRUE;
	
	m_show_org_struct=TRUE;
	m_show_classificators=TRUE;
	
	m_BPType=TRUE;
	m_BPId=TRUE;
	m_BPName=TRUE;
//	m_BPDescr = FALSE;
	m_BPDescr = TRUE;
	
	m_prd_id=TRUE;
	m_prd_name=TRUE;
	m_prd_count=TRUE;
	m_prd_position=TRUE;
	m_prd_code = FALSE;
	m_pdf_code = FALSE;
	m_pdf_code1 = FALSE;
	m_pdf_code2 = FALSE;
	
	m_appr_pers=TRUE;
	m_appr_status=TRUE;
	m_appr_pers_role=TRUE;
	m_appr_date = TRUE;
	m_appr_time = FALSE;
	
	m_charact_id = FALSE;
	m_charact_name = TRUE;
	m_charact_value=TRUE;
	m_charact_unit=TRUE;
	m_charact_scope=FALSE;
	
	m_doc_id=TRUE;
	m_doc_show_add_code_document_type=TRUE;
	m_doc_name=TRUE;
	m_doc_ver=FALSE;
	m_doc_type=FALSE;
	m_doc_editing_user=FALSE;
	m_doc_show_addional_code= FALSE;
	m_doc_show_date= FALSE;
	m_doc_show_inv_num= FALSE;
	m_doc_show_recipient= FALSE;


	m_doc__view_on_dblclick=FALSE;
	
	m_org_id=FALSE;
	m_org_name=TRUE;

	m_PrdNoShowPlusToPart=TRUE;

	m_PrdNoShowReplacedPart=FALSE;

	m_categ_id=TRUE;
	m_categ_name=TRUE;

	m_task_cancel=FALSE;
	m_task_complete=FALSE;
	m_task_suspend=FALSE;

	m_show_charactId_or_name=TRUE;
	
	m_auto_wfstate = FALSE;

	m_PrdInstSN = FALSE;
	m_PrdInstId = TRUE;
	m_PrdInstPrd = TRUE;

	m_PersonFullInitials = FALSE;
	m_PersonId = FALSE;

	m_show_project_id = TRUE;
	m_show_project_num_zak = FALSE;
	m_show_project_name = TRUE;
	m_show_project_type = TRUE;
	m_show_project_state = TRUE;
	m_show_project_number = TRUE;

	m_show_refusal_doc_type = TRUE;
	m_show_refusal_doc_id = TRUE;
	m_show_refusal_doc_date = TRUE;
	m_show_refusal_state = TRUE;
	m_show_refusal_type = TRUE;
	m_show_refusal_descr = FALSE;
	m_show_refusal_stage = FALSE;
	m_show_refusal_planer = FALSE;
	m_show_refusal_item = FALSE;

	m_show_classifier_system_id = FALSE;
	m_show_classifier_system_name = TRUE;
	
	m_show_classifier_level_id = FALSE;
	m_show_classifier_level_name = TRUE;
	m_show_classifier_level_level = FALSE;

	m_show_task_id = FALSE;
	m_show_task_name = TRUE;
	m_show_task_process_id = FALSE;
	m_show_task_process_name = FALSE;

	m_show_process_id  = FALSE;
	m_show_process_name = TRUE;

	LoadData();
}

CShowOpt::~CShowOpt()
{
	SaveData();
}

BOOL CShowOpt::LoadData()
{
	CRegKey key;
	if(key.Open(HKEY_CURRENT_USER,
		_T("Software\\CALS Centre \"Applied Logistic\"\\PDM STEP Suite\\options"))
		!=ERROR_SUCCESS) return FALSE;
	
	GetValue(key,_T("ShowId"), m_prd_id);
	GetValue(key,_T("ShowName"), m_prd_name);
	GetValue(key,_T("ShowCount"), m_prd_count);
	GetValue(key,_T("showPosition"), m_prd_position);
	GetValue(key,_T("PrdNoShowPlusToPart"), m_PrdNoShowPlusToPart);
	GetValue(key,_T("PrdNoShowReplacedPart"), m_PrdNoShowReplacedPart);

	GetValue(key,_T("ShowPrdCode"), m_prd_code);
	GetValue(key,_T("ShowPdfCode"), m_pdf_code);
	GetValue(key,_T("ShowPdfCode1"), m_pdf_code1);
	GetValue(key,_T("ShowPdfCode2"), m_pdf_code2);

	GetValue(key,_T("ShowDocId"), m_doc_id);
	GetValue(key,_T("ShowDocAddCodeDocumentType"), m_doc_show_add_code_document_type);
	GetValue(key,_T("ShowDocName"), m_doc_name);
	GetValue(key,_T("ShowDocType"), m_doc_type);
	GetValue(key,_T("ShowDocVersion"), m_doc_ver);
	GetValue(key,_T("ShowDocEditingUser"), m_doc_editing_user);
	GetValue(key,_T("ShowDocAdditionalCode"), m_doc_show_addional_code);
	GetValue(key,_T("ShowDocDate"), m_doc_show_date);
	GetValue(key,_T("ShowDocInvNum"), m_doc_show_inv_num);
	GetValue(key,_T("ShowDocRecipient"), m_doc_show_recipient);


	GetValue(key,_T("ShowApprovalPerson"), m_appr_pers);
	GetValue(key,_T("ShowApprovalStatus"), m_appr_status);
	GetValue(key,_T("ShowApprovalPersonRole"), m_appr_pers_role);
	GetValue(key,_T("ShowApprovalDate"), m_appr_date);
	GetValue(key,_T("ShowApprovalTime"), m_appr_time);

	GetValue(key,_T("ShowCharacteristicValue"), m_charact_value);
	GetValue(key,_T("ShowCharacteristicUnit"), m_charact_unit);
	GetValue(key,_T("ShowCharacteristicScope"), m_charact_scope);
	GetValue(key,_T("ShowCharacteristicId"), m_charact_id);
	GetValue(key,_T("ShowCharacteristicName"), m_charact_name);

	GetValue(key,_T("ShowOrgId"), m_org_id);
	GetValue(key,_T("ShowOrgName"), m_org_name);

	GetValue(key,_T("ShowCategId"), m_categ_id);
	GetValue(key,_T("ShowCategName"), m_categ_name);

	GetValue(key,_T("ShowTaskCancel"), m_task_cancel);
	GetValue(key,_T("ShowTaskComplete"), m_task_complete);
	GetValue(key,_T("ShowTaskSuspend"), m_task_suspend);

	GetValue(key,_T("bBPShowType"), m_BPType);
	GetValue(key,_T("bBPShowId"), m_BPId);
	GetValue(key,_T("bBPShowName"), m_BPName);
	GetValue(key,_T("bBPShowDescr"), m_BPDescr);
	GetValue(key,_T("bBPShowNum"), m_BPNum);

	GetValue(key,_T("ShowCharacteristicId_or_Name"), m_show_charactId_or_name);

	GetValue(key,_T("ShowOrgStruct"), m_show_org_struct);
	GetValue(key,_T("ShowClassificators"), m_show_classificators);

	GetValue(key,_T("ShowBPInstId"), m_showbpinst_id);
	GetValue(key,_T("ShowBPInstName"), m_showbpinst_name);
	GetValue(key,_T("ShowBPInstDate"), m_showbpinst_date);

	GetValue(key,_T("ShowBPResId"), m_showbpres_id);
	GetValue(key,_T("ShowBPResType"),m_showbpres_type );
	GetValue(key,_T("ShowBPResObject"), m_showbpres_object);
	GetValue(key,_T("ShowBPResAmount"), m_showbpres_amount);
	GetValue(key,_T("AutoChangeWFState"), m_auto_wfstate);

	GetValue(key,_T("ShowProjectId"),m_show_project_id);
	GetValue(key,_T("ShowProjectNumZak"),m_show_project_num_zak);
	GetValue(key,_T("ShowProjectName"),m_show_project_name);
	GetValue(key,_T("ShowProjectState"),m_show_project_state);
	GetValue(key,_T("ShowProjectType"),m_show_project_type);
	GetValue(key,_T("ShowProjectNumber"),m_show_project_number);

	GetValue(key,_T("show_refusal_doc_type"),m_show_refusal_doc_type);
	GetValue(key,_T("show_refusal_doc_id"),m_show_refusal_doc_id);
	GetValue(key,_T("show_refusal_doc_date"),m_show_refusal_doc_date);
	GetValue(key,_T("show_refusal_state"),m_show_refusal_state);
	GetValue(key,_T("show_refusal_type"),m_show_refusal_type);
	GetValue(key,_T("show_refusal_descr"),m_show_refusal_descr);
	GetValue(key,_T("m_show_refusal_stage"),m_show_refusal_stage);
	GetValue(key,_T("m_show_refusal_planer"),m_show_refusal_planer);
	GetValue(key,_T("m_show_refusal_item"),m_show_refusal_item);

	GetValue(key, _T("ShowPrdInstId"), m_PrdInstId);
	GetValue(key, _T("ShowPrdInstSN"), m_PrdInstSN);
	GetValue(key, _T("ShowPrdInstPrd"), m_PrdInstPrd);

	GetValue(key, _T("ShowPersonFullInitials"), m_PersonFullInitials);
	GetValue(key, _T("ShowPersonId"), m_PersonId);

	GetValue(key, _T("ShowClassifierSystemId"), m_show_classifier_system_id);
	GetValue(key, _T("ShowClassifierSystemName"), m_show_classifier_system_name);
	
	GetValue(key, _T("ShowClassifierLevelId"), m_show_classifier_level_id);
	GetValue(key, _T("ShowClassifierLevelName"), m_show_classifier_level_name);
	GetValue(key, _T("ShowClassifierLevelDepth"), m_show_classifier_level_level);

	GetValue(key, _T("ShowTaskId"), m_show_task_id);
	GetValue(key, _T("ShowTaskName"), m_show_task_name);
	GetValue(key, _T("ShowTaskProcessId"), m_show_task_process_id);
	GetValue(key, _T("ShowTaskProcessName"), m_show_task_process_name);
	GetValue(key, _T("ShowProcessId"), m_show_process_id);
	GetValue(key, _T("ShowProcessName"), m_show_process_name);

	key.Close();
	return TRUE;
}

BOOL CShowOpt::SaveData()
{
	CRegKey key;
	if(key.Create(HKEY_CURRENT_USER,_T("Software\\CALS Centre \"Applied Logistic\"\\PDM STEP Suite\\options"),
		REG_NONE,REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS)==ERROR_SUCCESS)
	{
#if _MSC_VER >= 1400
		key.SetDWORDValue(_T("ShowId"), m_prd_id);
		key.SetDWORDValue(_T("ShowName"), m_prd_name);
		key.SetDWORDValue(_T("ShowCount"), m_prd_count);
		key.SetDWORDValue(_T("showPosition"), m_prd_position);
		key.SetDWORDValue(_T("ShowPrdCode"), m_prd_code);
		key.SetDWORDValue(_T("ShowPdfCode"), m_pdf_code);
		key.SetDWORDValue(_T("ShowPdfCode1"), m_pdf_code1);
		key.SetDWORDValue(_T("ShowPdfCode2"), m_pdf_code2);
		key.SetDWORDValue(_T("PrdNoShowPlusToPart"), m_PrdNoShowPlusToPart);
		key.SetDWORDValue(_T("PrdNoShowReplacedPart"), m_PrdNoShowReplacedPart);

		key.SetDWORDValue(_T("ShowDocId"), m_doc_id);
		key.SetDWORDValue(_T("ShowDocAddCodeDocumentType"), m_doc_show_add_code_document_type);
		key.SetDWORDValue(_T("ShowDocName"), m_doc_name);
		key.SetDWORDValue(_T("ShowDocType"), m_doc_type);
		key.SetDWORDValue(_T("ShowDocVersion"), m_doc_ver);
		key.SetDWORDValue(_T("ShowDocEditingUser"), m_doc_editing_user);
		key.SetDWORDValue(_T("ShowDocAdditionalCode"), m_doc_show_addional_code);

		key.SetDWORDValue(_T("ShowDocDate"), m_doc_show_date);
		key.SetDWORDValue(_T("ShowDocInvNum"), m_doc_show_inv_num);
		key.SetDWORDValue(_T("ShowDocRecipient"), m_doc_show_recipient);

		key.SetDWORDValue(_T("ShowApprovalPerson"), m_appr_pers);
		key.SetDWORDValue(_T("ShowApprovalStatus"), m_appr_status);
		key.SetDWORDValue(_T("ShowApprovalPersonRole"), m_appr_pers_role);
		key.SetDWORDValue(_T("ShowApprovalDate"), m_appr_date);
		key.SetDWORDValue(_T("ShowApprovalTime"), m_appr_time);

		key.SetDWORDValue(_T("ShowCharacteristicValue"), m_charact_value);
		key.SetDWORDValue(_T("ShowCharacteristicUnit"), m_charact_unit);
		key.SetDWORDValue(_T("ShowCharacteristicScope"), m_charact_scope);
		key.SetDWORDValue(_T("ShowCharacteristicId"), m_charact_id);
		key.SetDWORDValue(_T("ShowCharacteristicName"), m_charact_name);

		key.SetDWORDValue(_T("ShowOrgId"), m_org_id);
		key.SetDWORDValue(_T("ShowOrgName"), m_org_name);

		key.SetDWORDValue(_T("ShowCategId"), m_categ_id);
		key.SetDWORDValue(_T("ShowCategName"), m_categ_name);

		key.SetDWORDValue(_T("ShowTaskCancel"), m_task_cancel);
		key.SetDWORDValue(_T("ShowTaskComplete"), m_task_complete);
		key.SetDWORDValue(_T("ShowTaskSuspend"), m_task_suspend);

		key.SetDWORDValue(_T("bBPShowType"), m_BPType);
		key.SetDWORDValue(_T("bBPShowId"), m_BPId);
		key.SetDWORDValue(_T("bBPShowName"), m_BPName);
		key.SetDWORDValue(_T("bBPShowDescr"), m_BPDescr);
		key.SetDWORDValue(_T("bBPShowNum"), m_BPNum);

		key.SetDWORDValue(_T("ShowCharacteristicId_or_Name"), m_show_charactId_or_name);

		key.SetDWORDValue(_T("ShowOrgStruct"), m_show_org_struct);

		key.SetDWORDValue(_T("ShowClassificators"), m_show_classificators);

		key.SetDWORDValue(_T("ShowBPInstId"), m_showbpinst_id);
		key.SetDWORDValue(_T("ShowBPInstName"), m_showbpinst_name);
		key.SetDWORDValue(_T("ShowBPInstDate"), m_showbpinst_date);

		key.SetDWORDValue(_T("ShowBPResId"), m_showbpres_id);
		key.SetDWORDValue(_T("ShowBPResType"), m_showbpres_type);
		key.SetDWORDValue(_T("ShowBPResObject"), m_showbpres_object);
		key.SetDWORDValue(_T("ShowBPResAmount"), m_showbpres_amount);

		key.SetDWORDValue(_T("AutoChangeWFState"), m_auto_wfstate);

		key.SetDWORDValue(_T("ShowProjectId"), m_show_project_id);
		key.SetDWORDValue(_T("ShowProjectNumZak"), m_show_project_num_zak);
		key.SetDWORDValue(_T("ShowProjectName"), m_show_project_name);
		key.SetDWORDValue(_T("ShowProjectType"), m_show_project_type);
		key.SetDWORDValue(_T("ShowProjectState"), m_show_project_state);
		key.SetDWORDValue(_T("ShowProjectNumber"), m_show_project_number);

		key.SetDWORDValue(_T("show_refusal_doc_type"), m_show_refusal_doc_type);
		key.SetDWORDValue(_T("show_refusal_doc_id"), m_show_refusal_doc_id);
		key.SetDWORDValue(_T("show_refusal_doc_date"), m_show_refusal_doc_date);
		key.SetDWORDValue(_T("show_refusal_state"), m_show_refusal_state);
		key.SetDWORDValue(_T("show_refusal_type"), m_show_refusal_type);
		key.SetDWORDValue(_T("show_refusal_descr"), m_show_refusal_descr);
		key.SetDWORDValue(_T("m_show_refusal_stage"), m_show_refusal_stage);
		key.SetDWORDValue(_T("m_show_refusal_planer"), m_show_refusal_planer);
		key.SetDWORDValue(_T("m_show_refusal_item"), m_show_refusal_item);

		key.SetDWORDValue(_T("ShowPrdInstId"), m_PrdInstId);
		key.SetDWORDValue(_T("ShowPrdInstSN"), m_PrdInstSN);
		key.SetDWORDValue(_T("ShowPrdInstPrd"), m_PrdInstPrd);

		key.SetDWORDValue(_T("ShowPersonFullInitials"), m_PersonFullInitials);
		key.SetDWORDValue(_T("ShowPersonId"), m_PersonId);

		key.SetDWORDValue(_T("ShowClassifierSystemId"), m_show_classifier_system_id);
		key.SetDWORDValue(_T("ShowClassifierSystemName"), m_show_classifier_system_name);

		key.SetDWORDValue(_T("ShowClassifierLevelId"), m_show_classifier_level_id);
		key.SetDWORDValue(_T("ShowClassifierLevelName"), m_show_classifier_level_name);
		key.SetDWORDValue(_T("ShowClassifierLevelDepth"), m_show_classifier_level_level);
		
		key.SetDWORDValue(_T("ShowTaskId"), m_show_task_id);
		key.SetDWORDValue(_T("ShowProcessId"), m_show_process_id);
		key.SetDWORDValue(_T("ShowTaskName"), m_show_task_name);
		key.SetDWORDValue(_T("ShowProcessName"), m_show_process_name);
		key.SetDWORDValue(_T("ShowTaskProcessId"), m_show_task_process_id);
		key.SetDWORDValue(_T("ShowTaskProcessName"), m_show_task_process_name);
#else
		key.SetValue(m_prd_id,_T("ShowId"));
		key.SetValue(m_prd_name,_T("ShowName"));
		key.SetValue(m_prd_name,_T("ShowName"));
		key.SetValue(m_prd_count,_T("ShowCount"));
		key.SetValue(m_prd_position,_T("showPosition"));
		key.SetValue(m_prd_code, _T("ShowPrdCode"));
		key.SetValue(m_pdf_code, _T("ShowPdfCode"));
		key.SetValue(m_pdf_code1, _T("ShowPdfCode1"));
		key.SetValue(m_pdf_code2, _T("ShowPdfCode2"));
		key.SetValue(m_PrdNoShowPlusToPart,_T("PrdNoShowPlusToPart"));
		key.SetValue(m_PrdNoShowReplacedPart,_T("PrdNoShowReplacedPart"));

		key.SetValue(m_doc_id,_T("ShowDocId"));
		key.SetValue(m_doc_name,_T("ShowDocName"));
		key.SetValue(m_doc_type,_T("ShowDocType"));
		key.SetValue(m_doc_ver,_T("ShowDocVersion"));
		key.SetValue(m_doc_editing_user,_T("ShowDocEditingUser"));

		key.SetValue(m_appr_pers,_T("ShowApprovalPerson"));
		key.SetValue(m_appr_status,_T("ShowApprovalStatus"));
		key.SetValue(m_appr_pers_role,_T("ShowApprovalPersonRole"));
		key.SetValue(m_appr_date,_T("ShowApprovalDate"));
		key.SetValue(m_appr_time,_T("ShowApprovalTime"));

		key.SetValue(m_charact_value,_T("ShowCharacteristicValue"));
		key.SetValue(m_charact_unit,_T("ShowCharacteristicUnit"));
		key.SetValue(m_charact_scope,_T("ShowCharacteristicScope"));
		key.SetValue(m_charact_id,_T("ShowCharacteristicId"));
		key.SetValue(m_charact_name,_T("ShowCharacteristicName"));

		key.SetValue(m_org_id,_T("ShowOrgId"));
		key.SetValue(m_org_name,_T("ShowOrgName"));

		key.SetValue(m_categ_id,_T("ShowCategId"));
		key.SetValue(m_categ_name,_T("ShowCategName"));

		key.SetValue(m_task_cancel,_T("ShowTaskCancel"));
		key.SetValue(m_task_complete,_T("ShowTaskComplete"));
		key.SetValue(m_task_suspend,_T("ShowTaskSuspend"));

		key.SetValue(m_BPType,_T("bBPShowType"));
		key.SetValue(m_BPId,_T("bBPShowId"));
		key.SetValue(m_BPName,_T("bBPShowName"));
		key.SetValue(m_BPDescr,_T("bBPShowDescr"));
		key.SetValue(m_BPNum,_T("bBPShowNum"));

		key.SetValue(m_show_charactId_or_name,_T("ShowCharacteristicId_or_Name"));

		key.SetValue(m_show_org_struct,_T("ShowOrgStruct"));

		key.SetValue(m_show_classificators,_T("ShowClassificators"));

		key.SetValue(m_showbpinst_id,_T("ShowBPInstId"));
		key.SetValue(m_showbpinst_name,_T("ShowBPInstName"));
		key.SetValue(m_showbpinst_date,_T("ShowBPInstDate"));

		key.SetValue(m_showbpres_id,_T("ShowBPResId"));
		key.SetValue(m_showbpres_type,_T("ShowBPResType"));
		key.SetValue(m_showbpres_object,_T("ShowBPResObject"));
		key.SetValue(m_showbpres_amount,_T("ShowBPResAmount"));

		key.SetValue(m_auto_wfstate,_T("AutoChangeWFState"));

		key.SetValue(m_show_project_id,_T("ShowProjectId"));
		key.SetValue(m_show_project_number_zak,_T("ShowProjectNum"));
		key.SetValue(m_show_project_name,_T("ShowProjectName"));
		key.SetValue(m_show_project_type,_T("ShowProjectType"));
		key.SetValue(m_show_project_state,_T("ShowProjectState"));
		key.SetValue(m_show_project_number,_T("ShowProjectNumber"));
		
		key.SetValue(m_PrdInstId, _T("ShowPrdInstId"));
		key.SetValue(m_PrdInstSN, _T("ShowPrdInstSN"));
		key.SetValue(m_PrdInstPrd, _T("ShowPrdInstPrd"));

		key.SetValue(m_PersonFullInitials, _T("ShowPersonFullInitials"));
		key.SetValue(m_PersonId, _T("ShowPersonId"));

		key.SetValue(m_show_classifier_system_id, _T("ShowClassifierSystemId"));
		key.SetValue(m_show_classifier_system_name, _T("ShowClassifierSystemName"));
		
		key.SetValue(m_show_classifier_level_id, _T("ShowClassifierLevelId"));
		key.SetValue(m_show_classifier_level_name, _T("ShowClassifierLevelName"));
		key.SetValue(m_show_classifier_level_level, _T("ShowClassifierLevelDepth"));
		
		key.SetValue(m_show_task_id, _T("ShowTaskId"));
		key.SetValue(m_show_process_id, _T("ShowProcessId"));
		key.SetValue(m_show_task_name, _T("ShowTaskName"));
		key.SetValue(m_show_process_name, _T("ShowProcessName"));

#endif
		
		key.Close();
	}
	else
	{
		AfxMessageBox(APL_T("   !\n\n     \"Software\\CALS Centre \"Applied Logistic\"\\PDM STEP Suite\\options\""),MB_OK|MB_ICONSTOP);
	}
	return TRUE;
}

void CShowOpt::GetValue(CRegKey &key, CString name, BOOL &param)
{
	DWORD dw;
#if _MSC_VER >= 1400
	if(key.QueryDWORDValue(name, dw)!=ERROR_SUCCESS) return;
#else
	if(key.QueryValue(dw,name)!=ERROR_SUCCESS) return;
#endif

	if(dw>0) param=TRUE;
	else param=FALSE;
	return;
}

BOOL CShowOpt::ShowOption()
{
	CaplSetResourceHandle setres(module_inst);
	CShowOptDlg dlg;

	dlg.m_appr_pers = m_appr_pers;
	dlg.m_appr_pers_role = m_appr_pers_role;
	dlg.m_appr_status = m_appr_status;
	dlg.m_appr_date = m_appr_date;
	dlg.m_appr_time = m_appr_time;

	dlg.m_BPId = m_BPId;
	dlg.m_BPName = m_BPName;
	dlg.m_BPType = m_BPType;
	dlg.m_BPDescr = m_BPDescr;
	dlg.m_BPNum = m_BPNum;

	dlg.m_categ_id = m_categ_id;
	dlg.m_categ_name = m_categ_name;

	dlg.m_charact_unit =m_charact_unit;
	dlg.m_charact_scope =m_charact_scope;
	dlg.m_charact_value = m_charact_value;
	dlg.m_charact_id =m_charact_id;
	dlg.m_charact_name = m_charact_name;

	dlg.m_org_id = m_org_id;
	dlg.m_org_name = m_org_name;

	dlg.m_prd_count = m_prd_count;
	dlg.m_prd_id = m_prd_id;
	dlg.m_prd_name = m_prd_name;
	dlg.m_prd_position = m_prd_position;
	dlg.m_prd_code = m_prd_code;
	dlg.m_pdf_code = m_pdf_code;
	dlg.m_pdf_code1 = m_pdf_code1;
	dlg.m_pdf_code2 = m_pdf_code2;

	dlg.m_show_charactId_or_name = m_show_charactId_or_name;

	dlg.m_task_cancel = m_task_cancel;
	dlg.m_task_complete = m_task_complete;
	dlg.m_task_suspend = m_task_suspend;

	dlg.m_doc_id = m_doc_id;
	dlg.m_doc_show_add_code_document_type = m_doc_show_add_code_document_type;
	dlg.m_doc_name = m_doc_name;
	dlg.m_doc_type = m_doc_type;
	dlg.m_doc_ver  = m_doc_ver;
	dlg.m_doc_editing_user=m_doc_editing_user;
	dlg.m_doc_show_addional_code=m_doc_show_addional_code;

	dlg.m_doc_show_date=m_doc_show_date;
	dlg.m_doc_show_inv_num=m_doc_show_inv_num;
	dlg.m_doc_show_recipient=m_doc_show_recipient;

	dlg.m_show_bpinst_id = m_showbpinst_id;
	dlg.m_show_bpinst_name=m_showbpinst_name;
	dlg.m_show_bpinst_date=m_showbpinst_date;

	dlg.m_show_bpres_id=m_showbpres_id;
	dlg.m_show_bpres_type=m_showbpres_type;
	dlg.m_show_bpres_object=m_showbpres_object;
	dlg.m_show_bpres_amount=m_showbpres_amount;

	dlg.m_show_org_struct=m_show_org_struct;

	dlg.m_show_classificators=m_show_classificators;

	dlg.m_show_project_id = m_show_project_id;
	dlg.m_show_project_num_zak = m_show_project_num_zak;
	dlg.m_show_project_name = m_show_project_name;
	dlg.m_show_project_type = m_show_project_type;
	dlg.m_show_project_state = m_show_project_state;
	dlg.m_show_project_number = m_show_project_number;

	dlg.m_PrdInstId = m_PrdInstId;
	dlg.m_PrdInstSN = m_PrdInstSN;
	dlg.m_PrdInstPrd = m_PrdInstPrd;

	dlg.m_show_refusal_doc_type=m_show_refusal_doc_type;
	dlg.m_show_refusal_doc_id=m_show_refusal_doc_id;
	dlg.m_show_refusal_doc_date=m_show_refusal_doc_date;
	dlg.m_show_refusal_state=m_show_refusal_state;
	dlg.m_show_refusal_type=m_show_refusal_type;
	dlg.m_show_refusal_descr=m_show_refusal_descr;
	dlg.m_show_refusal_stage=m_show_refusal_stage;
	dlg.m_show_refusal_planer=m_show_refusal_planer;
	dlg.m_show_refusal_item=m_show_refusal_item;

	dlg.m_PersonFullInitials = m_PersonFullInitials;
	dlg.m_PersonId = m_PersonId;

	//Classifier
	dlg.m_show_classifier_level_id = m_show_classifier_level_id;
	dlg.m_show_classifier_level_name = m_show_classifier_level_name;
	dlg.m_show_classifier_level_level = m_show_classifier_level_level;

	dlg.m_show_classifier_system_id = m_show_classifier_system_id;
	dlg.m_show_classifier_system_name = m_show_classifier_system_name;

	dlg.m_show_task_id= m_show_task_id;
	dlg.m_show_task_name= m_show_task_name;
	dlg.m_show_task_process_id= m_show_task_process_id;
	dlg.m_show_task_process_name= m_show_task_process_name;
	dlg.m_show_process_id= m_show_process_id;
	dlg.m_show_process_name= m_show_process_name;

	if(dlg.DoModal()==IDOK)
	{
		m_doc_id =					dlg.m_doc_id;
		m_doc_show_add_code_document_type =					dlg.m_doc_show_add_code_document_type;
		m_doc_name =				dlg.m_doc_name;
		m_doc_type =				dlg.m_doc_type;
		m_doc_ver  =				dlg.m_doc_ver;
		m_doc_editing_user  =		dlg.m_doc_editing_user;
		m_doc_show_addional_code  =		dlg.m_doc_show_addional_code;
		m_doc_show_date  =		dlg.m_doc_show_date;
		m_doc_show_inv_num  =		dlg.m_doc_show_inv_num;;
		m_doc_show_recipient  =		dlg.m_doc_show_recipient;
		  

		m_appr_pers =				dlg.m_appr_pers;
		m_appr_pers_role =			dlg.m_appr_pers_role;
		m_appr_status =				dlg.m_appr_status;
		m_appr_date =				dlg.m_appr_date;
		m_appr_time =				dlg.m_appr_time;
		m_BPId = 					dlg.m_BPId;
		m_BPName =					dlg.m_BPName;
		m_BPType =					dlg.m_BPType;
		m_BPDescr =					dlg.m_BPDescr;
		m_BPNum =					dlg.m_BPNum;
		m_categ_id =				dlg.m_categ_id;
		m_categ_name =				dlg.m_categ_name;
		m_charact_unit =			dlg.m_charact_unit;
		m_charact_scope =			dlg.m_charact_scope;
		m_charact_value =			dlg.m_charact_value;
		m_charact_id =				dlg.m_charact_id;
		m_charact_name =			dlg.m_charact_name;
		m_org_id =					dlg.m_org_id;
		m_org_name =				dlg.m_org_name;
		m_prd_count =				dlg.m_prd_count;
		m_prd_id =					dlg.m_prd_id;
		m_prd_name =				dlg.m_prd_name;
		m_prd_position =			dlg.m_prd_position;
		m_prd_code =				dlg.m_prd_code;
		m_pdf_code =				dlg.m_pdf_code;
		m_pdf_code1 =				dlg.m_pdf_code1;
		m_pdf_code2 =				dlg.m_pdf_code2;
		m_show_charactId_or_name =	dlg.m_show_charactId_or_name;
		m_task_cancel =				dlg.m_task_cancel;
		m_task_complete =			dlg.m_task_complete;
		m_task_suspend =			dlg.m_task_suspend;
		m_showbpinst_id =			dlg.m_show_bpinst_id;
		m_showbpinst_name=			dlg.m_show_bpinst_name;
		m_showbpinst_date=			dlg.m_show_bpinst_date;
		m_showbpres_id=				dlg.m_show_bpres_id;
		m_showbpres_type=			dlg.m_show_bpres_type;
		m_showbpres_object=			dlg.m_show_bpres_object;
		m_showbpres_amount=			dlg.m_show_bpres_amount;
		m_show_org_struct=			dlg.m_show_org_struct;
		m_show_classificators=		dlg.m_show_classificators;
		m_show_project_id =			dlg.m_show_project_id;
		m_show_project_num_zak =	dlg.m_show_project_num_zak;
		m_show_project_name =		dlg.m_show_project_name;
		m_show_project_type =		dlg.m_show_project_type;
		m_show_project_state =		dlg.m_show_project_state;
		m_show_project_number =		dlg.m_show_project_number;
		m_PrdInstId =				dlg.m_PrdInstId;
		m_PrdInstSN =				dlg.m_PrdInstSN;
		m_PrdInstPrd =				dlg.m_PrdInstPrd;

		m_show_refusal_doc_type=dlg.m_show_refusal_doc_type;
		m_show_refusal_doc_id=dlg.m_show_refusal_doc_id;
		m_show_refusal_doc_date=dlg.m_show_refusal_doc_date;
		m_show_refusal_state=dlg.m_show_refusal_state;
		m_show_refusal_type=dlg.m_show_refusal_type;
		m_show_refusal_descr=dlg.m_show_refusal_descr;
		m_show_refusal_stage=dlg.m_show_refusal_stage;
		m_show_refusal_planer=dlg.m_show_refusal_planer;
		m_show_refusal_item=dlg.m_show_refusal_item;


		m_PersonFullInitials =		dlg.m_PersonFullInitials;
		m_PersonId =				dlg.m_PersonId;

		m_show_classifier_level_id =		dlg.m_show_classifier_level_id;
		m_show_classifier_level_name =		dlg.m_show_classifier_level_name;
		m_show_classifier_level_level =		dlg.m_show_classifier_level_level;
		
		m_show_classifier_system_id =		dlg.m_show_classifier_system_id;
		m_show_classifier_system_name =		dlg.m_show_classifier_system_name;

		m_show_task_id= dlg.m_show_task_id;
		m_show_task_name= dlg.m_show_task_name;
		m_show_task_process_id= dlg.m_show_task_process_id;
		m_show_task_process_name= dlg.m_show_task_process_name;
		m_show_process_id= dlg.m_show_process_id;
		m_show_process_name= dlg.m_show_process_name;

		SaveData();
		return TRUE;
	}
	return FALSE;
}
