// SpravFilterPropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "SpravFilterPropDlg.h"
#include "aplGuiEx.h"

//#include "FindAdjustCharactDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSpravFilterPropDlg dialog


CSpravFilterPropDlg::CSpravFilterPropDlg(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CSpravFilterPropDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSpravFilterPropDlg)
	//}}AFX_DATA_INIT
	m_is_load_bmp=false;
	m_all_char=0;
	m_sel_row=-1;
	m_edit_col=-1;
	m_edit_row=-1;
	m_edited=false;
}


void CSpravFilterPropDlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSpravFilterPropDlg)
	DDX_Control(pDX, IDC_DATETIME, m_DateTime);
	DDX_Control(pDX, IDC_COMBO, m_Combo);
	DDX_Control(pDX, IDC_EDIT, m_Edit);
	DDX_Control(pDX, IDC_LIST_ADJUST, m_ListAdjust);
	DDX_Control(pDX, IDOK, m_BtnOk);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSpravFilterPropDlg, CResizableDialog)
	//{{AFX_MSG_MAP(CSpravFilterPropDlg)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_ADJUST, OnRclickListAdjust)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_ADJUST, OnDblclkListAdjust)
	ON_NOTIFY(NM_CLICK, IDC_LIST_ADJUST, OnClickListAdjust)
	ON_NOTIFY(NM_SETFOCUS, IDC_LIST_ADJUST, OnSetfocusListAdjust)
	ON_NOTIFY(LVN_KEYDOWN, IDC_LIST_ADJUST, OnKeydownListAdjust)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSpravFilterPropDlg message handlers

BOOL CSpravFilterPropDlg::OnInitDialog() 
{
	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	// TODO: Add extra initialization here
	m_Combo.SetParent(&m_ListAdjust);
	m_Edit.SetParent(&m_ListAdjust);
	m_DateTime.SetParent(&m_ListAdjust);
//	m_ImageList.Create(16,16,ILC_COLOR,0,0);
//	m_ListAdjust.SetImageList(&m_ImageList,LVSIL_SMALL);
	
	EnableToolTips(TRUE);
	if(m_api==0) return FALSE;

	COLORMAP  cm;
	cm.from=RGB(192,192,192);
	cm.to=GetSysColor(COLOR_BTNFACE);

	if(!m_is_load_bmp)
	{
		imagelist_but.Create(IDR_MENU_ICONS,20,2,cm.from);
		m_is_load_bmp=true;
	}

	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_BtnOk.SetFlat(FALSE);
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);

	//    
	HWND hWnd = ::GetDlgItem(m_hWnd, IDC_LIST_ADJUST);
	ListView_SetExtendedListViewStyle(hWnd, 
		ListView_GetExtendedListViewStyle(hWnd) | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES );
	m_ListAdjust.ModifyStyle(0, LVS_REPORT|LVS_SINGLESEL|LVS_SHOWSELALWAYS);

	AddAnchor(IDC_LIST_ADJUST, TOP_LEFT, BOTTOM_RIGHT);
	
	AddAnchor(IDOK, BOTTOM_RIGHT, BOTTOM_RIGHT);
	AddAnchor(IDCANCEL, BOTTOM_RIGHT, BOTTOM_RIGHT);

	RECT rect;
	//        
	m_ListAdjust.GetWindowRect(&rect);
	int width=rect.right-rect.left;
	int delt;
	delt=div(width,100).quot;
	m_ListAdjust.InsertColumn(0, APL_T(""),LVCFMT_LEFT,delt*30);
	m_ListAdjust.InsertColumn(1, APL_T(""),LVCFMT_LEFT,delt*20);
	m_ListAdjust.InsertColumn(2, APL_T(""),LVCFMT_LEFT,delt*17);
	m_ListAdjust.InsertColumn(3, APL_T(" 1"),LVCFMT_LEFT,delt*17);
	m_ListAdjust.InsertColumn(4, APL_T(" 2"),LVCFMT_LEFT,delt*17);

	FillTableCharact();
	FillTableAdjust();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CSpravFilterPropDlg::FillTableCharact() 
{
	int i,j;
	CaplInstance *inst=0,*unit=0,*charact=0,*type=0;
	ElValChar* el_ch=0;
	SFilterData *fd=0;
	COleDateTime odt;
	CString buf,buf1;
	int item_num;
	
	m_ListAdjust.DeleteAllItems();
	if(m_all_char==0 )return;

	for(i=0;i<m_all_char->GetSize();i++){
		inst=m_all_char->GetAt(i);
		if(inst==0){
			::MessageBox(0, APL_T("  !"),_T("Error"),MB_OK|MB_ICONERROR);
			return;
		}
		apidata.GetAttr(inst,m_api->m_charact_mgr.a_apl_characteristic_and_type_characteristic,charact);
		if(charact!=0){
			apidata.GetAttrBN(charact,_T("name"),buf);
		}else{
			::MessageBox(0, APL_T(" -   !"),_T("Error"),MB_OK|MB_ICONERROR);
			return;
		}
		
		apidata.GetAttrBN(charact,_T("unit"),unit);
		apidata.GetAttr(inst,m_api->m_charact_mgr.a_apl_characteristic_and_type_type,type);
		//    -     ?
		for(j=0;j<m_list_char.Size;j++){
			el_ch=m_list_char.GetAt(j);
			if(el_ch==0){
				::MessageBox(0, APL_T("  !"),_T("Error"),MB_OK|MB_ICONERROR);
				return;
			}
			if(el_ch->apl_char==charact && el_ch->type==type){
				break;
			}else{
				el_ch=0;
			}
		}
		
		fd=new SFilterData(charact,unit,type,el_ch);
		m_list_filter_data.Add(fd);
		
		apidata.GetAttrBN(charact,_T("name"),buf);
		item_num=m_ListAdjust.InsertItem(i,buf,0);
		m_ListAdjust.SetItemData(item_num,(DWORD)fd);
		
		if(type!=0){apidata.GetAttrBN(type,_T("name"),buf);}else{buf=_T("");}
		m_ListAdjust.SetItemText(item_num,1,buf);
	}
}


void CSpravFilterPropDlg::FillTableAdjust() 
{
	CaplInstance *inst=0,*unit=0,*charact=0,*type=0;
	SFilterData *fd=0;
	COleDateTime odt;
	CString buf,buf1;
	int item_num_prev=-1,item_num;

	if(m_all_char==0 )return;

//	item_num=m_ListAdjust.GetNextItem(item_num_prev,LVNI_ALL);
	while((item_num=m_ListAdjust.GetNextItem(item_num_prev,LVNI_ALL))!=-1)
	{
		item_num_prev=item_num;
		fd=(SFilterData*)m_ListAdjust.GetItemData(item_num);
		if(fd==0 || fd==(SFilterData*)-1){
			::MessageBox(0, APL_T("  !"),_T("Error"),MB_OK|MB_ICONERROR);
		}
		m_ListAdjust.SetItemText(item_num,3,_T(""));
		m_ListAdjust.SetItemText(item_num,4,_T(""));
		if(/*fd->valid &&*/ fd->el_ch!=0 && fd->el_ch->log_relation!=CaplQLQuery::aplNOLOGREL){
			if(fd->el_ch->is_exist){
				m_ListAdjust.SetItemText(item_num,2,CaplQLQuery::LogOp2String(fd->el_ch->log_relation));
				if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_step_unit))
				{
					if(fd->el_ch->b_val)m_ListAdjust.SetItemText(item_num,3,fd->el_ch->val);
					if(fd->el_ch->log_relation==CaplQLQuery::aplINDIAPAZON){
						if(fd->el_ch->b_max)m_ListAdjust.SetItemText(item_num,4,fd->el_ch->val_max);
					}
				}
				else if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_descript_unit)||
					apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_enum_unit) )
				{
					if(fd->el_ch->b_val){
						m_ListAdjust.SetItemText(item_num,3,fd->el_ch->val);
					}
				}
				else if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_monetary_unit))
				{
					if(fd->el_ch->b_val){
						m_ListAdjust.SetItemText(item_num,3,fd->el_ch->val);
					}
				}
				else if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_time_unit))
				{
					COleDateTime odt;
					if(fd->el_ch->b_val){
						aplString2Date(fd->el_ch->val,odt);
						buf1=odt.Format(_T("%d.%m.%Y"));
//						if(fd->el_ch->dtt!=0){
//							//buf1=fd->el_ch->dtt->Format(_T("%d.%m.%Y %H:%M:%S"));
//							buf1=fd->el_ch->dtt->Format(_T("%d.%m.%Y"));
//						}else{
//							buf1=_T(" ");
//						}
						m_ListAdjust.SetItemText(item_num,3,buf1);
					}
					if(fd->el_ch->log_relation==CaplQLQuery::aplINDIAPAZON){
						if(fd->el_ch->b_max){
							aplString2Date(fd->el_ch->val_max,odt);
							buf1=odt.Format(_T("%d.%m.%Y"));

//							if(fd->el_ch->dtt_max!=0){
//								//buf1=fd->el_ch->dtt->Format(_T("%d.%m.%Y %H:%M:%S"));
//								buf1=fd->el_ch->dtt_max->Format(_T("%d.%m.%Y"));
//							}else{
//								buf1=_T(" ");
//							}
							m_ListAdjust.SetItemText(item_num,4,buf1);
						}
					}

				}
				else if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_reference_unit))
				{
					if(fd->el_ch->b_val){
						m_api->m_charact_mgr.GetItemName(fd->el_ch->m_cur_ref_val,buf1);
						m_ListAdjust.SetItemText(item_num,3,buf1);
					}
				}
				else
				{
					m_ListAdjust.SetItemText(item_num,2, APL_T(""));
				}	
			}else{
				m_ListAdjust.SetItemText(item_num,2, APL_T(""));
			}
		}else{
			m_ListAdjust.SetItemText(item_num,2,_T(""));
		}
	}
}

void CSpravFilterPropDlg::OnRclickListAdjust(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	*pResult = 0;
	TestEdited();
	
//	const MSG* msg;
//	CPoint mouseclick;
//	msg=GetCurrentMessage();
//	//mouseclick -   
//	mouseclick=msg->pt;
//	CaplMenu menu;
//	CMenu* pPopup =0;
//	//  
//	VERIFY(menu.LoadMenu(IDR_CONTEXT_MENU));
//	pPopup = menu.GetSubMenu(0);
//	
//	int num_curr= m_ListAdjust.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
//	if(num_curr== -1){
//		pPopup->EnableMenuItem(IDC_CHANGE,MF_BYCOMMAND | MF_GRAYED);
//		pPopup->EnableMenuItem(IDC_DELETE,MF_BYCOMMAND | MF_GRAYED);
//	}else{
//		pPopup->SetDefaultItem(IDC_CHANGE,MF_BYCOMMAND | MF_GRAYED);
//	}
//	
//	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
//		TPM_RIGHTBUTTON|TPM_RETURNCMD,msg->pt.x, msg->pt.y,this);
//	//       :
//	switch (res)
//	{
//	case IDC_ADD: OnAdjustAdd();      break;
//	case IDC_DELETE:OnAdjustDel();	break;
//	case IDC_CHANGE:OnAdjustEdit();	break;
//	default:break;
//	}
}

void CSpravFilterPropDlg::OnClickListAdjust(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	LPNMLISTVIEW pNMListView=(LPNMLISTVIEW)pNMHDR;
	TestEdited();
	
	if(pNMListView==0)return;
	
	if(m_sel_row==pNMListView->iItem){
		Edit(pNMListView->iItem,pNMListView->iSubItem);
	}else{
		m_sel_row=pNMListView->iItem;
	}

	*pResult = 0;
}

//     
void CSpravFilterPropDlg::OnDblclkListAdjust(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	LPNMLISTVIEW pNMListView=(LPNMLISTVIEW)pNMHDR;
	TestEdited();
	
	if(pNMListView==0)return;
	Edit(pNMListView->iItem,pNMListView->iSubItem);
	*pResult = 0;
}

void CSpravFilterPropDlg::OnSetfocusListAdjust(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	//TestEdited();
	
	*pResult = 0;
}


void CSpravFilterPropDlg::Edit(int row,int col)
{
	SFilterData *fd=0;
	COleDateTime odt;
	CString buf,buf1;
	if(row==-1 || col==-1)return;

	fd=(SFilterData*)m_ListAdjust.GetItemData(row);
	if(fd==0)return;

	if(col<2)col=2;
	CRect rect,rectc;
	BOOL res=true;
	int col1size=0;
	int i,pos_added;
	CaplQLQuery::aplQLLogRelation def_log_rel;
	

	if(/*fd->valid && */fd->el_ch!=0){
		def_log_rel=fd->el_ch->log_relation;
	}else{
		def_log_rel=CaplQLQuery::aplNOLOGREL;
		//     -    ,      
		col=2;
	}
	if(def_log_rel==CaplQLQuery::aplEXIST || def_log_rel==CaplQLQuery::aplNOTEXIST){
		//       
		col=2;
	}else if(def_log_rel!=CaplQLQuery::aplINDIAPAZON && col==4){
		//    " ",    
		//  .   , 
		col=3;
	}

	m_ListAdjust.GetItemRect(row,rect,LVIR_BOUNDS);
	m_ListAdjust.GetClientRect(&rectc);
	if(rectc.right<rect.right)rect.right=rectc.right;
	for(i=col-1;i>=0;i--){
		col1size+=m_ListAdjust.GetColumnWidth(i);
	}
	rect.left+=col1size;
	rect.right=rect.left+m_ListAdjust.GetColumnWidth(col);

	switch(col){
	case 2:
		res=m_Combo.SetWindowPos(&wndTop,rect.left,rect.top,rect.Width(),rect.Height(),
			SWP_SHOWWINDOW|SWP_NOCOPYBITS);
		m_Combo.SetFocus();
		m_Combo.ResetContent();
		pos_added=m_Combo.InsertString(0,_T(""));
		m_Combo.SetItemData(pos_added,(DWORD)CaplQLQuery::aplNOLOGREL);
		InserString2ControlDef(m_Combo,CaplQLQuery::aplEXIST,def_log_rel);
		InserString2ControlDef(m_Combo,CaplQLQuery::aplNOTEXIST,def_log_rel);

		if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_step_unit) ||
			apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_monetary_unit) ||
			apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_time_unit))
		{
			InserString2ControlDef(m_Combo,CaplQLQuery::aplSMALL,def_log_rel);
			InserString2ControlDef(m_Combo,CaplQLQuery::aplBIG,def_log_rel);
			InserString2ControlDef(m_Combo,CaplQLQuery::aplSMALLEQUAL,def_log_rel);
			InserString2ControlDef(m_Combo,CaplQLQuery::aplBIGEQUAL,def_log_rel);
			InserString2ControlDef(m_Combo,CaplQLQuery::aplEQUAL,def_log_rel);
			InserString2ControlDef(m_Combo,CaplQLQuery::aplNOTEQUAL,def_log_rel);
			InserString2ControlDef(m_Combo,CaplQLQuery::aplINDIAPAZON,def_log_rel);
		}
		else if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_descript_unit)||
			apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_enum_unit) )
		{
			InserString2ControlDef(m_Combo,CaplQLQuery::aplEQUAL,def_log_rel);
			InserString2ControlDef(m_Combo,CaplQLQuery::aplLIKE,def_log_rel);
			InserString2ControlDef(m_Combo,CaplQLQuery::aplNOTEQUAL,def_log_rel);
			InserString2ControlDef(m_Combo,CaplQLQuery::aplNOTLIKE,def_log_rel);
		}
		else if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_reference_unit))
		{
			InserString2ControlDef(m_Combo,CaplQLQuery::aplEQUAL,def_log_rel);
			InserString2ControlDef(m_Combo,CaplQLQuery::aplNOTEQUAL,def_log_rel);
		}
		else
		{//       ""
		}
		

		break;
	case 3:
	case 4:
		//  
		//  

		if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_step_unit) ||
			apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_monetary_unit) ||
			apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_descript_unit)||
			apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_enum_unit)
			)
		{
			rect.bottom=rect.top+16;
			res=m_Edit.SetWindowPos(&wndTop,rect.left,rect.top,rect.Width(),rect.Height(),
				SWP_SHOWWINDOW|SWP_NOCOPYBITS);
			m_Edit.SetFocus();
			if(col==3){
				m_Edit.SetWindowText(fd->el_ch->val);
			}else{
				m_Edit.SetWindowText(fd->el_ch->val_max);
			}

		}
		else if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_time_unit))
		{
			rect.bottom=rect.top+20;
			m_DateTime.SetWindowPos(&wndTop,rect.left,rect.top,rect.Width(),rect.Height(),
				SWP_SHOWWINDOW|SWP_NOCOPYBITS);
			m_DateTime.SetFocus();
			COleDateTime odt;
			if(col==3){
				aplString2Date(fd->el_ch->val,odt);
				m_DateTime.SetTime(odt);
//				if(fd->el_ch->dtt!=0){
//					m_DateTime.SetTime(*(fd->el_ch->dtt));
//					//m_time_ctrl.SetTime(*(m_el->dtt));
//				}
			}else{
				aplString2Date(fd->el_ch->val_max,odt);
				m_DateTime.SetTime(odt);
//				if(fd->el_ch->dtt_max!=0){
//					m_DateTime.SetTime(*(fd->el_ch->dtt_max));
//					//m_time_ctrl.SetTime(*(m_el->dtt));
//				}
			}

		}
		else if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_reference_unit))
		{
			//   ,     
			fd->el_ch->m_cur_ref_val=m_api->m_charact_mgr.BrowseReferenceVal(fd->unit);
			fd->el_ch->b_val=fd->el_ch->m_cur_ref_val!=0;
			m_edited=false;
			m_edit_row=-1;
			m_edit_col=-1;
			FillTableAdjust();
			return;
		}
		else
		{//       ""
		}
		break;
	}
	m_edited=true;
	m_edit_row=row;
	m_edit_col=col;

}

bool CSpravFilterPropDlg::TestEdited()
{
	if(m_edited){
		//  
		if(!TestEditedInternal()){
			return false;
		}
		//      -
		m_Combo.ShowWindow(SW_HIDE);
		m_DateTime.ShowWindow(SW_HIDE);
		m_Edit.ShowWindow(SW_HIDE);

		m_edited=false;
		m_edit_row=-1;
		m_edit_col=-1;
		m_sel_row=-1;
		FillTableAdjust();
	}
	return true;
}

bool CSpravFilterPropDlg::TestEditedInternal()
{
	SFilterData *fd=0;
	COleDateTime odt;
	CString buf,buf1;
	CaplQLQuery::aplQLLogRelation log_op;
	int pos_sel;

	if(m_edit_row==-1 || m_edit_col==-1){
		return true;
	}
	// ,   
	fd=(SFilterData*)m_ListAdjust.GetItemData(m_edit_row);
	if(fd==0){
		return true;
	}
	//          
	switch(m_edit_col){
	case 2:
		pos_sel=m_Combo.GetCurSel();
		log_op=(CaplQLQuery::aplQLLogRelation)m_Combo.GetItemData(pos_sel);
		if(log_op==CaplQLQuery::aplNOLOGREL || log_op==-1){
			//fd->valid=false;
			if(fd->el_ch!=0){
				fd->el_ch->log_relation=CaplQLQuery::aplNOLOGREL;
				fd->el_ch->b_val=false;
				fd->el_ch->b_max=false;
			}
			return true;
		}
		if(fd->el_ch==0){
			fd->el_ch=new ElValChar();
			m_list_char.Add(fd->el_ch);
		}
		if(fd->el_ch!=0){
			/*fd->valid=true;*/
			fd->el_ch->is_exist=true;
			fd->el_ch->log_relation=log_op;
			fd->el_ch->apl_char=fd->charact;
			fd->el_ch->type=fd->type;
			if(log_op!=CaplQLQuery::aplINDIAPAZON){
				fd->el_ch->b_max=false;
			}
			if(log_op==CaplQLQuery::aplEXIST || log_op==CaplQLQuery::aplNOTEXIST){
				fd->el_ch->b_val=false;
				fd->el_ch->b_max=false;
			}
		}
		break;
	case 3:
	case 4:

		if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_step_unit) ||
			apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_monetary_unit))
		{
			m_Edit.GetWindowText(buf);
			if(buf.IsEmpty()==TRUE){
				if(m_edit_col==3){
					fd->el_ch->b_val=false;
				}else{
					fd->el_ch->b_max=false;
				}
				break;
			}
			//    
			if(!IsReal(buf)){
				if(AfxMessageBox( APL_T("    .  ?"),MB_YESNO)==IDNO){
					break;
				}else{
					//m_Edit.SetForegroundWindow();
					SetActiveWindow( );
					m_Edit.SetFocus();
					return false;
				}
			}
			if(m_edit_col==3){
				fd->el_ch->val=buf;
				fd->el_ch->b_val=true;
			}else{
				fd->el_ch->val_max=buf;
				fd->el_ch->b_max=true;
			}

		}
		else if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_descript_unit)||
				apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_enum_unit))
		{
			m_Edit.GetWindowText(buf);
			if(m_edit_col==3){
				fd->el_ch->val=buf;
			}else{
				fd->el_ch->val_max=buf;
			}
			fd->el_ch->b_val=true;
			
		}
		else if(apidata.IsKindOf(fd->unit,m_api->m_charact_mgr.e_apl_time_unit))
		{
			COleDateTime d_time/*,t_time*/;
			m_DateTime.GetTime(d_time);
			//m_time_ctrl.GetTime(t_time);
			if(m_edit_col==3){
				aplDate2String(d_time,fd->el_ch->val);
//				if(fd->el_ch->dtt==0){fd->el_ch->dtt=new COleDateTime();}
//				//fd->el_ch->dtt->SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),t_time.GetHour(),t_time.GetMinute(),t_time.GetSecond());
//				fd->el_ch->dtt->SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),0,0,0);
				fd->el_ch->b_val=true;
			}else{
				aplDate2String(d_time,fd->el_ch->val_max);
//				if(fd->el_ch->dtt_max==0){fd->el_ch->dtt_max=new COleDateTime();}
//				//fd->el_ch->dtt_max->SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),t_time.GetHour(),t_time.GetMinute(),t_time.GetSecond());
//				fd->el_ch->dtt_max->SetDateTime(d_time.GetYear(),d_time.GetMonth(),d_time.GetDay(),0,0,0);
				fd->el_ch->b_max=true;
			}
		}			


		break;
	}
	
	//   (   measured)
	
	return true;
}

void CSpravFilterPropDlg::OnOK() 
{
	// TODO: Add extra validation here
	int i,j;
	SFilterData *fd=0;
	CString buf,buf1;

	if(m_edited){
		TestEdited();
		return;
	}
	for(i=0;i<m_list_filter_data.GetSize();i++){
		fd=m_list_filter_data.GetAt(i);
		if(fd->el_ch==0) continue;
		if(fd->el_ch->log_relation==CaplQLQuery::aplEXIST ||
			fd->el_ch->log_relation==CaplQLQuery::aplNOTEXIST)
		{
			continue;
		}
		if(fd->el_ch->log_relation==CaplQLQuery::aplINDIAPAZON)
		{
			if(fd->el_ch->b_val==false)
			{
				buf= APL_T("      \"");
				apidata.GetAttrBN(fd->charact,_T("name"),buf1);
				buf+=buf1;
				if(fd->type!=0){
					apidata.GetAttrBN(fd->type,_T("name"),buf1);
					buf+=_T("\":\"")+buf1;
				}
				buf+=_T("\"");
				AfxMessageBox(buf);
				return;
			}
			if( fd->el_ch->b_max==false)
			{
				buf= APL_T("      \"");
				apidata.GetAttrBN(fd->charact,_T("name"),buf1);
				buf+=buf1;
				if(fd->type!=0){
					apidata.GetAttrBN(fd->type,_T("name"),buf1);
					buf+=_T("\":\"")+buf1;
				}
				buf+=_T("\"");
				AfxMessageBox(buf);
				return;
			}
		}else if(fd->el_ch->log_relation!=CaplQLQuery::aplNOLOGREL)
		{
			if(fd->el_ch->b_val==false)
			{
				buf= APL_T("      \"");
				apidata.GetAttrBN(fd->charact,_T("name"),buf1);
				buf+=buf1;
				if(fd->type!=0){
					apidata.GetAttrBN(fd->type,_T("name"),buf1);
					buf+=_T("\":\"")+buf1;
				}
				buf+=_T("\"");
				AfxMessageBox(buf);
				return;
			}
		}else{
			//   
			for(j=0;j<m_list_char.GetSize();j++){
				if(m_list_char.GetAt(j)==fd->el_ch){
					m_list_char.Remove(j);
					fd->el_ch=0;
					break;
				}
			}
		}

	}
	//   -     -
	CaplInstance *inst,*charact,*type;
	ElValChar* el_ch;
	bool flag_del;
	if(m_all_char==0){
		m_list_char.Clear();
	}else{
		for(j=0;j<m_list_char.GetSize();j++){
			el_ch=m_list_char.GetAt(j);
			if(el_ch->apl_char==0){
				m_list_char.Remove(j);
				j--;
				continue;
			}
			flag_del=true;
			for(i=0;i<m_all_char->GetSize();i++){
				inst=m_all_char->GetAt(i);
				apidata.GetAttr(inst,m_api->m_charact_mgr.a_apl_characteristic_and_type_characteristic,charact);
				apidata.GetAttr(inst,m_api->m_charact_mgr.a_apl_characteristic_and_type_type,type);
				if(el_ch->apl_char==charact && el_ch->type==type){
					flag_del=false; break;
				}
			}
			if(flag_del){
				m_list_char.Remove(j);
				j--;
				continue;
			}
		}
	}


	CResizableDialog::OnOK();
}


void CSpravFilterPropDlg::OnKeydownListAdjust(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_KEYDOWN* pLVKeyDow = (LV_KEYDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here
	*pResult = 0;
	if(!TestEdited()){
		*pResult = 1;
	}
	
}
