// aplBaseTreeItem.h: interface for the CaplBaseTreeItem class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_APLBASETREEITEM_H__BEF5D248_E416_44D1_89A9_83E47541C4C1__INCLUDED_)
#define AFX_APLBASETREEITEM_H__BEF5D248_E416_44D1_89A9_83E47541C4C1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "apl_gui.h"
#include "apl_api.h"

#define APL_SHOW_DOC			1
#define APL_SHOW_CHARACT		2
#define APL_SHOW_APPROVAL		4
#define APL_SHOW_MATERIAL		8
#define APL_SHOW_LOT			16
#define APL_SHOW_INST			32
#define APL_SHOW_BP				64
#define APL_SHOW_RES			128
#define APL_SHOW_VER			256
#define APL_SHOW_BPINST			512
#define APL_SHOW_SUBSTITUTE		1024

class CLASS_DECL_APL_STEP_MGR CaplTreeExpandOptions
{
public:
	UINT m_showintree_prd;
	UINT m_showintree_pdf;
	UINT m_showintree_prdinst;
	UINT m_showintree_doc;
	UINT m_showintree_charact;
	UINT m_showintree_change;
	UINT m_showintree_bp;
	UINT m_showintree_bpres;
	UINT m_showintree_bpinst;
	UINT m_showintree_categ;
	UINT m_showintree_lot;
	UINT m_showintree_project;
	UINT m_showintree_org;
	UINT m_showintree_official;
	UINT m_showintree_person;
	UINT m_showintree_classif_s;
	UINT m_showintree_classif_l;

	CaplTreeExpandOptions(UINT value);
		
	void InitializeTreeExpandOptions();
	void EditTreeExpandOptions();
};

/************************************************************************/
/*                                                                      */
/************************************************************************/

class CaplBaseTreeItem;
typedef CaplTAggr <CaplBaseTreeItem*, CaplBaseTreeItem*, APLAGGR_LIST|APLAGGR_AUTOKILLREF> aplTIArray;

class CLASS_DECL_APL_STEP_MGR CaplBaseTreeItem : public CaplTreeItemData  
{

public:
	CaplBaseTreeItem(CaplAPI* api= NULL, CTreeCtrl* tree= NULL, aplTIArray* items= NULL,
		CaplInstance* inst= NULL, CaplInstance* rel= NULL);
	virtual ~CaplBaseTreeItem();
	
	virtual bool RefreshItem(){return true;}
    virtual bool Expand(UINT action){return true;}
	virtual void ShowCmd(long cmd){return;}
    virtual bool CreateTreeItem(HTREEITEM parent_item){return true;};
	
	virtual void CollapseItem(bool bInsertFictive= true);
	bool GetChilds(aplTIArray &childs);
	CaplBaseTreeItem* GetParent();
	bool RefreshAllItems();
	
	virtual void ShowAllDocs(bool bShowMessage= true){;}
	virtual void ShowAllApproval(bool showMsg= true){;}
    virtual	void ShowAllCharacteristic(bool  showMsg= true){;}
	
	virtual void Sort(bool bRefreshParent=false);
    static	int CALLBACK CompareHtreeItem(LPARAM lParam1, LPARAM lParam2,LPARAM lParamSort);

	CaplAPI* m_api;
	HTREEITEM m_fictive_item;
	
	CaplInstance* m_inst;
	CaplInstance* m_rel;
	
	aplTIArray	*m_ItemsArray;
	
	aplExtent m_relatedInstances;
	CaplMap m_relatedItems;

	static CaplTreeExpandOptions m_ExpandOption;
};


#endif // !defined(AFX_APLBASETREEITEM_H__BEF5D248_E416_44D1_89A9_83E47541C4C1__INCLUDED_)
