// aplCharactView.cpp : implementation file
//

#include "stdafx.h"
#include "aplCharactView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CaplCharactView

IMPLEMENT_DYNCREATE(CaplCharactView, CaplPropsView)

CaplCharactView::CaplCharactView()
{
}

CaplCharactView::~CaplCharactView()
{
}


BEGIN_MESSAGE_MAP(CaplCharactView, CaplPropsView)
	//{{AFX_MSG_MAP(CaplCharactView)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CaplCharactView drawing

void CaplCharactView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CaplCharactView diagnostics

#ifdef _DEBUG
void CaplCharactView::AssertValid() const
{
	CaplPropsView::AssertValid();
}

void CaplCharactView::Dump(CDumpContext& dc) const
{
	CaplPropsView::Dump(dc);
}
#endif //_DEBUG



BOOL CaplCharactView::InitColumns(void)
{
	CListCtrl*	pList		=NULL;

	CString		csTxt[]		={ APL_T(""), APL_T(""), APL_T(""), APL_T("")};
	int			iSz[]		={100,150,100,150};

	int			i;

	pList=&GetListCtrl();
	if(NULL==pList)
		return FALSE;

	pList->SetImageList(aplGetInstImageList(),LVSIL_SMALL);

	for(i=0;i<sizeof(iSz)/sizeof(int);i++)
		pList->InsertColumn(i,csTxt[i],LVCFMT_LEFT,iSz[i]);

	long lStyles=::GetWindowLong(GetListCtrl().m_hWnd,GWL_STYLE);
	lStyles|=LVS_SINGLESEL|LVS_SHOWSELALWAYS;
	::SetWindowLong(GetListCtrl().m_hWnd,GWL_STYLE,lStyles);

	return TRUE;
}

void CaplCharactView::ChangeCtrlsState(void)
{
	CaplInstance*	cit	=NULL;

	POSITION pos		=NULL;

	CListCtrl*	pList	=NULL;

	BOOL	bEnAdd		=FALSE;
	BOOL	bEnDel		=FALSE;
	BOOL	bEnProps	=FALSE;

	int		ipos;

	if(!IsWindowVisible())
		return;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	pos=pList->GetFirstSelectedItemPosition();
	if(NULL!=m_inst)
	{
		if(m_inst->GetAccessmode()<aplRO)
		{
			bEnAdd=TRUE;
			if(NULL!=pos)
			{
				ipos=pList->GetNextSelectedItem(pos);
				cit=(CaplInstance*)pList->GetItemData(ipos);

				if(m_api->m_data.IsMyInstance(cit, true))
				{
					if(cit->GetAccessmode()==aplOWN)
						bEnDel=TRUE;
					bEnProps=TRUE;
				}			
			}
		}
		else
		if(m_inst->GetAccessmode()==aplRO)
			if(NULL!=pos)
				bEnProps=TRUE;
	}

	m_pAdd->EnableWindow(bEnAdd);
	m_pDel->EnableWindow(bEnDel);
	m_pProps->EnableWindow(bEnProps);
}

BOOL CaplCharactView::LoadData(void)
{
	aplExtent	aeGrp,aet;

	if(NULL==m_api)
		return TRUE;

	if(NULL==m_inst)
		return TRUE;

	int bWithSystem= 0;
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("     "), bWithSystem, 0);

	if(false==m_api->m_charact_mgr.FindAssociatedCharacteristic(m_inst,m_aeItems,aeGrp, false, false, true, (bWithSystem!=0)?true:false))
		return FALSE;
	if(apidata.IsKindOf(m_inst,m_api->m_prd_mgr.e_apl_pdf))
	{
		CaplInstance*	cit	=NULL;
		if(false==apidata.GetAttr(m_inst,m_api->m_prd_mgr.a_pdf_prd,cit))
			return FALSE;
		if(false==m_api->m_charact_mgr.FindAssociatedCharacteristic(cit,aet,aeGrp, false, false, true, (bWithSystem!=0)?true:false))
			return FALSE;
		m_aeItems.Append(aet);
	}

	return TRUE;
}

BOOL CaplCharactView::_FillItem(int iPos,CaplInstance* ciIn)
{
	CaplInstance*		ciChar	=	NULL;
	CaplInstance*		ciUnit	=	NULL;
	CaplInstance*		cit		=	NULL;

	CListCtrl*			pList	=	NULL;

	CString				cst;

	int					i;

	if(NULL==m_api)
		return FALSE;

	if(NULL==ciIn)
		return FALSE;

	pList=&GetListCtrl();
	if(NULL==pList)
		return FALSE;

	if(pList->GetItemCount()<=iPos)
		iPos=pList->InsertItem(iPos,_T(""),m_api->GetInstIco(ciIn));
	else
	{
		LVITEM item;
		item.iItem=iPos;
		item.mask=LVIF_IMAGE;
		item.iImage=m_api->GetInstIco(ciIn);
		pList->SetItem(&item);
	}

	for(i=0;i<pList->GetHeaderCtrl()->GetItemCount();i++)
		pList->SetItemText(iPos,i,_T(""));

	if (apidata.IsKindOf(ciIn, m_api->m_charact_mgr.e_apl_charact_value_ver))
		apidata.GetAttr(ciIn, m_api->m_charact_mgr.a_apl_charact_val_ver_charact, ciChar);
	else
		apidata.GetAttr(ciIn, m_api->m_charact_mgr.a_apl_charact_val_charact, ciChar);
	
	apidata.GetAttr(ciChar, m_api->m_charact_mgr.a_apl_charact_unit, ciUnit);

	apidata.GetAttr(ciChar,m_api->m_charact_mgr.a_apl_charact_id,cst);
	pList->SetItemText(iPos,0,cst);cst=_T("");

	apidata.GetAttr(ciChar,m_api->m_charact_mgr.a_apl_charact_name,cst);
	pList->SetItemText(iPos,1,cst);cst=_T("");

	if (apidata.IsKindOf(ciIn, m_api->m_charact_mgr.e_apl_charact_value_ver))
		apidata.GetAttr(ciIn,m_api->m_charact_mgr.a_apl_charact_val_ver_type, cit);
	else
		apidata.GetAttr(ciIn,m_api->m_charact_mgr.a_apl_charact_val_type, cit);

	if(NULL!=cit)
		apidata.GetAttr(cit,m_api->m_charact_mgr.a_apl_charact_type_name,cst);
	pList->SetItemText(iPos,2,cst);cst=_T("");

	m_api->m_charact_mgr.PrintCharacteristicValue(ciIn,ciUnit,cst);
	pList->SetItemText(iPos,3,cst);cst=_T("");

	pList->SetItemData(iPos,(DWORD)ciIn);

	return TRUE;
}
/////////////////////////////////////////////////////////////////////////////
// CaplCharactView message handlers

void CaplCharactView::OnInitialUpdate() 
{
	CaplPropsView::OnInitialUpdate();
}

void CaplCharactView::OnBAdd(void)
{
	CListCtrl*		pList	=NULL;

	CaplInstance*	cit		=NULL;

	if(0==m_inst->GetType())
		return;
	if(m_inst->GetAccessmode()>aplRO)
		return;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	CaplInstance* inst;

	if(m_api->m_data.IsKindOf(m_inst, m_api->m_bp_mgr.e_apl_bp_ver))
		m_api->m_data.GetAttr(m_inst, m_api->m_bp_mgr.a_bp_ver_bp, inst);
	else
		inst= m_inst;

	if(true==m_api->m_charact_mgr.CreateCharacteristic(inst,NULL,&cit,NULL,NULL))
	{
		_FillItem(m_aeItems.GetSize(),cit);
		m_aeItems.Add(cit);
	}
	ReSort();
}

void CaplCharactView::OnBDel(void)
{
	CaplInstance*	cit		=NULL;

	CListCtrl*		pList	=NULL;

	POSITION		pos		=NULL;

	int				i,iPos,iRet;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;
	pos=pList->GetFirstSelectedItemPosition();
	if(NULL==pos)
		return;
	iPos=pList->GetNextSelectedItem(pos);

	cit=(CaplInstance*)pList->GetItemData(iPos);
	if(NULL==cit)
		return;
	
	iRet=AfxMessageBox( APL_T(" ?"),MB_ICONQUESTION|MB_YESNO);
	if(IDNO==iRet)
		return;

	if(true==m_api->m_charact_mgr.DeleteCharacteristic(cit))
	{
		for(i=0;i<m_aeItems.GetSize();i++)
			if(cit==m_aeItems.GetAt(i))
			{
				m_aeItems.Remove(i);
				break;
			}

		pList->DeleteItem(iPos);

		apidata.NET_SaveChanges( APL_T(" "));
	}
}

void CaplCharactView::OnBProps(void)
{
	CaplInstance*	cit		=NULL;

	CListCtrl*		pList	=NULL;

	POSITION		pos		=NULL;

	int				iPos;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;
	pos=pList->GetFirstSelectedItemPosition();
	if(NULL==pos)
		return;
	iPos=pList->GetNextSelectedItem(pos);

	cit=(CaplInstance*)pList->GetItemData(iPos);
	if(NULL==cit)
		return;

	if(true==m_api->m_charact_mgr.ShowProperties(cit))
		_FillItem(iPos,cit);
}
