// apl_api.cpp

#include "stdafx.h"
#include "apl_api.h"
#include "dictionary.h"
#include "FindPKIDlg.h"
#include "SetAccessContentAndRecursive.h"
#include "ChangePasswordDlg.h"
//#include "aplProjectMgr.h"
#include "GetStrDlg.h"

//     
//#define WRITE_TICK_LOG

#ifdef WRITE_TICK_LOG

//   .   .    
#define WriteTickLog(mess) \
	if(tmpp_name != _T("")){CString tmpp;DWORD tmpp_t2=GetTickCount()-tmpp_t1;tmpp.Format(_T("%04i : "),tmpp_t2);tmpp+=tmpp_name;list_times.Add(tmpp);}else{}\
	tmpp_name = mess;\
	if(tmpp_name != _T("")){tmpp_t1=GetTickCount();}

//      .      
#define SaveTickLog {CString mess;GetClearTickLog(mess);m_data.WriteLocalLog(mess);}

CStringArray list_times;

CString tmpp_name=_T("");
DWORD tmpp_t1=0;

void GetClearTickLog(CString &mess)
{
	WriteTickLog(_T(""));
	mess = _T("");
	for(int i=0;i<list_times.GetSize();i++)
	{
		mess+=list_times.GetAt(i);
		mess+=_T("\n");
	}
	list_times.RemoveAll();
}

#else // WRITE_TICK_LOG

#define WriteTickLog(mess)
#define SaveTickLog

#endif // WRITE_TICK_LOG

//************************************************************************
//************************************************************************
//************************************************************************

bool CaplAPI::m_bLss3Mode = false;

CaplAPI::CaplAPI()
{
	m_AutoSave= true;
	m_AutoUsurpire=true;
	m_ModeInteractive= true;
	m_MaxItemsLoad= 1000;
	m_bModeIntegration= false;
	m_expl_mgr=0;
	m_wms_mgr=NULL;
	m_packet_mgr = NULL;
	m_techGuide_mgr = NULL;
	m_wf_mgr= NULL;	
	m_config_mgr = NULL;
	m_forum_mgr= NULL;
	m_project_mgr= new CaplPreProjectManager;
	m_load_characteristic_values = false;
	m_old_mode_save_access = false;
	m_bUseConfigurationPdfs= true;
	m_bLoadedOrgstruct=false;
}

CaplAPI::~CaplAPI()
{
	if(m_project_mgr)
	{
		delete m_project_mgr;
		m_project_mgr= NULL;
	}

//  [1/28/2013 lobanov]     -   
/* 
	if(m_config_mgr)
	{
		delete m_config_mgr;
		m_config_mgr = NULL;
	}
*/
}

bool CaplAPI::Connect(const TCHAR *_username, const TCHAR *_pwd,const TCHAR* _name_connect, long connection_type, const TCHAR* wait_text, bool supress_dlg)
{
	WriteTickLog(_T("m_data.NET_Connect"));
	bool b=m_data.NET_Connect(_username,_pwd,_name_connect,connection_type,wait_text, supress_dlg);
	WriteTickLog(APL_T("  Init"));
	m_bLoadedOrgstruct=false;
	Init();
	return m_data.IsConnected();
}

bool CaplAPI::Disconnect()
{
	m_data.NET_Disconnect();
	m_data.ClearData();
	m_data.ClearDict();
	m_bLoadedOrgstruct=false;
	Init();
	return true;
}

bool CaplAPI::SaveChanges()
{
	if(m_data.IsReadOnly()) return false;
	if(m_data.IsConnected())
		return m_data.NET_SaveChanges();
	else if(m_data.IsDictLoad())
		return m_data.SaveToFile(NULL);
	return false;
}

void CaplAPI::Init()
{
	if(m_data.m_CurSchema==_T("apl_tgb_a")) return;

	if(m_data.IsConnected() || !m_data.m_CurSchema.IsEmpty())
	{
		if(AfxGetMainWnd())
			AfxGetMainWnd()->BeginWaitCursor();

		WriteTickLog(_T("m_categ_mgr.Attach"));
		m_categ_mgr.Attach(this);	
		
		WriteTickLog(_T("m_doc_mgr.Attach"));
		m_doc_mgr.Attach(this);
		
		WriteTickLog(_T("m_prd_mgr.Attach"));
		m_prd_mgr.Attach(this);
		
		WriteTickLog(_T("m_prd_inst_mgr.Attach"));
		m_prd_inst_mgr.Attach(this);	
		
		WriteTickLog(_T("m_bp_mgr.Attach"));
		m_bp_mgr.Attach(this);	
		
		WriteTickLog(_T("m_charact_mgr.Attach"));
		m_charact_mgr.Attach(this);
		
		WriteTickLog(_T("m_unit_exch_mgr.Attach"));
		m_unit_exch_mgr.Attach(this);
		
		WriteTickLog(_T("m_folder_mgr.Attach"));
		m_folder_mgr.Attach(this);
		
		WriteTickLog(_T("m_message_mgr.Attach"));
		m_message_mgr.Attach(this);
		
		WriteTickLog(_T("m_appr_mgr.Attach"));
		m_appr_mgr.Attach(this);		

		WriteTickLog(_T("m_change_mgr.Attach"));
		m_change_mgr.Attach(this);

		WriteTickLog(_T("m_classifier_mgr.Attach"));
		m_classifier_mgr.Attach(this);

		WriteTickLog(_T("m_req_mgr.Attach"));
		m_req_mgr.Attach(this);
						
		if(m_expl_mgr)
		{
			WriteTickLog(_T("m_expl_mgr->Attach"));
			if(!m_expl_mgr->Attach(this))
			{
				AfxMessageBox( APL_T("    .   !"));
				Disconnect();
				if(AfxGetMainWnd())
					AfxGetMainWnd()->EndWaitCursor();
				return;
			}
		}
		WriteTickLog(_T("m_project_mgr->Attach"));
		if(m_project_mgr)
			m_project_mgr->Attach(this);
		WriteTickLog(_T("m_config_mgr->Attach"));
		if(m_config_mgr)
			m_config_mgr->Attach(this);
		WriteTickLog(_T("m_wf_mgr->Attach"));
		if(m_wf_mgr)
			m_wf_mgr->Attach(this);
		WriteTickLog(_T("m_packet_mgr->Attach"));
		if (m_packet_mgr)
			m_packet_mgr->Attach(this);
		WriteTickLog(_T("m_wms_mgr->Attach"));
		if(m_wms_mgr)
			m_wms_mgr->Attach(this);
		WriteTickLog(_T("m_techGuide_mgr->Attach"));
		if (m_techGuide_mgr)
			m_techGuide_mgr->Attach(this);

		WriteTickLog(_T("m_forum_mgr->Attach"));
		if(m_forum_mgr)
			m_forum_mgr->Attach(this);
		WriteTickLog(_T("m_form_mgr.Attach"));
		m_form_mgr.Attach(this);
		WriteTickLog(_T("m_query_mgr.Attach"));
		//   Attach    !!!!!!    top-level ,     
		m_query_mgr.Attach(this);
		WriteTickLog(_T("m_options_mgr.Attach"));
		//   Attach   !!!!!!
		m_options_mgr.Attach(this);

		WriteTickLog(_T("m_project_mgr->LoadDictionary"));
		m_project_mgr->LoadDictionary();
		if(AfxGetMainWnd())
			AfxGetMainWnd()->EndWaitCursor();

		WriteTickLog(_T("m_prd_mgr.InitCompareSNLibrary"));
		m_prd_mgr.InitCompareSNLibrary(); //  ,     
	}
	else
	{
		m_categ_mgr.Detach();	
		m_doc_mgr.Detach();
		m_prd_mgr.Detach();
		m_prd_inst_mgr.Detach();	
		m_bp_mgr.Detach();	
		m_charact_mgr.Detach();
		m_unit_exch_mgr.Detach();
		m_folder_mgr.Detach();
		m_message_mgr.Detach();
		m_appr_mgr.Detach();		
		m_change_mgr.Detach();
		m_query_mgr.Detach();
		m_project_mgr->Detach();
		m_options_mgr.Detach();
		m_classifier_mgr.Detach();
		m_req_mgr.Detach();
				
		if (m_expl_mgr)
			m_expl_mgr->Detach();
		if (m_packet_mgr)
			m_packet_mgr->Detach();
		if (m_techGuide_mgr)
			m_techGuide_mgr->Detach();
		if(m_config_mgr)
			m_config_mgr->Detach();
		if(m_wf_mgr)
			m_wf_mgr->Detach();
		if(m_wms_mgr)
			m_wms_mgr->Detach();
		if(m_forum_mgr)
			m_forum_mgr->Detach();
		
		m_form_mgr.Detach();
	}
	
	WriteTickLog(APL_T(" Set"));
	SetAutoSave(m_AutoSave);
	SetAutoUsurpire(m_AutoUsurpire);
	SetModeInteractive(m_ModeInteractive);

	SetMaxItemsLoad(m_MaxItemsLoad);
	WriteTickLog(_T(""));
	SaveTickLog;

	if(m_data.IsConnected())
	{
		if(!m_categ_mgr.m_AllAttrDefined	||
			!m_doc_mgr.m_AllAttrDefined	||
			!m_prd_mgr.m_AllAttrDefined	||
			!m_prd_inst_mgr.m_AllAttrDefined	||
			!m_bp_mgr.m_AllAttrDefined	||
			!m_charact_mgr.m_AllAttrDefined	||
			!m_unit_exch_mgr.m_AllAttrDefined	||
			!m_folder_mgr.m_AllAttrDefined	||
			!m_message_mgr.m_AllAttrDefined	||
			!m_appr_mgr.m_AllAttrDefined	||
			!m_change_mgr.m_AllAttrDefined	||
			!m_query_mgr.m_AllAttrDefined   ||
			!m_project_mgr->m_AllAttrDefined ||
			!m_options_mgr.m_AllAttrDefined ||
			!m_form_mgr.m_AllAttrDefined    ||
			!m_classifier_mgr.m_AllAttrDefined ||
			(m_packet_mgr && !m_packet_mgr->m_AllAttrDefined) ||
			(m_techGuide_mgr && !m_techGuide_mgr->m_AllAttrDefined) ||
			(m_wf_mgr && !m_wf_mgr->m_AllAttrDefined) ||
			(m_config_mgr && !m_config_mgr->m_AllAttrDefined) ||
			(m_wms_mgr && !m_wms_mgr->m_AllAttrDefined))
		{
			if(m_ModeInteractive)AfxMessageBox( APL_T("  !\n   !"));
		}
	}
}
//************************************************************************
void CaplAPI::SetModeInteractive(bool mode)
{
	m_ModeInteractive= mode;
	/*m_categ_mgr.m_ModeInteractive=mode;	
	m_doc_mgr.m_ModeInteractive=mode;
	m_prd_mgr.m_ModeInteractive=mode;
	m_prd_inst_mgr.m_ModeInteractive=mode;	
	m_bp_mgr.m_ModeInteractive=mode;	
	m_charact_mgr.m_ModeInteractive=mode;
	m_unit_exch_mgr.m_ModeInteractive=mode;
	m_folder_mgr.m_ModeInteractive=mode;
	m_message_mgr.m_ModeInteractive=mode;
	m_appr_mgr.m_ModeInteractive=mode;		
	m_change_mgr.m_ModeInteractive=mode;
	m_query_mgr.m_ModeInteractive=mode;
	m_project_mgr->m_ModeInteractive=mode;
	m_options_mgr.m_ModeInteractive=mode;
	m_form_mgr.m_ModeInteractive=mode;
	m_classifier_mgr.m_ModeInteractive=mode;*/
}
void CaplAPI::SetAutoUsurpire(bool mode)
{
	m_AutoUsurpire= mode;
	m_categ_mgr.m_AutoUsurpire=m_AutoUsurpire;	
	m_doc_mgr.m_AutoUsurpire=m_AutoUsurpire;
	m_prd_mgr.m_AutoUsurpire=m_AutoUsurpire;
	m_prd_inst_mgr.m_AutoUsurpire=m_AutoUsurpire;	
	m_bp_mgr.m_AutoUsurpire=m_AutoUsurpire;	
	m_charact_mgr.m_AutoUsurpire=m_AutoUsurpire;
	m_unit_exch_mgr.m_AutoUsurpire=m_AutoUsurpire;
	m_folder_mgr.m_AutoUsurpire=m_AutoUsurpire;
	m_message_mgr.m_AutoUsurpire=m_AutoUsurpire;
	m_appr_mgr.m_AutoUsurpire=m_AutoUsurpire;		
	m_change_mgr.m_AutoUsurpire=m_AutoUsurpire;
	m_query_mgr.m_AutoUsurpire=m_AutoUsurpire;
	m_project_mgr->m_AutoUsurpire=m_AutoUsurpire;
	if(m_forum_mgr) m_forum_mgr->m_AutoUsurpire=m_AutoUsurpire;
	m_options_mgr.m_AutoUsurpire=m_AutoUsurpire;
	m_form_mgr.m_AutoUsurpire=m_AutoUsurpire;
	m_classifier_mgr.m_AutoUsurpire=m_AutoUsurpire;	
}
void CaplAPI::SetAutoSave(bool mode)
{
	m_AutoSave= mode;
	m_categ_mgr.m_AutoSave=m_AutoSave;	
	m_doc_mgr.m_AutoSave=m_AutoSave;
	m_prd_mgr.m_AutoSave=m_AutoSave;
	m_prd_inst_mgr.m_AutoSave=m_AutoSave;	
	m_bp_mgr.m_AutoSave=m_AutoSave;	
	m_charact_mgr.m_AutoSave=m_AutoSave;
	m_unit_exch_mgr.m_AutoSave=m_AutoSave;
	m_folder_mgr.m_AutoSave=m_AutoSave;
	m_message_mgr.m_AutoSave=m_AutoSave;
	m_appr_mgr.m_AutoSave=m_AutoSave;		
	m_change_mgr.m_AutoSave=m_AutoSave;
	m_query_mgr.m_AutoSave=m_AutoSave;
	m_project_mgr->m_AutoSave=m_AutoSave;
	if(m_forum_mgr) m_forum_mgr->m_AutoSave=m_AutoSave;
	m_options_mgr.m_AutoSave=m_AutoSave;
	m_form_mgr.m_AutoSave=m_AutoSave;	
	m_classifier_mgr.m_AutoSave=m_AutoSave;	
	if(!m_AutoSave)m_old_mode_save_access = m_data.SetModeSetAccessWithSave(true);
	else m_data.SetModeSetAccessWithSave(m_old_mode_save_access);
}
void CaplAPI::SetMaxItemsLoad(int MaxItemsLoad)
{
	m_MaxItemsLoad=MaxItemsLoad;
	m_categ_mgr.m_MaxItemsLoad=m_MaxItemsLoad;	
	m_doc_mgr.m_MaxItemsLoad=m_MaxItemsLoad;
	m_prd_mgr.m_MaxItemsLoad=m_MaxItemsLoad;
	m_prd_inst_mgr.m_MaxItemsLoad=m_MaxItemsLoad;	
	//m_bp_mgr.m_MaxItemsLoad=m_MaxItemsLoad;	
	m_bp_mgr.m_MaxItemsLoad = m_MaxItemsLoad>0?m_MaxItemsLoad:500;
	//m_charact_mgr.m_MaxItemsLoad=m_MaxItemsLoad;
	m_charact_mgr.m_MaxItemsLoad = m_MaxItemsLoad>0 ? m_MaxItemsLoad : 500;
	m_unit_exch_mgr.m_MaxItemsLoad=m_MaxItemsLoad;
	m_folder_mgr.m_MaxItemsLoad=m_MaxItemsLoad;
	m_message_mgr.m_MaxItemsLoad=m_MaxItemsLoad;
	m_appr_mgr.m_MaxItemsLoad=m_MaxItemsLoad;		
	m_change_mgr.m_MaxItemsLoad=m_MaxItemsLoad;
	m_query_mgr.m_MaxItemsLoad=m_MaxItemsLoad;
	m_project_mgr->m_MaxItemsLoad=m_MaxItemsLoad;
	if(m_forum_mgr) m_forum_mgr->m_MaxItemsLoad=m_MaxItemsLoad;
	m_options_mgr.m_MaxItemsLoad=m_MaxItemsLoad;
	m_form_mgr.m_MaxItemsLoad=m_MaxItemsLoad;
	m_classifier_mgr.m_MaxItemsLoad=m_MaxItemsLoad;
}
//************************************************************************
//************************************************************************
//************************************************************************
bool CaplAPI::GetPdfName(CaplInstance * pdf, CString &buf, bool bShowCode)
{
	buf=_T("");
	if(0 == pdf)return false;
	if(0 == pdf->GetId())return false;
	if(pdf->GetAccessmode()>aplRO)return false;
	if(!m_data.IsKindOf(pdf,m_prd_mgr.e_pdf))return false;

	if(bShowCode)
	{
		CString pdfCode1;
		m_data.GetAttr(pdf, m_prd_mgr.a_pdf_code1, pdfCode1);

		if(pdfCode1!=_T(""))
			buf = _T("[") + pdfCode1 + _T("] ");
	}

	//wmsMgr.m_api->GetItemName(pdf, name);

	CString id,name,ver;
	CaplInstance *prd;
	m_data.GetAttr(pdf, m_prd_mgr.a_pdf_prd, prd);
	m_data.GetAttr(prd, m_prd_mgr.a_prd_name, name);
	m_data.GetAttr(prd,m_prd_mgr.a_prd_id, id);
	m_data.GetAttr(pdf, m_prd_mgr.a_pdf_id, ver);

	if(ver!=_T("")) {id+=_T(" "); id+=ver;}


	if(name==_T("")) buf+=id;
	else
	{
		//     
		int i=0;
		bool bHasDigt=false;
		while (id[i]!=_T('\0'))
		{
			if(id[i]==_T(' ')&& i>3) break;
			if(id[i]>=_T('0') && id[i]<=_T('9') ) {bHasDigt=true; break;}
			i++;
		}

		if(bHasDigt) //   
		{
			buf+=name;
			buf+=_T(" ");
			buf+=id;
		}
		else //,    
		{
			buf+=id;
			if(id.Find(name)<0) { buf+=_T(" ("); buf+=name; buf+=_T(")");}
		}
	}
	return true;
}

bool CaplAPI::GetItemsName(aplExtent &ext, CString &names, const TCHAR *razdelit)
{
	int i;
	names=_T("");
	CString buf;
	CString razd=_T("; ");
	if(0!=razdelit){if(razdelit[0]!=_T('\0')) razd=razdelit;}
	for(i=0;i<ext.GetSize();i++)
	{
		if(i!=0) names+=razd;
		GetItemName(ext[i],buf);
		names+=buf;
	}
	return true;
}

//************************************************************************
//************************************************************************
//************************************************************************
CString CaplAPI::GetItemName(CaplInstance * item)
{
	CString itemName;

	GetItemName(item, itemName);
	return itemName;
}

bool CaplAPI::GetItemName(CaplInstance * item, CString &buf)
{
	buf=_T("");
	if(item==0)
	{
		return false;
	}
	if(item->IsDeleted())
	{
		buf=  APL_T("< >");
		return false;
	}
	if(item->GetAccessmode()>aplRO)
	{
		buf = _T("<   >");
		return true;
	}

	CString s_id,s_name;
	// 
	if(m_data.IsKindOf(item,m_categ_mgr.e_categ))
	{
/*		m_data.GetAttrBN(item,S::id,s_id);
		if(s_id==_T("")) s_id=_T("?");
		m_data.GetAttrBN(item,S::name,s_name);
		if(s_name==_T("")) s_name=_T("?");
		buf=s_id+_T(" : ")+s_name;*/
		//  
		CString sep = _T("");
		if(m_show.m_categ_id)
		{
			m_data.GetAttr(item,m_categ_mgr.a_categ_id,s_id);
			if(s_id==_T("")) s_id=_T("?");
		}
		if(m_show.m_categ_name)
		{
			m_data.GetAttr(item,m_categ_mgr.a_categ_name,s_name);
			if(s_name==_T("")) s_name=_T("?");
		}
		if(m_show.m_categ_id && m_show.m_categ_name) sep=_T(" : ");
		buf=s_id+sep+s_name;
	}
	// 
	else if(m_data.IsKindOf(item,m_folder_mgr.e_folder))
	{
		m_data.GetAttr(item,m_folder_mgr.a_folder_name,buf);
	}
	// 
	else if(m_data.IsKindOf(item,m_doc_mgr.e_doc))
	{
/*		m_data.GetAttrBN(item,S::id,s_id);
		if(s_id==_T("")) s_id=_T("?");
		m_data.GetAttrBN(item,S::name,s_name);
		if(s_name==_T("")) s_name=_T("?");
		buf=s_id+_T(" : ")+s_name;*/

		CString sep2=_T(""), type=_T(""),buf1;
		if(m_show.m_doc_id)
		{
			m_data.GetAttr(item,m_doc_mgr.a_doc_id,s_id);
			if(s_id==_T("")) s_id=_T("?");
			buf+=s_id;

			m_data.GetAttr(item,m_doc_mgr.a_doc_part,s_id);
			if(s_id!=_T(""))
			{
				buf+=_T("/");
				buf+=s_id;
			}
		}

		if(m_show.m_doc_show_add_code_document_type)
		{
			m_data.GetAttr(item, m_doc_mgr.a_doc_add_dt_code, buf1);
			if(buf1!=_T("")){if(buf!=_T(""))buf+=_T(" "); buf+=buf1;}
		}

		if(m_show.m_doc_name)
		{
			m_data.GetAttr(item,m_doc_mgr.a_doc_name,s_name);
			if(s_name==_T("")) s_name=_T("?");
			if(buf>_T("")) buf+=_T(" : ") + s_name;
			else buf = s_name;
		}
		if(m_show.m_doc_ver)
		{
			CaplInstance *rev;
			m_data.GetAttr(item,m_doc_mgr.a_apl_doc_active,rev);
			CString str;
			if(rev!=0 && rev->GetAccessmode()<=aplRO)
			{
				m_data.GetAttr(rev,m_doc_mgr.a_apl_doc_rev_id,str);
				if(str==_T("")) str=_T("?");
				if(buf>_T("")) buf+=_T(" : ")+str;
				else buf = str;

				m_data.GetAttr( rev, m_doc_mgr.a_apl_doc_rev_label,str);
				if(!str.IsEmpty()){if(!buf.IsEmpty())buf+=_T(" : "); buf+=str;}
			}
		}
		if(m_show.m_doc_type)
		{
			CaplInstance *type;
			m_data.GetAttr(item,m_doc_mgr.a_doc_kind,type);
			CString str;
			if(type!=0)
			{
				//m_data.GetAttrBN(type,S::product_data_type,str);
				m_data.GetAttr(type, m_doc_mgr.a_dt_pdt,str);
				if(str==_T("")) str=_T("?");
				if(buf>_T("")) buf+=_T(" : ")+str;
				else buf = str;
			}
		}
		if(m_show.m_doc_show_addional_code)
		{
			CString str;
			m_data.GetAttr(item, m_doc_mgr.a_doc_code_depend_desp, str);
			if(str==_T("")) str=_T("?");
			if(buf>_T("")) buf+=_T(" : {")+str+_T("}");
			else buf = _T("{")+str+_T("}");
		}
		if(m_show.m_doc_editing_user)
		{
			CaplInstance *lock;
			m_data.GetAttr(item,m_doc_mgr.a_apl_doc_lock,lock);
			if(lock!=0)
			{
				CString str;
				m_data.GetAttr(lock,m_doc_mgr.a_apl_doc_rev_user,str);
				if(str==_T("")) str=_T("?");
				if(buf>_T("")) buf+=_T(" : ")+str;
				else buf = str;
			}
		}
		if(m_show.m_doc_show_date)
		{
			CString str;
			m_data.GetAttr(item,m_doc_mgr.a_doc_date,str);
			if(str!=_T(""))
			{
				COleDateTime odt;
				aplString2Date(str,odt);
				str=odt.Format(_T("%d.%m.%Y"));
				buf+=APL_T(" /  : ");
				buf+=str;
			}
		}
		if(m_show.m_doc_show_inv_num)
		{
			CString str;
			m_data.GetAttr(item,m_doc_mgr.a_doc_inv_num,str);
			if(str!=_T(""))
			{
				buf+=APL_T(" /  ..: ");
				buf+=str;
			}
		}
		if(m_show.m_doc_show_recipient)
		{
			aplExtent doc_recitients;
			m_data.GetAttr(item,m_doc_mgr.a_doc_recipients,doc_recitients);
			if(doc_recitients.GetSize()>0)
			{
				buf+=APL_T(" /  : ");
				int j;
				CString str,sRecipients;
				for(j=0;j<doc_recitients.GetSize();j++)
				{
					CaplInstance *po=doc_recitients[j];
					//m_api->m_appr_mgr.GetItemName(po,buf);
					m_data.GetAttr(po, m_appr_mgr.a_org_id, str);	
					if(sRecipients!=_T("")) sRecipients+=_T(", ");
					sRecipients+=str;
				}
				buf+=sRecipients;
			}
		}
	}
	//   ( PSM  )
	else if(m_data.IsKindOf(item,m_doc_mgr.e_apl_doc_rev))
	{
		CaplInstance *doc;
		CString s_ver;
		//m_data.GetAttrBN(item,_T("of_document"),doc);
		m_data.GetAttr(item, m_doc_mgr.a_apl_doc_rev_doc, doc);
		//m_data.GetAttrBN(item,_T("revision_id"),s_ver);
		m_data.GetAttr(item,m_doc_mgr.a_apl_doc_rev_id,s_ver);
		if(doc) 
		{
			if(doc->GetType()!=0 && doc->GetAccessmode()<=aplRO)
			{
				//m_data.GetAttrBN(doc,S::id,s_id);
				m_data.GetAttr(doc, m_doc_mgr.a_doc_id,s_id);
				//m_data.GetAttrBN(doc,S::name,s_name);
				m_data.GetAttr(doc,m_doc_mgr.a_doc_name,s_name);
			}
			else {	s_id=_T("?"); s_name=_T("?");}
		}
		if(s_id==_T("")) s_id=_T("?");		
		if(s_name==_T("")) s_name=_T("?");
		buf=s_id+_T(" : ")+s_name +  APL_T(" : . ") + s_ver;
	}
	// 
	else if(m_data.IsKindOf(item,m_categ_mgr.e_apl_product_category_ver))
	{
		//CaplInstance *doc;
		//m_data.GetAttrBN(item,_T("category"),categ);
		CString s_ver;
		m_data.GetAttrBN(item,_T("number"),s_ver);
		m_data.GetAttrBN(item,S::id,s_id);
		if(s_id==_T("")) s_id=_T("?");
		m_data.GetAttrBN(item,S::name,s_name);
		if(s_name==_T("")) s_name=_T("?");
		buf=s_id+_T(" : ")+s_name +  APL_T(" : . ") + s_ver;
	}
	// 
	else if(m_data.IsKindOf(item,m_bp_mgr.e_apl_bp_ver))
	{
		buf=_T("");
		if(m_show.m_BPId)
		{
			m_data.GetAttrBN(item,S::id,s_id);
			if(s_id==_T("")) s_id=_T("?");
			buf+=s_id;
		}
		if(m_show.m_BPName)
		{
			m_data.GetAttrBN(item,S::name,s_name);
			if(s_name==_T("")) s_name=_T("?");
			if(buf>_T("")) buf+=_T(" : ")+s_name;
			else buf = s_name;
		}
		if(m_show.m_BPType)
		{
			CString tmp=_T("");
			CaplInstance *type=0;
			m_data.GetAttrBN(item,_T("type"),type);
			if(type)
			{
				m_data.GetAttrBN(type,_T("name"),tmp);
				if(tmp==_T("")) tmp=_T("?");
				buf+=_T(" : ")+tmp;
			}
			else buf+=_T(" : ?");
		}
		if(m_show.m_BPDescr)
		{
			CString tmp=_T("");
			m_data.GetAttr(item,m_bp_mgr.a_bp_ver_descr,tmp);
			if(tmp==_T("")) tmp=_T("?");
			if(tmp.GetLength()>150)
			{
				tmp = tmp.Left(147);
				tmp+=_T("...");
			}
			buf+=_T(" : ")+tmp;
		}
		buf+= APL_T(" : . ");
		CString s_ver;
		m_data.GetAttrBN(item,_T("number"),s_ver);
		buf+=s_ver;
	}
	// 
	else if(m_data.IsKindOf(item,m_prd_mgr.e_prd))
	{
/*		m_data.GetAttrBN(item,S::id,s_id);
		if(s_id==_T("")) s_id=_T("?");
		m_data.GetAttrBN(item,S::name,s_name);
		if(s_name==_T("")) s_name=_T("?");
		buf=s_id+_T(" : ")+s_name;*/
		if(m_show.m_prd_id)
		{
			m_data.GetAttr(item, m_prd_mgr.a_prd_id, s_id);
			if(s_id==_T("")) s_id = _T("?");
			buf = s_id;
		}
		if(m_show.m_prd_name)
		{
			m_data.GetAttr(item, m_prd_mgr.a_prd_id, s_name);
			if(s_name==_T("")) s_name=_T("?");
			if(buf>_T("")) buf+=_T(" : ") + s_name;
			else buf = s_name;
		}
	}
	// 
	else if(m_data.IsKindOf(item,m_prd_mgr.e_pdf))
	{
		CaplInstance *inst, *nauo=0;
		m_data.GetAttr(item, m_prd_mgr.a_pdf_prd, inst);
/*		if(inst!=0)
		{
			m_data.GetAttrBN(inst,S::id,s_id);
			if(s_id==_T("")) s_id=_T("?");
			buf=s_id;
			m_data.GetAttrBN(inst,S::name,s_name);
			//if(s_name==_T("")) s_name=_T("?");
			if(s_name!=_T("")){buf+=_T(" : "); buf+=s_name;}
			m_data.GetAttrBN(item,S::id,s_id);
			if(s_id!=_T("")) {buf+=_T(" : "); buf+=s_id;}
		}
		else buf=_T("?");*/
		if(inst!=0)
		{
			if(m_show.m_prd_id)
			{
				m_data.GetAttr(inst, m_prd_mgr.a_prd_id, s_id);
				if(s_id==_T("")) s_id=_T("?");
				if(buf!=_T("")) buf+=_T(" : ")+s_id;
				else buf = s_id;

				m_data.GetAttr(item,m_prd_mgr.a_pdf_id, s_id);
				if(buf.IsEmpty())
					buf = s_id;
				else
				{
					if(!s_id.IsEmpty())	buf +=_T(" - ")+s_id;	
				}
					
			}
		
			if(m_show.m_prd_name)
			{
				m_data.GetAttr(inst, m_prd_mgr.a_prd_name, s_name);
				if(s_name==_T("")) s_name=_T("?");
				if(buf!=_T(""))	buf+=_T(" : ")+s_name;
				else buf = s_name;
			}

			//  
			if(m_show.m_prd_code)
			{
				CString code;
				CaplInstance *prd;
				m_data.GetAttr(item,m_prd_mgr.a_pdf_prd, prd);

				if(prd)
				{
					m_data.GetAttr(prd, m_prd_mgr.a_prd_code, code);
					if(buf.IsEmpty() &&!code.IsEmpty())	
						buf = code;
					else if(!buf.IsEmpty() && !code.IsEmpty())
					{
						buf+=_T(" [");
						buf+=code;
						buf+=_T("]");
					}				
				}
			}

			if(m_show.m_pdf_code)
			{
				CString code;
				m_data.GetAttr(item,m_prd_mgr.a_pdf_code, code);
				if(buf.IsEmpty() &&!code.IsEmpty())
					buf = code;
				else if(!buf.IsEmpty() && !code.IsEmpty())
				{
					buf+=_T(" [");
					buf+=code;
					buf+=_T("]");
				}				
			}

			if(m_show.m_pdf_code1)
			{
				CString code;
				m_data.GetAttr(item,m_prd_mgr.a_pdf_code1, code);
				if(buf.IsEmpty() &&!code.IsEmpty())
					buf = code;
				else if(!buf.IsEmpty() && !code.IsEmpty())
				{
					buf+=_T(" [");
					buf+=code;
					buf+=_T("]");
				}				
			}

			if(m_show.m_pdf_code2)
			{
				CString code;
				m_data.GetAttr(item,m_prd_mgr.a_pdf_code2, code);
				if(buf.IsEmpty() &&!code.IsEmpty())
					buf = code;
				else if(!buf.IsEmpty() && !code.IsEmpty())
				{
					buf+=_T(" [");
					buf+=code;
					buf+=_T("]");
				}				
			}

			//if(!buf.IsEmpty() && !s_id.IsEmpty()) buf+=_T(" : ");
		}
		else buf=_T("?");

	}
	// 
	else if(m_data.IsKindOfBN(item,_T("apl_action")))
	{
		m_data.GetAttrBN(item,S::id,s_id);
		if(s_id==_T("")) s_id=_T("?");
		m_data.GetAttrBN(item,S::name,s_name);
		if(s_name==_T("")) s_name=_T("?");
		buf=s_id+_T(" : ")+s_name;
	}
	// - 
	else if(m_data.IsKindOf(item,m_bp_mgr.e_bp))
	{
/*		m_data.GetAttrBN(item,S::id,s_id);
		if(s_id==_T("")) s_id=_T("?");
		m_data.GetAttrBN(item,S::name,s_name);
		if(s_name==_T("")) s_name=_T("?");
		buf=s_id+_T(" : ")+s_name;*/
		buf=_T("");
		if(m_show.m_BPId)
		{
			m_data.GetAttrBN(item,S::id,s_id);
			if(s_id==_T("")) s_id=_T("?");
			buf+=s_id;
		}
		if(m_show.m_BPName)
		{
			m_data.GetAttrBN(item,S::name,s_name);
			if(s_name==_T("")) s_name=_T("?");
			if(buf>_T("")) buf+=_T(" : ")+s_name;
			else buf = s_name;
		}
		if(m_show.m_BPType)
		{
			CString tmp=_T("");
			CaplInstance *type=0;
			m_data.GetAttrBN(item,_T("type"),type);
			if(type)
			{
				m_data.GetAttrBN(type,_T("name"),tmp);
				if(tmp==_T("")) tmp=_T("?");
				buf+=_T(" : ")+tmp;
			}
			else buf+=_T(" : ?");
		}
		if(m_show.m_BPDescr)
		{
			CString tmp=_T("");
			m_data.GetAttr(item,m_bp_mgr.a_bp_descr,tmp);
			if(tmp==_T("")) tmp=_T("?");
			if(tmp.GetLength()>150)
			{
				tmp = tmp.Left(147);
				tmp+=_T("...");
			}
			buf+=_T(" : ")+tmp;
		}
	}
	// 
	else if(m_data.IsKindOf(item,m_bp_mgr.e_bp_res))
	{
		if(m_show.m_showbpres_id)
		{
			m_data.GetAttr(item,m_bp_mgr.a_bp_res_id,s_id);
			if(s_id==_T("")) buf=_T("?");
			else buf=s_id;
		}
		if(m_show.m_showbpres_type)
		{
			CaplInstance *inst;
			m_data.GetAttr(item,m_bp_mgr.a_bp_res_type,inst);
			if(inst!=0) m_data.GetAttr(inst,m_bp_mgr.a_bp_res_type_name,s_name);
			if(s_name==_T("")) s_name=_T("?");
			if(buf>_T("")) buf+=_T(" : ")+s_name;
			else buf = s_name;
		}
		if(m_show.m_showbpres_object)
		{
			CaplInstance *inst;
			m_data.GetAttr(item,m_bp_mgr.a_bp_res_object,inst);
			if(inst!=0) m_bp_mgr.GetItemName(inst,s_name);
			if(s_name==_T("")) s_name=_T("?");
			if(buf>_T("")) buf+=_T(" : ")+s_name;
			else buf = s_name;
		}
		if(m_show.m_showbpres_amount)
		{
			CString tmp=_T("");
			CaplInstance *inst;
			double v;
			CString buf1;
			m_data.GetAttr(item,m_bp_mgr.a_bp_res_val,v);
			if(v!=0)
			{
				m_data.GetAttr(item,m_bp_mgr.a_bp_res_unit,inst);
				m_charact_mgr.GetUnitName(inst,buf1);
				tmp.Format(_T(" : %g %s"),v,LPCTSTR(buf1));
			}
			if(tmp==_T("")) tmp=_T("?");
			if(buf>_T("")) buf+=_T(" : ")+tmp;
			else buf = tmp;
		}
	}
	//  
	else if(m_data.IsKindOf(item,m_prd_inst_mgr.e_lot))
	{
//		CaplInstance *inst;
//		m_data.GetAttrBN(item,S::id,buf);
//		m_data.GetAttrBN(item,S::formation,inst);
//		if(inst!=0)
//		{
//			GetItemName(inst,s_name);
//			if(s_name!=_T("")) { buf+=_T(" {"); buf+=s_name;buf+=_T("}"); }
//		}
		CString buf1,buf2;
		m_data.GetAttr(item,m_prd_inst_mgr.a_lot_id,buf);
		CaplInstance *pdf;
		m_data.GetAttr(item,m_prd_inst_mgr.a_lot_pdf,pdf);
		if(pdf!=0)
		{
			m_prd_inst_mgr.GetItemName(pdf,buf1);
			if(buf1!=_T(""))	{ buf+=_T(" {"); buf+=buf1; buf+=_T("}");}
		}
		CaplInstance *inst0,*inst1;
		double count;
		m_data.GetAttr(item,m_prd_inst_mgr.a_lot_size,inst0);
		if(inst0!=0)
		{
			m_data.GetAttr(inst0,m_prd_inst_mgr.a_mwu_val,count);
			m_data.GetAttr(inst0,m_prd_inst_mgr.a_mwu_unit,inst1);
			m_charact_mgr.GetUnitName(inst1,buf1);
			buf2.Format(_T(" [%g %s]"),count,buf1);
			buf+=buf2;
		}

	}
	//  
	else if(m_data.IsKindOf(item,m_prd_inst_mgr.e_prd_inst))
	{
		CString sn, id;
		CaplInstance *inst;
		if(m_show.m_PrdInstId)
		{
			m_data.GetAttr(item,m_prd_inst_mgr.a_prd_inst_id, id);
			if(id.IsEmpty())
				id = _T("???");
			buf += id;
		}
		if(m_show.m_PrdInstSN)
		{
			m_data.GetAttr(item,m_prd_inst_mgr.a_prd_inst_sn, sn);
			if(!buf.IsEmpty() && !sn.IsEmpty()) buf+= APL_T(" : ");
			buf += sn;
		}
		if(m_show.m_PrdInstPrd)
		{
			m_data.GetAttrBN(item,S::formation,inst);
			if(inst!=0)
			{
				GetItemName(inst,s_name);
				if(s_name!=_T("")) { buf+=_T(" {"); buf+=s_name;buf+=_T("}"); }
			}
		}
	}
	else if(m_data.IsKindOf(item,m_appr_mgr.e_pers_org))
	{
		m_appr_mgr.GetPersonName(item,buf,m_show.m_PersonFullInitials==FALSE);
	}
	else if(m_data.IsKindOf(item,m_appr_mgr.e_person))
	{
		m_appr_mgr.GetPersonName(item,buf,m_show.m_PersonFullInitials==FALSE);
	}
	else if(m_data.IsKindOf(item,m_appr_mgr.e_official))
	{
		m_appr_mgr.GetPersonName(item,buf,m_show.m_PersonFullInitials==FALSE);
//		m_data.GetAttr(item, m_appr_mgr.a_official_id, buf);
	}
	else if(m_data.IsKindOf(item,m_appr_mgr.e_org ))
	{
		if(m_show.m_org_id)
		{
			m_data.GetAttr(item, m_appr_mgr.a_org_id, s_id);
			if(s_id.IsEmpty()) s_id=_T("?");
			buf=s_id;
		}
		if(m_show.m_org_name)
		{
			m_data.GetAttr(item, m_appr_mgr.a_org_name, s_name);
			if(s_name.IsEmpty()) s_name=_T("?");
			if(!buf.IsEmpty()) buf+=_T(" : ")+s_name;
			else buf = s_name;
		}

	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_apl_assigned_document))
	{
		m_data.GetAttrBN(item,_T("apl_assigned_document_location_path"),buf);
	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_apl_stored_document))
	{
		m_doc_mgr.GetFileName(item, buf);
	}
	else if(m_data.IsKindOf(item, m_project_mgr->e_project))
	{
		CString tmp=_T("");
		if(m_show.m_show_project_id)
		{
			m_data.GetAttr(item, m_project_mgr->a_project_id, tmp);
			if(tmp.IsEmpty()) tmp = _T("?");
		}
		buf+=tmp;
		if(m_show.m_show_project_num_zak)
		{
			m_data.GetAttr(item, m_project_mgr->a_project_number, s_name);
			if(s_name!=_T("")) {buf+=_T(" ["); buf+=s_name; buf+=_T("] ");}
		}
		if(m_show.m_show_project_name)
		{
			m_data.GetAttr(item, m_project_mgr->a_project_name, s_name);
			if(s_name.IsEmpty()) s_name= _T("?");
			if(buf.IsEmpty()) buf = s_name;
			else buf = buf+_T(" : ")+s_name;
		}
		if(m_show.m_show_project_type)
		{
			CaplInstance* type = NULL;
			m_data.GetAttr(item,m_project_mgr->a_project_type, type);
			if(type!=NULL)
			{
				m_data.GetAttr(type,m_project_mgr->a_project_type_name,tmp);
				if(tmp.IsEmpty()) tmp=_T("?");
				if(buf.IsEmpty()) buf = tmp;
				else buf = buf+_T(" : ")+tmp;
			}
		}
		if(m_show.m_show_project_state)
		{
			m_data.GetAttr(item,m_project_mgr->a_project_state,tmp);
			if(tmp.IsEmpty()) tmp=_T("?");
			if(buf.IsEmpty()) buf = tmp;
			else buf = buf+_T(" : ")+tmp;
		}
	}
	else if(m_data.IsKindOf(item,m_project_mgr->e_project_adm_ver))
	{
		CString s_ver;
		m_data.GetAttr(item,m_project_mgr->a_project_adm_ver_num,s_ver);
		m_data.GetAttr(item,m_project_mgr->a_project_adm_ver_id,s_id);
		if(s_id==_T("")) s_id=_T("?");
		m_data.GetAttr(item,m_project_mgr->a_project_adm_ver_name,s_name);
		if(s_name==_T("")) s_name=_T("?");

		CaplInstance *project_ver_project=0,*locker=0;
		m_data.GetAttr(item,m_project_mgr->a_project_adm_ver_project,project_ver_project);
		if(project_ver_project) m_data.GetAttr(project_ver_project,m_project_mgr->a_project_locker_adm_version,locker); 
		if(item==locker) 
		{
			CString tmp=_T("");
			if(m_show.m_show_project_id)
			{
				buf+=s_id;
			}
			
			if(m_show.m_show_project_num_zak)
			{
				CString s_num;
				m_data.GetAttr(item,m_project_mgr->a_project_adm_ver_num,s_num);
				if(s_num!=_T("")){buf+=_T(" ["); buf+=s_num; buf+=_T("] ");}
			}

			if(m_show.m_show_project_name)
			{
				if(buf.IsEmpty()) buf = s_name;
				else buf +=_T(" : ")+s_name;
			}
			if(m_show.m_show_project_type)
			{
				CaplInstance* type = NULL;
				m_data.GetAttr(project_ver_project,m_project_mgr->a_project_type, type);
				if(type!=NULL)
				{
					m_data.GetAttr(type,m_project_mgr->a_project_type_name,tmp);
					if(tmp.IsEmpty()) tmp=_T("?");
					if(buf.IsEmpty()) buf = tmp;
					else buf += _T(" : ")+tmp;
				}
			}
			if(m_show.m_show_project_state)
			{
				m_data.GetAttr(project_ver_project,m_project_mgr->a_project_state,tmp);
				if(tmp.IsEmpty()) tmp=_T("?");
				if(buf.IsEmpty()) buf = tmp;
				else buf += _T(" : ")+tmp;
			}
		}
		else 
			buf=s_id+_T(" : ")+s_name +  APL_T(" : . ") + s_ver;
	}
	else if(m_data.IsKindOf(item, m_bp_mgr.e_apl_bp_inst))
	{
		CString name=_T("");
		if(m_show.m_showbpinst_id)
		{
			m_data.GetAttr(item,m_bp_mgr.a_bp_inst_id,buf);
			if(buf==_T("")) buf=_T("?");
			if(name>_T("")) name+=_T(" : ")+buf;
			else name = buf;
		}
		if(m_show.m_showbpinst_name)
		{
			m_data.GetAttr(item,m_bp_mgr.a_bp_inst_name,buf);
			if(buf==_T("")) buf=_T("?");
			if(name>_T("")) name+=_T(" : ")+buf;
			else name = buf;
		}
		if(m_show.m_showbpinst_date)
		{
			CString val;
			m_data.GetAttr(item,m_bp_mgr.a_bp_inst_date_time,val);
			COleDateTime time;
			aplString2Date(val,time);
			val = time.Format(_T("%d.%m.%Y %H:%M"));
			name+=_T(" : ")+val;
		}
		buf = name;
	}
	else if(m_expl_mgr !=0 && m_data.IsKindOf(item, m_expl_mgr->e_apl_refusal))
	{
		CString buf1;
		if(m_show.m_show_refusal_stage)
		{
			CaplInstance *inst;
			m_data.GetAttr(item, m_expl_mgr->a_apl_refusal_stage, inst);			
			if(inst)m_data.GetAttr(inst, m_classifier_mgr.a_apl_classifier_level_name, buf1);
			else buf1=_T("");

			if(buf1!=_T(""))
			{
				if(buf!=_T("")) buf+=_T(" ");
				buf+=buf1;
			}
		}

		if(m_show.m_show_refusal_doc_type)
		{
			m_data.GetAttr(item, m_expl_mgr->a_apl_refusal_doc_type, buf1);
			if(buf1!=_T(""))
			{
				if(buf!=_T("")) buf+=_T(" ");
				buf+=buf1;
			}
		}
		if(m_show.m_show_refusal_doc_id)
		{
			m_data.GetAttr(item,m_expl_mgr->a_apl_refusal_doc_num,buf1);
			if(buf1!=_T(""))
			{
				if(buf!=_T("")) buf+=_T(" ");
				buf+=buf1;
			}
		}
		if(m_show.m_show_refusal_doc_date)
		{
			m_data.GetAttr(item,m_expl_mgr->a_apl_refusal_doc_date,buf1);
			if(buf1!=_T(""))
			{
				COleDateTime odt;
				aplString2Date(buf1,odt);
				if(buf!=_T("")) buf+=_T(" ");
				buf+=_T('[');
				buf+=odt.Format(_T("%d.%m.%Y"));// %H:%M:%S");
				buf+=_T(']');
			}
		}
		if(m_show.m_show_refusal_state)
		{
			m_data.GetAttr(item, m_expl_mgr->a_apl_refusal_state, buf1);
			if(buf1!=_T(""))
			{
				if(buf!=_T("")) buf+=_T(" ");
				buf+=_T('{');
				buf+=buf1;
				buf+=_T('}');
			}
		}
		if(m_show.m_show_refusal_type)
		{
			CaplInstance *ref_type;
			m_data.GetAttr(item,m_expl_mgr->a_apl_refusal_type,ref_type);
			if(0!=ref_type)
			{
				m_data.GetAttr(ref_type,m_classifier_mgr.a_apl_classifier_level_name,buf1);
				if(buf!=_T("")) buf+=_T(" ");
				buf+=buf1;
			}
		}
		if(m_show.m_show_refusal_descr)
		{
			m_data.GetAttr(item, m_expl_mgr->a_apl_refusal_description, buf1);
			if(buf1!=_T(""))
			{
				if(buf!=_T("")) buf+=_T(" ");
				buf+=buf1;
			}
		}
		if(m_show.m_show_refusal_planer)
		{
			CaplInstance *inst;
			m_data.GetAttr(item, m_expl_mgr->a_apl_refusal_planer, inst);
			GetItemName(inst,buf1);
			
			if(buf1!=_T(""))
			{
				if(buf!=_T("")) buf+=_T(" / ");
				buf+=buf1;
			}
		}
		if(m_show.m_show_refusal_item)
		{
			CaplInstance *inst;
			m_data.GetAttr(item, m_expl_mgr->a_apl_refusal_item, inst);
			GetItemName(inst,buf1);

			if(buf1!=_T(""))
			{
				if(buf!=_T("")) buf+=_T(" / ");
				buf+=buf1;
			}	
		}
	}
	else if(m_data.IsKindOf(item, m_message_mgr.e_alert))
	{
		CaplInstance* cur_person=NULL;
		CaplInstance* person, *author;
		cur_person = m_appr_mgr.GetCurrentPerson();
		CString tmp=_T(""), date;
		m_data.GetAttr(item,m_message_mgr.a_alert_text,tmp);
		m_data.GetAttr(item,m_message_mgr.a_alert_date,date);
		COleDateTime time;
		aplString2Date(date,time);
		date = time.Format(_T("%d.%m.%Y %H:%M"));
		m_data.GetAttr(item,m_message_mgr.a_alert_person,person);
		m_data.GetAttr(item,m_message_mgr.a_alert_author,author);
		
		buf+=date+_T(" : ")+tmp;

		CString sName;
		m_appr_mgr.GetPersonName(author,sName);
		buf+=_T(" ( ");
		buf+=sName;
		buf+=_T(" => ");
		m_appr_mgr.GetPersonName(person,sName);
		buf+=sName;
		buf+=_T(" )");
	}
	else if(m_data.IsKindOf(item, m_options_mgr.e_str))
	{
		m_data.GetAttr(item,m_options_mgr.a_str_name,buf);
	}
	else if(m_data.IsKindOf(item, m_options_mgr.e_int))
	{
		m_data.GetAttr(item,m_options_mgr.a_int_name,buf);
	}
	else if (m_data.IsKindOf(item, m_options_mgr.e_double))
	{
		m_data.GetAttr(item, m_options_mgr.a_double_name, buf);
	}
	else if(m_data.IsKindOf(item, m_options_mgr.e_inst))
	{
		m_data.GetAttr(item,m_options_mgr.a_inst_name,buf);
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_unit))
	{
		m_data.GetAttr(item,m_charact_mgr.a_apl_unit_id,buf);
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_charact_type))
	{
		m_data.GetAttr(item,m_charact_mgr.a_apl_charact_type_name,buf);
	}
	else if(m_data.IsKindOf(item, m_change_mgr.e_chng))
	{
		CString buf1;
		m_data.GetAttr(item, m_change_mgr.a_chng_id, buf);

		if(!m_options_mgr.CheckInstallCode(_T("grpz"))) //    
		{
			m_data.GetAttr(item, m_change_mgr.a_chng_name, buf1);
			if(!buf.IsEmpty() && !buf1.IsEmpty()) buf+=_T(":");
			buf+=buf1;
		}

		m_data.GetAttr(item, m_change_mgr.a_chng_urgency, buf1);
		if(buf1!=_T("")){buf+=_T(" {"); buf+=buf1; buf+=_T("}");}

	}
	else if(m_data.IsKindOf(item, m_change_mgr.e_avc))
	{
		CString sDate;
		CString sStr;
		COleDateTime time;
		CaplInstance *cit = NULL;
		
		//     
		LoadItemInfo(item);
		m_data.GetAttr(item, m_change_mgr.a_chng_item_accept_date, sDate);
		aplString2Date(sDate, time);
		sDate.Format( APL_T(": %.2d.%.2d.%.4d;"), time.GetDay(), time.GetMonth(), time.GetYear());
		
		m_data.GetAttr(item, m_change_mgr.a_avc_doc, cit);
		if(cit)
		{
//			LoadItemInfo(cit);
			GetItemName(cit, buf);
			sDate +=  APL_T(" : ") + buf;
		}
		
		m_data.GetAttr(item, m_change_mgr.a_chng_item_id, buf);
		if(!buf.IsEmpty()) sDate =  _T(":")+ buf+_T("; ")+sDate;
		
		m_data.GetAttr(item, m_change_mgr.a_avc_new_rev, cit);
		sStr= _T("?");
		if(cit)
			m_data.GetAttr(cit, m_doc_mgr.a_apl_doc_rev_id, sStr);
		sDate+= APL_T("; : ")+sStr;

		buf = sDate;
	}
	else if(m_data.IsKindOf(item, m_change_mgr.e_psc))
	{
		CaplInstance* pdr_or_pdf= NULL;
		CaplInstance* assemly_pdf= NULL;
		CaplInstance* part_pdf= NULL;
		CaplInstance* new_pdf= NULL;

		aplExtent ext;

		CString sType;
		CString sName;
		CString cond1, cond2, sEff;
		COleDateTime odt;
		
//		m_change_mgr.LoadItemInfo(item);

		m_data.GetAttr(item, m_change_mgr.a_psc_changed_product, pdr_or_pdf);
		m_data.GetAttr(item, m_change_mgr.a_psc_changing_product, new_pdf);

		m_data.GetAttr(item, m_change_mgr.a_psc_eff_type, sType);
		cond1= _T(""); cond2= _T("");
		
		if(sType==_T("dated"))
		{
			m_data.GetAttr(item, m_change_mgr.a_psc_start_date, cond1);
			if(!cond1.IsEmpty())
			{
				aplString2Date(cond1, odt);
				cond1= odt.Format(_T("%d.%m.%Y"));
				sEff+= APL_T(": ");sEff+=cond1;
			}

			m_data.GetAttr(item, m_change_mgr.a_psc_end_date, cond2);
			if(!cond2.IsEmpty())
			{
				aplString2Date(cond2, odt);
				cond2= odt.Format(_T("%d.%m.%Y"));
				sEff+= APL_T(" : ");sEff+=cond2;				
			}
		}
		else if(sType==_T("numbered"))
		{
			m_data.GetAttr(item, m_change_mgr.a_psc_start_num, cond1);
			if(!cond1.IsEmpty())
			{
				sEff+= APL_T(": ");sEff+=cond1;
			}
			m_data.GetAttr(item, m_change_mgr.a_psc_end_num, cond2);
			if(!cond2.IsEmpty())
			{
				sEff+= APL_T(" : ");sEff+=cond2;				
			}
		}
		else //    
		{
			m_data.GetAttr(item, m_change_mgr.a_chng_item_accept_date, cond1);
			if(!cond1.IsEmpty())
			{
				aplString2Date(cond1, odt);
				cond1= odt.Format(_T("%d.%m.%Y"));
				sEff+= APL_T(": ");sEff+=cond1;
			}
			else
			{
				sEff=  APL_T("[   ]");
			}
		}

		if(!pdr_or_pdf)//     
		{
			m_data.GetAttr(item, m_change_mgr.a_psc_created_pdr, pdr_or_pdf);
			if(pdr_or_pdf)
			{
//				LoadItemInfo(pdr_or_pdf);
				m_data.GetAttr(pdr_or_pdf, m_prd_mgr.a_pdr_r_ting, assemly_pdf);
				m_data.GetAttr(pdr_or_pdf, m_prd_mgr.a_pdr_r_ted, part_pdf);
				ext.Add(assemly_pdf);
				ext.Add(part_pdf);
//				LoadExtentInfo(ext);
				
				if(assemly_pdf)
				{
					buf+= APL_T("[!]   ");
					GetItemName(assemly_pdf, sName);
					buf+=sName;
					buf+=  APL_T("    [!]");
					
					buf+=  APL_T("; : ");
					m_data.GetAttr(item, m_change_mgr.a_chng_item_id, sName);
					buf+=sName;
					
					if(new_pdf)
					{
//						LoadItemInfo(new_pdf);

						buf+= APL_T(";     ");
						GetItemName(new_pdf, sName);
						buf+=sName;
					}
				}
			}
			else // 
			{
				buf+= APL_T("[!]       [!]");
			}
		}
		else 
		{
			if(pdr_or_pdf && m_data.IsKindOf(pdr_or_pdf, m_prd_mgr.e_pdf) && new_pdf)// 
			{
				buf+= APL_T(": ");
				GetItemName(pdr_or_pdf, sName);
				buf+=sName;
				
				buf+=  APL_T("; : ");
				m_data.GetAttr(item, m_change_mgr.a_chng_item_id, sName);
				buf+=sName;
				
//				LoadItemInfo(new_pdf);

				buf+= APL_T("; : ");
				GetItemName(new_pdf, sName);
				buf+=sName;			
			}
			else if(pdr_or_pdf && m_data.IsKindOf(pdr_or_pdf, m_prd_mgr.e_pdr))
			{
//				LoadItemInfo(pdr_or_pdf);

				m_data.GetAttr(pdr_or_pdf, m_prd_mgr.a_pdr_r_ting, assemly_pdf);
				m_data.GetAttr(pdr_or_pdf, m_prd_mgr.a_pdr_r_ted, part_pdf);
				if(assemly_pdf && part_pdf)
				{
					ext.Add(assemly_pdf);
					ext.Add(part_pdf);
					if(new_pdf)ext.Add(new_pdf);
//					LoadExtentInfo(ext);
					
					buf+= APL_T(": ");
					GetItemName(assemly_pdf, sName);
					buf+=sName;
					
					buf+=  APL_T("; : ");
					m_data.GetAttr(item, m_change_mgr.a_chng_item_id, sName);
					buf+=sName;
					
					buf+= APL_T("; : ");
					GetItemName(part_pdf, sName);
					buf+=sName;
					
					if(new_pdf)// 
					{
						buf+= APL_T(";   : ");
						if(new_pdf->GetAccessmode()>aplRO)
							sName= _T("???");
						else
							GetItemName(new_pdf, sName);
						buf+=sName;
					}
					else// 
					{
						buf+= APL_T("; ");				
					}
				}			
			}

		}
		
		buf+= APL_T("; : ");
		buf+=sEff;			
	}
	else if(m_data.IsKindOf(item, m_appr_mgr.e_apl_appr))
	{
		CaplInstance *inst;
		CString buf1;
		
		if(m_show.m_appr_status)
		{
			m_data.GetAttr(item, m_appr_mgr.a_appr_status/*"status"*/,inst);
			if(inst!=0) m_data.GetAttr(inst, m_appr_mgr.a_appr_status_name/*S::name*/,buf);
		}
		
		if(m_show.m_appr_pers_role)
		{
			if(buf.GetLength()>0) buf+=_T(" ");
			m_data.GetAttrBN(item,_T("role"),buf1);
			buf+=buf1;
		}
		if(m_show.m_appr_pers)
		{
			if(buf.GetLength()>0) buf+=_T(" ");
			m_data.GetAttrBN(item,_T("person_organization"),inst);
			//m_appr_mgr.GetPersonName(inst,buf1);
			GetItemName(inst,buf1);
			buf+=buf1;
		}
		if(m_show.m_appr_date)
		{
			m_data.GetAttr(item, m_appr_mgr.a_appr_appr_date_time_s, buf1);
			
			COleDateTime time;
			CString sTime;
			if(aplString2Date(buf1, time))
			{
				TCHAR* res_date = new TCHAR[255];
				SYSTEMTIME SysTime;
				time.GetAsSystemTime(SysTime);
				::GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, &SysTime, NULL, res_date, 255);
				buf1 = res_date;
				if(m_show.m_appr_time)
				{
					::GetTimeFormat(LOCALE_USER_DEFAULT, TIME_NOSECONDS, &SysTime, NULL, res_date, 255);
					sTime = res_date;
					buf+=_T(" [")+buf1+_T(" ")+sTime+_T("]");
				}
				else
					buf+=_T(" [")+buf1+_T("]");
				delete [] res_date;
			}
			m_data.GetAttrBN(item, _T("revocation_date_time"), buf1);
			
			if(aplString2Date(buf1, time))
			{
				TCHAR* res_date = new TCHAR[255];
				SYSTEMTIME SysTime;
				time.GetAsSystemTime(SysTime);
				::GetDateFormat(LOCALE_USER_DEFAULT, DATE_SHORTDATE, &SysTime, NULL, res_date, 255);
				buf1 = res_date;
				if(m_show.m_appr_time)
				{
					::GetTimeFormat(LOCALE_USER_DEFAULT, TIME_NOSECONDS, &SysTime, NULL, res_date, 255);
					sTime = res_date;
					buf+=_T(" /[")+buf1+_T(" ")+sTime+_T("]");
				}
				else
					buf+=_T(" /[")+buf1+_T("]");
				delete [] res_date;
			}
		}
	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_doc_copy_order))
	{
		CString t_str, sType;
		CaplInstance *cit = NULL;

		m_data.GetAttr(item, m_doc_mgr.a_purchase_order_type, sType);

		m_data.GetAttr(item, m_doc_mgr.a_purchase_order_id, t_str);
		buf += t_str;

		if(sType == _T("print"))
		{
			buf += _T(" {");

			m_data.GetAttr(item, m_doc_mgr.a_purchase_order_order, t_str);
			buf += t_str + _T(": ");

			m_data.GetAttr(item, m_doc_mgr.a_purchase_order_code, t_str);
			buf += t_str + _T(": ");

			m_data.GetAttr(item, m_doc_mgr.a_purchase_order_cust, cit);
			GetItemName(cit, t_str);
			buf += t_str + _T("}");		
		}
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_charact))
	{
		CString name, id;
		if(m_show.m_charact_id)
			m_data.GetAttr(item, m_charact_mgr.a_apl_charact_id, id);
		if(m_show.m_charact_name)
			m_data.GetAttr(item, m_charact_mgr.a_apl_charact_name, name);
		if(id.IsEmpty() && !name.IsEmpty())
			buf = name;
		else if(name.IsEmpty() && !id.IsEmpty())
			buf = id;
		else if(!name.IsEmpty() && !id.IsEmpty())
			buf = id+_T(" : ")+name;

		return true;
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_charact_value))
	{
		CaplInstance *inst = NULL,*m_unit = NULL,*type = NULL, *ver = NULL;
		ver=m_charact_mgr.CheckMyLock(item, false);
		
		if(ver)
		{
			if(ver->GetAccessmode()>aplRO) { buf= APL_T("( )");return true;}
			m_data.GetAttr(ver, m_charact_mgr.a_apl_charact_val_ver_charact,inst);
			m_data.GetAttr(ver, m_charact_mgr.a_apl_charact_val_ver_type,type);
		}
		else
		{
			if(item->GetAccessmode()>aplRO) { buf= APL_T("( )");return true;}
			m_data.GetAttr(item, m_charact_mgr.a_apl_charact_val_charact,inst);
			m_data.GetAttr(item, m_charact_mgr.a_apl_charact_val_type,type);
		}
		CString name, id, type_name, value;

		if(inst!=0)
		{
			GetItemName(inst, buf);
		}
		if(type!=0) m_data.GetAttr(type,  m_charact_mgr.a_apl_charact_type_name, type_name);
		if(!type_name.IsEmpty()) {buf+=_T(" ("); buf+=type_name;buf+=_T(")"); }
		if(inst!=0) m_data.GetAttrBN(inst,_T("unit"),m_unit);
		
		if(m_show.m_charact_value)
		{
			buf+=_T(" = ");
			//  
			CaplInstance* unit = NULL;
			if(m_show.m_charact_unit)
				unit = m_unit;
			if(ver)
				m_charact_mgr.PrintCharacteristicValue(ver, unit, value);
			else
				m_charact_mgr.PrintCharacteristicValue(item, unit, value);

			if(value.GetLength()>128) {CString tmp=value.Left(100); value=tmp;}
			if(!value.IsEmpty())	buf+=value;
			else buf+= APL_T("( )");

			if(m_show.m_charact_scope )
			{
				CString sScope;
				if(ver)
					 m_data.GetAttr(ver,  m_charact_mgr.a_apl_charact_val_ver_scope, sScope);
				else
					m_data.GetAttr(item,  m_charact_mgr.a_apl_charact_val_scope, sScope);

				if(sScope!=_T("")) {buf +=_T(" [");buf+=sScope;buf+=_T("]");}
			}

		}
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_charact_value_ver))
	{
		CaplInstance *inst=0,*unit=0,*type=0;
		if(item->GetAccessmode()>aplRO) { buf= APL_T("( )");return true;}
		m_data.GetAttr(item, m_charact_mgr.a_apl_charact_val_ver_charact, inst);
		m_data.GetAttr(item, m_charact_mgr.a_apl_charact_val_ver_type, type);

		CString name, id, type_name, value;
		if(inst!=0) GetItemName(inst, buf);
		if(type!=0) m_data.GetAttrBN(type, S::name, type_name);
		if(type_name!=_T("")) {buf+=_T(" ("); buf+=type_name;buf+=_T(")"); }
		if(inst!=0) m_data.GetAttrBN(inst,_T("unit"),unit);
		CString ver_num=_T("");
		m_data.GetAttr(item, m_charact_mgr.a_apl_charact_val_ver_version_num, ver_num);
		buf=ver_num+_T(" : ")+buf;
		
		if(m_show.m_charact_value)
		{
			buf+=_T(" = ");
			//  
			if(m_show.m_charact_unit)
				m_charact_mgr.PrintCharacteristicValue(item, unit, value);
			else
				m_charact_mgr.PrintCharacteristicValue(item, NULL, value);
			if(value!=_T(""))	buf+=value;
			else buf+= APL_T("( )");
		}
	}
	else if(m_data.IsKindOf(item, m_query_mgr.e_apl_query))
	{
		//m_data.GetAttr(item,m_query_mgr.a_apl_query_name,buf);
		CString in_name,in_description;
		m_query_mgr.GetName(item,in_name,in_description);
		buf=in_name;
		if(buf==_T("")){
			buf=in_description;
		}
	}
	else if(m_data.IsKindOf(item, m_query_mgr.e_apl_ct))
	{
		m_data.GetAttr(item,m_query_mgr.a_apl_ct_name,buf);
	}
	else if(m_data.IsKindOf(item, m_classifier_mgr.e_apl_classifier_system))
	{
		CString name;
		if(m_show.m_show_classifier_system_id)
			m_data.GetAttr(item, m_classifier_mgr.a_apl_classifier_system_id, buf);
		if(m_show.m_show_classifier_system_name)
			m_data.GetAttr(item, m_classifier_mgr.a_apl_classifier_system_name, name);
		if(buf.IsEmpty())
			buf = name;
		else
			buf = buf + _T(" : ") + name;
	}
	else if(m_data.IsKindOf(item, m_classifier_mgr.e_apl_classifier_level))
	{
		CString name,s_level=_T("");int i_level;
		if(m_show.m_show_classifier_level_id)
			m_data.GetAttr(item, m_classifier_mgr.a_apl_classifier_level_id, buf);
		if(m_show.m_show_classifier_level_name)
			m_data.GetAttr(item, m_classifier_mgr.a_apl_classifier_level_name, name);
		if(m_show.m_show_classifier_level_level){
			i_level=m_classifier_mgr.GetLevelClassifierLevel(item);
			s_level.Format(_T(" : (%i)"),i_level);
		}
		if(buf.IsEmpty()) buf = name;
		else
		{
			if(!name.IsEmpty()) buf = buf + _T(" : ") + name;
		}
		buf+=s_level;
	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_doc_copy))
	{
		m_data.GetAttr(item,m_doc_mgr.a_doc_copy_id,buf);
		CString state=_T("");
		m_data.GetAttr(item,m_doc_mgr.a_doc_copy_state,state);
		if(state!= APL_T("")) buf+=_T(" : ")+state;
		CaplInstance *doc=0;
		m_data.GetAttr(item,m_doc_mgr.a_doc_copy_doc,doc);
		if(doc)
		{
			CString doc_name=_T("");
			GetItemName(doc,doc_name);
			if(doc_name!=_T("")) { buf+=_T(" {"); buf+=doc_name;buf+=_T("}"); }
		}

	}
	else if(m_data.IsKindOf(item, m_appr_mgr.e_po_role))
	{
		m_data.GetAttr(item, m_appr_mgr.a_po_role_name, buf);
	}
	else if(m_data.IsKindOf(item, m_message_mgr.e_message))
	{
		CString sFrom, sTo, sTopic, sDate, sType;
		COleDateTime time;

		bool bIsRecepient = false;
		aplExtent officials;
		CaplInstance *pers;
		CaplInstance *curPers = m_appr_mgr.GetCurrentPerson();
		m_appr_mgr.GetPersonOfficials(curPers, officials);

		m_data.GetAttr(item, m_message_mgr.a_message_sender, pers);
		if(pers)
			GetItemName(pers, sFrom);
		m_data.GetAttr(item, m_message_mgr.a_message_recipient, pers);
		if(pers)
		{
			GetItemName(pers, sTo);
			if(pers==curPers || officials.Find(pers)>-1) bIsRecepient = true;
		}
		else
		{
			m_data.GetAttr(item, m_message_mgr.a_message_rec_offisial, pers);
			if(pers)
			{
				GetItemName(pers, sTo);
				if(pers==curPers || officials.Find(pers)>-1) bIsRecepient = true;
			}
			else
				m_data.GetAttr(item, m_message_mgr.a_message_rec_nick, sTo);
		}

		m_data.GetAttr(item, m_message_mgr.a_message_subject, sTopic);
		if(bIsRecepient)
			m_data.GetAttr(item, m_message_mgr.a_message_date_received, sDate);
		else
			m_data.GetAttr(item, m_message_mgr.a_message_date_send, sDate);
		if(sDate.IsEmpty())
			buf.Format(_T("%s -> %s : %s"), sFrom, sTo, sTopic);
		else
		{
			aplString2Date(sDate, time);
			buf.Format(_T("%s -> %s : %s [%s]"), sFrom, sTo, sTopic, time.Format());
		}
	}
	else if(m_data.IsKindOf(item, m_req_mgr.e_requirement))
	{
		CString str;
		COleDateTime time;

		m_data.GetAttr(item, m_req_mgr.a_req_id, buf);
		m_data.GetAttr(item, m_req_mgr.a_req_name, str);

		int maxCount = 100;
		if(str.GetLength() > maxCount) 
		{
			str = str.Left(maxCount-3);
			str += _T("...");
		}
		if(str.IsEmpty()) str = _T("???");
		buf = buf + _T(" : ") + str;
	}
	else if(m_data.IsKindOfBN(item, _T("apl_assortment")))
	{
		CString assortmentId;
		CString assortmentName;

		m_data.GetAttrBN(item, _T("id"), assortmentId);
		m_data.GetAttrBN(item, _T("name"), assortmentName);

		if(assortmentId.IsEmpty()) assortmentId = _T("???");
		if(assortmentName.IsEmpty()) assortmentName = _T("???");

		buf = assortmentId + _T(" :: ") + assortmentName;
	}
	else if(m_data.IsKindOfBN(item, _T("apl_product_appearance")))
	{
		CString strAppCode;
		CString strAppName;

		m_data.GetAttrBN(item, _T("code"), strAppCode);
		m_data.GetAttrBN(item, _T("name"), strAppName);
		buf = strAppCode + _T(" :: ") + strAppName;
	}
	else if(m_data.IsKindOfBN(item, _T("apl_appearence_composition")))
	{
		CString strCompCode;
		CString strCompName;

		m_data.GetAttrBN(item, _T("code"), strCompCode);
		m_data.GetAttrBN(item, _T("name"), strCompName);
		buf = strCompCode + _T(" :: ") + strCompName;
	}
	else if(m_data.IsKindOfBN(item, _T("ils_base_product_instance")))
	{
		CString strId;
		CString strSN;

		m_data.GetAttrBN(item, _T("id"), strId);
		m_data.GetAttrBN(item, _T("serial_number"), strSN);
		buf = strId + _T(" :: ") + strSN;
	}
	else if(m_data.IsKindOfBN(item, _T("ils_bulletin")))
	{
		CString strId;
		CString strName;

		m_data.GetAttrBN(item, _T("id"), strId);
		m_data.GetAttrBN(item, _T("name"), strName);
		buf = strId + _T(" :: ") + strName;
	}
	else if(m_data.IsKindOfBN(item, _T("apl_composition_requirement")))
	{
		CString strId;
		CString strName;

		m_data.GetAttrBN(item, _T("code"), strId);
		m_data.GetAttrBN(item, _T("name"), strName);

		buf = strName;
	}
	else if (m_data.IsKindOfBN(item, _T("apl_lss3_component")) ||
			 m_data.IsKindOfBN(item, _T("apl_lss3_failure_mode")))
	{
		CString strId;
		CString strName;

		m_data.GetAttrBN(item, _T("id"), strId);
		m_data.GetAttrBN(item, _T("name_rus"), strName);

		buf = strId + _T(" :: ") + strName;
	}
	else if (m_data.IsKindOfBN(item, _T("apl_lss3_logistic_element")) ||
			 m_data.IsKindOfBN(item, _T("apl_lss3_function")))
	{
		CString strId;
		CString strName;

		m_data.GetAttrBN(item, _T("lcn"), strId);
		m_data.GetAttrBN(item, _T("name_rus"), strName);

		buf = strId + _T(" :: ") + strName;
	}
	else if (m_data.IsKindOfBN(item, _T("apl_lss3_function_logel_link")))
	{
		CaplInstance* pFunction=NULL;
		CaplInstance* pLogel = NULL;
		CString sFuncSysId, dLogelSysId;

		m_data.GetAttrBN(item, _T("function"), pFunction);
		if(pFunction) 
			sFuncSysId.Format(_T("#%d"), pFunction->GetId());
		m_data.GetAttrBN(item, _T("logel"), pLogel);
		if (pLogel)
			dLogelSysId.Format(_T("#%d"), pLogel->GetId());
		buf = sFuncSysId + _T(" :: ") + dLogelSysId;
	}
	else if (m_data.IsKindOfBN(item, _T("apl_lss3_failure_mode_cause")))
	{
		CaplInstance* pCause = NULL;
		CaplInstance* pConseq = NULL;
		CString sCauseSysId, sConseqSysId;

		m_data.GetAttrBN(item, _T("cause"), pCause);
		if (pCause)
			sCauseSysId.Format(_T("#%d"), pCause->GetId());
		m_data.GetAttrBN(item, _T("consequence"), pConseq);
		if (pConseq)
			sConseqSysId.Format(_T("#%d"), pConseq->GetId());
		buf = sCauseSysId + _T(" :: ") + sConseqSysId;
	}
	else if (m_data.IsKindOfBN(item, _T("apl_lss3_expl_scenario")) ||
			 m_data.IsKindOfBN(item, _T("apl_lss3_maintenance_program_item")))
	{
		CString strId;
		CString strName;

		m_data.GetAttrBN(item, _T("id"), strId);
		m_data.GetAttrBN(item, _T("name"), strName);

		buf = strId + _T(" :: ") + strName;
	}
	else if (m_data.IsKindOfBN(item, _T("ils_mission")))
	{
		CString strName;

		m_data.GetAttrBN(item, _T("name"), strName);

		buf = strName;
	}
	else if (m_data.IsKindOfBN(item, _T("ils_maint_prog_item_proc_chart_relation")))
	{
		CaplInstance* pMaintProgItem = NULL;
		CaplInstance* pProcessChart = NULL;
		CString sMaintProgItemSysId, sProcessChartSysId;

		m_data.GetAttrBN(item, _T("maint_prog_item"), pMaintProgItem);
		if (pMaintProgItem)
			sMaintProgItemSysId.Format(_T("#%d"), pMaintProgItem->GetId());
		m_data.GetAttrBN(item, _T("process_chart"), pProcessChart);
		if (pProcessChart)
			sProcessChartSysId.Format(_T("#%d"), pProcessChart->GetId());
		buf = sMaintProgItemSysId + _T(" :: ") + sProcessChartSysId;
	}
	else if (m_data.IsKindOfBN(item, _T("ils_process_chart")))
	{
		CString strId;
		CString strName;

		m_data.GetAttrBN(item, _T("id_mpd"), strId);
		if (strId.IsEmpty())
		{
			m_data.GetAttrBN(item, _T("id_mrbr"), strId);
		}
		m_data.GetAttrBN(item, _T("name"), strName);

		buf = strId + _T(" :: ") + strName;
	}
	else
		return false;
	if(buf.IsEmpty()) buf=_T("???");
	return true;
}

bool CaplAPI::LoadItemInfo(CaplInstance *item)
{
	if(0==item) return false;
	if(!m_data.IsConnected()) return true;
	if(item->IsDeleted()) return false;
	if(item->GetAccessmode()>aplRO) return false;
	aplExtent ext;
	ext.Add(item);
	return LoadExtentInfo(ext);
}

bool CaplAPI::CreateGuid(CString &guid)
{
	guid=_T("");

	::CoInitialize(NULL);
	GUID pGuid = GUID_NULL;
	::CoCreateGuid(&pGuid);
	if(pGuid==GUID_NULL)
	{
		#ifdef _DEBUG
		AfxMessageBox( APL_T("   GUID !"));
		#endif
		return false;
	}
	guid.Format(_T("{%08lX-%04X-%04x-%02X%02X-%02X%02X%02X%02X%02X%02X}"),
		pGuid.Data1, pGuid.Data2, pGuid.Data3,
		pGuid.Data4[0], pGuid.Data4[1], pGuid.Data4[2], pGuid.Data4[3],
		pGuid.Data4[4], pGuid.Data4[5], pGuid.Data4[6], pGuid.Data4[7]);

	::CoUninitialize();
	
	return true;
}

//************************************************************************
//************************************************************************
//************************************************************************
//      TGB
bool CaplAPI::LoadExtentInfoPrimitive(aplExtent &ext)
{
	if(0==ext.GetSize()) return true;
	if(!m_data.IsConnected()) return true;

	aplExtent ext_any; ext_any.Unique=false;

	//   ,  
	int i;
	CaplInstance *inst;
	for(i=0;i<ext.Size;i++)
	{
		inst=ext[i];
		if(inst==0) continue;
		if(inst->GetId()==0) continue;
		if(inst->IsDeleted()) continue;
		if(inst->GetAccessmode()>aplRO) continue;

		ext_any.Add(inst);
	}

	// 
	if(0==ext_any.GetSize()) return true;

	CaplMap map4entity; map4entity.bAutoSort=true;
	int j,indx;
	aplExtent* ext_tmp;
	for(i=0;i<ext_any.GetSize();i++)
	{
		CaplInstance *inst=ext_any[i];
		if(inst==0)continue;
		indx=map4entity.QFindByIn((long)inst->GetType());
		if(indx==-1){
			ext_tmp=new aplExtent();
			map4entity.Add((long)inst->GetType(),(long)ext_tmp);
		}else{
			ext_tmp=(aplExtent*)map4entity[indx].out;
		}
		if(ext_tmp==0)return false;
		ext_tmp->Add(inst);
	}
	CaplLoadData ld_any(&m_data,DEF_SOURCE);
	int i1=0, size=1000;
	for(i=0;i<map4entity.Size;i++)
	{
		i1=0;
		ext_tmp=(aplExtent*)map4entity[i].out;
		if(0==ext_tmp) continue;

		for(j=0; j<ext_tmp->GetSize(); j++)
		{
			ld_any.AddQuery(0,ext_tmp->GetAt(j),true);
			i1++;
			if(i1>=size)
			{
				ld_any.LoadEx();
				ld_any.ClearQuery();
				i1=0;
			}
		}
		if(i1>0) {ld_any.LoadEx(); ld_any.ClearQuery();}
		delete ext_tmp;
	}
	return true;
}

//***************************
bool CaplAPI::LoadExtentInfo(aplExtent &ext)
{
	if(0==ext.GetSize()) return true;
	if(!m_data.IsConnected()) return true;
	int i;
	CaplLoadData ld_chng(&m_data,DEF_SOURCE); 
	bool load_chng= false;

	aplExtent ext_bp;
	aplExtent ext_bp_inst;
	aplExtent ext_doc;
	aplExtent ext_doc_ref;
	aplExtent ext_categ;
	aplExtent ext_fold;
	aplExtent ext_prd;
	aplExtent ext_prdinst;
	aplExtent ext_refusal;
	aplExtent ext_lot;
	aplExtent ext_stores_doc;
	aplExtent ext_find;
	aplExtent ext_ct;
	aplExtent ext_mes;
	aplExtent ext_prj;
	aplExtent ext_options;
	aplExtent ext_classif;
	aplExtent ext_doc_copy;
	aplExtent ext_charact;
	aplExtent ext_pdf_subst;

	aplExtent ext_any;
	
	CaplInstance *inst;

	for(i=0;i<ext.Size;i++)
	{
		inst=ext[i];
		if(inst==0) continue;
		if(inst->GetId()==0) continue;
		if(inst->IsDeleted()) continue;
		if(inst->GetAccessmode()>aplRO) continue;

		if(m_data.IsKindOf(inst,m_prd_mgr.e_prd))			ext_prd.Add(inst);
		else if(m_data.IsKindOf(inst,m_prd_mgr.e_pdf))		ext_prd.Add(inst);
		else if(m_data.IsKindOf(inst,m_doc_mgr.e_doc))		ext_doc.Add(inst);
		else if(m_data.IsKindOf(inst,m_doc_mgr.e_apl_doc_ref))		ext_doc.Add(inst);
		else if(m_data.IsKindOf(inst,m_doc_mgr.e_apl_doc_rev))		ext_doc.Add(inst);
		else if(m_data.IsKindOf(inst,m_doc_mgr.e_apl_stored_document))		ext_stores_doc.Add(inst);
		else if(m_data.IsKindOf(inst,m_folder_mgr.e_folder))	ext_fold.Add(inst);
		else if(m_data.IsKindOf(inst,m_bp_mgr.e_bp))			ext_bp.Add(inst);
		else if(m_data.IsKindOf(inst,m_bp_mgr.e_apl_bp_ver))	ext_bp.Add(inst);
		else if(m_data.IsKindOf(inst,m_bp_mgr.e_apl_bp_inst))	ext_bp_inst.Add(inst);
		else if(m_data.IsKindOf(inst,m_categ_mgr.e_categ)) 	ext_categ.Add(inst);
		else if(m_data.IsKindOf(inst,m_prd_inst_mgr.e_prd_inst)) 	ext_prdinst.Add(inst);
		else if(m_expl_mgr && m_data.IsKindOf(inst,m_expl_mgr->e_apl_refusal)) 	ext_refusal.Add(inst);
		else if(m_data.IsKindOf(inst,m_prd_inst_mgr.e_lot)) 		ext_lot.Add(inst);
		else if(m_data.IsKindOf(inst,m_query_mgr.e_apl_query)) 		ext_find.Add(inst);
		else if(m_data.IsKindOf(inst,m_query_mgr.e_apl_ct)) 		ext_ct.Add(inst);
		else if(m_data.IsKindOf(inst,m_change_mgr.e_chng))
		{
			//
			ld_chng.AddQuery(0, inst,true);
			load_chng= true;
		}
		else if(m_data.IsKindOf(inst,m_message_mgr.e_message)) ext_mes.Add(inst);
		else if(m_data.IsKindOf(inst,m_project_mgr->e_project)) ext_prj.Add(inst);
		else if(m_data.IsKindOf(inst,m_options_mgr.e_str)) ext_options.Add(inst);
		else if(m_data.IsKindOf(inst,m_options_mgr.e_int)) ext_options.Add(inst);
		else if(m_data.IsKindOf(inst,m_classifier_mgr.e_apl_classifier_level)) ext_classif.Add(inst);
		else if(m_data.IsKindOf(inst,m_classifier_mgr.e_apl_classifier_system)) ext_classif.Add(inst);
		else if(m_data.IsKindOf(inst,m_doc_mgr.e_doc_copy)) ext_doc_copy.Add(inst);
		else if(m_load_characteristic_values && (m_data.IsKindOf(inst,m_charact_mgr.e_apl_charact_value) ||
			m_data.IsKindOf(inst,m_charact_mgr.e_apl_charact_value_ver)))ext_charact.Add(inst);
		else if(m_data.IsKindOf(inst,m_prd_mgr.e_pdf_subst)) ext_pdf_subst.Add(inst);
		else ext_any.Add(inst);
		
	}

	bool bRes=true;

	if(ext_prd.GetSize()>0)		bRes&=m_prd_mgr.LoadPrdInfo(ext_prd);
	if(ext_doc.GetSize()>0)		bRes&=m_doc_mgr.LoadDocInfo(ext_doc);
	if(ext_bp.GetSize()>0)		bRes&=m_bp_mgr.LoadBPInfo(ext_bp);
	if(ext_bp_inst.GetSize()>0) bRes&=m_bp_mgr.LoadBPInstInfo(ext_bp_inst);
	if(ext_categ.GetSize()>0)	bRes&=m_categ_mgr.LoadCategoryInfo(ext_categ);
	if(ext_fold.GetSize()>0)	bRes&=m_folder_mgr.LoadFolderInfo(ext_fold);
	if(ext_prdinst.GetSize()>0) bRes&=m_prd_inst_mgr.LoadPrdInstInfo(ext_prdinst);
	if(ext_refusal.GetSize()>0) bRes&=m_expl_mgr->LoadRefusalsInfo(ext_refusal);
	if(ext_lot.GetSize()>0 )	bRes&=m_prd_inst_mgr.LoadLotInfo(ext_lot);
	if(ext_find.GetSize()>0)	bRes&=m_query_mgr.LoadQueryInfo(ext_find);
	if(ext_ct.GetSize()>0)		bRes&=m_query_mgr.LoadCombinedTableInfo(ext_ct);
	if(ext_prj.GetSize()>0)		bRes&=m_project_mgr->LoadProjectInfo(ext_prj);
	if(ext_prj.GetSize()>0)		bRes&=m_options_mgr.LoadOptionsInfo(ext_prj);
	if(ext_classif.GetSize()>0)	bRes&=m_classifier_mgr.LoadClassifierInfo(ext_classif);
	if(ext_doc_copy.GetSize()>0)	bRes&=m_doc_mgr.LoadDocCopyInfo(ext_doc_copy);
	if(ext_mes.GetSize()>0)			bRes&=m_message_mgr.LoadMessageInfo(ext_mes);
	if(ext_charact.GetSize()>0)		bRes&=m_charact_mgr.LoadCharacteristic(ext_charact);
	if(ext_pdf_subst.GetSize()>0)	bRes&=m_prd_mgr.LoadSubstituteInfo(ext_pdf_subst);

	if(ext_stores_doc.Size>0)
	{
		CaplLoadData ld(&m_data,DEF_SOURCE);
		for(i=0;i<ext_stores_doc.Size;i++)
		{
			if(ext_stores_doc[i]==0) continue;
			if(ext_stores_doc[i]->GetAccessmode()>aplRO) continue;
			ld.AddQuery(0,ext_stores_doc[i],true);
		}
		bRes&=ld.LoadEx();
	}

	aplExtent ext_prd_1;
	for(i=0;i<ext_lot.Size;i++)
	{
		if(ext_lot[i]==0) continue;
		if(ext_lot[i]->GetAccessmode()>aplRO) continue;
		m_data.GetAttr(ext_lot[i],m_prd_inst_mgr.a_lot_pdf,inst);
		ext_prd_1.Add(inst);
	}
	for(i=0;i<ext_prdinst.Size;i++)
	{
		if(ext_prdinst[i]==0) continue;
		if(ext_prdinst[i]->GetAccessmode()>aplRO) continue;
		m_data.GetAttr(ext_prdinst[i],m_prd_inst_mgr.a_prd_inst_pdf,inst);
		ext_prd_1.Add(inst);
	}
	if(ext_prd_1.GetSize()>0)
	{
		m_prd_mgr.LoadPrdInfo(ext_prd_1);
	}

	//
	if(load_chng) bRes&=ld_chng.LoadEx();
	
	if(ext_any.GetSize()>0) bRes&=LoadExtentInfoPrimitive(ext_any);

	if(!bRes)
	{
		if(m_ModeInteractive)AfxMessageBox(S::ErrorLoadDataMgr(),MB_OK|MB_ICONSTOP);
	}

	return bRes;
}

int CaplAPI::GetInstIco(CaplInstance* item)
{
//	if(!m_data.IsConnected()) return -1;
	if(item==0) return -1;
	if(item->IsDeleted()) return -1;

	int ico = -1;

//Products
	if(m_data.IsKindOf(item, m_prd_mgr.e_prd))//Product
	{
		ico = ICON_PROD;
	}
	else if(m_data.IsKindOf(item, m_prd_mgr.e_pdf))
	{
		ico=ICON_PART;
		CString form_type;
		if(item->GetAccessmode()>aplRO) return ico;
		m_data.GetAttr(item,m_prd_mgr.a_apl_pdf_type,form_type);
		
		if(form_type==_T("assembly")){ico=ICON_ASSEMBLY;}
		else if(form_type==_T("material")){ico=ICON_MATERIAL;}
		else if(form_type==_T("kit")){ico=ICON_KIT;}
		else if(form_type==_T("komplex")){ico=ICON_KOMPLEX;}
		else if(form_type==_T("zone")){ico=ICON_ZONE;}
		else if(form_type==_T("module")){ico=ICON_MODULE;}
		else if(form_type==_T("system")){ico=ICON_SYSTEM;}
		else if(form_type==_T("other")){ico=ICON_OTHER;}
	}
	else if(m_data.IsKindOf(item, m_prd_inst_mgr.e_prd_inst))
	{
		ico = ICON_PRD_INST;
	}
	else if(m_data.IsKindOf(item, m_prd_inst_mgr.e_lot))
	{
		ico = ICON_LOT;
	}
//Documents
	else if(m_data.IsKindOf(item, m_doc_mgr.e_doc))
	{
		ico = ICON_DOCUMENT;
		if(item->GetAccessmode()>aplRO) return ico;
		CaplInstance* lock;
		m_data.GetAttr(item, m_doc_mgr.a_apl_doc_lock, lock);
		if(lock)
			ico = ICON_DOCUMENT_CHECKOUTED;
		
		CString buf,buf1;
		CaplInstance *rev;
		m_data.GetAttr(item, m_doc_mgr.a_apl_doc_active, rev);
		if(0!=rev && rev->GetAccessmode() <= aplRO)
		{	bool b;
			m_data.GetAttr(rev, m_doc_mgr.a_apl_doc_rev_it_needs_work, b);
			if(b && ico == ICON_DOCUMENT) ico++;
		}

		m_data.GetAttr(item, m_doc_mgr.a_doc_id, buf);
		if(buf.GetLength()>7)
		{
			buf1=buf.Left(7);
			if(0==buf1.CompareNoCase(_T("autovue"))) ico=ICON_DOCUMENT_MARKUP;
		}

	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_apl_doc_rev))
	{
		ico = ICON_DOCUMENT_REV;
		if(item->GetAccessmode()>aplRO) return ico;
		CaplInstance* doc;
		m_data.GetAttr(item, m_doc_mgr.a_apl_doc_rev_doc, doc);
		if(doc)
		{
			CaplInstance* ver = NULL;
			m_data.GetAttr(doc, m_doc_mgr.a_apl_doc_active, ver);
			if(ver==item)
				ico = ICON_DOCUMENT_ACTIVE_REV;
		}
		bool b;
		m_data.GetAttr(item, m_doc_mgr.a_apl_doc_rev_it_needs_work, b);
		if(b) ico++;
	}
//Folders
	else if(m_data.IsKindOf(item, m_folder_mgr.e_folder))
	{
		ico = ICON_FOLDER;
	}
//Organization
	else if(m_data.IsKindOf(item, m_appr_mgr.e_org))
	{
		CString name;
		m_data.GetAttr(item, m_appr_mgr.a_org_name, name);

		if (name == APL_T(""))
			ico = ICON_ORGANIZATION_DELETE;
		else
			ico = ICON_ORGANIZATION;			
	}
	else if(m_data.IsKindOf(item, m_appr_mgr.e_official))
	{
		ico = ICON_OFFICIAL;
	}
	else if(m_data.IsKindOf(item, m_appr_mgr.e_person))
	{
		ico = ICON_PERSON;
	}
	else if(m_data.IsKindOf(item, m_appr_mgr.e_pers_org))
	{
		ico = ICON_PERSON;
	}
//Alerts & Messages
	else if(m_data.IsKindOf(item, m_message_mgr.e_alert))
	{
		ico = ICON_ALERT;
	}
	else if(m_data.IsKindOf(item, m_message_mgr.e_message))
	{
		ico = ICON_MESSAGES+4;
		
		CString sState;
		CaplInstance* forwInst= NULL;

		m_data.GetAttr(item, m_message_mgr.a_message_status, sState);
		m_data.GetAttr(item, m_message_mgr.a_message_forward, forwInst);

		if(sState==_T("readed"))
		{
			ico+=1;
			if(forwInst) ico+=2;
		}
		else if(sState==_T("replyed")) 
		{
			ico+=2;
			if(forwInst) ico+=2;
		}	
	}
//Characteristics & CharacteristicGroups;
	else if(m_data.IsKindOf(item, m_charact_mgr.e_charact_val_group))
	{
		ico = ICON_CHARACTERISTIC_GROUP;
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_charact_value))
	{
		ico = ICON_CHARACTERISTIC;
		if(item->GetAccessmode()>aplRO) return ico;
		CaplInstance *inst;
		m_data.GetAttr(item, m_charact_mgr.a_apl_charact_val_item, inst);
		if(!inst) m_data.GetAttr(item, m_charact_mgr.a_apl_charact_val_base_item, inst);
		if(inst)
		{
			if(m_data.IsKindOf(inst, m_prd_mgr.e_pdf)) ico+=1;
			else if(m_data.IsKindOf(inst, m_prd_inst_mgr.e_prd_inst)) ico+=2;
			else if(m_data.IsKindOf(inst, m_prd_inst_mgr.e_lot)) ico+=3;
			else if(m_data.IsKindOf(inst, m_categ_mgr.e_categ)) ico+=4;
		}
		CaplInstance* lock = m_charact_mgr.GetLock(item,false);
		if(lock)
			ico+=5;
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_charact_value_ver))
	{
		ico = ICON_CHARACTERISTIC;
		if(item->GetAccessmode()>aplRO) return ico;
		CaplInstance *char_value=0,*inst=0;
		m_data.GetAttr(item, m_charact_mgr.a_apl_charact_val_ver_char_value, char_value);
		if(char_value)
		{
			m_data.GetAttr(char_value, m_charact_mgr.a_apl_charact_val_item, inst);
			if(!inst) m_data.GetAttr(item, m_charact_mgr.a_apl_charact_val_base_item, inst);
			if(inst)
			{
				if(m_data.IsKindOf(inst, m_prd_mgr.e_pdf)) ico+=1;
				else if(m_data.IsKindOf(inst, m_prd_inst_mgr.e_prd_inst)) ico+=2;
				else if(m_data.IsKindOf(inst, m_prd_inst_mgr.e_lot)) ico+=3;
				else if(m_data.IsKindOf(inst, m_categ_mgr.e_categ)) ico+=4;
			}
		}
	}
//BP
	else if(m_data.IsKindOf(item, m_bp_mgr.e_bp))
	{
		ico = ICON_BP;
		if(item->GetAccessmode()>aplRO) return ico;
		CString sType;
		CaplInstance* iType = NULL;
		CaplInstance* pLock = NULL, *my_lock=NULL;
		m_data.GetAttr(item, m_bp_mgr.a_bp_lock, pLock);
		my_lock=m_bp_mgr.CheckMyLock(item,false);
		if(!pLock)
		{
			m_data.GetAttr(item, m_bp_mgr.a_bp_type, iType);
			if(iType)
				m_data.GetAttr(iType, m_bp_mgr.a_bp_type_name, sType);
			sType.MakeUpper();
			if(sType.Find(_T("QM"))>=0) ico=ICON_BP_QM;
			else if(sType.Find( APL_T(""))>=0) ico=ICON_BP_VERTICS;
		}
		aplExtent ext;
		if(my_lock)
			m_data.GetAttr(my_lock, m_bp_mgr.a_bp_ver_elements, ext);
		else
			m_data.GetAttr(item, m_bp_mgr.a_bp_elements, ext);
		if(ext.Size==0) ico++;
		if(pLock)
			ico += 2;
	}
	else if(m_data.IsKindOf(item, m_bp_mgr.e_apl_bp_ver))
	{
		ico = ICON_BP;
		if(item->GetAccessmode()>aplRO) return ico;
		CString sType;
		CaplInstance *iType=0, *pLock=0, *bp=0;
		m_data.GetAttr(item, m_bp_mgr.a_bp_ver_bp, bp);
		m_data.GetAttr(bp, m_bp_mgr.a_bp_lock, pLock);
		if(!pLock)
		{
			m_data.GetAttr(bp, m_bp_mgr.a_bp_type, iType);
			if(iType)
				m_data.GetAttr(iType, m_bp_mgr.a_bp_type_name, sType);
			sType.MakeUpper();
			if(sType.Find(_T("QM"))>=0) ico=ICON_BP_QM;
			else if(sType.Find( APL_T(""))>=0) ico=ICON_BP_VERTICS;
		}
		aplExtent ext;
		m_data.GetAttr(item, m_bp_mgr.a_bp_ver_elements, ext);
		if(ext.Size==0) ico++;
	}
	else if(m_data.IsKindOf(item, m_bp_mgr.e_bp_res))
	{
		ico = ICON_BP_RES;
	}
	else if(m_data.IsKindOf(item, m_bp_mgr.e_apl_bp_inst))
	{
		ico = ICON_BP_INST;
		if(item->GetAccessmode()>aplRO) return ico;
		aplExtent ext;
		m_data.GetAttr(item,m_bp_mgr.a_bp_inst_elements, ext);
		if(ext.GetSize()==0) ico++;
	}
	else if(m_data.IsKindOf(item, m_categ_mgr.e_categ))
	{
		ico = ICON_CATEGORIES;
		if(item->GetAccessmode()>aplRO) return ico;
		CaplInstance* pLock;
		m_data.GetAttr(item, m_categ_mgr.a_categ_lock, pLock);
		if(pLock)
			ico++;
	}
	else if(m_data.IsKindOf(item, m_categ_mgr.e_apl_product_category_ver))
	{
		ico = ICON_CATEGORIES;
	}
	else if(m_data.IsKindOf(item, m_appr_mgr.e_apl_appr))
	{
		CaplInstance *status;
		ico = ICON_APPROVAL;
		m_data.GetAttr(item, m_appr_mgr.a_appr_status, status);
		if(status)
		{
			m_data.GetAttr(status, m_appr_mgr.a_appr_status_icon, ico);
			ico+=ICON_APPROVAL;
		}
	}
	else if(m_data.IsKindOf(item, m_project_mgr->e_project))
	{
		ico=ICON_PROJECT;
		if(item->GetAccessmode()>aplRO) return ico;

		CString buf=_T("");
		CaplInstance *type=0;
		CaplInstance *pLock=0,*my_lock=0;
		my_lock=m_project_mgr->CheckMyLock(item,false);
		if(my_lock) m_data.GetAttr(my_lock,m_project_mgr->a_project_adm_ver_type,type);
		else m_data.GetAttr(item,m_project_mgr->a_project_type,type);
		if(type) m_data.GetAttr(type,m_project_mgr->a_project_type_name,buf);
		if(buf== APL_T(""))	ico+=4;
		else if(buf== APL_T(" ")) ico+=5;
		else 
		{
			bool m_is_in_content=m_project_mgr->IsProjectInContentOfParent(item);
			if(m_is_in_content) ico+=2;
			if(buf== APL_T("   ")) ico++;
		}
		m_data.GetAttr(item,m_project_mgr->a_project_locker_adm_version,pLock);
		if(pLock) ico+=6;
		
	}
	else if(m_data.IsKindOf(item, m_project_mgr->e_project_adm_ver))
	{
		ico=ICON_PROJECT;
		if(item->GetAccessmode()>aplRO) return ico;

		CString buf=_T("");
		CaplInstance *type=0;
		m_data.GetAttr(item,m_project_mgr->a_project_adm_ver_type,type);
		if(type) m_data.GetAttr(type,m_project_mgr->a_project_type_name,buf);
		if(buf== APL_T(""))	ico+=4;
		else if(buf== APL_T(" ")) ico+=5;
		else 
		{
			CaplInstance *prj_ver_prj=0;
			m_data.GetAttr(item,m_project_mgr->a_project_adm_ver_project,prj_ver_prj);
			if(prj_ver_prj)
			{
				bool m_is_in_content=m_project_mgr->IsProjectInContentOfParent(prj_ver_prj);
				if(m_is_in_content) ico+=2;
			}
			if(buf== APL_T("   ")) ico++;
		}
	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_apl_assigned_document))
	{
//		ico = ICON_FILE;
		ico = ICON_DOCUMENT_COPY;
	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_apl_stored_document))
	{
//		ico = ICON_FILE;
		ico = ICON_DOCUMENT_COPY;
	}
// 	
	else if(m_data.IsKindOf(item, m_change_mgr.e_chng))
		ico = ICON_CHANGE;	
	else if(m_data.IsKindOf(item, m_change_mgr.e_psc))
		ico= ICON_CHANGE+5;
	else if(m_data.IsKindOf(item, m_change_mgr.e_avc))
		ico = ICON_CHANGE+6;	
	else if(m_data.IsKindOf(item, m_change_mgr.e_abpc))
		ico = ICON_CHANGE+7;	
	else if(m_data.IsKindOf(item, m_change_mgr.e_mat))
		ico = ICON_CHANGE+8;	
	else if(m_data.IsKindOf(item, m_change_mgr.e_chng_item))
		ico = ICON_CHANGE;
// 
	else if(m_data.IsKindOf(item,m_query_mgr.e_apl_query))
	{
		bool is_text=false;
		CString type;
		if(item->GetAccessmode()<=aplRW){
			m_query_mgr.UpdateTypeQuery(item);
			m_data.GetAttr(item,m_query_mgr.a_apl_query_mode,type);	
			m_data.GetAttr(item,m_query_mgr.a_apl_query_is_text_query,is_text);	
		}
		if(is_text && item->GetTemporary()){
			ico=ICON_QUERY_Q;
		}else if(is_text && !item->GetTemporary()){
			ico=ICON_QUERY_Q_SAVED;
		}else if(type==_T("Find") && item->GetTemporary()){
			ico=ICON_FIND;
		}else if(type==_T("Find") && !item->GetTemporary()){
			ico=ICON_FIND;
		}else if(type==_T("Query_niiao") && item->GetTemporary()){
			ico=ICON_QUERY_N;
		}else if(type==_T("Query_niiao") && !item->GetTemporary()){
			ico=ICON_QUERY_N_SAVED;
		}else if(type==_T("Query") && !item->GetTemporary()){
			ico=ICON_QUERY_SAVED;
		}else{
			ico=ICON_QUERY;
		}
	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_doc_copy_order))
	{
		CString sType;
		m_data.GetAttr(item, m_doc_mgr.a_purchase_order_type, sType);

		if(sType == _T("print")) ico=ICON_DOCUMENT_COPY;
		else if(sType == _T("destroy")) ico=ICON_DOCUMENT_ACT;
	}
	else if(m_data.IsKindOf(item, m_query_mgr.e_apl_ct))
	{
		if(item->GetTemporary())
		{
			ico=ICON_COMB_TABLE;
		}
		else
		{
			ico=ICON_COMB_TABLE_SAVED;
		}
	}
	else if(m_data.IsKindOf(item, m_classifier_mgr.e_apl_classifier_system))
	{
		ico = ICON_CLASSIFIER_SYSTEM;
	}
	else if(m_data.IsKindOf(item, m_classifier_mgr.e_apl_classifier_level))
	{
		aplExtent ext;
		CString sectionType;

		m_data.GetAttr(item,m_classifier_mgr.a_apl_classifier_level_childs,ext);
		m_data.GetAttr(item, m_classifier_mgr.a_apl_classifier_level_section_type, sectionType);

		if(ext.GetSize()>0)
		{
			ico = ICON_CLASSIFIER_ELEMENT_M;

			if(0 == sectionType.CompareNoCase(APL_T("A :: "))) ico = ICON_CLASSIFIER_ELEMENT_M_ANALOGUE;
			else if(0 == sectionType.CompareNoCase(APL_T("K :: "))) ico = ICON_CLASSIFIER_ELEMENT_M_KIT;
		}
		else
		{
			ico = ICON_CLASSIFIER_ELEMENT_S;

			if(0 == sectionType.CompareNoCase(APL_T("A :: "))) ico = ICON_CLASSIFIER_ELEMENT_S_ANALOGUE;
			else if(0 == sectionType.CompareNoCase(APL_T("K :: "))) ico = ICON_CLASSIFIER_ELEMENT_S_KIT;
		}
	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_doc_copy))
	{
		ico = ICON_DOCUMENT_COPY;
		CaplInstance *doc=0,*doc_act_ver=0,*copy_cur_ver=0;
		m_data.GetAttr(item, m_doc_mgr.a_doc_copy_cur_rev, copy_cur_ver);
		m_data.GetAttr(item, m_doc_mgr.a_doc_copy_doc, doc);
		if(doc)
		{
			CaplInstance* ver = NULL;
			m_data.GetAttr(doc, m_doc_mgr.a_apl_doc_active, doc_act_ver);
			if(doc_act_ver!=copy_cur_ver)
				ico = ICON_DOCUMENT_COPY_OUT_OF_DATE;
		}
	}
	else if(m_data.IsKindOf(item, m_req_mgr.e_requirement))
	{
		bool bNoNeed = false;
		ico = ICON_REQUIMENT;

		m_data.GetAttr(item, m_req_mgr.a_req_no_need, bNoNeed);
		if(bNoNeed) ico = ICON_REQUIMENT_NO_NEED;		
	}
	else if(m_expl_mgr && m_data.IsKindOf(item, m_expl_mgr->e_apl_refusal))
	{
		bool bNoNeed = false;
		ico = ICON_REFUSAL;

		m_data.GetAttr(item, m_req_mgr.a_req_no_need, bNoNeed);
		if(bNoNeed) ico = ICON_REQUIMENT_NO_NEED;		
	}
	else if(m_data.IsKindOfBN(item, _T("apl_process")))
	{
		ico= ICON_PROCESS;
	}
	else if(m_data.IsKindOfBN(item, _T("apl_task")))
	{
		ico= ICON_TASK;
		CString str;
		m_data.GetAttrBN(item, _T("state"), str);
		if(str==_T("inactive")) ico+=3;
		else if(str!=_T("work"))	 ico+=1;
	}
	else if(m_data.IsKindOfBN(item, _T("apl_process_template")))
	{
		ico= ICON_PROCESS_TMPL;
	}
	else if(m_data.IsKindOfBN(item, _T("apl_activity")))
	{
		ico= ICON_ACTIVITY;
	}
	else if(m_data.IsKindOfBN(item, _T("apl_composition_requirement")))
	{
		ico = ICON_OPTION;
	}

	return ico;
}

int CaplAPI::aplCompareItemsImage(int Image1, int Image2)
{
	if(Image1 == ICON_PERSON_LOCK_FOLDER || Image1 == ICON_PERSON_LOCK_FOLDER_OPEN) return -1;
	if(Image2 == ICON_PERSON_LOCK_FOLDER || Image2 == ICON_PERSON_LOCK_FOLDER_OPEN) return 1;


	if( (Image1 >= ICON_PRJ_INDEX && Image1 < ICON_CONTINUE_INDEX) &&
	    (Image2 >= ICON_PRJ_INDEX && Image2 < ICON_CONTINUE_INDEX))
		return 0;


	//  
	if((Image1==ICON_CLASSIFIER_ELEMENT_M )&&(Image2==ICON_CLASSIFIER_ELEMENT_S)) 
		return 0;
	if((Image1==ICON_CLASSIFIER_ELEMENT_S )&&(Image2==ICON_CLASSIFIER_ELEMENT_M)) return 0;


	if(Image1==ICON_DOCUMENT_REV && Image2==ICON_DOCUMENT_ACTIVE_REV) return 0;
	if(Image2==ICON_DOCUMENT_REV && Image1==ICON_DOCUMENT_ACTIVE_REV) return 0;


	bool bCmpImage=true;
	if((Image1>=ICON_BP && Image1<=ICON_BP+8)
		&&(Image2>=ICON_BP && Image2<=ICON_BP+8)) bCmpImage=false;
	else if((Image1>=ICON_DOCUMENT_REV && Image1<=ICON_DOCUMENT_REV+1)
		&&(Image2>=ICON_DOCUMENT_REV && Image2<=ICON_DOCUMENT_REV+1)) bCmpImage=false;


	//     
	if((Image1>=ICON_APPR_INDEX && Image1<=ICON_APPR_INDEX+5)
		&&(Image2>=ICON_APPR_INDEX && Image2<=ICON_APPR_INDEX+5)) return 0;

/*
	else if(Image1>=ICON_KOMPLEX && Image1<=ICON_KOMPLEX+3)
	{
		if(Image2>=ICON_KOMPLEX && Image2<=ICON_KOMPLEX+3) bCmpImage=false;
	}
	else if(Image1>=ICON_KIT && Image1<=ICON_KIT+3)
	{
		if(Image2>=ICON_KIT && Image2<=ICON_KIT+3) bCmpImage=false;
	}
	else if(Image1>=ICON_ASSEMBLY && Image1<=ICON_ASSEMBLY+3)
	{
		if(Image2>=ICON_ASSEMBLY && Image2<=ICON_ASSEMBLY+3) bCmpImage=false;
	}
	else if(Image1>=ICON_PART && Image1<=ICON_PART+3)
	{
		if(Image2>=ICON_PART && Image2<=ICON_PART+3) bCmpImage=false;
	}
	else if(Image1>=ICON_MATERIAL && Image1<=ICON_MATERIAL+3)
	{
		if(Image2>=ICON_MATERIAL && Image2<=ICON_MATERIAL+3) bCmpImage=false;
	}
	else if(Image1>=ICON_BP_INST && Image1<=ICON_BP_INST+1)
	{
		if(Image2>=ICON_BP_INST && Image2<=ICON_BP_INST+1) bCmpImage=false;
	}*/


	if(bCmpImage)
	{
		if(Image1<Image2) return -1;
		if(Image1>Image2) return  1;
	}
	return 0;
}

bool CaplAPI::SelectPdf(CaplInstance **Pdf, LPCTSTR Id, bool bFindExecute, aplStringBindMode BindMode)
{
	if(!m_data.IsConnected()) return false;
	CaplSetResourceHandle setres(module_inst);
	CFindPKIDlg dlg;
	dlg.m_api = this;
	dlg.m_BindMode = BindMode;
	if(Id)
		dlg.m_sId = Id;
	dlg.m_bFindExecute = bFindExecute;
	if(dlg.DoModal()==IDOK)
	{
		*Pdf = dlg.m_Selected;
		return true;
	}
	return false;
}

bool CaplAPI::ShowItemProperties(CaplInstance* Item)
{
	if(!m_data.IsConnected()) return false;

	bool bRes = false;
	if(m_data.IsKindOf(Item, m_doc_mgr.e_doc))
		bRes = m_doc_mgr.ShowDocProperties(Item);
	if(m_data.IsKindOf(Item, m_doc_mgr.e_apl_doc_rev))
		bRes = m_doc_mgr.ShowDocProperties(Item);
	else if(m_data.IsKindOf(Item, m_bp_mgr.e_bp))
		bRes = m_bp_mgr.ShowBPProperties(Item);
	else if(m_data.IsKindOf(Item, m_bp_mgr.e_apl_bp_inst))
		bRes = m_bp_mgr.ShowBPInstProperties(Item);
	else if(m_data.IsKindOf(Item, m_prd_inst_mgr.e_prd_inst))
		bRes = m_prd_inst_mgr.ShowPrdInstProperties(Item);
	else if(m_data.IsKindOf(Item, m_prd_inst_mgr.e_lot))
		bRes = m_prd_inst_mgr.ShowLotProperties(Item);
	else if(m_data.IsKindOf(Item, m_project_mgr->e_project))
		bRes = m_project_mgr->ShowProjectProperties(Item);
	else if(m_data.IsKindOf(Item, m_folder_mgr.e_folder))
		bRes = m_folder_mgr.ShowFolderProperties(Item);
//	else if(m_data.IsKindOf(Item, m_categ_mgr.e_categ))
//		bRes = m_categ_mgr.Show(Item);
	else if(m_data.IsKindOf(Item, m_appr_mgr.e_person))
		bRes = m_appr_mgr.ShowPersonProperties(Item);
	else if(m_data.IsKindOf(Item, m_appr_mgr.e_org))
		bRes = m_appr_mgr.ShowOrganizationProperties(Item);
	else if(m_data.IsKindOf(Item, m_prd_mgr.e_prd))
		bRes = m_prd_mgr.ShowProperties(Item);
	else if(m_data.IsKindOf(Item, m_prd_mgr.e_pdf))
		bRes = m_prd_mgr.ShowProperties(Item);
	else if(m_data.IsKindOf(Item, m_req_mgr.e_requirement))
		bRes = m_req_mgr.ShowProperties(Item);
	else if(m_expl_mgr!=0 && m_data.IsKindOf(Item, m_expl_mgr->e_apl_refusal))
		bRes = m_expl_mgr->ShowRefusalProperies(Item);
	else
		return false;

	return bRes;
}

// #define TEST_ACCESS_ITEM \
// 	if(Item->GetAccessmode()>aplOWN){if(m_ModeInteractive)AfxMessageBox( APL_T("       \n"\
// 	"   \n"),MB_ICONEXCLAMATION);return false;}

// #define TEST_BP_CHECKED(bp) \
// 	if(bp->GetAccessmode()>aplOWN){if(m_ModeInteractive)AfxMessageBox( APL_T(" -    !\n" \
// 		"  !\n    "),MB_ICONERROR);goto begin;}\
// 	if(m_bp_mgr.GetLock(bp,false)!=0){if(m_ModeInteractive)AfxMessageBox( APL_T("-   !\n" \
// 		"  !\n    "),MB_ICONERROR);goto begin;}
// 
// #define TEST_PROJECT_CHECKED(project) \
// 	if(project->GetAccessmode()>aplOWN){if(m_ModeInteractive)AfxMessageBox( APL_T("     !\n" \
// 		"  !\n    "),MB_ICONERROR);goto begin;}\
// 	if(m_project_mgr->GetLock(project,false)!=0){if(m_ModeInteractive)AfxMessageBox( APL_T("   !\n" \
// 		"  !\n    "),MB_ICONERROR);goto begin;}
// 
// #define TEST_DOC_CHECKED(doc) \
// 	if(doc->GetAccessmode()>aplOWN){if(m_ModeInteractive)AfxMessageBox( APL_T("     !\n" \
// 		"  !\n    "),MB_ICONERROR);goto begin;}\
// 	m_data.GetAttr(doc,m_doc_mgr.a_apl_doc_lock, inst);if(inst!=0){\
// 		if(m_ModeInteractive)AfxMessageBox( APL_T("   !\n" \
// "  !\n    "),MB_ICONERROR);goto begin;}


#define ADD_CHECKED_STRING_COUNTER \
count_checked++;\
if(m_ModeInteractive){\
	if(list_checked !=_T("")) list_checked += _T("\n");\
	list_checked += GetItemTypeName(tested_inst) + _T(": \"") + GetItemName(tested_inst) + _T("\"");}


bool CaplAPI::TestAccessChecked(CaplInstance* Item)
{
	aplExtent ext;
	ext.Add(Item);
	return TestAccessChecked(ext, true);
}

bool CaplAPI::TestAccessChecked(aplExtent &extent, bool single)
{
	CString list_access=_T(""),list_checked=_T(""),buf = _T(""), buf1;
	int i,count_access=0,count_checked=0;
	CaplInstance *tested_inst,*inst;

	for(i=0;i<extent.GetSize();i++)
	{
		tested_inst = extent.GetAt(i);
		if(tested_inst==0) continue;
		////   
		if(tested_inst->GetAccessmode()>aplOWN)
		{
			count_access++;
			if(m_ModeInteractive)
			{
				if(list_access!=_T("")) list_access += _T("\n");
				list_access += GetItemTypeName(tested_inst) + _T(": \"") + GetItemName(tested_inst) + _T("\"");
			}
		}
		
		/////////     
		//  (     ,   )
		if(m_bp_mgr.GetLock(tested_inst,false)!=0)
		{
			ADD_CHECKED_STRING_COUNTER
		}
		//  (     ,   )
		if(m_project_mgr->GetLock(tested_inst,false)!=0)
		{
			ADD_CHECKED_STRING_COUNTER
		}
		// 
		if(m_data.IsKindOf(tested_inst,m_doc_mgr.e_apl_doc))
		{
			m_data.GetAttr(tested_inst,m_doc_mgr.a_apl_doc_lock, inst);
			if(inst!=0)
			{
				ADD_CHECKED_STRING_COUNTER
			}
		}
		//  (     ,   )
		if(m_charact_mgr.GetLock(tested_inst,false)!=0)
		{
			ADD_CHECKED_STRING_COUNTER
		}
	}
	if(count_access + count_checked > 0)
	{
		if(m_ModeInteractive)
		{
			if(count_access == 1 && single)
			{
				buf = APL_T("     : ");
			}
			else if(count_access == 1)
			{
				buf = APL_T("       \n   :\n");
			}
			else if(count_access > 1)
			{
				buf = APL_T("       \n   :\n");

			}
			buf+=list_access;

			if(count_access>0 && count_checked > 0) buf+=_T("\n\n");

			if(count_checked == 1 && single)
			{
				buf += APL_T("  (") + list_checked + APL_T(")   !\n");
			}
			else if(count_checked == 1)
			{
				buf += APL_T("    :\n");
			}
			else if(count_checked > 1)
			{
				buf += APL_T("    :\n");

			}
			buf+=list_checked;
			buf+=_T("\n");
			buf+=APL_T("\n  !");
			
			if(single) AfxMessageBox(buf ,MB_ICONEXCLAMATION);
			else aplShowBigMsg(buf,APL_T("  "));
		}
		return false;
	}
	return true;
}



bool CaplAPI::SetRecursiveAccess(CaplInstance* Item)
{
	aplExtent ext_all,ext_all_rel;
	aplExtent ext_cur_parent,ext_cur_child,ext_cur_rel;
	aplExtent ext_prd,ext_pdf;

	long trd=0;
	int i,j;
	CString pattern;
	CString titul;
	bool val0=false;
	bool val1=false;
	bool val2=false;
	bool val3=false;
	bool val4=false;
	bool val5=false;

	bool val_char=false;
	bool val_doc=false;
	bool val_doc_ver=false;
	bool val_appr=false;
	bool val_project=false;

	bool val_v_of_izd=false;
	bool val_ekz_of_bp=false;

	if(!m_data.IsConnected()) return false;
	if(Item==0) return false;
	if(Item->IsDeleted()) return false;
	bool bRes = false;
	//CSetAccessContentAndRecursive dlg;

begin:
	ext_all.Clear();
	ext_all_rel.Clear();

	if(!TestAccessChecked(Item)) return false;

	ext_all.Add(Item);
	
	//   -     
	if(m_data.IsKindOf(Item,m_prd_inst_mgr.e_prd_inst))
	{
		if(!ShowDlgAccessProperties(this, APL_T("     "),pattern,
			 APL_T("     "),&val1,
			 APL_T("    -"),&val2,
			 APL_T("     -"),&val3,
			 APL_T("    "),&val_doc,
			 APL_T("      "),&val_doc_ver,
			 APL_T("    "),&val_char,
			 APL_T("    "),&val_appr)){return false;};
//		dlg.m_mode=_T("PrdInst");
		
		//   -  PI
		trd=aplStartWaitDlg( APL_T("    "));
		if(val1){
			ext_cur_parent.Clear();
			ext_cur_parent.Append(ext_all);
			while(true){
				ext_cur_child.Clear();
				ext_cur_rel.Clear();
				m_prd_inst_mgr.LoadInsertedInstances(ext_cur_parent,ext_cur_rel,ext_cur_child);
				if(ext_cur_child.GetSize()==0)break;
				ext_cur_parent.Clear();
				ext_cur_parent.Append(ext_cur_child);
				ext_all.Append(ext_cur_child);
				ext_all.Append(ext_cur_rel);
			}
		}
		//    
		if(val2){
			m_bp_mgr.FindAssociatedBP(ext_all,ext_cur_child,ext_cur_rel);
			ext_all_rel.Append(ext_cur_rel);
			ext_all.Append(ext_cur_child);
		}
		//     inst
		if(val3){
			m_bp_mgr.FindAssociatedBPInst(ext_all,ext_cur_child,ext_cur_rel);
			ext_all_rel.Append(ext_cur_rel);
			ext_all.Append(ext_cur_child);

//			//    
//			trd=aplStartWaitDlg(APL_T("   "));
//			ext_cur_parent.Clear();
//			ext_cur_parent.Append(ext_cur_child);
//			while(true){
//				ext_cur_child.Clear();
//				m_bp_mgr.LoadBPInstInfo(ext_cur_parent);
//				for(i=0;i<ext_cur_parent.GetSize();i++){
//					m_data.GetAttr(ext_cur_parent.GetAt(i),m_bp_mgr.a_bp_inst_elements,ext_cur_rel);
//					ext_cur_child.Append(ext_cur_rel);
//				}
//				if(ext_cur_child.GetSize()==0)break;
//				ext_cur_parent.Clear();
//				ext_cur_parent.Append(ext_cur_child);
//				ext_all.Append(ext_cur_child);
//			}
//			aplEndWaitDlg(trd);
		}
		aplEndWaitDlg(trd);
	}
	//  -    
	else if(m_data.IsKindOf(Item,m_project_mgr->e_project))
	{
		if(!ShowDlgAccessProperties(this, APL_T("    "),pattern,
			 APL_T("     "),&val1,
			 APL_T("  ,   "),&val2,
			 APL_T("    "),&val_doc,
			 APL_T("      "),&val_doc_ver,
			 APL_T("    "),&val_char,
			 APL_T("    "),&val_appr)){return false;};
		//		dlg.m_mode=_T("Project");

		trd=aplStartWaitDlg( APL_T("    "));
		//   
		if(val1){
			ext_cur_parent.Clear();
			ext_cur_parent.Append(ext_all);
			while(true){
				ext_cur_child.Clear();
				ext_cur_rel.Clear();
				for(i=0;i<ext_cur_parent.GetSize();i++){
					m_data.GetAttr(ext_cur_parent.GetAt(i),m_project_mgr->a_project_content,ext_cur_rel);
					if(!TestAccessChecked(ext_cur_rel))
					{
						aplEndWaitDlg(trd);
						goto begin;
					}
					ext_cur_child.Append(ext_cur_rel);
				}
				if(ext_cur_child.GetSize()==0)break;
				ext_cur_parent.Clear();
				ext_cur_parent.Append(ext_cur_child);
				ext_all.Append(ext_cur_child);
				ext_all_rel.Append(ext_cur_rel);
			}
		}
		
		//  ,   
		if(val2){
//			trd=aplStartWaitDlg(APL_T(" ,   "));      
			ext_cur_parent.Clear();
			ext_cur_parent.Append(ext_all);
			
			// 
			for(i=0;i<ext_cur_parent.GetSize();i++){
				m_project_mgr->FindAssociatedItems(ext_cur_parent.GetAt(i),ext_cur_child,ext_cur_rel);
				ext_all.Append(ext_cur_child);
				ext_all.Append(ext_all_rel);
			}
//			aplEndWaitDlg(trd);
		}
		aplEndWaitDlg(trd);

	}
	//   -    
	else if(m_data.IsKindOf(Item,m_bp_mgr.e_bp))
	{
		if(!ShowDlgAccessProperties(this, APL_T("    -"),pattern,
			 APL_T("     "),&val1,
			 APL_T("    "),&val2,
			 APL_T("       "),&val3,
			 APL_T("    "),&val_doc,
			 APL_T("      "),&val_doc_ver,
			 APL_T("    "),&val_char,
			 APL_T("    "),&val_appr)){return false;};
		//		dlg.m_mode=_T("BP");

		trd=aplStartWaitDlg( APL_T("    "));
		if(val1){
			//  .   
			m_bp_mgr.GetAllSubBP(Item,ext_cur_parent);
			if(!TestAccessChecked(ext_cur_parent))
			{
				aplEndWaitDlg(trd);
				goto begin;
			}
			ext_all.Append(ext_cur_parent);
		
			ext_cur_parent.Clear();
			for(i=0;i<ext_all.GetSize();i++){
				//         .
				m_bp_mgr.GetAllBPVersion(ext_all[i],ext_cur_child);
				ext_cur_parent.Append(ext_cur_child);
			}
			ext_all.Append(ext_cur_parent);
		}
			
		if(val2){
			//  
			if(m_bp_mgr.GetBPInstForBP(ext_all,ext_cur_child)){
				ext_all.Append(ext_cur_parent);
			}else{
				aplEndWaitDlg(trd);
				AfxMessageBox(APL_T("    "),MB_ICONERROR);
				goto begin;
			}
		}
		if(val3){
			// 
			ext_cur_parent.Clear();
			for(i=0;i<ext_all.GetSize();i++){
				m_bp_mgr.LoadAllBPResources(ext_all[i],ext_cur_child);
				ext_cur_parent.Append(ext_cur_child);
			}
			ext_all.Append(ext_cur_parent);
		}
		aplEndWaitDlg(trd);
	}
	//   -    
	else if(m_data.IsKindOf(Item,m_bp_mgr.e_apl_bp_inst))
	{
		if(!ShowDlgAccessProperties(this, APL_T("     "),pattern,
			 APL_T("      "),&val1,
			 APL_T("   "),&val2,
			 APL_T("    "),&val_doc,
			 APL_T("      "),&val_doc_ver,
			 APL_T("    "),&val_char,
			 APL_T("    "),&val_appr)){return false;};
		//		dlg.m_mode=_T("BPInst");
		trd=aplStartWaitDlg( APL_T("    "));
		if(val1){
			m_bp_mgr.GetAllSubBPInst(Item,ext_cur_parent);	
			if(!TestAccessChecked(ext_cur_parent))
			{
				aplEndWaitDlg(trd);
				goto begin;
			}
			ext_all.Append(ext_cur_parent);
		}
		if(val2){
			ext_cur_parent.Clear();
			for(i=0;i<ext_all.GetSize();i++){
				m_bp_mgr.LoadAllBPResources(ext_all[i],ext_cur_child);
				ext_cur_parent.Append(ext_cur_child);
			}
			ext_all.Append(ext_cur_parent);
		}
		aplEndWaitDlg(trd);
	}
	//  -    (!)
	else if(m_data.IsKindOf(Item,m_categ_mgr.e_categ))
	{
		ext_all.Clear();//     ,     !
		if(!ShowDlgAccessProperties(this, APL_T("    "),pattern,
			 APL_T("     "),&val1,
			 APL_T("    "),&val2,
			 APL_T("    "),&val_doc,
			 APL_T("      "),&val_doc_ver,
			 APL_T("    "),&val_char,
			 APL_T("    "),&val_appr)){return false;};
		//		dlg.m_mode=_T("Categories");
		ext_cur_parent.Clear();
		trd=aplStartWaitDlg( APL_T("    "));
		if(val1){
			m_categ_mgr.GetAllSubCategory(Item,ext_cur_parent,true);
		}
		ext_cur_parent.Add(Item);
		for(i=0;i<ext_cur_parent.GetSize();i++){
			m_categ_mgr.GetCategoryContents(ext_cur_parent[i],ext_cur_child,val1);
			ext_all.Append(ext_cur_child);
		}
		if(val2){
			m_prd_mgr.GetAllProductVersion(ext_all,ext_all_rel);
			ext_all.Append(ext_all_rel);
		}
		aplEndWaitDlg(trd);
	}
	//   -     
	else if(m_data.IsKindOf(Item,m_prd_mgr.e_pdf))
	{
		if(!ShowDlgAccessProperties(this, APL_T("    "),pattern,
			 APL_T("    "),&val1,
			 APL_T("     "),&val2,
//			APL_T("  "),&val3,
			 APL_T("    "),&val_doc,
			 APL_T("      "),&val_doc_ver,
			 APL_T("    "),&val_char,
			 APL_T("    "),&val_appr)){return false;};
		//		dlg.m_mode=_T("Product");
		aplInstArray arr_pdf,arr_unit;
		aplRealArray count_array;
		trd=aplStartWaitDlg( APL_T("    "));
		if(m_prd_mgr.DisassemblyProduct(0,0,Item,arr_pdf,count_array,arr_unit,false))
		{
//			arr_pdf -  ,      ,    
// 			if(!TestAccessChecked(arr_pdf))
// 			{
// 				aplEndWaitDlg(trd);
// 				goto begin;
// 			}
// 			ext_all.Append(arr_pdf);

			for(i=0;i<arr_pdf.Size;i++)
			{
				if(arr_pdf[i]==0)continue;
				if(arr_pdf[i]->GetAccessmode()<aplRO){
					ext_all.Add(arr_pdf[i]);	
				}else{
					CString sMsg;
					sMsg.Format(APL_T("  \"%s\"     %s\n     !\n  !"),
						GetItemName(arr_pdf[i]), GetItemName(Item));
					if(m_ModeInteractive)AfxMessageBox(sMsg,MB_ICONERROR);
					aplEndWaitDlg(trd);
					return false;
				}
			}
		}
		if(ext_all.Size==0)
		{
			aplEndWaitDlg(trd);
			AfxMessageBox(APL_T(" ,   "));
			return true;
		}
		if(val1){
			m_bp_mgr.FindAssociatedBP(ext_all,ext_cur_parent,ext_cur_rel);	
			ext_all.Append(ext_cur_parent);
			ext_all.Append(ext_cur_rel);
		}
		if(val2){
			m_bp_mgr.FindAssociatedBPInst(Item,ext_cur_parent,ext_cur_rel);	
			ext_all.Append(ext_cur_parent);
			ext_all.Append(ext_cur_rel);
		}
		aplEndWaitDlg(trd);
	}
	//  -    (!)
	//  -     (!)
	else if(m_data.IsKindOf(Item,m_folder_mgr.e_folder) || 
		m_data.IsKindOf(Item,m_query_mgr.e_apl_query))
	{
		ext_all.Clear();//     /,     !
		if(m_data.IsKindOf(Item,m_folder_mgr.e_folder)){
			titul= APL_T("    ");
		}else{
			titul= APL_T("    ");
		}
		if(!ShowDlgAccessProperties(this,titul,pattern,
			 APL_T("     "),&val0,
			 APL_T("      "),&val1,
			 APL_T("    ,   "),&val_v_of_izd,
			 APL_T("      "),&val2,
			 APL_T("      "),&val3,
			 APL_T("    -"),&val4,
			 APL_T("     -"),&val5,
			 APL_T("    -,   "),&val_ekz_of_bp,
			 APL_T("    "),&val_doc,
			 APL_T("      "),&val_doc_ver,
			 APL_T("    "),&val_char,
			 APL_T("    "),&val_appr,
			 APL_T("     "), &val_project)){return false;};
		//		dlg.m_mode=_T("Folder");

		trd=aplStartWaitDlg( APL_T("    "));

		if(m_data.IsKindOf(Item,m_folder_mgr.e_folder)){
			m_folder_mgr.LoadFolderInfo(Item);
			m_folder_mgr.GetFolderContents(Item,ext_cur_child);
			if(val1 || val0){
				m_folder_mgr.GetAllSubFolder(Item,ext_cur_parent,true);
				if(val1){
					for(i=0;i<ext_cur_parent.GetSize();i++){
						m_folder_mgr.GetFolderContents(ext_cur_parent[i],ext_cur_rel);
						ext_all.Append(ext_cur_rel);
					}
				}
				if(val0)ext_all.Append(ext_cur_parent);
			}
			ext_all.Append(ext_cur_child);
		}else{
			COleDateTime time;
			m_query_mgr.GetFindResult(Item,ext_cur_child,time);
			ext_all.Append(ext_cur_child);
			if(val1){
				ext_cur_child.Clear();
				for(int j=0;j<ext_all.GetSize();j++){
					if(!m_data.IsKindOf(ext_all[j],m_folder_mgr.e_folder)){continue;}
					m_folder_mgr.GetFolderContents(ext_all[j],ext_cur_parent);
					ext_cur_child.Append(ext_cur_parent);
					m_folder_mgr.GetAllSubFolder(ext_all[j],ext_cur_parent);
					ext_cur_child.Append(ext_cur_parent);
					for(i=0;i<ext_cur_parent.GetSize();i++){
						m_folder_mgr.GetFolderContents(ext_cur_parent[i],ext_cur_rel);
						ext_cur_child.Append(ext_cur_rel);
					}
				}
				ext_all.Append(ext_cur_child);
			}
		}
		if(ext_all.Size==0)
		{
			aplEndWaitDlg(trd);
			AfxMessageBox(APL_T("  ,   "));
			return true;
		}
		//   ,   ?
		if(!TestAccessChecked(ext_all_rel))
		{
			aplEndWaitDlg(trd);
			goto begin;
		}

		if(val_v_of_izd){
			ext_prd.Clear();
			for(int k=0;k<ext_cur_child.Size;k++){
				if(m_data.IsKindOf(ext_cur_child[k],m_prd_mgr.e_prd)){
					ext_prd.Add(ext_cur_child[k]);
				}
			}
			m_prd_mgr.GetAllProductVersion(ext_prd,ext_pdf);
			ext_all.Append(ext_pdf);
			ext_cur_child.Append(ext_pdf);
		}
		if(val2 || val3){
			for(int k=0;k<ext_cur_child.Size;k++){
				if(m_data.IsKindOf(ext_cur_child[k],m_prd_mgr.e_pdf) && val2){
					aplInstArray ext_pdf,ext_unit;
					aplRealArray count_array;
					int i;
					if(m_prd_mgr.DisassemblyProduct(0,0,ext_cur_child[k],ext_pdf,count_array,ext_unit,false))
					{
						for(i=0;i<ext_pdf.Size;i++)
						{
							ext_all.Add(ext_pdf[i]);	
						}
					}
				}
				if(m_data.IsKindOf(ext_cur_child[k],m_prd_inst_mgr.e_prd_inst) && val3){
					aplExtent ext_cur_parent,ext_cur_rel,ext_cur_child;
					ext_cur_parent.Add(ext_cur_child[k]);
					while(true){
						ext_cur_child.Clear();
						ext_cur_rel.Clear();
						m_prd_inst_mgr.LoadInsertedInstances(ext_cur_parent,ext_cur_rel,ext_cur_child);
						if(ext_cur_child.GetSize()==0)break;
						ext_cur_parent.Clear();
						ext_cur_parent.Append(ext_cur_child);
						ext_all.Append(ext_cur_child);
						ext_all.Append(ext_cur_rel);
					}
				}
			}
		}
		//      
		if(val_ekz_of_bp){
			ext_prd.Clear();
			for(int k=0;k<ext_cur_child.Size;k++){
				if(m_data.IsKindOf(ext_cur_child[k],m_bp_mgr.e_bp)){
					ext_prd.Add(ext_cur_child[k]);
				}
			}
			m_bp_mgr.GetAllBPVersion(ext_prd,ext_pdf);
			ext_all.Append(ext_pdf);
			ext_cur_child.Append(ext_pdf);
		}
		//    
		if(val4){
			m_bp_mgr.FindAssociatedBP(ext_all,ext_cur_child,ext_cur_rel);
			ext_all_rel.Append(ext_cur_rel);
			ext_all.Append(ext_cur_child);
		}
		//     inst
		if(val5){
			m_bp_mgr.FindAssociatedBPInst(ext_all,ext_cur_child,ext_cur_rel);
			ext_all_rel.Append(ext_cur_rel);
			ext_all.Append(ext_cur_child);
		}
		//    
		if(val_project)
		{
			aplExtent aeChild;
			m_project_mgr->GetAllSubProject(ext_all, aeChild, true);
			ext_all.Append(aeChild);
		}
		aplEndWaitDlg(trd);
	}
	//  -     ()  
	//    ()     (!)
	else if(m_data.IsKindOf(Item,m_classifier_mgr.e_apl_classifier_system))
	{
		titul= APL_T("    ");
		if(!ShowDlgAccessProperties(this,titul,pattern,
			 APL_T("     "),&val1,
			 APL_T("      "),&val2,
			 APL_T("   ,    "),&val3,
			 APL_T("    "),&val_doc,
			 APL_T("      "),&val_doc_ver,
			 APL_T("    "),&val_char,
			 APL_T("    "),&val_appr)){return false;};
//		dlg.m_mode=_T("ClassifSystem");
		
		trd=aplStartWaitDlg( APL_T("    "));
		if(val1){
			m_classifier_mgr.LoadSubClassifierSystems(Item,ext_cur_child,true);
			ext_all.Append(ext_cur_child);
		}
		//       2  3
		if(val2 || val3){
			ext_cur_parent.Clear();
			for(i=0;i<ext_all.Size;i++){
				m_classifier_mgr.LoadSubClassifierLevels(ext_all[i],ext_cur_child,true);
				ext_cur_parent.Append(ext_cur_child);	
			}
		}
		if(val2){
			ext_all.Append(ext_cur_parent);
		}
		if(val3){
			for(i=0;i<ext_cur_parent.Size;i++){
				m_classifier_mgr.GetSubItems(ext_cur_parent[i],ext_cur_child);
				ext_all.Append(ext_cur_child);
			}
		}
		//     -       
		ext_cur_child.Clear();
		for(j=0;j<ext_all.GetSize();j++){
			//
			CaplInstance *prd;
			if(m_data.IsKindOf(ext_all[j],m_prd_mgr.e_pdf)){
				m_data.GetAttr(ext_all[j],m_prd_mgr.a_pdf_prd,prd);
				ext_cur_child.Add(prd);
			}
		}
		ext_all.Append(ext_cur_child);
		aplEndWaitDlg(trd);
	}
	//  -     ()  
	//    ()     (!)
	else if(m_data.IsKindOf(Item,m_classifier_mgr.e_apl_classifier_level))
	{
		titul= APL_T("      ");
		if(!ShowDlgAccessProperties(this,titul,pattern,
			APL_T("      "),&val2,
			APL_T("   ,    "),&val3,
			APL_T("    "),&val_doc,
			APL_T("      "),&val_doc_ver,
			APL_T("    "),&val_char,
			APL_T("    "),&val_appr)){return false;};
		//		dlg.m_mode=_T("ClassifSystem");

		trd=aplStartWaitDlg( APL_T("    "));
// 		if(val1){
// 			m_classifier_mgr.LoadSubClassifierSystems(Item,ext_cur_child,true);
// 			ext_all.Append(ext_cur_child);
// 		}
		//   ,   
		if(val2)
		{
			ext_cur_parent.Clear();
			for(i=0;i<ext_all.Size;i++)
			{
				m_classifier_mgr.LoadSubClassifierLevels(ext_all[i],ext_cur_child,true);
				ext_cur_parent.Append(ext_cur_child);
			}
			ext_all.Append(ext_cur_parent);
		}
		// ,     
		if(val3)
		{
			ext_cur_parent.Clear();
			for(i=0;i<ext_all.Size;i++)
			{
				m_classifier_mgr.GetSubItems(ext_all[i],ext_cur_child);
				ext_cur_parent.Append(ext_cur_child);
			}
			ext_all.Append(ext_cur_parent);
		}
		//     -       
		ext_cur_child.Clear();
		for(j=0;j<ext_all.GetSize();j++)
		{
			//
			CaplInstance *prd;
			if(m_data.IsKindOf(ext_all[j],m_prd_mgr.e_pdf))
			{
				m_data.GetAttr(ext_all[j],m_prd_mgr.a_pdf_prd,prd);
				ext_cur_child.Add(prd);
			}
		}
		ext_all.Append(ext_cur_child);
		aplEndWaitDlg(trd);
	}
	//  -       ()
	else if(m_data.IsKindOf(Item,m_appr_mgr.e_org))
	{
		titul= APL_T("      ");
		if(!ShowDlgAccessProperties(this,titul,pattern,
			 APL_T("     "),&val1,
			 APL_T("      "),&val2,
			 APL_T("    "),&val_doc,
			 APL_T("      "),&val_doc_ver,
			 APL_T("    "),&val_char
			)){return false;};
//		dlg.m_mode=_T("ClassifLevel");

		trd=aplStartWaitDlg( APL_T("    "));
		ext_cur_child.Clear();
		ext_cur_parent.Clear();
		if(val1){
			ext_cur_child.Add(Item);
			m_appr_mgr.GetAllSubOrganization(ext_cur_child,ext_cur_parent,true);
			ext_all.Append(ext_cur_parent);
		}
		ext_cur_parent.Add(Item);
		if(val2){
			for(i=0;i<ext_cur_parent.Size;i++){
				m_appr_mgr.GetAllSubPerson(ext_cur_parent[i],ext_cur_child,ext_cur_rel);
				ext_all.Append(ext_cur_child);
			}
		}
		aplEndWaitDlg(trd);
	}
	//      - 
	else
	{
//		dlg.m_mode=_T("");
	}
	// ,      
	//    
	if(!TestAccessChecked(ext_all)) goto begin;


	if(val_doc){
		//      
		m_doc_mgr.FindAssociatedDocumentsRec(ext_all,ext_cur_child,ext_cur_rel);
		//   ,   ?
		if(!TestAccessChecked(ext_cur_child)) 
			goto begin;
		for(i=0;i<ext_cur_child.GetSize();i++){
			if(val_doc_ver){
				//    
				m_doc_mgr.LoadAllDocumentRevision(ext_cur_child[i],ext_all_rel);
				if(!TestAccessChecked(ext_all_rel)) 
					goto begin;
				ext_all.Append(ext_all_rel);
			}
		}
		//      PI  BPI 
		ext_all.Append(ext_cur_child);
		//  relation-
		ext_all.Append(ext_all_rel);
	}			
	if(val_char){
		//      
		m_charact_mgr.FindAssociatedCharacteristic(ext_all,ext_cur_child,ext_cur_rel,true,true,true);
		//     ?
		//    relation
		ext_cur_child.Append(ext_cur_rel);
		if(!TestAccessChecked(ext_cur_child)) 
			goto begin;
		//     
		ext_all.Append(ext_cur_child);

	}			
	if(val_appr){
		//      
		ext_all_rel.Clear();
		for(i=0;i<ext_all.GetSize();i++){
			m_appr_mgr.LoadItemApproval(ext_all[i],ext_cur_child);
			if(!TestAccessChecked(ext_cur_child)) 
				goto begin;
			//      PI  BPI 
			ext_all_rel.Append(ext_cur_child);
		}
		ext_all.Append(ext_all_rel);
	}	


	//     
	if(pattern==_T(""))
	{
		return m_data.NET_SetInstancesAccess(&ext_all,_T(""));
	}else{
		if(m_data.NET_SetAccessFromPattern(&ext_all,pattern, APL_T(" ")))
		{
			if(m_ModeInteractive)AfxMessageBox( APL_T(" !"));
		}else{
			return false;
		}
	}

	return true;
}

bool CaplAPI::DeleteItem(CaplInstance* Item)
{
	if(Item==0) return false;
	if(Item->IsDeleted()) return false;
	
	bool res;

	//   -     
	if(m_data.IsKindOf(Item,m_prd_mgr.e_prd))
	{
		res = m_prd_mgr.DeleteProductWithAllVersion(Item);
	}
	else if(m_data.IsKindOf(Item,m_prd_mgr.e_pdf))
	{
		res = m_prd_mgr.DeleteProductVersion(Item);
	}
	else if(m_data.IsKindOf(Item,m_prd_inst_mgr.e_prd_inst))
	{
		res = m_prd_inst_mgr.DeletePrdInst(Item);
	}
	else if(m_data.IsKindOf(Item,m_prd_inst_mgr.e_lot))
	{
		res = m_prd_inst_mgr.DeleteLot(Item);
	}
	else if(m_data.IsKindOf(Item,m_bp_mgr.e_apl_bp_inst))
	{
		res = m_bp_mgr.DeleteBPInst(Item);
	}
	else if(m_data.IsKindOf(Item,m_bp_mgr.e_bp))
	{
		res = m_bp_mgr.DeleteBP(Item);
	}
	else if(m_data.IsKindOf(Item,m_change_mgr.e_avc))
	{
		res = m_change_mgr.DeleteChange(Item);
	}
	else if(m_data.IsKindOf(Item,m_doc_mgr.e_doc))
	{
		res = m_doc_mgr.DeleteDoc(Item);
	}
	else if(m_data.IsKindOf(Item,m_doc_mgr.e_apl_doc_rev))
	{
		res = m_doc_mgr.DeleteRevision(Item);
	}
	else if(m_data.IsKindOf(Item,m_folder_mgr.e_folder))
	{
		res = m_folder_mgr.DeleteFolder(Item);
	}
	else if(m_data.IsKindOf(Item,m_message_mgr.e_message))
	{
		res = m_message_mgr.DeleteMessage(Item);
	}
	else if(m_data.IsKindOf(Item,m_query_mgr.e_apl_ct))
	{
		res = m_query_mgr.DeleteQuery(Item);
	}
	else if(m_data.IsKindOf(Item,m_query_mgr.e_apl_query))
	{
		res = m_query_mgr.DeleteQuery(Item);
	}
	else if(m_data.IsKindOf(Item,m_classifier_mgr.e_apl_classifier_level))
	{
		res = m_classifier_mgr.DeleteClassifierItem(Item);
	}
	else if(m_data.IsKindOf(Item,m_classifier_mgr.e_apl_classifier_system))
	{
		res = m_classifier_mgr.DeleteClassifierItem(Item);
	}else{
		if(Item==0) return false;
		if(Item->IsDeleted()) return false;
		if(Item->GetAccessmode()>aplOWN) 
		{
			if(m_ModeInteractive)aplErrorMessage(S::NoAccessRight(),Item);
			return false;
		}
		res = m_data.DeleteInstance(Item);
	}
	return res;
}

bool CaplAPI::ChangeCurrentUserPassword()
{
	if(!m_data.IsDictLoad()) return false;

	CaplSetResourceHandle setres(module_inst);

	CChangePasswordDlg dlg(false, this);
	dlg.DoModal();
	
	return true;
}

bool CaplAPI::ChangeUserPassword(CaplInstance* pUser)
{
	if(!m_data.IsDictLoad()) return false;
	if(m_appr_mgr.IsAdmin()==false)//       
	{
		return false;
	}

	CaplSetResourceHandle setres(module_inst);

	CChangePasswordDlg dlg(true, this);
	dlg.m_pUser= pUser;
	dlg.DoModal();

	return true;
}

bool CaplAPI::SetPasswordSecurity()
{
	if(m_appr_mgr.IsAdmin()==false)
	{
		return false;
	}

	CaplSetResourceHandle setres(module_inst);

	CSecuritySettings cSecurity(this);
	cSecurity.ReadFromOptions();

	CSecurityPasswordDlg dlg(this, &cSecurity);
	dlg.DoModal();

	return true;
}

bool CaplAPI::aplGetCurrentTime(COleDateTime &time)
{
	if(m_data.IsConnected())
		m_data.NET_GetServerDateTime(time);
	else
		time = COleDateTime::GetCurrentTime();

	return true;
}

bool CaplAPI::aplGetCurrentTime(CString &time)
{
	COleDateTime tmp;
	aplGetCurrentTime(tmp);
	aplDate2String(tmp, time);

	return true;
}

bool CaplAPI::LoadByParts(aplExtent &ext, int nMaxLoad, bool bLoadAttrs, void(*fn)(CaplAPI *, CaplLoadData &, DWORD), DWORD data)
{
	if(!m_data.IsConnected()) return false;
	if(ext.GetSize() == 0) return true;
	CaplLoadData ld(&m_data, DEF_SOURCE);

	int co = 0;
	for(int i=0; i<ext.GetSize(); i++)
	{
		if(ext[i]) if(ext[i]->GetId()) 
		{
			ld.AddQuery(0, ext[i], bLoadAttrs);
			++co;
		}

		if(((co == nMaxLoad) || (i == ext.GetSize()-1)) && ld.m_queries.GetSize())
		{
			if(fn) fn(this, ld, data);
			if (!ld.LoadEx())
			{
			//	if(m_data.GetLastAplError()!=APL_SOCK_OPERATION_IN_PROGRESS){
			//		if(m_ModeInteractive)AfxMessageBox(APL_T("   ."), MB_OK|MB_ICONSTOP);}
				return false;
			}
			co  = 0;
			ld.ClearQuery();
		}
	}
	return true;
}

bool CaplAPI::SetLoadCharacteristicValues(bool is_load)
{
	bool prev_val=m_load_characteristic_values;
	m_load_characteristic_values=is_load;
	return prev_val;
}

void CaplAPI::SetLss3Mode()
{
	m_bLss3Mode = true;
}

bool CaplAPI::GetLss3Mode()
{
	return m_bLss3Mode;
}

CString CaplAPI::GetItemTypeName(CaplInstance * item)
{
	CString buf=_T("");
	if(item==0)
	{
		return _T("");
	}
	if(item->IsDeleted())
	{
		buf=  APL_T("< >");
	}
	else if(item->GetAccessmode()>aplRO)
	{
		buf = APL_T("<   >");
	}
	// 
	else if(m_data.IsKindOf(item,m_categ_mgr.e_categ))
	{
		buf=APL_T(":");
	}
	// 
	else if(m_data.IsKindOf(item,m_folder_mgr.e_folder))
	{
		buf=APL_T("");
	}
	// 
	else if(m_data.IsKindOf(item,m_doc_mgr.e_doc))
	{
		buf=APL_T("");
	}
	//   ( PSM  )
	else if(m_data.IsKindOf(item,m_doc_mgr.e_apl_doc_rev))
	{
		buf=APL_T(" ");
	}
	// 
	else if(m_data.IsKindOf(item,m_categ_mgr.e_apl_product_category_ver))
	{
		buf=APL_T(" ");
	}
	// 
	else if(m_data.IsKindOf(item,m_bp_mgr.e_apl_bp_ver))
	{
		buf=APL_T(" ");
	}
	// 
	else if(m_data.IsKindOf(item,m_prd_mgr.e_prd))
	{
		buf = APL_T("");
	}
	// 
	else if(m_data.IsKindOf(item,m_prd_mgr.e_pdf))
	{
		buf = APL_T(" ");
	}
	// 
	else if(m_data.IsKindOfBN(item,_T("apl_action")))
	{
		buf=APL_T("");
	}
	// - 
	else if(m_data.IsKindOf(item,m_bp_mgr.e_bp))
	{
		buf=APL_T("-");
	}
	// 
	else if(m_data.IsKindOf(item,m_bp_mgr.e_bp_res))
	{
		buf=APL_T(" ");
	}
	//  
	else if(m_data.IsKindOf(item,m_prd_inst_mgr.e_lot))
	{
		buf=APL_T(" ");
	}
	//  
	else if(m_data.IsKindOf(item,m_prd_inst_mgr.e_prd_inst))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item,m_appr_mgr.e_pers_org))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item,m_appr_mgr.e_person))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item,m_appr_mgr.e_official))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item,m_appr_mgr.e_org ))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_apl_assigned_document))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_apl_stored_document))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item, m_project_mgr->e_project))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item,m_project_mgr->e_project_adm_ver))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_bp_mgr.e_apl_bp_inst))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item, m_message_mgr.e_alert))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_options_mgr.e_str))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_options_mgr.e_int))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_options_mgr.e_inst))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_unit))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_charact_type))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item, m_change_mgr.e_chng))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_change_mgr.e_avc))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item, m_change_mgr.e_psc))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item, m_appr_mgr.e_apl_appr))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_doc_copy_order))
	{
		buf=APL_T("-    ");
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_charact))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_charact_value))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item, m_charact_mgr.e_apl_charact_value_ver))
	{
		buf=APL_T("  ");
	}
	else if(m_data.IsKindOf(item, m_query_mgr.e_apl_query))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_query_mgr.e_apl_ct))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item, m_classifier_mgr.e_apl_classifier_system))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_classifier_mgr.e_apl_classifier_level))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item, m_doc_mgr.e_doc_copy))
	{
		buf=APL_T(" ");
	}
	else if(m_data.IsKindOf(item, m_appr_mgr.e_po_role))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_message_mgr.e_message))
	{
		buf=APL_T("");
	}
	else if(m_data.IsKindOf(item, m_req_mgr.e_requirement))
	{
		buf=APL_T("");
	}
	return buf;
}


bool aplInputStrValue(LPCTSTR sHader, LPCTSTR sName, CString &sVal)
{
	CaplSetResourceHandle setres(module_inst);
	CGetStrDlg dlg;
	dlg.m_sHeader=sHader;
	dlg.m_sName=sName;
	dlg.m_sValue=sVal;
	int res=dlg.DoModal();
	if(IDOK!=res) return false;
	sVal=dlg.m_sValue;
	return true;
}