// MProcStartDialog.cpp : implementation file
//

#include "stdafx.h"
#include "aplWorkFlowManager.h"
#include "MProcStartDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMProcStartDialog dialog


CMProcStartDialog::CMProcStartDialog(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CMProcStartDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMProcStartDialog)
	m_csTempl = _T("");
	m_iProcSchema = 0;
	//}}AFX_DATA_INIT

	m_api		=NULL;
	m_wf_mgr	=NULL;

	m_ciTemplate=NULL;
	m_ciTask	=NULL;

	m_csTemplId		=_T("");
	m_csTemplName	=_T("");
	m_csTemplDescr	=_T("");

	m_bSavedAutoSave=false;
	m_bAutoAddProcInst= false;
}


void CMProcStartDialog::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMProcStartDialog)
	DDX_Control(pDX, IDC_LC_LIST, m_lcList);
	DDX_Control(pDX, IDC_CB_SET, m_cbSet);
	DDX_Text(pDX, IDC_E_PROC_TEMPL, m_csTempl);
	DDX_Control(pDX, IDOK, m_OK);
	DDX_Control(pDX, IDCANCEL, m_Cancel);
	DDX_Control(pDX, IDC_B_PROPS, m_bProps);
	DDX_Control(pDX, IDC_B_DEL, m_bDel);
	DDX_Control(pDX, IDC_B_ADD, m_bAdd);
	DDX_Control(pDX, IDC_PROTOTYPES, m_cbPrototypes);
	DDX_CBIndex(pDX, IDC_PROTOTYPES, m_iProcSchema);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMProcStartDialog, CaplResizableDialog)
	//{{AFX_MSG_MAP(CMProcStartDialog)
	ON_BN_CLICKED(IDC_B_ADD, OnBAdd)
	ON_BN_CLICKED(IDC_B_PROPS, OnBProps)
	ON_BN_CLICKED(IDC_B_DEL, OnBDel)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LC_LIST, OnItemchangedLcList)
	ON_WM_DESTROY()
	ON_NOTIFY(NM_DBLCLK, IDC_LC_LIST, OnDblclkLcList)
	ON_CBN_SELCHANGE(IDC_CB_SET, OnSelchangeCbSet)
	ON_CBN_SELCHANGE(IDC_PROTOTYPES, OnSelchangePrototypes)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CMProcStartDialog::ShowPerf(void)
{
	CString	cst;
	m_cbSet.GetLBText(m_cbSet.GetCurSel(),cst);
	if(APL_T("")!=cst)
		return FALSE;

	return TRUE;
}

void CMProcStartDialog::SetAnchors(void)
{
	AddAnchor(IDC_GRP_SETTINGS,TOP_LEFT,TOP_RIGHT);
		AddAnchor(IDC_T_PROC_TEMPL,TOP_LEFT);
		AddAnchor(IDC_E_PROC_TEMPL,TOP_LEFT,TOP_RIGHT);
		AddAnchor(IDC_T_SET,TOP_LEFT);
		AddAnchor(IDC_CB_SET,TOP_LEFT,TOP_RIGHT);
		AddAnchor(IDC_PROTOTYPES,TOP_LEFT,TOP_RIGHT);

	AddAnchor(IDC_GRP_LIST,TOP_LEFT,BOTTOM_RIGHT);
		AddAnchor(IDC_B_ADD,TOP_RIGHT);
		AddAnchor(IDC_B_PROPS,TOP_RIGHT);
		AddAnchor(IDC_B_DEL,TOP_RIGHT);
		AddAnchor(IDC_LC_LIST,TOP_LEFT,BOTTOM_RIGHT);

	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
}

void CMProcStartDialog::InitControls(void)
{
	CaplInstance*	cit		=NULL;

	CString			cst;

	int				i;

	//	templ text
	m_api->GetItemName(m_ciTemplate,m_csTempl);

	//	combo
	m_cbSet.AddString(APL_T(""));
	m_cbSet.AddString(APL_T(""));
	m_cbSet.SelectString(-1,APL_T(""));

	//	list
	m_lcList.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
	m_lcList.InsertColumn(0,APL_T(""),LVCFMT_LEFT,100);
	m_wf_mgr->GetProcessComponents(m_ciTemplate, m_aeComponents);
	aplSortByDate(&m_api->m_data, m_aeComponents, 0, m_aeComponents.GetSize()-1, m_wf_mgr->a_action_id);
	
	for(i=0;i<m_aeComponents.GetSize();i++)
	{
		cit=m_aeComponents.GetAt(i);
		if(!m_api->m_data.IsKindOf(cit,m_wf_mgr->e_activity))
			continue;

		m_api->GetItemName(cit,cst);
		m_lcList.InsertColumn(i+1,cst,LVCFMT_LEFT,100);

		m_Act2Col.SetAt(cit,i+1);
		m_Col2Act.SetAt(i+1,cit);
	}
}

void CMProcStartDialog::ChangeCtrlsState(void)
{
	POSITION	pos		=NULL;
	CaplInstance*	selected_proc= NULL;
	CaplInstance*	prot_schema= NULL;
	BOOL		bEn		=FALSE;

	int			ipos	=-1;
	CString buf= APL_T("< >");

	pos=m_lcList.GetFirstSelectedItemPosition();
	if(NULL!=pos)
		ipos=m_lcList.GetNextSelectedItem(pos);

	if(-1!=ipos)
	{
		bEn=TRUE;

		selected_proc= (CaplInstance*)m_lcList.GetItemData(ipos);
	
		m_api->m_data.GetAttr(selected_proc, m_wf_mgr->a_proc_process_prot, prot_schema);
		if(prot_schema)
			m_api->m_data.GetAttr(prot_schema, m_wf_mgr->a_proc_prot_name, buf);
	}

	m_iProcSchema= m_cbPrototypes.SelectString(-1, buf);	

	m_bDel.EnableWindow(bEn);
	m_bProps.EnableWindow(bEn);
}

void CMProcStartDialog::InitVars(void)
{
	double	dblDur;
	int i, iNum;
	aplExtent ext;
	CString buf;

	m_api->m_data.GetAttr(m_ciTemplate,m_wf_mgr->a_action_id,m_csTemplId);
	m_api->m_data.GetAttr(m_ciTemplate,m_wf_mgr->a_action_name,m_csTemplName);
	m_api->m_data.GetAttr(m_ciTemplate,m_wf_mgr->a_action_dscr,m_csTemplDescr);

	m_api->m_data.GetAttr(m_ciTemplate,m_wf_mgr->a_proc_tmpl_duration,dblDur);
	if(dblDur==0)//    
		m_dtsTemplDuration.SetDateTimeSpan(1, 0, 0, 0);
	else 
		m_dtsTemplDuration.m_span=dblDur;

	m_wf_mgr->GetProcessPrototypes(m_ciTemplate, ext);
	for(i= 0; i<ext.GetSize(); i++)
	{
		m_api->m_data.GetAttr(ext[i], m_wf_mgr->a_proc_prot_name, buf);
		if(!buf.IsEmpty())
		{
			iNum= m_cbPrototypes.InsertString(i, buf);
			m_cbPrototypes.SetItemData(iNum, (DWORD)ext[i]);
		}
	}
	
	iNum= m_cbPrototypes.InsertString(0, APL_T("< >"));
	m_cbPrototypes.SetItemData(iNum, (DWORD)NULL);
}

void CMProcStartDialog::FillList(void)
{
	CaplInstance*	ciProc		=NULL;
	CaplInstance*	selected_proc= NULL;
	CaplInstance* prot_schema= NULL;
	CString			cst;
	CString			buf;
	BOOL			bShowPerf=TRUE;
	int				i;

	UpdateData();

	int index= m_lcList.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
	if(-1!=index)
	{
		selected_proc= (CaplInstance*)m_lcList.GetItemData(index);
	}

	m_lcList.SetRedraw(FALSE);
	m_lcList.DeleteAllItems();

	for(i=0;i<m_aeProcesses.GetSize();i++)
	{
		ciProc= m_aeProcesses[i];
		FillRow(i, ciProc, ShowPerf());

		if(ciProc==selected_proc)
		{
			m_lcList.SetItemState(i, LVNI_SELECTED, LVNI_SELECTED);
			
			m_api->m_data.GetAttr(ciProc, m_wf_mgr->a_proc_process_prot, prot_schema);
			if(prot_schema)
				m_api->m_data.GetAttr(prot_schema, m_wf_mgr->a_proc_prot_name, buf);
			else
				buf= APL_T("< >");

			m_iProcSchema= m_cbPrototypes.SelectString(-1, buf);
		}
	}

	UpdateData(FALSE);

	m_lcList.SetRedraw(TRUE);
}

void CMProcStartDialog::FillRow(int iRow, CaplInstance* ciProc, BOOL bShowPerf)
{
	CaplInstance*	ciComp		=NULL;
	CaplInstance*	ciAct		=NULL;

	CaplInstance*	cit			=NULL;
	CaplInstance* prot_schema= NULL;

	aplExtent		aet;
	aplExtent persons;

	CString			cst;

	WORD			icol;
	
	int				i,ipos;


	m_api->GetItemName(ciProc,cst);

	//	  
	if(iRow>=m_lcList.GetItemCount())
		ipos=m_lcList.InsertItem(iRow,_T(""));
	else
		ipos=iRow;

	m_lcList.SetItemData(ipos,(DWORD)ciProc);
	m_lcList.SetItemText(ipos,0,cst);

	//	  
	for(i=1;i<m_lcList.GetHeaderCtrl()->GetItemCount();i++)
		m_lcList.SetItemText(ipos,i,_T(""));

	//	 task_prototypes

	m_api->m_data.GetAttr(ciProc, m_wf_mgr->a_proc_process_prot, prot_schema);
	if(prot_schema)
		m_wf_mgr->GetProcessPrototypeItems(prot_schema, aet);
	else
		m_api->m_data.GetAttr(ciProc,m_wf_mgr->a_proc_task_prot,aet);
	
	CString buf;
	//   
	for(i=0;i<m_aeComponents.GetSize();i++)
	{
		ciAct= m_aeComponents[i];
		cit=0;

		if(FALSE==m_Act2Col.Lookup(ciAct,(WORD&)icol))
			continue;
		
		if(TRUE==bShowPerf)
		{
			m_api->m_data.GetAttr(ciAct, m_wf_mgr->a_activity_executors, persons);

			if(persons.GetSize()==1)
				if(!m_api->m_data.IsKindOf(persons[0], m_api->m_appr_mgr.e_org))
					cit= persons[0];
		}
		else
		{
			m_api->m_data.GetAttr(ciAct, m_wf_mgr->a_activity_managers, persons);

			if(persons.GetSize()==1)
				if(!m_api->m_data.IsKindOf(persons[0], m_api->m_appr_mgr.e_org))
					cit= persons[0];			
		}
		
		if(!cit)
			continue;

		m_api->m_appr_mgr.GetPersonName(cit, buf);
		cst.Format(APL_T(" [%s]"), buf);

		m_lcList.SetItemText(ipos, icol, cst);
	}

	//	  components
	for(i=0;i<aet.GetSize();i++)
	{
		ciComp=aet.GetAt(i);
		m_api->m_data.GetAttr(ciComp, m_wf_mgr->a_task_tmpl_activity, ciAct);
		
		if(FALSE==m_Act2Col.Lookup(ciAct,(WORD&)icol))
			continue;
				
		if(TRUE==bShowPerf)
		{
			m_api->m_data.GetAttr(ciComp, m_wf_mgr->a_task_tmpl_performer,cit);
			
			if(!cit)
			{
				m_api->m_data.GetAttr(ciAct, m_wf_mgr->a_activity_executors, persons);

				if(persons.GetSize()==1)
					if(!m_api->m_data.IsKindOf(persons[0], m_api->m_appr_mgr.e_org))
						cit= persons[0];
			}
			
			m_api->m_appr_mgr.GetPersonName(cit, cst);
		}
		else
		{
			m_api->m_data.GetAttr(ciComp, m_wf_mgr->a_task_tmpl_manager,cit);
			if(!cit)
			{
				m_api->m_data.GetAttr(ciAct, m_wf_mgr->a_activity_managers, persons);

				if(persons.GetSize()==1)
					if(!m_api->m_data.IsKindOf(persons[0], m_api->m_appr_mgr.e_org))
						cit= persons[0];
			}
			
			m_api->m_appr_mgr.GetPersonName(cit, cst);
		}
		
		if(NULL==cit)
			continue;
		
		m_lcList.SetItemText(ipos, icol, cst);
	}
}

BOOL CMProcStartDialog::SetUsers(int iRow,int iCol)
{
	aplExtent		aeTP;
	aplExtent		aeActUsers;

	CaplInstance*	ciProc		=NULL;
	CaplInstance*	ciComp		=NULL;
	CaplInstance*	ciCompAct	=NULL;
	CaplInstance*	ciAct		=NULL;

	CaplInstance*	ciUser		=NULL;

	CString			cst1,cst2;

	BOOL			bShowPerf	=TRUE;
	BOOL			bFound		=FALSE;

	//double			dDur;

	int				i;
	
	UpdateData();
	if(m_iProcSchema!=0) 
		return FALSE;

	ciProc=(CaplInstance*)m_lcList.GetItemData(iRow);
	if(NULL==ciProc)
		return FALSE;
	if(FALSE==m_Col2Act.Lookup(iCol,(void*&)ciAct))
		return FALSE;

	bShowPerf=ShowPerf();

	m_api->m_data.GetAttr(ciProc,m_wf_mgr->a_proc_task_prot,aeTP);

	for(i=0;i<aeTP.GetSize();i++)
	{
		ciComp=aeTP.GetAt(i);
		m_api->m_data.GetAttr(ciComp,m_wf_mgr->a_task_tmpl_activity,ciCompAct);
		if(ciAct==ciCompAct)
		{
			bFound=TRUE;
			break;
		}
	}

	if(TRUE==bShowPerf)
	{
		m_api->m_data.GetAttr(ciAct,m_wf_mgr->a_activity_executors,aeActUsers);
		cst1=APL_T("  ");
		cst2=APL_T("  :");

		if(!aeActUsers.GetSize())
		{
			AfxMessageBox(APL_T("   ."), MB_OK|MB_ICONWARNING);
			return FALSE;
		}
	}
	else
	{
		m_api->m_data.GetAttr(ciAct,m_wf_mgr->a_activity_managers,aeActUsers);
		cst1=APL_T("  ");
		cst2=APL_T("  :");
		
		if(!aeActUsers.GetSize())
		{
			AfxMessageBox(APL_T("   ."), MB_OK|MB_ICONWARNING);
			return FALSE;
		}
	}

	ciUser=m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_PERSON|APL_MODE_SELECT_OFFICIAL,aeActUsers,cst1,cst2);
	if(NULL==ciUser)
		return FALSE;

	//	 task_prototype
	if(FALSE==bFound)
	{
		ciComp=m_api->m_data.CreateInstance(m_wf_mgr->e_task_tmpl);
		m_api->m_data.PutAttr(ciComp,m_wf_mgr->a_task_tmpl_activity,ciAct);

		/*   0,   
		m_api->m_data.GetAttr(ciAct,m_wf_mgr->a_activity_duration, dDur);
		m_api->m_data.PutAttr(ciComp,m_wf_mgr->a_task_tmpl_duration,dDur);*/
		m_api->m_data.GetAttr(ciAct,m_wf_mgr->a_action_id,cst1);
		m_api->m_data.PutAttr(ciComp,m_wf_mgr->a_task_tmpl_id,cst1);
		m_api->m_data.GetAttr(ciAct,m_wf_mgr->a_action_name,cst1);
		m_api->m_data.PutAttr(ciComp,m_wf_mgr->a_task_tmpl_name,cst1);

		aeTP.Add(ciComp);
		m_api->m_data.PutAttr(ciProc,m_wf_mgr->a_proc_task_prot,aeTP);
	}

	if(TRUE==bShowPerf)
		m_api->m_data.PutAttr(ciComp,m_wf_mgr->a_task_tmpl_performer,ciUser);
	else
		m_api->m_data.PutAttr(ciComp,m_wf_mgr->a_task_tmpl_manager,ciUser);

	m_api->m_data.NET_SaveChanges();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMProcStartDialog message handlers

BOOL CMProcStartDialog::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();

//	m_bSavedAutoSave=m_wf_mgr->m_AutoSave;
//	m_wf_mgr->m_AutoSave=false;

	SetAnchors();
	InitControls();

	ChangeCtrlsState();

	InitVars();


	m_bAdd.SetIcon(GetAplStdIco16(APLSTDICO_PLUS));		m_bAdd.SetFlat(FALSE);
	m_bDel.SetIcon(GetAplStdIco16(APLSTDICO_MINUS));	m_bDel.SetFlat(FALSE);

	m_bProps.SetIcon(GetAplTableIco(APL_TABLE_PROP));	m_bProps.SetFlat(FALSE);
	m_OK.SetIcon(GetAplStdIco16(APLSTDICO_OK));			m_OK.SetFlat(FALSE);
	m_Cancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));	m_Cancel.SetFlat(FALSE);

	UpdateData(FALSE);
	
	//     ,   
	if(!BAdd()) OnCancel();
	
	return TRUE;
}

CaplInstance* CMProcStartDialog::BAdd()
{
	CaplInstance*		ciPers	=NULL;

	CaplInstance*		ciProc	=NULL;

	CaplInstance*		cit		=NULL;

	aplExtent			tpExt,woExt;
	bool				bNoteOnly;

	COleDateTimeSpan	dtst;
	COleDateTime		dtStart,dtFinish,dtCheck;
	CString				csStart,csFinish,csCheck;
	CString sProcName;
	CString sBuf, sState;

	//      (  )      
	if(m_ciTask)
	{
		m_api->m_data.GetAttr(m_ciTask, m_wf_mgr->a_task_proc, cit);
		m_api->m_data.GetAttr(cit, m_wf_mgr->a_proc_wo, tpExt);
		
		m_wf_mgr->LoadExtentInfo(tpExt);

		CaplInstance *ciTemp = NULL;
		CaplInstance *ciWO = NULL;
		CaplInstance *ciChange= NULL;

		for(int i=0; i<tpExt.GetSize(); i++)
		{
			ciWO = m_api->m_data.CreateInstance(m_wf_mgr->e_wo);

			if(ciWO)
			{
				m_api->m_data.GetAttr(tpExt[i], m_wf_mgr->a_wo_object, ciTemp);
				/* :     ,  */
				//if(m_api->m_data.IsKindOf(ciTemp, m_api->m_change_mgr.e_chng) && !sDistrCode.CompareNoCase(_T("KVZ")))
				if(m_api->m_data.IsKindOf(ciTemp, m_api->m_change_mgr.e_chng) && m_api->m_options_mgr.CheckInstallCode(_T("KVZ")))
				{
					m_api->m_change_mgr.LoadChangeInfo(ciChange, false);
					m_api->m_data.GetAttr(ciTemp, m_api->m_change_mgr.a_chng_id, sBuf);
					m_api->m_data.GetAttr(ciTemp, m_api->m_change_mgr.a_chng_state, sState);
					if(!sBuf.IsEmpty())
					{
						if(sProcName.IsEmpty())
							sProcName= APL_T(" ")+sBuf;
						else if(sState!=_T("applied"))
							sProcName= APL_T(" ")+sBuf;
					}
				}
				m_api->m_data.PutAttr(ciWO, m_wf_mgr->a_wo_object, ciTemp);

				m_api->m_data.GetAttr(tpExt[i], m_wf_mgr->a_wo_for_note, bNoteOnly);
				m_api->m_data.PutAttr(ciWO, m_wf_mgr->a_wo_for_note, bNoteOnly);

				m_api->m_data.GetAttr(tpExt[i], m_wf_mgr->a_wo_action, ciTemp);
				m_api->m_data.PutAttr(ciWO, m_wf_mgr->a_wo_action, ciTemp);

				woExt.Add(ciWO);
			}
		}		
	}
	
	tpExt.Clear();
	ciPers= m_api->m_appr_mgr.GetCurrentPerson();

	m_api->m_data.NET_GetServerDateTime(dtStart);
	aplDate2String(dtStart,csStart);

	/*dtFinish=dtStart+m_dtsTemplDuration;
	aplDate2String(dtFinish,csFinish);

	dtst=m_dtsTemplDuration;
	dtst.m_span=dtst.m_span*2/3;
	dtCheck=dtStart+dtst;
	aplDate2String(dtCheck,csCheck);*/

	//   10.10.2011:   
	m_api->m_appr_mgr.LoadHolydaysInCash();
	COleDateTime odt_check,odt_finish;
	m_wf_mgr->FillWfDates(dtStart,m_dtsTemplDuration,odt_check,odt_finish);
	aplDate2String(odt_finish,csFinish);
	aplDate2String(odt_check,csCheck);



	ciProc=m_wf_mgr->CreateWfProcess(_T(""),(sProcName.IsEmpty())?m_csTemplName:sProcName,m_csTemplDescr,
									 m_ciTemplate,ciPers,NULL,
									 (LPCTSTR)csStart,(LPCTSTR)csFinish,(LPCTSTR)csCheck,
									 tpExt,woExt);

	m_api->m_data.NET_SaveChanges();

	if(NULL!=ciProc)
	{
		m_aeProcesses.Add(ciProc);
		FillList();
	}
	
	return ciProc;

//	ciProc=m_wf_mgr->CreateWfProcess(_T(""),_T(""),_T(""),m_ciTemplate,ciPers,
//									 0,0,0,
//									 tpExt,woExt);
//	m_api->m_data.NET_SaveChanges();
//	aplExtent aet;
//	m_wf_mgr->GetProcessTasks(ciProc,aet);
//	CaplInstance* cit=aet.GetAt(0);	
}

void CMProcStartDialog::OnDestroy() 
{
	CaplResizableDialog::OnDestroy();

//	m_wf_mgr->m_AutoSave=m_bSavedAutoSave;
}

void CMProcStartDialog::OnOK() 
{
	CaplInstance*	ciProc	=NULL;

	int				i;
	CString sId;

	for(i=0;i<m_aeProcesses.GetSize();i++)
	{
		ciProc=m_aeProcesses.GetAt(i);
		
		m_api->m_data.GetAttr(ciProc, m_wf_mgr->a_action_id, sId);
		if(sId==APL_T("<>"))
		{
			m_wf_mgr->GenerateProcId(ciProc,sId);
			m_api->m_data.PutAttr(ciProc, m_wf_mgr->a_action_id, sId);
		}


		m_wf_mgr->RunWfProcess(ciProc, true, NULL);
	}

	CaplResizableDialog::OnOK();
}

void CMProcStartDialog::OnCancel() 
{
	CaplInstance*	ciProc	=NULL;

	CStringArray	csa;

	int				i;

	for(i=0;i<m_lcList.GetItemCount();i++)
	{
		ciProc=(CaplInstance*)m_lcList.GetItemData(i);
		if(NULL!=ciProc)
			m_wf_mgr->DeleteWfProcess(ciProc,csa,false,true);
		ciProc=NULL;
	}

	m_api->m_data.NET_SaveChanges(APL_T(" ..."));
	
	CaplResizableDialog::OnCancel();
}


void CMProcStartDialog::OnBProps() 
{
	CaplInstance*	ciProc	=NULL;

	POSITION		pos;
	int				ipos;

	pos=m_lcList.GetFirstSelectedItemPosition();
	if(NULL==pos)
		return;
	ipos=m_lcList.GetNextSelectedItem(pos);

	ciProc=(CaplInstance*)m_lcList.GetItemData(ipos);
	if(NULL==ciProc)
		return;
	if(true==m_wf_mgr->ShowProcessProperties(ciProc))
		FillRow(ipos,ciProc,ShowPerf());
	
}

void CMProcStartDialog::OnBAdd() 
{
	BAdd();
}

void CMProcStartDialog::OnBDel() 
{
	CaplInstance*	ciProc	=NULL;
	CaplInstance*	cit		=NULL;

	CStringArray	csa;

	POSITION		pos	=NULL;

	int				i,ipos;

	pos=m_lcList.GetFirstSelectedItemPosition();
	if(NULL==pos)
		return;
	ipos=m_lcList.GetNextSelectedItem(pos);
	ciProc=(CaplInstance*)m_lcList.GetItemData(ipos);
	if(NULL==ciProc)
		return;
	
	for(i=0;i<m_aeProcesses.GetSize();i++)
	{
		cit=m_aeProcesses.GetAt(i);
		if(cit==ciProc)
			m_aeProcesses.Remove(i);
	}

	m_wf_mgr->DeleteWfProcess(ciProc,csa,true,true);
	FillList();
		
}

void CMProcStartDialog::OnItemchangedLcList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	ChangeCtrlsState();
	
	*pResult = 0;
}

void CMProcStartDialog::OnDblclkLcList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	CaplInstance*	ciProc	=NULL;

	if(-1==pNMListView->iItem)
		return;

	if(TRUE==SetUsers(pNMListView->iItem,pNMListView->iSubItem))
	{
		ciProc=(CaplInstance*)m_lcList.GetItemData(pNMListView->iItem);
		if(NULL!=ciProc)
			FillRow(pNMListView->iItem,ciProc,ShowPerf());
	}
	
	*pResult = 0;
}

void CMProcStartDialog::OnSelchangeCbSet() 
{
	FillList();
}

void CMProcStartDialog::OnSelchangePrototypes() 
{
	UpdateData();

	CaplInstance* selected_proc= NULL;
	int index= m_lcList.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
	if(-1!=index)
	{
		selected_proc= (CaplInstance*)m_lcList.GetItemData(index);
	
		CaplInstance* prot_schema= (CaplInstance*)m_cbPrototypes.GetItemData(m_iProcSchema);
		m_api->m_data.PutAttr(selected_proc, m_wf_mgr->a_proc_process_prot, prot_schema);

		FillList();
	}
}
