#if !defined(AFX_PROCESSDLG_H__6BE99525_ABC4_49C9_AB38_69AADF3B98E7__INCLUDED_)
#define AFX_PROCESSDLG_H__6BE99525_ABC4_49C9_AB38_69AADF3B98E7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ProcessDlg.h : header file
//
  
#include "aplNetStepData.h"
#include "resource.h"
#include "apl_gui.h"

//#include "StatusSelectInstanceTreeItem.h"
#include "SelectInstanceView.h"
#include <map>

class CaplWorkFlowManager;
class CaplAPI;
/////////////////////////////////////////////////////////////////////////////
// CProcessDlg dialog

#define APL_WFWO_FORWORK 0
#define APL_WFWO_FORNOTE 1

class CProcessDlg : public CaplResizableDialog
{
// Construction
public:
	CProcessDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CProcessDlg)
	enum { IDD = IDD_PROCESS_DIALOG };
	
	//CSortListCtrl	m_woList;
	CaplTreeListCtrlView *m_woListView;

	CTabCtrl	m_woTabCtrl;
	CaplButton	m_deleteBtn;
	CaplButton	m_mgrSelectBtn;
	CaplButton	m_startBtn;
	CaplButton	m_okBtn;
	CaplButton	m_cancelBtn;
	CaplButton	m_deleteWoBtn;
	CaplButton	m_addWoBtn;
	CaplButton	m_addFileBtn;
	CaplButton	m_editProtScemaBtn;
	CaplButton	m_viewBtn;
	CSliderCtrl	m_percentCtrl;
	CEdit	m_id;
	CEdit	m_name;
	CEdit	m_dscr;
	CaplStatic	m_to;
	CComboBox	m_state;
	CComboBox	m_prior;
	CComboBox	m_subCB;
	CComboBox	m_protCBCtrl;
	CDateTimeCtrl	m_t_start_ctrl;
	CDateTimeCtrl	m_t_check_ctrl;
	CDateTimeCtrl	m_d_start_ctrl;
	CDateTimeCtrl	m_d_finish_ctrl;
	CDateTimeCtrl	m_d_check_ctrl;
	CDateTimeCtrl	m_t_finish_ctrl;
	COleDateTime	m_d_check;
	COleDateTime	m_d_finish;
	COleDateTime	m_d_start;
	COleDateTime	m_t_check;
	COleDateTime	m_t_finish;
	COleDateTime	m_t_start;
	int		m_iPrior;
	int		m_iState;
	int		m_iSub;
	int		m_iPercent;
	int		m_iProtScema;
	CString	m_sId;
	CString	m_sName;
	CString	m_sDscr;
	CString	m_sTmplId;
	CString	m_sPercent;
	CString	m_sPlanDate;
	CString	m_sFactDate;
	CString	m_sManager;
	//}}AFX_DATA
	
	CaplInstance* m_process;
	CaplInstance* m_process_tmpl;

	CaplInstance* m_old_up_level_task;
	CaplInstance* m_up_level_task;
	CaplInstance* m_manager;
	
	CString m_sPriority;
	CString m_sState;
	CString m_sOldState;
	CString m_sTitle;

	CaplInstance* m_proc_prot;
	aplExtent m_aeItemsNotForWork;

	std::map<CaplInstance*,CaplInstance*>::iterator IMap_Iter;
	std::map<CaplInstance*, CaplInstance*> m_MapOfUnCheckedItems;
	
	aplExtent m_prot_items;
	aplExtent m_wo_items;//  
	aplExtent m_new_wo_items;//  
	aplExtent m_new_items_4_notes;//    
	aplExtent m_del_wo_items;
	aplExtent m_procMgrs;
	
	CStringArray m_fileItemsSprav;
	CStringArray m_fileItems;
	
	CaplAPI *m_api;
	CaplWorkFlowManager* m_wf_mgr;
	COleDateTime m_curDate;

	CToolTipCtrl m_toolTip;
	BOOL m_bReadOnly;
	
	long m_lAction;
	aplTIArray m_Array;	// SelectInstItem
	
	BOOL IsValidDates();
	CString GetTypeName(CaplInstance* inst);

	BOOL CheckUncheck(HTREEITEM hItem, BOOL bCheck);
	void CheckUncheckInside(HTREEITEM hItem, BOOL bCheck);

	void ShowWorkObjects(BOOL bWo= APL_WFWO_FORWORK);
	void ProcessWorkObjects();
	void ProcessTaskProts();
	void TreeListInit();
	void AddAllAnchor();
	void FillAdditionalInfoAboutChilds(CSelectInstanceTreeItemEx *pItem);

	HTREEITEM GetSelectedItem();
	CaplInstance* GetParentItemInst(HTREEITEM hItem);
	CaplInstance* GetWOByInstance(CaplInstance *cit);

	virtual bool Expanded(HTREEITEM hItem,UINT action, HWND hWnd);
	virtual bool ItemChange(NM_TREEVIEW* pNMTreeView);
	virtual bool CheckItem();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CProcessDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CProcessDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnSelchangeProcPriority();
	afx_msg void OnSelchangeProcState();
	virtual void OnCancel();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnProcStartButton();
	afx_msg void OnSelchangeSubProcessCombo();
	afx_msg void OnProcSelect();
	afx_msg void OnProcDelete();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnProcEditProt();
	afx_msg void OnProcAddWo();
	afx_msg void OnProcDeleteWo();
	afx_msg void OnSelchangeProcTab(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnProcAddFile();
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnBnClickedProcView();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PROCESSDLG_H__6BE99525_ABC4_49C9_AB38_69AADF3B98E7__INCLUDED_)
