// TaskDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TaskDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "dictionary.h"
#include <apl_api.h>
#include "ListDialog.h"
#include "aplWorkFlowManager.h"
#include <aplguiex.h>
#include "SetDateDlg.h"


/////////////////////////////////////////////////////////////////////////////
// CTaskDlg dialog


CTaskDlg::CTaskDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CTaskDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTaskDlg)
	m_d_check = COleDateTime::GetCurrentTime();
	m_d_finish = COleDateTime::GetCurrentTime();
	m_d_start = COleDateTime::GetCurrentTime();
	m_sDscr = _T("");
	m_sId = _T("");
	m_sName = _T("");
	m_iPrior = -1;
	m_iState = -1;
	m_sActId = _T("");
	m_t_check = COleDateTime::GetCurrentTime();
	m_t_finish = COleDateTime::GetCurrentTime();
	m_t_start = COleDateTime::GetCurrentTime();
	m_sPercent = _T("");
	m_iPercent = 0;
	m_sFactDate = APL_T(" :");
	m_sPlanDate = APL_T(" :");
	m_sManager = _T("");
	m_sPerformer = _T("");
	m_bStartCheck = FALSE;
	m_bCheckCheck = FALSE;
	m_bEndCheck = FALSE;
	//}}AFX_DATA_INIT
	m_wf_mgr= NULL;
	m_curDate = COleDateTime::GetCurrentTime();

	m_api=NULL;
	m_task= NULL;
	m_activity= NULL;
	m_process= NULL;
	m_taskProt= NULL;

	m_sPriority= _T("medium");
	m_sState= _T("inactive");m_sOldState= _T("inactive");
	m_sLastState= _T("");
	m_sTitle= _T("");
	m_bReadOnly= TRUE;
	m_lAction= 0;
	m_lRestart= 0;
	
	m_newManager= NULL;
	m_newPerformer= NULL;
	m_manager= NULL;
	m_performer= NULL;
	m_up_level_task= NULL;
}


void CTaskDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTaskDlg)
	DDX_Control(pDX, IDC_PROC_ADD_FILE, m_addFileBtn);
	DDX_Control(pDX, IDC_TASK_WO_LISTCTRL, m_woList);
	DDX_Control(pDX, IDC_PROC_TAB, m_woTabCtrl);
	DDX_Control(pDX, IDC_PROC_DELETE_WO, m_deleteWoBtn);
	DDX_Control(pDX, IDC_PROC_ADD_WO, m_addWoBtn);
	DDX_Control(pDX, IDC_TASK_END_DATE, m_checkEnd);
	DDX_Control(pDX, IDC_TASK_CHECK_DATE, m_checkCheck);
	DDX_Control(pDX, IDC_TASK_START_DATE, m_startCheck);
	DDX_Control(pDX, IDC_TASK_PERFORMER_DELETE, m_perDeleteBtn);
	DDX_Control(pDX, IDC_TASK_MANAGER_DELETE, m_mgrDeleteBtn);
	DDX_Control(pDX, IDC_TASK_ACCEPT_BUTTON, m_acceptBtn);
	DDX_Control(pDX, IDC_TASK_PER_SLIDER, m_percentCtrl);
	DDX_Control(pDX, IDC_TASK_PERFORMER_RESOURCES, m_perResBtn);
	DDX_Control(pDX, IDC_TASK_MANAGER_RESOURCES, m_mgrResBtn);
	DDX_Control(pDX, IDC_TASK_MANAGER, m_manager_wnd);
	DDX_Control(pDX, IDC_TASK_PERFORMER, m_performer_wnd);
	DDX_Control(pDX, IDC_TASK_T_FINISH, m_t_finish_ctrl);
	DDX_Control(pDX, IDC_TASK_ID, m_id);
	DDX_Control(pDX, IDC_TASK_T_START, m_t_start_ctrl);
	DDX_Control(pDX, IDC_TASK_T_CHECK, m_t_check_ctrl);
	DDX_Control(pDX, IDC_TASK_TIME_OUT, m_to);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDC_TASK_STATE, m_state);
	DDX_Control(pDX, IDC_TASK_PRIORITY, m_prior);
	DDX_Control(pDX, IDC_TASK_NAME, m_name);
	DDX_Control(pDX, IDC_TASK_DSCR, m_dscr);
	DDX_Control(pDX, IDC_TASK_D_START, m_d_start_ctrl);
	DDX_Control(pDX, IDC_TASK_D_FINISH, m_d_finish_ctrl);
	DDX_Control(pDX, IDC_TASK_D_CHECK, m_d_check_ctrl);
	DDX_DateTimeCtrl(pDX, IDC_TASK_D_CHECK, m_d_check);
	DDX_DateTimeCtrl(pDX, IDC_TASK_D_FINISH, m_d_finish);
	DDX_DateTimeCtrl(pDX, IDC_TASK_D_START, m_d_start);
	DDX_Text(pDX, IDC_TASK_DSCR, m_sDscr);
	DDX_Text(pDX, IDC_TASK_ID, m_sId);
	DDX_Text(pDX, IDC_TASK_NAME, m_sName);
	DDX_CBIndex(pDX, IDC_TASK_PRIORITY, m_iPrior);
	DDX_CBIndex(pDX, IDC_TASK_STATE, m_iState);
	DDX_Text(pDX, IDC_ACTIVITY_ID, m_sActId);
	DDX_DateTimeCtrl(pDX, IDC_TASK_T_CHECK, m_t_check);
	DDX_DateTimeCtrl(pDX, IDC_TASK_T_FINISH, m_t_finish);
	DDX_DateTimeCtrl(pDX, IDC_TASK_T_START, m_t_start);
	DDX_Text(pDX, IDC_TASK_PER_STATIC, m_sPercent);
	DDX_Slider(pDX, IDC_TASK_PER_SLIDER, m_iPercent);
	DDX_Text(pDX, IDC_FACT_STATIC, m_sFactDate);
	DDX_Text(pDX, IDC_PLAN_STATIC, m_sPlanDate);
	DDX_Text(pDX, IDC_TASK_MANAGER, m_sManager);
	DDX_Text(pDX, IDC_TASK_PERFORMER, m_sPerformer);
	DDX_Check(pDX, IDC_TASK_START_DATE, m_bStartCheck);
	DDX_Check(pDX, IDC_TASK_CHECK_DATE, m_bCheckCheck);
	DDX_Check(pDX, IDC_TASK_END_DATE, m_bEndCheck);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_TASK_VIEW, m_viewBtn);
	DDX_Control(pDX, IDC_RESET_D_START, m_ResetStartDateBtn);
}

void CTaskDlg::AddAnchors()
{
	AddAnchor(IDOK,BOTTOM_RIGHT);	
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);	

	AddAnchor(IDC_TASK_ACCEPT_BUTTON,BOTTOM_LEFT);	
	AddAnchor(IDC_RESET_D_START,BOTTOM_LEFT);	

	AddAnchor(IDC_PROC_DELETE_WO,TOP_RIGHT);	
	AddAnchor(IDC_TASK_VIEW,TOP_RIGHT);	
	AddAnchor(IDC_PROC_ADD_FILE,TOP_RIGHT);	
	AddAnchor(IDC_PROC_ADD_WO,TOP_RIGHT);	
	
	AddAnchor(IDC_PROC_TAB,TOP_LEFT,BOTTOM_RIGHT);	
	AddAnchor(IDC_TASK_WO_LISTCTRL,TOP_LEFT,BOTTOM_RIGHT);	
	AddAnchor(IDC_STATIC_RAMKA_WO,TOP_LEFT,BOTTOM_RIGHT);	

}


BEGIN_MESSAGE_MAP(CTaskDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CTaskDlg)
	ON_CBN_SELCHANGE(IDC_TASK_PRIORITY, OnSelchangeTaskPriority)
	ON_CBN_SELCHANGE(IDC_TASK_STATE, OnSelchangeTaskState)
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_TASK_ACCEPT_BUTTON, OnTaskAcceptButton)
	ON_BN_CLICKED(IDC_TASK_PERFORMER_RESOURCES, OnTaskPerformerResources)
	ON_BN_CLICKED(IDC_TASK_MANAGER_RESOURCES, OnTaskManagerResources)
	ON_BN_CLICKED(IDC_TASK_MANAGER_DELETE, OnTaskManagerDelete)
	ON_BN_CLICKED(IDC_TASK_PERFORMER_DELETE, OnTaskPerformerDelete)
	ON_BN_CLICKED(IDC_TASK_START_DATE, OnTaskStartDate)
	ON_BN_CLICKED(IDC_TASK_END_DATE, OnTaskEndDate)
	ON_BN_CLICKED(IDC_TASK_CHECK_DATE, OnTaskCheckDate)
	ON_BN_CLICKED(IDC_PROC_ADD_WO, OnProcAddWo)
	ON_BN_CLICKED(IDC_PROC_DELETE_WO, OnProcDeleteWo)
	ON_BN_CLICKED(IDC_PROC_ADD_FILE, OnProcAddFile)
	ON_NOTIFY(TCN_SELCHANGE, IDC_PROC_TAB, OnSelchangeProcTab)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_TASK_VIEW, &CTaskDlg::OnBnClickedTaskView)
	ON_BN_CLICKED(IDC_RESET_D_START, &CTaskDlg::OnBnClickedResetDStart)
	ON_NOTIFY(NM_RCLICK, IDC_TASK_WO_LISTCTRL, &CTaskDlg::OnNMRClickTaskWoListctrl)
END_MESSAGE_MAP()
  
/////////////////////////////////////////////////////////////////////////////
// CTaskDlg message handlers

BOOL CTaskDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	AddAnchors();
	
	m_cancelBtn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancelBtn.SetFlat(FALSE);
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);

	m_mgrResBtn.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_mgrResBtn.SetFlat(FALSE);
	m_mgrResBtn.SetTooltipText(APL_T(" "));
	m_perResBtn.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_perResBtn.SetFlat(FALSE);
	m_perResBtn.SetTooltipText(APL_T(" "));
	m_perDeleteBtn.SetIcon(aplGetButtonIco(APL_24_DELETE));
	m_perDeleteBtn.SetFlat(FALSE);
	m_perDeleteBtn.SetTooltipText(APL_T(""));
	m_mgrDeleteBtn.SetIcon(aplGetButtonIco(APL_24_DELETE));
	m_mgrDeleteBtn.SetFlat(FALSE);
	m_mgrDeleteBtn.SetTooltipText(APL_T(""));

	m_addWoBtn.SetFlat(FALSE);
	m_addWoBtn.SetIcon(aplGetButtonIco(APL_24_PLUS));
	m_addWoBtn.SetTooltipText(APL_T(" "));
	m_deleteWoBtn.SetFlat(FALSE);
	m_deleteWoBtn.SetIcon(aplGetButtonIco(APL_24_DELETE));
	m_deleteWoBtn.SetTooltipText(APL_T(""));
	m_addFileBtn.SetFlat(FALSE);
	m_addFileBtn.SetIcon(aplGetButtonIco(APL_24_OPEN_FILE));
	m_addFileBtn.SetTooltipText(APL_T("   "));
	m_viewBtn.SetFlat(FALSE);
	m_viewBtn.SetIcon(aplGetButtonIco(APL_24_VIEW));
	m_viewBtn.SetTooltipText(APL_T(" /  "));

	m_t_start_ctrl.SetFormat(_T("HH:mm"));
	m_t_check_ctrl.SetFormat(_T("HH:mm"));
	m_t_finish_ctrl.SetFormat(_T("HH:mm"));

	TCITEM tcItem;
	tcItem.mask= TCIF_PARAM;
		
	m_woTabCtrl.InsertItem(APL_WFWO_FORWORK, APL_T(""), -1);
	tcItem.lParam= (LPARAM)APL_WFWO_FORWORK;
	m_woTabCtrl.SetItem(APL_WFWO_FORWORK, &tcItem);
	m_woTabCtrl.InsertItem(APL_WFWO_FORNOTE, APL_T(" "), -1);	
	tcItem.lParam= (LPARAM)APL_WFWO_FORNOTE;
	m_woTabCtrl.SetItem(APL_WFWO_FORNOTE, &tcItem);

	m_woList.InsertColumn(0, APL_T(""), LVCFMT_LEFT, 250);
	m_woList.InsertColumn(1, APL_T(""), LVCFMT_LEFT, 100);
	m_woList.SetImageList(aplGetInstImageList(), LVSIL_SMALL);

	if(m_api && apidata.IsConnected())
	{
/*		CaplDateManager dateMgr;
		dateMgr.Attach(m_data);*/
		
		m_api->m_data.NET_GetServerDateTime(m_curDate);
		m_api->m_data.NET_GetServerDateTime(m_d_check);
		m_api->m_data.NET_GetServerDateTime(m_d_finish);
		m_api->m_data.NET_GetServerDateTime(m_d_start);
		m_api->m_data.NET_GetServerDateTime(m_t_check);
		m_api->m_data.NET_GetServerDateTime(m_t_finish);
		m_api->m_data.NET_GetServerDateTime(m_t_start);
		
		COleDateTimeSpan odts;
		COleDateTime odt;
		apidata.NET_GetServerDateTime(odt);

		CaplInstance* inst= NULL, *inst1= NULL;
		CaplInstance* owner= NULL, *procMgr= NULL;
		CaplInstance* process_prot= NULL;
		CString buf, buf1;
		CaplAggr aggr, aggr0, roleAggr;
		aplExtent ext0, taskProts;

		m_percentCtrl.SetRange(0, 100);
		m_percentCtrl.SetTic(0);
		m_percentCtrl.SetTic(50);
		m_percentCtrl.SetTic(100);
		m_percentCtrl.SetPageSize(5);
		m_percentCtrl.SetLineSize(1);

		if(m_task)
		{
			m_wf_mgr->LoadTaskInfo(m_task);

			apidata.GetAttr(m_task, m_wf_mgr->a_task_activity, m_activity);
			apidata.GetAttr(m_task, m_wf_mgr->a_task_proc, m_process);
			apidata.GetAttr(m_task, m_wf_mgr->a_task_manager, m_manager);m_newManager= m_manager;
			apidata.GetAttr(m_task, m_wf_mgr->a_task_performer, m_performer);m_newPerformer= m_performer;

			//   
			aplExtent taskProts;
			m_api->m_data.GetAttr(m_process, m_wf_mgr->a_proc_process_prot, process_prot);
			if(process_prot)
				m_wf_mgr->GetProcessPrototypeItems(process_prot, taskProts);
			else
				m_api->m_data.GetAttr(m_process, m_wf_mgr->a_proc_task_prot, taskProts);		

			for(int i= 0; i<taskProts.GetSize(); i++)
			{
				m_api->m_data.GetAttr(taskProts[i], m_wf_mgr->a_task_tmpl_activity, inst);
				if(inst==m_activity)
				{
					m_taskProt= taskProts[i];
					break;
				}
			}

			if(m_activity)
			{
				apidata.GetAttr(m_activity, m_wf_mgr->a_action_id, m_sActId);
				apidata.GetAttr(m_activity, m_wf_mgr->a_action_name, buf);
				m_sActId+=_T(" : "); m_sActId+=buf;

				apidata.GetAttr(m_activity, m_wf_mgr->a_activity_executors, m_taskPer);	
				apidata.GetAttr(m_activity, m_wf_mgr->a_activity_managers, m_taskMgr);
				
				if(m_performer==NULL) m_sPerformer= APL_T("<  >");
				else m_api->m_appr_mgr.GetPersonName(m_performer, m_sPerformer);					
				
				if(m_manager==NULL) m_sManager= APL_T("<  >");
				else m_api->m_appr_mgr.GetPersonName(m_manager, m_sManager);					
				/////////////////////////////////////////////////////////////
				
				bool bAddWO= false;
				apidata.GetAttr(m_activity, m_wf_mgr->a_activity_add_wo, bAddWO);
				if(bAddWO)
				{
					CaplAttrValue val[3];
					aplExtent ext;

					val[0].value.Set(m_process);
					val[0].attr= m_wf_mgr->a_task_sub_proc;
					apidata.NET_FindInstancesWithAttrValues(m_wf_mgr->e_task, 1, &val[0], ext, false);

					if(ext.GetSize()>0)
					{
						m_up_level_task= ext[0];
					}
				}
			}
			
			apidata.GetAttr(m_task, m_wf_mgr->a_action_id, m_sId);
			apidata.GetAttr(m_task, m_wf_mgr->a_action_name, m_sName);
			apidata.GetAttr(m_task, m_wf_mgr->a_action_dscr, m_sDscr);

			apidata.GetAttr(m_task, m_wf_mgr->a_task_state, m_sOldState);m_sState= m_sOldState;
			apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_prior, m_sPriority);
//			inst= NULL;
			buf= _T("");
			apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_start_date, buf);
			
			if(!buf.IsEmpty()){aplString2Date(buf, m_d_start); m_t_start= m_d_start;
				m_d_start_ctrl.EnableWindow(TRUE);m_t_start_ctrl.EnableWindow(TRUE); m_bStartCheck= TRUE;
			}
			else {m_d_start_ctrl.EnableWindow(FALSE);m_t_start_ctrl.EnableWindow(FALSE); m_bStartCheck= FALSE;}
			
			if(m_sOldState==_T("complete") || m_sState==_T("cancel"))
			{
				m_sFactDate = APL_T(" :");
				m_sPlanDate = APL_T(" :");

				apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_finish_date, buf);
				if(!buf.IsEmpty()){aplString2Date(buf, m_d_finish); m_t_finish= m_d_finish;
					m_d_finish_ctrl.EnableWindow(TRUE);m_t_finish_ctrl.EnableWindow(TRUE); m_bEndCheck= TRUE;					
				}
				else{m_d_finish_ctrl.EnableWindow(FALSE);m_t_finish_ctrl.EnableWindow(FALSE); m_bEndCheck= FALSE;}	

				apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_end_date, buf);
				if(!buf.IsEmpty()){aplString2Date(buf, m_d_check); m_t_check= m_d_check;
					m_d_check_ctrl.EnableWindow(TRUE);m_t_check_ctrl.EnableWindow(TRUE); m_bCheckCheck= TRUE;				
				}	
				else {m_d_check_ctrl.EnableWindow(FALSE);m_t_check_ctrl.EnableWindow(FALSE); m_bCheckCheck= FALSE;}	
			}
			else
			{
				apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_check_date, buf);
				if(!buf.IsEmpty()){aplString2Date(buf, m_d_check); m_t_check= m_d_check;
					m_d_check_ctrl.EnableWindow(TRUE);m_t_check_ctrl.EnableWindow(TRUE); m_bCheckCheck= TRUE;				
				}	
				else {
					m_d_check_ctrl.EnableWindow(FALSE);m_t_check_ctrl.EnableWindow(FALSE); m_bCheckCheck= FALSE;}	
				
				apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_finish_date, buf);
				if(!buf.IsEmpty()){aplString2Date(buf, m_d_finish); m_t_finish= m_d_finish;
					m_d_finish_ctrl.EnableWindow(TRUE);m_t_finish_ctrl.EnableWindow(TRUE); m_bEndCheck= TRUE;					
				}
				else{m_d_finish_ctrl.EnableWindow(FALSE);m_t_finish_ctrl.EnableWindow(FALSE); m_bEndCheck= FALSE;}

			}
			
			double dbl;
			apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_percent, dbl);
			m_iPercent= (int)dbl;

			CaplInstance* process;
			apidata.GetAttr(m_task, m_wf_mgr->a_task_proc, process);
			aggr.Clear();

			if(process)
			{
				m_wf_mgr->LoadProcessInfo(process);

				m_wo_items.Clear();
				apidata.GetAttr(process, m_wf_mgr->a_proc_wo, m_wo_items);
				ShowWorkObjects();
				
				apidata.GetAttr(process, m_wf_mgr->a_proc_owner, owner);
				apidata.GetAttr(process, m_wf_mgr->a_proc_manager, procMgr);
				
				if(procMgr && m_api->m_data.IsKindOf(procMgr, m_api->m_appr_mgr.e_official))
					m_api->m_data.GetAttr(procMgr, m_api->m_appr_mgr.a_official_act_person, procMgr);
			}
		}
		
		CaplInstance *user= m_api->m_appr_mgr.GetCurrentPerson();
		m_api->m_appr_mgr.GetPersonOfficials(user, m_personOfficials);

		if(m_sPriority==_T("low")) buf= APL_T("");
		else if(m_sPriority==_T("medium")) buf= APL_T("");
		else if(m_sPriority==_T("hight")) buf= APL_T("");
 		
		int iVal;
		m_api->m_options_mgr.GetOptionValueBN(APL_NO_T(" Workflow\\  (  )    "), iVal, 0);
		if(0!=iVal)
		{
			if(m_sPriority==_T("low"))buf= APL_T("");
			m_prior.DeleteString(2);
		}
		
		m_iPrior= m_prior.FindString(-1, buf);
		buf= _T("");

/*!*/	m_state.ResetContent();

		if(m_sOldState==_T("inactive"))
		{
			m_sLastState= APL_T("");
			m_sState= _T("active");
//			m_sLastState= APL_T(" ");
			m_state.InsertString(0, APL_T(" "));
			m_state.InsertString(1, APL_T(""));
		}
		else if(m_sOldState==_T("active") || m_sOldState==_T("notify")) 
		{
			m_sLastState= APL_T("");
			m_state.InsertString(0, APL_T(""));
			if(user==m_performer || -1!=m_personOfficials.Find(m_performer))
			{
				m_state.InsertString(1, APL_T(""));
//				if(IDNO==MessageBox(APL_T("  ?"), 
//					APL_T("  "), MB_YESNO|MB_ICONWARNING))
//				{
//					m_acceptBtn.ModifyStyle(0, WS_VISIBLE, 0);
//				}
// 				else
				{					
// 					aplExtent extWO;
// 					if(FALSE==m_wf_mgr->RunProgrammModule(m_task, extWO))
// 					{
// 						AfxMessageBox(APL_T("     ."), MB_ICONERROR|MB_OK);
// 						return FALSE; 
// 					}

					m_sLastState= APL_T("");
					m_sOldState= _T("work");
					m_sState= _T("work");
					m_wf_mgr->SetTaskWorking(m_task);

					m_state.DeleteString(0);
					m_state.InsertString(1,  APL_T(""));
				}
			}
			if(user==owner || user==procMgr || -1!=m_personOfficials.Find(owner)|| -1!=m_personOfficials.Find(procMgr))
				m_state.InsertString(1, APL_T(""));
			if(user==m_manager || -1!=m_personOfficials.Find(m_manager))
			{
				if(m_performer==NULL)
				AfxMessageBox(APL_T("    !\n\n  ."), 
					MB_OK|MB_ICONWARNING);
				else
				AfxMessageBox(APL_T("    !\n\n  ."), 
					MB_OK|MB_ICONWARNING);
			}
		}
		else if(m_sOldState==_T("work"))
		{
			m_sLastState= APL_T("");
			m_state.InsertString(0,  APL_T(""));	
			if(user==owner || user==procMgr || -1!=m_personOfficials.Find(owner)|| -1!=m_personOfficials.Find(procMgr))
			{
				m_state.InsertString(1, APL_T(""));
//				m_state.InsertString(2, APL_T(""));
			}
			if(user==m_performer || -1!=m_personOfficials.Find(m_performer))
				m_state.InsertString(1, APL_T(""));
		}
		else if(m_sOldState==_T("suspend")) 
		{
			m_sLastState= APL_T("");
			m_state.InsertString(0, APL_T(""));
			if(user==owner)
			{
				m_state.InsertString(0, APL_T(""));
//				m_state.InsertString(0, APL_T(""));
//				m_state.InsertString(2, APL_T(""));
			}
		}
		else if(m_sOldState==_T("cancel"))
		{
			m_sLastState= APL_T("");
			m_state.InsertString(0,  APL_T(""));
		}
		else if(m_sOldState==_T("complete")) 
		{
			m_sLastState= APL_T("");
			m_state.InsertString(0,   APL_T(""));		
		}
		m_iState= m_state.FindString(-1, m_sLastState);
		
		m_sPercent.Format(_T("%i"), m_iPercent);
		m_sPercent+=_T("%");
		m_percentCtrl.SetSelection(0, m_iPercent);
		
		if(m_sState!=_T("inactive")){m_d_start_ctrl.EnableWindow(FALSE);m_t_start_ctrl.EnableWindow(FALSE);m_startCheck.EnableWindow(FALSE);}
		else{m_percentCtrl.EnableWindow(FALSE);m_bReadOnly= FALSE;}
//		if(m_process==NULL) m_state.EnableWindow(FALSE);

		m_api->m_data.NET_GetServerDateTime(odt);
		if(m_task)
		{
			apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_end_date, buf);
			if(!buf.IsEmpty())
				aplString2Date(buf, odt);
		}
		if(m_bEndCheck && m_d_finish<odt)
		{
			m_to.ModifyStyle(0, WS_VISIBLE, 0);
			COLORREF crTextColor= RGB(255, 0, 0);
			m_to.SetTextColor(crTextColor);
			m_to.SetText(APL_T(" !"));
		}
		
		// 
		if(m_task /*&& m_task->GetAccessmode()>aplRW*/)
		{
			m_id.SetReadOnly();
			m_name.SetReadOnly();
			m_dscr.SetReadOnly();

			m_prior.EnableWindow(FALSE);
			m_state.EnableWindow(FALSE);
			
			m_d_start_ctrl.EnableWindow(FALSE);
			m_t_start_ctrl.EnableWindow(FALSE);
			m_d_check_ctrl.EnableWindow(FALSE);
			m_t_check_ctrl.EnableWindow(FALSE);
			m_d_finish_ctrl.EnableWindow(FALSE);
			m_t_finish_ctrl.EnableWindow(FALSE);
			m_percentCtrl.EnableWindow(FALSE);
			
			m_startCheck.EnableWindow(FALSE);
			m_checkCheck.EnableWindow(FALSE);
			m_checkEnd.EnableWindow(FALSE);

//			m_performer_wnd.SetReadOnly(TRUE);
//			m_manager_wnd.SetReadOnly(TRUE);
			
			m_okBtn.EnableWindow(FALSE);
			m_mgrResBtn.EnableWindow(FALSE);
			m_perResBtn.EnableWindow(FALSE);
			m_mgrDeleteBtn.EnableWindow(FALSE);
			m_perDeleteBtn.EnableWindow(FALSE);
			m_addWoBtn.EnableWindow(FALSE);
			m_deleteWoBtn.EnableWindow(FALSE);
			m_addFileBtn.EnableWindow(FALSE);
			
			if(user==owner || user==procMgr || -1!=m_personOfficials.Find(owner) || -1!=m_personOfficials.Find(procMgr))
			{
				m_id.SetReadOnly(FALSE);
				m_name.SetReadOnly(FALSE);
				m_dscr.SetReadOnly(FALSE);

				if(m_sOldState==_T("inactive"))
				{
					m_startCheck.EnableWindow();
				}

				if(m_d_start.GetStatus()==COleDateTime::valid && m_curDate<=m_d_start)//       
				{
					m_d_start_ctrl.EnableWindow(m_bStartCheck);
					m_t_start_ctrl.EnableWindow(m_bStartCheck);
				}

				m_checkCheck.EnableWindow();
				m_d_check_ctrl.EnableWindow(m_bCheckCheck);
				m_t_check_ctrl.EnableWindow(m_bCheckCheck);
				
				m_checkEnd.EnableWindow();
				m_d_finish_ctrl.EnableWindow(m_bEndCheck);
				m_t_finish_ctrl.EnableWindow(m_bEndCheck);
				
				m_prior.EnableWindow();
				m_state.EnableWindow();

				if(m_taskMgr.GetSize())
					m_mgrResBtn.EnableWindow();
				m_perResBtn.EnableWindow();

				if(m_performer) m_perDeleteBtn.EnableWindow();					
				if(m_manager) m_mgrDeleteBtn.EnableWindow();
				
				m_addWoBtn.EnableWindow();
				m_deleteWoBtn.EnableWindow();
				m_addFileBtn.EnableWindow();
			}
			
			if(user==m_performer || -1!=m_personOfficials.Find(m_performer))
			{
				if(m_sOldState==_T("work") || m_sOldState==_T("active") || m_sOldState==_T("notify"))
					m_state.EnableWindow();
				
				if(m_sOldState==_T("work"))
				{
					m_state.EnableWindow();
					m_percentCtrl.EnableWindow();
					m_okBtn.EnableWindow();
					m_addWoBtn.EnableWindow();
					m_deleteWoBtn.EnableWindow();
					m_addFileBtn.EnableWindow();
					
					m_bReadOnly= FALSE;
				}
				else
				{
					m_bReadOnly= TRUE;
				}
			}

			if(user==owner || user==m_manager || user==procMgr  || -1!=m_personOfficials.Find(m_manager) || -1!=m_personOfficials.Find(owner))
			{
				if(m_taskMgr.GetSize())
					m_mgrResBtn.EnableWindow();
				if(-1!=m_personOfficials.Find(m_manager) && m_performer)
					m_perDeleteBtn.EnableWindow();
				m_perResBtn.EnableWindow();
				m_prior.EnableWindow();
				m_okBtn.EnableWindow();
			}

			if(m_api->m_appr_mgr.CheckPersonRoleByOption(0,APL_NO_T(" Workflow\\     "),false))
			{
				m_ResetStartDateBtn.ShowWindow(SW_SHOW);
				if( user==m_manager && !(m_sOldState==_T("complete")  || m_sOldState==_T("cancel") || m_sOldState==_T("suspend")) )
					m_ResetStartDateBtn.EnableWindow(TRUE);
			}

			
/*			if((user==owner || user==mgr) && user!=per)
			{
				m_okBtn.EnableWindow();
				m_bReadOnly= FALSE;
			}*/
		}

		if(m_sOldState==_T("complete") || m_sState==_T("cancel") || m_sState==_T("wait"))
		{
			m_id.SetReadOnly();
			m_name.SetReadOnly();
			m_dscr.SetReadOnly();

			m_d_check_ctrl.EnableWindow(FALSE);
			m_t_check_ctrl.EnableWindow(FALSE);
			m_d_finish_ctrl.EnableWindow(FALSE);
			m_t_finish_ctrl.EnableWindow(FALSE);
			m_percentCtrl.EnableWindow(FALSE);
			
			m_checkCheck.EnableWindow(FALSE);
			m_checkEnd.EnableWindow(FALSE);

//			m_performer_wnd.SetReadOnly(TRUE);
//			m_manager_wnd.SetReadOnly(TRUE);
			m_mgrResBtn.EnableWindow(FALSE);
			m_perResBtn.EnableWindow(FALSE);
			m_mgrDeleteBtn.EnableWindow(FALSE);
			m_perDeleteBtn.EnableWindow(FALSE);
			m_addWoBtn.EnableWindow(FALSE);
			m_deleteWoBtn.EnableWindow(FALSE);
			m_addFileBtn.EnableWindow(FALSE);

			m_bReadOnly= TRUE;

			m_prior.EnableWindow(FALSE);
			m_okBtn.EnableWindow(FALSE);
			m_state.EnableWindow(FALSE);
		}
		
		SetWindowText(m_sTitle);
	}

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTaskDlg::OnOK() 
{
	UpdateData();
	
	if(!IsValidDates())
	{
//		CString buf;
//
//		apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_start_date, buf);
//		if(!buf.IsEmpty()){aplString2Date(buf, m_d_start); m_t_start= m_d_start;}
//		apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_finish_date, buf);
//		if(!buf.IsEmpty()){aplString2Date(buf, m_d_finish); m_t_finish= m_d_finish;}
//
//		UpdateData(FALSE);

		return;
	}
	
	if(m_api && apidata.IsConnected())
	{
		if(m_task && m_task->GetType())
		{

			if(m_sOldState!=_T("complete") && m_sOldState!=_T("cancel"))
			{
				CaplInstance* inst= NULL;
				CaplInstance *user= m_api->m_appr_mgr.GetCurrentPerson();

				if(m_sState!=_T("inactive") && m_sState!=_T("cancel") && !m_newManager && !m_newPerformer)
				{
					AfxMessageBox(APL_T("  !"), MB_OK|MB_ICONERROR);
					return;
				}

				apidata.PutAttr(m_task, m_wf_mgr->a_action_id, m_sId);
				apidata.PutAttr(m_task, m_wf_mgr->a_action_name, m_sName);
				apidata.PutAttr(m_task, m_wf_mgr->a_action_dscr, m_sDscr);

				ProcessWorkObjects();
				apidata.PutAttr(m_process, m_wf_mgr->a_proc_wo, m_wo_items);

				COleDateTime odt;
				inst= NULL;
				CString buf, buf1;
				apidata.GetAttr(m_task, m_wf_mgr->a_task_state, buf);
//				if(buf==_T("inactive"))
				{
					apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_start_date, buf);
					odt.SetDateTime(m_d_start.GetYear(), m_d_start.GetMonth(), m_d_start.GetDay(),
						m_t_start.GetHour(), m_t_start.GetMinute(), 0);
					
					if(m_bStartCheck)	aplDate2String(odt, buf1);
					else buf1= _T("");

					if(buf!=buf1) apidata.PutAttr(m_task, m_wf_mgr->a_act_inst_start_date, buf1);
				}
				
				apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_check_date, buf);
				odt.SetDateTime(m_d_check.GetYear(), m_d_check.GetMonth(), m_d_check.GetDay(),
					m_t_check.GetHour(), m_t_check.GetMinute(), 0);
				
				if(m_bCheckCheck)	aplDate2String(odt, buf1);
				else buf1= _T("");

				if(buf!=buf1)apidata.PutAttr(m_task, m_wf_mgr->a_act_inst_check_date, buf1);

				apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_finish_date, buf);
				odt.SetDateTime(m_d_finish.GetYear(), m_d_finish.GetMonth(), m_d_finish.GetDay(),
					m_t_finish.GetHour(), m_t_finish.GetMinute(), 0);
				
				if(m_bEndCheck) aplDate2String(odt, buf1);
				else buf1= _T("");
				
				if(buf!=buf1)
				{
					apidata.PutAttr(m_task, m_wf_mgr->a_act_inst_finish_date, buf1);
				
					CaplInstance *process_template;
					apidata.GetAttr(m_process, m_wf_mgr->a_proc_of_tmpl, process_template);
					if(0!=process_template)
					{
						bool b_set_enddate_by_task;
						apidata.GetAttr(process_template, m_wf_mgr->a_proc_tmpl_set_enddate_by_task, b_set_enddate_by_task);
						if(b_set_enddate_by_task)
						{
							apidata.PutAttr(m_process, m_wf_mgr->a_act_inst_finish_date, buf1);

							CString buf2;
							apidata.GetAttr(m_task, m_wf_mgr->a_act_inst_check_date, buf2);
							if(buf2==_T("") && buf1!=_T("")) 
							{
								COleDateTime odt; aplString2Date(buf1,odt);
								COleDateTimeSpan odts(0,1,0,0);
								odt-=odts;
								aplDate2String(odt,buf2);
							}
							apidata.PutAttr(m_process, m_wf_mgr->a_act_inst_check_date, buf2);
						}

					}
				}

				apidata.PutAttr(m_task, m_wf_mgr->a_act_inst_prior, m_sPriority);
				double dbl= m_iPercent;
				apidata.PutAttr(m_task, m_wf_mgr->a_act_inst_percent, dbl);
				
				apidata.GetAttr(m_task, m_wf_mgr->a_task_state, buf);
				
				m_state.GetLBText(m_iState, m_sState);
				if(m_sState==APL_T(" "))
					m_sState= _T("inactive");
				else if(m_sState==APL_T(""))
					m_sState= _T("active");
				else if(m_sState==APL_T("")) 
					m_sState= _T("work");
				else if(m_sState==APL_T("")) 
					m_sState= _T("suspend");
				else if(m_sState==APL_T("")) 
					m_sState= _T("cancel");
				else if(m_sState==APL_T("")) 
					m_sState= _T("complete");
				
				if(m_sOldState!=m_sState)// 
				{
					if(m_sState==_T("work"))
						m_lAction= APL_WF_EVENT_ACCEPT;
					if(m_sState==_T("active") && m_sOldState!=_T("notify"))
						m_lAction= APL_WF_EVENT_RUN;
					if(m_sState==_T("suspend"))
						m_lAction= APL_WF_EVENT_SUSPEND;
					if(m_sState==_T("complete"))
						m_lAction= APL_WF_EVENT_COMPLETE;	

					//   
					if(m_sState==_T("active") ) apidata.PutAttr(m_process, m_wf_mgr->a_proc_state, _T("running"));

				}
				if(m_sState!=_T("inactive"))
				{
					if(m_newManager!=m_manager )
					{
						if(m_manager)// 
						{
							m_lRestart= m_lRestart|APL_WF_EVENT_MGR_CHANGE;
						}
						else// 
						{
							apidata.PutAttr(m_task, m_wf_mgr->a_task_manager, m_newManager);
						}
					}
					
					if(m_newPerformer!=m_performer)
					{
						if(m_performer)// 
						{
							m_lRestart= m_lRestart|APL_WF_EVENT_PER_CHANGE;
						}
						else// 
						{
							apidata.PutAttr(m_task, m_wf_mgr->a_task_performer, m_newPerformer);
		//					apidata.PutAttr(m_task, m_wf_mgr->a_task_state, _T("active"));				
						}
					}

					if(m_lRestart && IDNO==AfxMessageBox(APL_T("      .\n\n ?"), MB_ICONQUESTION|MB_YESNO))				
						m_lRestart= 0;
				}
				else
				{
					apidata.PutAttr(m_task, m_wf_mgr->a_task_manager, m_newManager);
					apidata.PutAttr(m_task, m_wf_mgr->a_task_performer, m_newPerformer);
				}
				apidata.NET_SaveChanges();
			}
		}//task && task->type
		else
		{
			if(!m_task->GetType())// ,     
			{
				bool bSave= false;
				for(int i= 0; i<m_wo_items.GetSize(); i++)
				{
					if(m_wo_items[i] && m_wo_items[i]->GetType())
					{
						apidata.DeleteInstance(m_wo_items[i]);
						bSave= true;
					}
				}
				if(bSave)
					apidata.NET_SaveChanges();
			}
		}
	}//IsConnected()

	CaplResizableDialog::OnOK();
}

void CTaskDlg::OnCancel() 
{
	bool bSave= false, bDelete= false;
	CaplInstance* process= NULL, *inst;
	aplExtent ext;

	apidata.GetAttr(m_task, m_wf_mgr->a_task_proc, process);
	if(process) apidata.GetAttr(process, m_wf_mgr->a_proc_wo, ext);
	
	for(int i= 0; i<m_wo_items.GetSize(); i++)
	{
		bDelete= true;
		for(int j= 0; j<ext.GetSize(); j++)
		{
			if(ext[j]==m_wo_items[i])
			{
				bDelete= false;
				break;
			}
		}

		if(bDelete)
		{
			m_api->m_data.GetAttr(m_wo_items[i], m_wf_mgr->a_wo_object, inst);

			if(m_api->m_data.IsKindOf(inst, m_api->m_doc_mgr.e_apl_stored_document))
				m_api->m_data.NET_DeleteBlob(inst, m_api->m_doc_mgr.a_apl_stored_document_source);

			m_api->m_data.DeleteInstance(m_wo_items[i]);
		}
	}
	if(bSave)
		apidata.NET_SaveChanges();
		
	CaplResizableDialog::OnCancel();
}

void CTaskDlg::OnSelchangeTaskPriority() 
{
	UpdateData();
	switch(m_iPrior){
		case 0: m_sPriority= _T("hight");
			break;
		case 1: m_sPriority= _T("medium");
			break;
		case 2: m_sPriority= _T("low");
			break;
	}
}

void CTaskDlg::OnSelchangeTaskState() 
{
	UpdateData();
	CString buf;m_state.GetLBText(m_iState, m_sLastState);
		
	if(m_sLastState==APL_T(" "))
		m_sState= _T("inactive");
	else if(m_sLastState==APL_T(""))
		m_sState= _T("active");
	else if(m_sLastState==APL_T("")) 
		m_sState= _T("work");
	else if(m_sLastState==APL_T("")) 
		m_sState= _T("suspend");
	else if(m_sLastState==APL_T("")) 
		m_sState= _T("cancel");
	else if(m_sLastState==APL_T("")) 
		m_sState= _T("complete");
	
	/////////////////////////////////////////////
/*	if(m_sState==_T("work") && m_sOldState==_T("active"))
		m_acceptBtn.ModifyStyle(0, WS_VISIBLE, 0);
	else
		m_acceptBtn.ModifyStyle(WS_VISIBLE, 0, 0);
	
	//    ,  ...
	RedrawWindow();*/
}

void CTaskDlg::OnTaskAcceptButton() 
{
	if(m_task)
	{
		m_wf_mgr->SetTaskWorking(m_task);

		m_percentCtrl.EnableWindow();
		m_state.EnableWindow();
		
		m_okBtn.EnableWindow();
		
		m_state.DeleteString(m_state.FindString(-1, APL_T("")));
		m_state.InsertString(1, APL_T(""));
		
		m_iState= m_state.FindString(-1, APL_T(""));
		m_sState= _T("work");

		m_bReadOnly= FALSE;

		m_acceptBtn.ModifyStyle(WS_VISIBLE, 0, 0);
		RedrawWindow();

		UpdateData(FALSE);
	}
}

void CTaskDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	UpdateData();
	
	m_percentCtrl.SetSelection(0, m_iPercent);
	m_percentCtrl.RedrawWindow();
	m_sPercent.Format(_T("%i"), m_iPercent);
	m_sPercent+=_T("%");
	
	if(m_iPercent==100)	m_iState= m_state.SelectString(-1, APL_T(""));
	else m_iState= m_state.SelectString(-1, m_sLastState);

	UpdateData(FALSE);
	
	CaplResizableDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}


BOOL CTaskDlg::IsValidDates()
{	
	COleDateTime odt_s= COleDateTime::GetCurrentTime(), 
		odt_s1= COleDateTime::GetCurrentTime(),
		odt_f= COleDateTime::GetCurrentTime(), 
		odt_ch= COleDateTime::GetCurrentTime();
	
	odt_s.SetDateTime(m_d_start.GetYear(), m_d_start.GetMonth(), m_d_start.GetDay(),
		m_t_start.GetHour(), m_t_start.GetMinute(), m_t_start.GetSecond());
	
	odt_s1.SetDateTime(m_d_start.GetYear(), m_d_start.GetMonth(), m_d_start.GetDay(),
		m_t_start.GetHour(), m_t_start.GetMinute(), 0);

	odt_f.SetDateTime(m_d_finish.GetYear(), m_d_finish.GetMonth(), m_d_finish.GetDay(),
		m_t_finish.GetHour(), m_t_finish.GetMinute(), 0);

	odt_ch.SetDateTime(m_d_check.GetYear(), m_d_check.GetMonth(), m_d_check.GetDay(),
		m_t_check.GetHour(), m_t_check.GetMinute(), 0);

	m_curDate.SetDateTime(m_curDate.GetYear(), m_curDate.GetMonth(), m_curDate.GetDay(),
		m_curDate.GetHour(), m_curDate.GetMinute(), 0);
	
	CString sStartDate, sCurStartDate, sCurDate;
	BOOL bStartCheck, bCheckCheck, bEndCheck;
	
	bStartCheck= (m_bStartCheck && ::IsWindowEnabled(m_d_start_ctrl.m_hWnd));
	bCheckCheck= (m_bCheckCheck && ::IsWindowEnabled(m_d_check_ctrl.m_hWnd));
	bEndCheck= (m_bEndCheck && ::IsWindowEnabled(m_d_finish_ctrl.m_hWnd));

	if((odt_s<m_curDate && bStartCheck))
	{
		AfxMessageBox(APL_T("    ."), MB_OK|MB_ICONERROR);
		return FALSE;		
	}

	if((odt_s>=odt_ch) && (bStartCheck && bCheckCheck))
	{
		AfxMessageBox(APL_T("      ."), MB_OK|MB_ICONERROR);
		return FALSE;				
	}

	if((odt_s>=odt_f) && (bStartCheck && bEndCheck))
	{
		AfxMessageBox(APL_T("      ."), MB_OK|MB_ICONERROR);
		return FALSE;
	}
//	else if(odt_s==odt_f)
//	{
//		//   , -  ...
//	}// ...
	if(!(odt_ch>odt_s && odt_ch<odt_f) && (bStartCheck && bCheckCheck && bEndCheck))
	{
//		if(IDNO==MessageBox(APL_T("      .\n")
//			APL_T(" ?"), APL_T(""), MB_YESNO|MB_ICONWARNING))
		AfxMessageBox(APL_T("      ."), 
			MB_OK|MB_ICONERROR);
			return FALSE;
	}

	//   ()  	
/*	if(m_task)
	{
		COleDateTimeSpan odts_t, odts_n;

		double dur= -1;

		CaplInstance* proc= NULL, *activity= NULL, *prot, *inst;
		apidata.GetAttr(m_task, m_wf_mgr->a_task_proc, proc);
		apidata.GetAttr(m_task, m_wf_mgr->a_task_activity, activity);
		if(proc)
		{
			m_wf_mgr->LoadProcessInfo(proc);
			CaplAggr aggr;
			apidata.GetAttr(proc, m_wf_mgr->a_proc_task_prot, aggr);
			for(int i= 0; i<aggr.GetSize(); i++)
			{
				prot= NULL;
				aggr.GetByIndex(i, prot);
				if(prot)
				{
					apidata.GetAttr(prot, m_wf_mgr->a_task_tmpl_activity, inst);
					if(inst)
					{
						
					}
				}
			}
		}
	}
*/
	return TRUE;
}

void CTaskDlg::OnTaskPerformerResources() 
{
	UpdateData();
	
	aplExtent performers, ext;

	if(m_manager==m_api->m_appr_mgr.GetCurrentPerson())
	{
		if(m_taskProt)
			m_api->m_data.GetAttr(m_taskProt, m_wf_mgr->a_task_tmpl_performers, performers);
	}
	
	if(!performers.GetSize())
		performers.Append(m_taskPer);

	bool bGiveTheProcessOwner=false; 
	CaplInstance* pOwner (NULL);
	m_api->m_data.GetAttr(m_activity, m_wf_mgr->a_activity_give_the_process_owner, bGiveTheProcessOwner);
	if(bGiveTheProcessOwner)
		m_api->m_data.GetAttr(m_process, m_wf_mgr->a_proc_owner, pOwner);
	if(pOwner)
	{
		performers.Add(pOwner);
	}

	CaplInstance* per= m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_PERSON|APL_MODE_SELECT_OFFICIAL, performers,
		APL_T("  "), APL_T("  :"));

	if(per)
	{
		m_newPerformer= per;
		m_api->m_appr_mgr.GetPersonName(m_newPerformer, m_sPerformer);						
		m_perDeleteBtn.EnableWindow();
	}

	UpdateData(FALSE);
}

void CTaskDlg::OnTaskManagerResources() 
{
	UpdateData();
	
	CaplInstance* per= m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_PERSON|APL_MODE_SELECT_OFFICIAL, m_taskMgr,
		APL_T("  "), APL_T("  :"));

	if(per)
	{
		m_newManager= per;
		m_api->m_appr_mgr.GetPersonName(m_newManager, m_sManager);	
		
		m_mgrDeleteBtn.EnableWindow();
	}

	UpdateData(FALSE);
}

void CTaskDlg::OnTaskManagerDelete() 
{
	if(!m_newManager) return;
	
	if(IDNO==AfxMessageBox(APL_T("     ?"), 
			MB_ICONQUESTION|MB_YESNO))
			return;
	
	UpdateData();	
	m_newManager= NULL;
	m_sManager= APL_T("<  >");
	m_mgrDeleteBtn.EnableWindow(FALSE);
	UpdateData(FALSE);
	
}

void CTaskDlg::OnTaskPerformerDelete() 
{
	if(!m_newPerformer) return;	
	if(IDNO==AfxMessageBox(APL_T("     ?"), 
			MB_ICONQUESTION|MB_YESNO))
			return;
	
	UpdateData();	
	m_newPerformer= NULL;
	m_sPerformer= APL_T("<  >");
	m_perDeleteBtn.EnableWindow(FALSE);	
	UpdateData(FALSE);
	
}

void CTaskDlg::OnTaskStartDate() 
{
	UpdateData();

	m_d_start_ctrl.EnableWindow(m_bStartCheck);m_t_start_ctrl.EnableWindow(m_bStartCheck);
	
	UpdateData(FALSE);
}

void CTaskDlg::OnTaskEndDate() 
{
	UpdateData();

	m_d_finish_ctrl.EnableWindow(m_bEndCheck);m_t_finish_ctrl.EnableWindow(m_bEndCheck);				
	
//	COleDateTime odt= COleDateTime::GetCurrentTime(), odt_f;
//	odt_f.SetDateTime(m_d_finish.GetYear(), m_d_finish.GetMonth(), m_d_finish.GetDay(),
//		m_t_finish.GetHour(), m_t_finish.GetMinute(), 0);
//
//	m_to.ModifyStyle(0, WS_VISIBLE, 0);
//
//	if(m_bEndCheck && odt_f>odt)
//	{
//		m_to.ModifyStyle(0, 0, WS_VISIBLE);
//		COLORREF crTextColor= RGB(255, 0, 0);
//		m_to.SetTextColor(crTextColor);
//		m_to.SetText(APL_T(" !"));
//	}	
	UpdateData(FALSE);
}

void CTaskDlg::OnTaskCheckDate() 
{
	UpdateData();
	
	m_d_check_ctrl.EnableWindow(m_bCheckCheck);m_t_check_ctrl.EnableWindow(m_bCheckCheck); 
	
	UpdateData(FALSE);
}

void CTaskDlg::OnProcAddFile() 
{
	int iIndex = m_woTabCtrl.GetCurSel();
	if(-1==iIndex) return;

	if(!m_wf_mgr->CanChangeWorkObjectsList(m_process))return;

	CFileDialog dlg(TRUE,0,0,OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_ALLOWMULTISELECT,
		_T("All Files (*.*)|*.*||"));
	
	CString buf;
	LPTSTR szFilesNames= buf.GetBuffer(2048);
	dlg.m_ofn.lpstrFile= szFilesNames;
	dlg.m_ofn.nMaxFile= 2048;

	if(dlg.DoModal()==IDOK)
	{
		CStringArray *arr;
		CStringArray *arraySinh;
		if(1==iIndex)
		{
			arr= &m_fileItemsSprav;
			arraySinh= &m_fileItems;
		}
		else
		{
			arr= &m_fileItems;
			arraySinh= &m_fileItemsSprav;
		}

		POSITION pos=dlg.GetStartPosition();
		while(pos!=0) 
		{
			CString buf1= dlg.GetNextPathName(pos);		

			LVFINDINFO info;
			info.flags= LVFI_STRING;		
			info.psz= buf1;
			
			if(m_woList.FindItem(&info, -1)==-1)
			{
				UINT ico= APL_ICON_FILE;
				arr->Add(buf1);

				for(int i= 0; i<arraySinh->GetSize(); i++)
				{
					if((*arraySinh)[i]==buf1)
					{
						arraySinh->RemoveAt(i);
						break;
					}
				}
			}
			else
			{
				AfxMessageBox(buf1+APL_T(":       ."));
			}		
		}
	}
	
	ShowWorkObjects((iIndex==0)?APL_WFWO_FORWORK:APL_WFWO_FORNOTE);
}

void CTaskDlg::OnProcAddWo() 
{
	int iIndex = m_woTabCtrl.GetCurSel();
	if(-1==iIndex) return;

	if(!m_wf_mgr->CanChangeWorkObjectsList(m_process))return;
	
	aplExtent res;
	m_wf_mgr->SelectInstanceEx(
								APL_MODE_SELECT_PRD |
								APL_MODE_SELECT_PDF |
								APL_MODE_SELECT_PRDINST  |
								APL_MODE_SELECT_LOT |
								APL_MODE_SELECT_DOC |
								APL_MODE_SELECT_DOC_REVISION |
								APL_MODE_SELECT_CATEG_REVISION |
								APL_MODE_SELECT_CATEGORY |
								APL_MODE_SELECT_FOLDER   |
								APL_MODE_SELECT_BP	|
								APL_MODE_SELECT_BP_REVISION	|
								APL_MODE_SELECT_BPINST	|
								APL_MODE_SELECT_CLASSIF_SYSTEM	|
								APL_MODE_SELECT_CLASSIF_ELEMENT |
								APL_MODE_SELECT_PROJECT  |
								APL_MODE_SELECT_CHANGE	|
								APL_MODE_SELECT_CHARACT	|
								APL_MODE_SELECT_CHARACT_REVISION  |
								APL_MODE_SELECT_ORG	|
//								APL_MODE_SELECT_PERSORG	|
								APL_MODE_SELECT_PERSON |
								APL_MODE_SELECT_OFFICIAL |
								APL_MODE_SELECT_MULTY
								,res);
	
	bool bNew;
	CaplInstance* inst;

	for(int i= 0; i<res.GetSize(); i++)
	{
		bNew= true;

		for(int j= 0; j<m_wo_items.GetSize(); j++)
		{
			m_api->m_data.GetAttr(m_wo_items[j], m_wf_mgr->a_wo_object, inst);
			if(inst==res[i])
			{
				bNew= false;
				m_del_wo_items.Remove(m_del_wo_items.Find(m_wo_items[j]));

				m_api->m_data.PutAttr(m_wo_items[j], m_wf_mgr->a_wo_for_note, (iIndex==1));
				break;
			}
		}

		if(bNew)
		{
			CaplInstance* new_wo= m_api->m_data.CreateInstance(m_wf_mgr->e_wo);
			if(new_wo)
			{
				m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_object, res[i]);
				m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_for_note, (iIndex==1));
				m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_action, m_process);

				m_wo_items.Add(new_wo);
			}

			if(m_up_level_task)
			{
				CaplInstance* up_level_proc= NULL;
				aplExtent objExt;
				apidata.GetAttr(m_up_level_task, m_wf_mgr->a_task_proc, up_level_proc);

				new_wo= m_api->m_data.CreateInstance(m_wf_mgr->e_wo);
				if(new_wo)
				{
					m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_object, res[i]);
					m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_for_note, (iIndex==1));
					m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_action, up_level_proc);
					m_api->m_data.GetAttr(up_level_proc, m_wf_mgr->a_proc_wo, objExt);
					objExt.Add(new_wo);
					m_api->m_data.PutAttr(up_level_proc, m_wf_mgr->a_proc_wo, objExt);
				}
			}
		}
	}

	ShowWorkObjects((iIndex==0)?APL_WFWO_FORWORK:APL_WFWO_FORNOTE);
}

void CTaskDlg::OnProcDeleteWo() 
{
	int iIndex = m_woTabCtrl.GetCurSel();
	if(-1==iIndex) return;

	if(!m_wf_mgr->CanChangeWorkObjectsList(m_process))return;
		
	POSITION pos= m_woList.GetFirstSelectedItemPosition();
	int nItem;
	CaplInstance * inst;
	CString sName;
	CStringArray* array= &m_fileItems;

	while (pos)
	{
		nItem = m_woList.GetNextSelectedItem(pos);
		inst= (CaplInstance*)m_woList.GetItemData(nItem);
		if(inst)
		{
			m_del_wo_items.Add(inst);
		}
		else
		{
			if(1==iIndex)array= &m_fileItemsSprav;

			sName= m_woList.GetItemText(nItem, 0);
			for(int i= 0; i<array->GetSize(); i++)
			{
				if(sName==(*array)[i])
				{
					array->RemoveAt(i);
					break;
				}
			}
		}
	}

	ShowWorkObjects((iIndex==0)?APL_WFWO_FORWORK:APL_WFWO_FORNOTE);
}

void CTaskDlg::OnBnClickedTaskView()
{
	int iIndex = m_woTabCtrl.GetCurSel();
	if(-1==iIndex) return;

	CString buf;
	CString sPath;

	CStringArray *arr;
	if(1==iIndex) arr= &m_fileItemsSprav;
	else arr= &m_fileItems;

	POSITION pos= m_woList.GetFirstSelectedItemPosition();
	int nItem;
	if(!pos) return;
	nItem = m_woList.GetNextSelectedItem(pos);

	CaplInstance *docInst = NULL;
	CaplInstance *workObj= (CaplInstance*)m_woList.GetItemData(nItem);
	if(workObj)
	{
		m_api->m_data.GetAttr(workObj, m_wf_mgr->a_wo_object, docInst);

		if(m_api->m_data.IsKindOf(docInst, m_api->m_doc_mgr.e_doc) || 
			m_api->m_data.IsKindOf(docInst, m_api->m_doc_mgr.e_apl_doc_rev) || 
			m_api->m_data.IsKindOf(docInst, m_api->m_doc_mgr.e_apl_stored_document))
			m_api->m_doc_mgr.View(docInst);
		else
		{
			AfxMessageBox(APL_T("     !"), MB_OK|MB_ICONERROR);
			return;
		}
	}
	else
	{
		sPath= m_woList.GetItemText(nItem, 0);
		if(sPath.IsEmpty())
		{
			AfxMessageBox(APL_T("    ."), MB_OK|MB_ICONERROR);
			return;
		}
		else
		{
			CFile file;
			if(!file.Open(sPath,CFile::modeRead|CFile::shareDenyNone))
			{
				CString sMsg;
				sMsg.Format(APL_T(" \"%s\"  !"), sPath);
				AfxMessageBox(sMsg, MB_OK|MB_ICONERROR);
				return;	
			}
			else file.Close();
		}
		aplShellExecute(NULL, _T("open"), sPath, NULL, NULL, SW_SHOW);
	}
}


void CTaskDlg::OnSelchangeProcTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int iIndex = m_woTabCtrl.GetCurSel();
	if(-1==iIndex) return;
		
	TCITEM tcItem;
	tcItem.mask = TCIF_PARAM;
	m_woTabCtrl.GetItem(iIndex, &tcItem);
	
	ShowWorkObjects(tcItem.lParam);

	*pResult = 0;
}

void CTaskDlg::ProcessWorkObjects()
{
	CaplInstance* inst;
	CaplInstance* new_wo;
	int i;

	for(i= 0; i<m_del_wo_items.GetSize(); i++)
	{
		m_wo_items.Remove(m_wo_items.Find(m_del_wo_items[i]));					
		
		m_api->m_data.GetAttr(m_del_wo_items[i], m_wf_mgr->a_wo_object, inst);

		if(m_api->m_data.IsKindOf(inst, m_api->m_doc_mgr.e_apl_stored_document))
			m_api->m_data.NET_DeleteBlob(inst, m_api->m_doc_mgr.a_apl_stored_document_source);
		
		apidata.DeleteInstance(m_del_wo_items[i]);
	}
	
	for(i= 0; i<m_fileItems.GetSize(); i++)
	{
		inst= m_api->m_doc_mgr.CreateFile(m_fileItems[i]);
		if(!inst) continue;

		new_wo= m_api->m_data.CreateInstance(m_wf_mgr->e_wo);
		if(new_wo)
		{
			m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_object, inst);
			m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_for_note, false);
			m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_action, m_process);

			m_wo_items.Add(new_wo);
		}		
	}

	for(i= 0; i<m_fileItemsSprav.GetSize(); i++)
	{
		inst= m_api->m_doc_mgr.CreateFile(m_fileItemsSprav[i]);
		if(!inst) continue;

		new_wo= m_api->m_data.CreateInstance(m_wf_mgr->e_wo);
		if(new_wo)
		{
			m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_object, inst);
			m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_for_note, true);
			m_api->m_data.PutAttr(new_wo, m_wf_mgr->a_wo_action, m_process);

			m_wo_items.Add(new_wo);
		}		
	}
}

void CTaskDlg::ShowWorkObjects(BOOL bWo/* = APL_WFWO_FORWORK */)
{
	m_woList.DeleteAllItems();
	
	CaplInstance* inst;
	bool bForNote= false;
	CStringArray *arr= &m_fileItems;
	bool bFlag;
	UINT ico;
	int iNum;
	CString sName, sType;
	aplExtent ext;
	int i;
	
	if(bWo==APL_WFWO_FORNOTE)
	{
		bForNote= true;
		arr= &m_fileItemsSprav;
	}
	
	for(i= 0; i<m_wo_items.GetSize(); i++)
	{
		if(!m_wo_items[i] || !m_wo_items[i]->GetType()) continue;
		if(m_wo_items[i]->GetAccessmode()==aplNO) continue;
		
		m_api->m_data.GetAttr(m_wo_items[i], m_wf_mgr->a_wo_object, inst);
		ext.Add(inst);
	}

	m_api->LoadExtentInfo(ext);

	for(i= 0; i<m_wo_items.GetSize(); i++)
	{
		if(-1!=m_del_wo_items.Find(m_wo_items[i])) continue;

		if(!m_wo_items[i] || !m_wo_items[i]->GetType()) continue;
		if(m_wo_items[i]->GetAccessmode()==aplNO) continue;
		
		m_api->m_data.GetAttr(m_wo_items[i], m_wf_mgr->a_wo_for_note, bFlag);
		if(bFlag==bForNote)
		{			
			m_api->m_data.GetAttr(m_wo_items[i], m_wf_mgr->a_wo_object, inst);
			if(!inst) continue;
			if(inst->GetAccessmode()==aplNO) continue;
			
			m_api->GetItemName(inst, sName);
			ico = m_api->GetInstIco(inst);
			sType= GetTypeName(inst);
			
			if(sName.IsEmpty()) sName.Format(_T("%s -> id %i"), inst->GetType()->name, inst->GetId());

			iNum= m_woList.GetItemCount();

			m_woList.InsertItem(iNum, sName, ico);
			m_woList.SetItemData(iNum, (DWORD)m_wo_items[i]);
			m_woList.SetItemText(iNum, 1, sType);			
		}
	}
	

	for(i= 0; i<arr->GetSize(); i++)
	{
		ico= ICON_DOCUMENT_COPY;
		iNum= m_woList.GetItemCount();
		m_woList.InsertItem(iNum, (*arr)[i], ico);
		m_woList.SetItemText(iNum, 1, APL_T(""));			
		m_woList.SetItemData(iNum, 0);
	}
	
	m_woList.ReSort();
}

CString CTaskDlg::GetTypeName(CaplInstance* inst)
{
	CString sType;
	
	if(!inst) return sType;
	if(!inst->GetType()) return sType;

	if(apidata.IsKindOf(inst, m_api->m_doc_mgr.e_apl_doc))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_doc_mgr.e_apl_doc_rev))
		sType = APL_T(" ");
	else if(apidata.IsKindOf(inst, m_api->m_doc_mgr.e_apl_stored_document))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_prd_mgr.e_prd))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_prd_mgr.e_apl_pdf))
		sType= APL_T(" ");
	else if(apidata.IsKindOf(inst, m_api->m_prd_inst_mgr.e_prd_inst))
		sType= APL_T(" ");
	else if(apidata.IsKindOf(inst, m_api->m_prd_inst_mgr.e_lot))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_change_mgr.e_chng))
		sType = APL_T(" ");
	else if(apidata.IsKindOf(inst, m_api->m_change_mgr.e_avc))
		sType = APL_T(" ");
	else if(apidata.IsKindOf(inst, m_api->m_change_mgr.e_psc))
		sType = APL_T(" ");
	else if(apidata.IsKindOf(inst, m_api->m_bp_mgr.e_bp))
		sType= APL_T("-");
	else if(apidata.IsKindOf(inst, m_api->m_bp_mgr.e_apl_bp_inst))
		sType= APL_T(" -");
	else if(0!= m_api->m_expl_mgr && apidata.IsKindOf(inst, m_api->m_expl_mgr->e_apl_refusal))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_classifier_mgr.e_apl_classifier_system))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_classifier_mgr.e_apl_classifier_level))
		sType= APL_T(" ");
	else if(apidata.IsKindOf(inst, m_api->m_folder_mgr.e_folder))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_project_mgr->e_project))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_appr_mgr.e_person))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_appr_mgr.e_org))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_appr_mgr.e_org))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_message_mgr.e_message))
		sType= APL_T("");
	else if(apidata.IsKindOf(inst, m_api->m_doc_mgr.e_doc_copy_order))
	{
		m_api->m_data.GetAttr(inst, m_api->m_doc_mgr.a_purchase_order_type, sType);
		sType.MakeLower();

		if(sType==_T("print")) sType= APL_T("-");
		else if(sType==_T("destroy")) sType = APL_T("  ");
		else sType = inst->GetType()->name;
	}
	else sType= inst->GetType()->name;

	return sType;
}


void CTaskDlg::OnBnClickedResetDStart()
{
	//    (   

	if(!m_api->m_appr_mgr.CheckPersonRoleByOption(0,APL_NO_T(" Workflow\\     "),true)) return;

	CSetDateDlg dlg;
	dlg.m_sHeader=APL_T("  ");
	m_d_start_ctrl.GetTime(dlg.m_date);
	m_t_start_ctrl.GetTime(dlg.m_time);
	if(IDOK!=dlg.DoModal()) return;

	m_d_start_ctrl.SetTime(dlg.m_date);
	m_t_start_ctrl.SetTime(dlg.m_time);
	m_d_start=dlg.m_date;
	m_t_start=dlg.m_time;

	COleDateTime odt;
	odt.SetDateTime(dlg.m_date.GetYear(),dlg.m_date.GetMonth(),dlg.m_date.GetDay(),dlg.m_time.GetHour(),dlg.m_time.GetMinute(),dlg.m_time.GetSecond());
	CString buf;
	aplDate2String(odt,buf);
	apidata.PutAttr(m_task, m_wf_mgr->a_act_inst_start_date, buf);
}



void CTaskDlg::OnNMRClickTaskWoListctrl(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	if(pNMItemActivate->iItem<0) return;
	if(m_bReadOnly) return;
	if(!m_wf_mgr->CanChangeWorkObjectsList(m_process))return;

	//if(0==m_woList.GetItemData(pNMItemActivate->iItem)) return;

	int iIndex = m_woTabCtrl.GetCurSel();
	if(-1==iIndex) return;

	CMenu menu; menu.CreatePopupMenu();

	if(APL_WFWO_FORWORK==iIndex)
		menu.InsertMenu(0,MF_BYPOSITION| MF_STRING ,WM_USER+1, APL_T("  \" \""));
	else if(APL_WFWO_FORNOTE==iIndex)
		menu.InsertMenu(0,MF_BYPOSITION| MF_STRING ,WM_USER+2,APL_T("  \"\""));
	else return;
	menu.InsertMenu(1,MF_BYPOSITION| MF_SEPARATOR ,0,_T(""));
	menu.InsertMenu(2,MF_BYPOSITION| MF_STRING ,WM_USER+3,APL_T(""));

	const MSG* msg;
	CPoint mouseclick;
	msg=GetCurrentMessage();
	//mouseclick -   
	mouseclick=msg->pt;

	int res=menu.TrackPopupMenu(TPM_LEFTALIGN|TPM_NONOTIFY|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,msg->pt.x, msg->pt.y,this);


	if((WM_USER+3)==res) return OnProcDeleteWo();
	
	if((WM_USER+1)==res || (WM_USER+2)==res )
	{
		bool bForNote=false;
		CStringArray *arrayFrom, *arrayTo = &m_fileItems;

		if((WM_USER+1)==res)
		{
			bForNote=true;
			arrayFrom=&m_fileItems;
			arrayTo=&m_fileItemsSprav;
		}
		else if((WM_USER+2)==res)
		{
			bForNote=false;
			arrayFrom=&m_fileItemsSprav;
			arrayTo=&m_fileItems;
		}

		POSITION pos= m_woList.GetFirstSelectedItemPosition();
		int i,nItem;
		CaplInstance * inst;
		CString sName;

		//    
		while (pos)
		{
			nItem = m_woList.GetNextSelectedItem(pos);
			inst= (CaplInstance*)m_woList.GetItemData(nItem);
			if(inst)
			{
				m_api->m_data.PutAttr(inst, m_wf_mgr->a_wo_for_note, bForNote);
			}
			else
			{
				sName= m_woList.GetItemText(nItem, 0);
				for( i= 0; i<arrayFrom->GetSize(); i++)
				{
					if(sName==(*arrayFrom)[i]) 	{arrayFrom->RemoveAt(i); break;}
				}
				bool bNeedAdd=true;
				for( i= 0; i<arrayTo->GetSize(); i++)
				{
					if(sName==(*arrayTo)[i]) {bNeedAdd=false; break;}
				}
				if(bNeedAdd) arrayTo->Add(sName);
			}
		}
		m_cancelBtn.EnableWindow(FALSE);
	}

	ShowWorkObjects((iIndex==0)?APL_WFWO_FORWORK:APL_WFWO_FORNOTE);
}
