#if !defined(AFX_TASKTIMESDIALOG_H__B06AA86D_4191_42F0_92C6_F77B047B8CEF__INCLUDED_)
#define AFX_TASKTIMESDIALOG_H__B06AA86D_4191_42F0_92C6_F77B047B8CEF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// TaskTimesDialog.h : header file
//

#include "resource.h"
#include "apl_api.h"
#include "common.h"
#include "afxwin.h"
#include "apl_gui.h"

class CWfGanttView;
/////////////////////////////////////////////////////////////////////////////
// CTaskTimesDialog dialog

class CReadWriteCheckCombo
{
public:

	CReadWriteCheckCombo(CaplCheckComboBox &combo) : m_combo(combo) {};
	void Read(CString &value)
	{
		if(value.IsEmpty() == false)
		{
			if(m_combo.m_bUseSpecialFirstString == true)
				m_combo.UnSelectAllCategoriesByFirstString();		

			int index1 = 0, index2 = -1;
			while(-1 != index1)
			{
				index2 = value.Find(_T(';'), index1);
				if(-1 == index2)
					break;

				CString indexName, str = value.Mid(index1, index2 - index1); str.Trim();
				for(int i=0; i<m_combo.GetCount(); ++i)
				{
					m_combo.GetLBText(i, indexName);
					if(0 == indexName.CompareNoCase(str))
					{
						m_combo.SetCheck(i, TRUE);	
						m_combo.SetWindowText(value);

						break;
					}
				}								

				index1 = index2 + 1;
			}
		}
		else
		{
			if(m_combo.m_bUseSpecialFirstString == true)
				m_combo.SelectAllCategoriesByFirstString();
		}
	}

	void GetWindowText(CString &value)
	{
		value.Empty();

		if(m_combo.GetCheck(0) && m_combo.m_bUseSpecialFirstString == true)
			return;

		m_combo.GetWindowText(value);
		value += _T(";");
	}

protected:

	CaplCheckComboBox &m_combo;	
};

class CTaskTimesDialog : public CaplResizableDialog
{
// Construction
public:
	CTaskTimesDialog(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CTaskTimesDialog)
	enum { IDD = IDD_TIMES_DIALOG };
	CStatic	m_tree_border_ctrl;
	CComboBox	m_view_mode_ctrl;
	CaplButton	m_zoomout_btn;
	CaplButton	m_zoomin_btn;
	CStatic	m_gantt_border_ctrl;
	CaplButton		m_Cancel;
	CaplButton		m_bShow;
	CButton			m_bSelect;
	CaplButton		m_bSave;
	CaplButton		m_bHeader;
//	CSortListCtrl	m_lcResults;
	CaplCheckComboBox		m_cbActivities;
	CaplCheckComboBox		m_cbStates;
	CaplCheckComboBox		m_cbTemplates;
	COleDateTime	m_codtEndDate;
	COleDateTime	m_codtStartDate;
	CString			m_csPerformer;
	//}}AFX_DATA

	int		m_iSz[11];

	CaplAPI*				m_pApi;
	CaplWorkFlowManager*	m_wf_mgr;

	CaplInstance*			m_ciSelTempl;
	CaplInstance*			m_ciSelAct;

	CaplTreeListCtrlView *m_tree_view;
	CWfGanttView *m_gantt_view;
	CaplSplitterBar *m_splitter;
	
	CaplMap m_ActivitiesMap;
	CaplStrMap	m_StatesMap;
	CaplMap	m_TemplatesMap;

	CaplMap m_amHeader;

	CString m_sTemplatesFilter;

	void			SetAnchors(void);

	void			FillTemplates(void);
	void			FillActivities(CaplInstance* ciTemplate);
	void			FillStates(void);

	void			ListSetColumns(int mode);
	void			ListFillData(void);
	void            SetItemText(HTREEITEM iPos, int iIndex, int &iColumn, CString& sText);


	void			GetEngState(CString& csRusState);
	void			GetRusState(CString& csEngState);

	CStringArray	m_csEngStates;
	CStringArray	m_csRusStates;

	CaplInstance*	m_ciPerformer;

	struct _task_info
	{
		CaplInstance*		ciTask;

		//	
		CaplInstance*		ciTemplate;
		//	
		CaplInstance*		ciActivity;
		//	
		CaplInstance*		ciProc;
		//	
		int					iIteration;
		//	
		CString				csState;
		//	
		CaplInstance*		ciPerformer;
		//	. .
		COleDateTimeSpan	codtNeedTime;
		//	. .
		COleDateTimeSpan	codtRealTime;
		//	  - start_date
		COleDateTime		codtStartDate;
		//	  - end_date
		COleDateTime		codtEndDate;
		//	  - finish_date
		COleDateTime		codtEndDateF;
	};

	typedef CArray<_task_info*,_task_info*> TaskArray;
	typedef CMap<long,long,void*,void*>		SortMap;

	TaskArray m_caTasks;

	void			GetParamsForQuery(aplExtent& ciTemplate,aplExtent& ciActivity,
								 CaplInstance*& ciPerformer,CStringArray& csState,
								 CString& csStartDate,CString& csEndDate);

	BOOL			ExecuteQuery(aplExtent& ciTemplate,aplExtent& ciActivity,
								 CaplInstance* ciPerformer,CStringArray& csState,
								 CString& csStartDate,CString& csEndDate,aplExtent& aeOutRes, bool bShowMsg);
	void			SortAndReadData(aplExtent& aeData,TaskArray& taTasksOut,BOOL bReadIterations);

	void			SetIterations(void);
	inline void		_Split(TaskArray& taIn,SortMap& mapOut);
	inline void		_Sort(SortMap& mapIn);
	inline void		_SetIter(SortMap& mapIn);
	inline void		_ClearMap(SortMap& mapIn,BOOL bDelInfo);

	void UpdateGanttView(bool bUpdateCalendar=false);	



// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTaskTimesDialog)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

	void Sort(int nCol);

// Implementation
protected:

	static int __cdecl Compare(const void* pstr1, const void* pstr2);

	// Generated message map functions
	//{{AFX_MSG(CTaskTimesDialog)
	virtual BOOL OnInitDialog();
	afx_msg void OnBSelectPerformer();
	afx_msg void OnBShow();
	afx_msg void OnBSave();
	afx_msg void OnBHeader();
	afx_msg void OnSelchangeCbTemplates();
	afx_msg void OnDestroy();
	afx_msg void OnBClearPerformer();
	afx_msg void OnDropdownDtStartDate(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDropdownDtEndDate(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDatetimechangeDtStartDate(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDatetimechangeDtEndDate(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchangeViewMode();
	afx_msg void OnZoomin();
	afx_msg void OnZoomout();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSelChanged();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:

	CEdit m_execute_len_ctrl;
	CEdit m_overdue_ctrl;
	CEdit m_dl_ctrl;
	CaplButton m_show_color_legend_btn;
	afx_msg void OnBnClickedShowColorLegend();
	CButton m_bShowNumIterationBtn;
	CEdit m_tmpl_filter_ctrl;
	afx_msg void OnBnClickedTmplFilterApply();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TASKTIMESDIALOG_H__B06AA86D_4191_42F0_92C6_F77B047B8CEF__INCLUDED_)
