// TmplDialog.cpp : implementation file
//

#include "stdafx.h"
#include "TmplDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "dictionary.h"
#include "common.h"
#include "aplWorkflowManager.h"
#include "aplStepManager.h"

/////////////////////////////////////////////////////////////////////////////
// CTmplDialog dialog
 

CTmplDialog::CTmplDialog(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CTmplDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTmplDialog)
	m_sFinish = _T("");
	m_sStart = _T("");
	m_sId = _T("");
	m_sName = _T("");
	m_sDscr = _T("");
	m_sRole = _T("");
	//}}AFX_DATA_INIT

	m_api= NULL;
	m_instance= NULL;
	m_wfMgr= NULL;
}


void CTmplDialog::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTmplDialog)
	DDX_Control(pDX, IDC_TMPL_TAB, m_tabCtrl);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDC_FINISH_STATIC, m_finish);
	DDX_Control(pDX, IDC_PERSON_LIST, m_perList);
	DDX_Text(pDX, IDC_FINISH_MODE_STATIC, m_sFinish);
	DDX_Text(pDX, IDC_START_MODE_STATIC, m_sStart);
	DDX_Control(pDX, IDC_START_STATIC, m_start);
	DDX_Text(pDX, IDC_TMPL_ID, m_sId);
	DDX_Text(pDX, IDC_TMPL_NAME, m_sName);
	DDX_Text(pDX, IDC_TMPL_DSCR, m_sDscr);
	DDX_Text(pDX, IDC_TMPL_ROLE, m_sRole);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_GIVE_PROCESS_OWNER, m_give_process_owner_ctrl);
}


BEGIN_MESSAGE_MAP(CTmplDialog, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CTmplDialog)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TMPL_TAB, OnSelchangeTmplTab)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_GIVE_PROCESS_OWNER, &CTmplDialog::OnBnClickedGiveProcessOwner)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTmplDialog message handlers

BOOL CTmplDialog::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);
	
	m_imageList.Create(IDR_NAVIGATOR_ICON, 20, 11, RGB(255, 0, 255));
	m_perList.SetImageList(&m_imageList, LVSIL_SMALL);
	
	if(m_api && m_api->m_data.IsConnected())
	{
		CaplAggr aggr;
		CString buf;
		CaplInstance* role= NULL;

		if(m_instance)
		{
			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_action_id, m_sId);
			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_action_name, m_sName);
			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_action_dscr, m_sDscr);
		}
		
		if(m_instance->GetType()==m_api->m_data.GetEntityBN(_T("apl_process_template")))
		{
			SetWindowText(APL_T("  "));
			m_tabCtrl.InsertItem(0, APL_T(""));
			m_api->m_data.GetAttrBN(m_instance, _T("holders"), aggr);
			m_tabCtrl.InsertItem(1, APL_T(""));
			m_api->m_data.GetAttrBN(m_instance, _T("holders"), aggr);
		}
		else if(m_instance->GetType()==m_api->m_data.GetEntityBN(_T("apl_activity")))
		{
			SetWindowText(APL_T(" "));
			m_tabCtrl.InsertItem(0, APL_T(""));
			m_tabCtrl.InsertItem(1, APL_T(""));
			
			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_activity_executors, aggr);
			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_activity_role, role);
			if(role)
			{
				if(!role->attrs)
					m_api->LoadItemInfo(role);

				m_api->m_data.GetAttrBN(role, S::name, m_sRole);
			}
			else
				m_sRole= APL_T("<  >");

			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_activity_st_mode, buf);
			if(buf==_T("manual")) m_sStart= APL_T("");
			else if(buf==_T("auto")) m_sStart= APL_T("");
			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_activity_fn_mode, buf);
			if(buf==_T("manual")) m_sFinish= APL_T("");
			else if(buf==_T("auto")) m_sFinish= APL_T("");

			m_start.ModifyStyle(0, WS_VISIBLE, 0);
			m_finish.ModifyStyle(0, WS_VISIBLE, 0);

			m_give_process_owner_ctrl.ShowWindow(SW_SHOW);
			m_give_process_owner_ctrl.EnableWindow(TRUE);
			bool bGiveTheProcessOwner=false;
			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_activity_give_the_process_owner, bGiveTheProcessOwner);
			if(bGiveTheProcessOwner) m_give_process_owner_ctrl.SetCheck(1);
		}
		
		m_perList.InsertColumn(0, _T(""), LVCFMT_LEFT, 400);
			
		ShowPersonsInList(aggr);
		UpdateData(FALSE);
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTmplDialog::ShowPersonsInList(CaplAggr &aggr)
{
	m_perList.DeleteAllItems();
	CaplInstance* inst;
	CString buf;

	for(int i= 0; i<aggr.GetSize(); i++)
	{
		aggr.GetByIndex(i, inst);
		if(!inst) continue;
		UINT ico;
		m_api->LoadItemInfo(inst);

		if(m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_org))
		{
			buf=_T("");
			m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_org_name, buf);
			ico= APL_ICON_ORGANIZATION;
		}
		else if(m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_person))
		{
			m_api->m_appr_mgr.GetPersonName(inst, buf);
			ico= APL_ICON_PERSON;
		}
		else if(m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_official))
		{
			m_api->m_appr_mgr.GetPersonName(inst, buf);
			ico= APL_ICON_OFFICIAL;
		}
		else continue;
		if(!buf.IsEmpty())
		{
			int n= m_perList.GetItemCount();
			m_perList.InsertItem(n, buf, ico);
		}
	}	
}

void CTmplDialog::OnSelchangeTmplTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int i= m_tabCtrl.GetCurSel();
	
	CaplAggr aggr;
	if(i==0)
	{
		if(m_api->m_data.IsKindOf(m_instance, m_wfMgr->e_proc_tmpl))
			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_proc_tmpl_holders, aggr);
		else
			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_activity_executors, aggr);
	}
	else if(i==1)
	{
		if(m_api->m_data.IsKindOf(m_instance, m_wfMgr->e_proc_tmpl))
			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_proc_tmpl_managers, aggr);
		else
			m_api->m_data.GetAttr(m_instance, m_wfMgr->a_activity_managers, aggr);
	}
	
	ShowPersonsInList(aggr);

	*pResult = 0;
}

void CTmplDialog::OnBnClickedGiveProcessOwner()
{
	// TODO: Add your control notification handler code here
}
