// GanttCtrl.h: interface for the CWfGanttCtrl class.
//
//////////////////////////////////////////////////////////////////////
#include "resource.h"
#include <apl_gui.h>
#include "apl_api.h"
//#include "aplProjectMgr.h"

#if !defined(AFX_GANTTCTRL_H__7A6CF8B4_93A5_469B_9FD4_9D610D558D86__INCLUDED_)
#define AFX_GANTTCTRL_H__7A6CF8B4_93A5_469B_9FD4_9D610D558D86__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#ifdef APL_PROGECT_MGR
#define APL_PM_CLASS_EXPORT		_declspec(dllexport)
#else
#define APL_PM_CLASS_EXPORT		_declspec(dllimport)
#endif

class CGanttItem
{
	public:
		CString id;
		CString name;
		DWORD itemData;
		HTREEITEM hTreeItem;
		CString pl_date_begin;
		CString pl_date_end;
		CString act_date_begin;
		CString act_date_end;
		CString act_date_end_prognoz;
		COLORREF color;
		double percentage;
		int last_sub_item;

	public:
		CGanttItem();
};

	#define APL_MODE_OPEN      0x00000
	#define APL_MODE_EDIT      0x00001
	#define APL_MODE_PRINT     0x00002
	#define APL_MODE_SAVE      0x00003

	#define APL_MODE_YEARS      0x00000
	#define APL_MODE_MONTHS     0x00001
	#define APL_MODE_WEEKS      0x00002

class CWfGanttCtrl : public CWnd 
{
public:
	int m_nOffset;
	CArray<CGanttItem,CGanttItem> m_items;
	bool m_bShowVerLiles;
	int m_blockHeight;
	int m_headerHeight;
	int m_project_id_width;
	CaplAPI *m_api;
	//CaplProjectManager *m_project_mgr;
	CaplResizableDialog *m_dlg;
	CaplToolTip m_ToolTip;
	CFont m_pFont;
//	CBitmap m_pattern_bmp;
	int m_view_mode;
	int m_max_id_length;
public:
	int GetDlitDays(LPCTSTR date_begin,LPCTSTR date_end);
	int GetFirstDays(LPCTSTR date_begin);
	CWfGanttCtrl();
	virtual ~CWfGanttCtrl();
	int InsertItem(CGanttItem &new_item);
	bool PointToVal(CPoint *point, CGanttItem &gItem,HTREEITEM &hItem,CaplInstance **inst);
	void RemoveAllItems();
	void UpdateCalendar(bool resetScrollBar=true);
	void ResetVertScrollBar();
	int GetColumnsWidth() { return m_nColumnsWidth; };
	void RecalcColumnsWidth();
	void AutoResizeDiagram(bool bReduce=false,bool bInvalidate=true);
	bool SetPixelsInDay(int pixelsInDay);
	int GetPixelsInDay(){ return m_pixelsInDay; };
	void GetMaxDate(CString &buf){buf=m_max_date;};
	void GetMinDate(CString &buf){buf=m_min_date;};
	CGanttItem* FindItem(HTREEITEM hItem);
	int GetItemNum(CGanttItem &gItem);
	void PaintDiagram(CDC &dc,long mode);
	bool ExportDiagramBmp(CString &bmp_f_name);
protected:
	void CheckSetPixelsInDay(int pixelsInDay);
	void GetPlannedRect(CGanttItem &item,CRect &rect,int top,int height);
	void GetActualRect(CGanttItem &item,CRect &rect,int top,int height,int *xPosPrognoz=0);
	int m_pixelsInDay;
	CString m_max_date;
	CString m_min_date;
	CString m_max_calendar_date;
	CString m_min_calendar_date;
	int m_col_days;
	COleDateTime m_max_dt;
	COleDateTime m_min_dt;
	COleDateTime m_min_calendar_dt;
	COleDateTime m_max_calendar_dt;
	int m_nColumnsWidth;
protected:
	void CalcMaxMinDates();
	void DisplayToolTip(CPoint point,CGanttItem &gItem);
	void HideToolTip();
	LRESULT OnMouseLeave(WPARAM wParam, LPARAM lParam);
	/*      
	  @param   
  		  APL_MODE_EDIT -   
		  APL_MODE_PRINT -     */
	//{{AFX_MSG(CaplTreeListCtrl)
	afx_msg void OnPaint();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point); 
	afx_msg void OnMouseMove(UINT nFlags, CPoint point); 
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif // !defined(AFX_GANTTCTRL_H__7A6CF8B4_93A5_469B_9FD4_9D610D558D86__INCLUDED_)
