// zoomtestView.cpp : implementation of the CZoomView class
//

#include "stdafx.h"
#include "zoomview.h"
#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define ZOOM_RECT 1
#define ZOOM_PAN 2

/////////////////////////////////////////////////////////////////////////////
// CZoomView

IMPLEMENT_DYNCREATE(CZoomView, CScrollView)

BEGIN_MESSAGE_MAP(CZoomView, CScrollView)
	//{{AFX_MSG_MAP(CZoomView)
	ON_COMMAND(ID_ZOOM_ALL, OnZoomAll)
	ON_COMMAND(ID_ZOOM_OUT, OnZoomOut)
	ON_COMMAND(ID_ZOOM_IN, OnZoomIn)
	ON_WM_PAINT()
	ON_WM_ERASEBKGND()
	ON_COMMAND(ID_ZOOM_TO_ORIG, OnZoomToOrig)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_COMMAND(ID_ZOOM_RECT, OnZoomRect)
	ON_COMMAND(ID_ZOOM_PAN, OnZoomPan)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CZoomView construction/destruction

CZoomView::CZoomView()
{
	// TODO: add construction code here
	
	m_iZoomMode=0;
	m_bLButtonDown=false;

	m_pages_x=1;
	m_pages_y=1;

	m_sizePage.cx=297;
	m_sizePage.cy=210;

}

CZoomView::~CZoomView()
{
}

BOOL CZoomView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CZoomView printing

BOOL CZoomView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CZoomView::OnBeginPrinting(CDC* pDC, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
	//pDC->SetMapMode(MM_ISOTROPIC);
	//pDC->SetViewportExt(m_sizePage.cx,m_sizePage.cy);

}

void CZoomView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CZoomView diagnostics

#ifdef _DEBUG
void CZoomView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CZoomView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}

CDocument* CZoomView::GetDocument() // non-debug version is inline
{
	if(m_pDocument==0) return 0;
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDocument)));
	return (CDocument*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CZoomView message handlers

/////////////////////////////////////////////////////////////////////////////
// CZoomView drawing

void CZoomView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	CScrollView::OnPrepareDC(pDC, pInfo);

	if(pInfo==0)
	{
		pDC->SetMapMode(MM_ISOTROPIC);
//		pDC->ScaleWindowExt(m_sizePage.cx,(int)(m_zoom*m_sizePage.cx),
//			m_sizePage.cy,(int)(m_zoom*m_sizePage.cy));


	}
}


void CZoomView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	OnPrepareDC(&dc);
	
	// TODO: Add your message handler code here
	
	dc.SetMapMode(MM_ISOTROPIC);
	//dc.SetViewportExt((int)(m_zoom*m_sizePage.cx),(int)(m_zoom*m_sizePage.cy));

//	CSize s1=dc.GetWindowExt( );

	dc.ScaleWindowExt(m_sizePage.cx,(int)(m_zoom*m_sizePage.cx),
		m_sizePage.cy,(int)(m_zoom*m_sizePage.cy));
//
//	CSize s2=dc.GetWindowExt( );

	dc.SelectClipRgn(NULL);

	OnDraw(&dc);
	
	// Do not call CScrollView::OnPaint() for painting messages
}


void CZoomView::OnDraw(CDC* pDC)
{
/*	CZoomtestDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
	//pDC->SetMapMode(MM_ISOTROPIC);
	//pDC->SetViewportExt(m_zoom*m_sizePage.cx,m_zoom*m_sizePage.cy);
	//Beep(4000,10);


	pDC->FillSolidRect(100,-100,500,-500,RGB(255,0,255));
	pDC->Ellipse(0,0,100,-100);
	pDC->Ellipse(0,0,m_sizePage.cx,-m_sizePage.cy);
	pDC->Draw3dRect(5,-5,m_sizePage.cx-5,-m_sizePage.cy+5,RGB(0,0,0),RGB(0,0,0));
	pDC->Draw3dRect(0,0,m_sizePage.cx/2,-m_sizePage.cy/2,RGB(0,255,0),RGB(0,255,0));
*/
}

void CZoomView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();
}

void  CZoomView::UpdateToNewZoom(double zoom, bool bInvalidate)
{
	m_zoom=zoom;
	if(m_zoom<0.01) m_zoom=0.01;
	else if(m_zoom>2000) m_zoom=2000;
	m_sizeTotal.cx=(int)(m_zoom*m_sizePage.cx*m_pages_x);
	m_sizeTotal.cy=(int)(m_zoom*m_sizePage.cy*m_pages_y);
	SetScrollSizes(MM_LOMETRIC, m_sizeTotal);
	if(bInvalidate) Invalidate();

}
//*******************************************************
void CZoomView::OnZoomOut() 
{
	m_zoom*=0.5;
	UpdateToNewZoom(m_zoom);
	
}
//*******************************************************
void CZoomView::OnZoomIn() 
{
	m_zoom*=2;
	UpdateToNewZoom(m_zoom);	
}
//*******************************************************
void CZoomView::OnZoomRect() 
{
	m_iZoomMode=ZOOM_RECT;
}

void CZoomView::OnZoomPan() 
{
	m_iZoomMode=ZOOM_PAN;
}

//*******************************************************
void CZoomView::OnZoomAll() 
{
	RECT rect;
	GetClientRect(&rect);
	
	CPaintDC dc(this); // device context for painting
	OnPrepareDC(&dc);
	dc.DPtoLP(&rect);

	double zoom_x=((double)(rect.right-rect.left))/m_sizeTotal.cx;
	double zoom_y=((double)(rect.top-rect.bottom))/m_sizeTotal.cy;
	if(zoom_y<zoom_x) m_zoom*=zoom_y;
	else m_zoom*=zoom_x;
	
	UpdateToNewZoom(m_zoom);
}
//*******************************************************
void CZoomView::ZoomRect(RECT &rectzoom)
{
	int cx=rectzoom.right-rectzoom.left;
	int cy=rectzoom.bottom-rectzoom.top;

	RECT rect;
	GetClientRect(&rect);

	CPaintDC dc(this); // device context for painting
	OnPrepareDC(&dc);
	dc.DPtoLP(&rect);

	double zoom_x=((double)(rect.right-rect.left))/cx;
	double zoom_y=((double)(rect.top-rect.bottom))/cy;
	if(zoom_y<zoom_x) m_zoom=zoom_y;
	else m_zoom=zoom_x;

	m_zoom*=0.95;
	
	UpdateToNewZoom(m_zoom,false);	
	
	POINT p;
	p.x=(int)(rectzoom.left*m_zoom);
	p.y=(int)(-rectzoom.top*m_zoom);

	ScrollToPosition(p);
	Invalidate();
}
//*******************************************************

BOOL CZoomView::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default
	CScrollView::OnEraseBkgnd(pDC);
	//CBrush brush(GetSysColor( COLOR_WINDOW ) );
	CBrush brush(GetSysColor( COLOR_SCROLLBAR));
	//CBrush brush(GetSysColor( COLOR_BACKGROUND));
	FillOutsideRect(pDC,&brush);
	brush.DeleteObject();
	return TRUE;
}
//*******************************************************
void CZoomView::OnZoomToOrig() 
{
	RECT rect;
	GetClientRect(&rect);
	
	CPaintDC dc(this); // device context for painting
	OnPrepareDC(&dc);
	dc.DPtoLP(&rect);

	m_zoom=1;

	m_sizeTotal.cx=(int)(m_zoom*m_sizePage.cx*m_pages_x);
	m_sizeTotal.cy=(int)(m_zoom*m_sizePage.cy*m_pages_y);
	SetScrollSizes(MM_LOMETRIC, m_sizeTotal);
	Invalidate();	
}
//************************************************************
void CZoomView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CScrollView::OnMouseMove(nFlags, point);

	if((m_iZoomMode==ZOOM_RECT) && m_bLButtonDown)
	{
		CDC *pDC=GetDC();

		CRect r1; 
		r1.left=m_first_point.x;
		r1.top=m_first_point.y;
		r1.right=m_prev_drag_point.x;
		r1.bottom=m_prev_drag_point.y;
		r1.NormalizeRect();

		CRect r2; 
		r2.left=m_first_point.x;
		r2.top=m_first_point.y;
		r2.right=point.x;
		r2.bottom=point.y;
		r2.NormalizeRect();
		
		pDC->DrawFocusRect(r1);
		pDC->DrawFocusRect(r2);

		m_prev_drag_point=point;
	}
	else if((m_iZoomMode==ZOOM_PAN) && m_bLButtonDown)
	{
		CPaintDC dc(this); // device context for painting
		OnPrepareDC(&dc);
		
		POINT p1=point;
		POINT p2=m_prev_drag_point;

		dc.DPtoLP(&p1);
		dc.DPtoLP(&p2);


		CPoint p=GetScrollPosition();
		p.x+=(p2.x-p1.x);
		p.y+=(p2.y-p1.y);
		
		ScrollToPosition(p);
		
		m_prev_drag_point=point;
	}
	
}
//************************************************************
void CZoomView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CScrollView::OnLButtonDown(nFlags, point);

	m_bLButtonDown=true;
	if(m_iZoomMode==ZOOM_RECT)
	{
		m_first_point=point;
		m_prev_drag_point=point;
	}
	else if(m_iZoomMode==ZOOM_PAN)
	{
		m_first_point=point;
		m_prev_drag_point=point;
	}
}
//************************************************************
void CZoomView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CScrollView::OnLButtonUp(nFlags, point);

	m_bLButtonDown=false;

	if(m_iZoomMode==ZOOM_RECT)
	{
		m_iZoomMode=0;
		
		CRect rect;
		rect.left=m_first_point.x;
		rect.top=m_first_point.y;
		rect.right=point.x;
		rect.bottom=point.y;
		
		CRect rect1;
		rect1.left=m_first_point.x;
		rect1.top=m_first_point.y;
		rect1.right=point.x;
		rect1.bottom=point.y;

		rect.NormalizeRect();

		CPaintDC dc(this); // device context for painting
		OnPrepareDC(&dc);
		dc.DPtoLP(&rect);

		rect.left=(int)(rect.left/m_zoom);
		rect.top=(int)(-rect.top/m_zoom);
		rect.right=(int)(rect.right/m_zoom);
		rect.bottom=-(int)(rect.bottom/m_zoom);

		ZoomRect(rect);
	}
	else if(m_iZoomMode==ZOOM_PAN)
	{
		m_iZoomMode=0;
	}
	
}
//************************************************************


