// zoomtestView.h : interface of the CZoomView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_ZOOMTESTVIEW_H__BE241C2D_B319_413B_B6F3_6349CEE64A02__INCLUDED_)
#define AFX_ZOOMTESTVIEW_H__BE241C2D_B319_413B_B6F3_6349CEE64A02__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifdef APL_WORKFLOW_MGR
#define APL_WF_CLASS_EXPORT		_declspec(dllexport)
#else
#define APL_WF_CLASS_EXPORT		_declspec(dllimport)
#endif

class APL_WF_CLASS_EXPORT CZoomView : public CScrollView
{
protected: // create from serialization only
	CZoomView();
	DECLARE_DYNCREATE(CZoomView)

// Attributes
public:
	CDocument* GetDocument();

	int m_pages_x,m_pages_y;

	CSize m_sizeTotal;
	CSize m_sizePage;
	double m_zoom;

	int m_iZoomMode;
	bool m_bLButtonDown;
	POINT m_first_point;
	POINT m_prev_drag_point;

// Operations
public:
	void UpdateToNewZoom(double zoom, bool bInvalidate=true);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CZoomView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
	protected:
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CZoomView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	void ZoomRect(RECT &rect);

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CZoomView)
	afx_msg void OnZoomAll();
	afx_msg void OnZoomOut();
	afx_msg void OnZoomIn();
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnZoomToOrig();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnZoomRect();
	afx_msg void OnZoomPan();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in zoomtestView.cpp
inline CDocument* CZoomView::GetDocument()
   { return (CDocument*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ZOOMTESTVIEW_H__BE241C2D_B319_413B_B6F3_6349CEE64A02__INCLUDED_)
