// InternalView.cpp : implementation file
//

#include "stdafx.h"
#include "InternalView.h"
#include <aplPSS.h>

bool GetInstanceInfo(CaplAPI *m_api,CaplInstance *m_inst, CString &sInfo);


// CInternalView

IMPLEMENT_DYNCREATE(CInternalView, CEditView)

CInternalView::CInternalView()
{
	m_api=0;
	m_inst=0;
}

CInternalView::~CInternalView()
{
}

BEGIN_MESSAGE_MAP(CInternalView, CEditView)
	ON_WM_CREATE()
END_MESSAGE_MAP()

// CInternalView diagnostics

#ifdef _DEBUG
void CInternalView::AssertValid() const
{
	CEditView::AssertValid();
}

#ifndef _WIN32_WCE
void CInternalView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}
#endif
#endif //_DEBUG


// CInternalView message handlers

//***************************************************************************

int CInternalView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CEditView::OnCreate(lpCreateStruct) == -1) return -1;

	GetEditCtrl().ModifyStyle(0,ES_MULTILINE|ES_WANTRETURN);
	
	return 0;
}
//***************************************************************************

LRESULT CInternalView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	if(message==m_update_msg) 
	{ 
		if(wParam==APL_UPDATE_INST_ITEM ) 
		{ 
			CaplUpdateItem* item = (CaplUpdateItem*)lParam; 
			if(m_api != item->app->m_api) m_api = item->app->m_api; 
			UpdateTreeItem(item->inst); 
			return 0; 
		} 
		else if(wParam==APL_UPDATE_TREE_ITEM) 
		{ 
			int aaa=0;
			//CaplTreeItem* item = (CaplTreeItem*)lParam;
			//if(m_api != item->app->m_api) m_api = item->app->m_api; 
			//UpdateTreeItem(item); 
		} 
	} 
	else if(message==m_disconnect_msg)
	{
		//       

		return 0;
	}
	return CEditView::WindowProc(message, wParam, lParam);
}

//***************************************************************************

//        
//     instance  

void CInternalView::UpdateTreeItem(CaplInstance *inst4update)
{
	if(m_inst==inst4update) return; //   
	m_inst=inst4update;

	CEdit &edit=GetEditCtrl();

	edit.SetSel(0,-1);
	edit.ReplaceSel(_T(""));

	if(0==m_inst) return;

	CString sInfo;
	GetInstanceInfo(m_api, m_inst, sInfo);
	edit.SetSel(-1,-1);
	edit.ReplaceSel(sInfo);
}
