// aplQLQueryParse.cpp: implementation of the CaplQLQueryParse class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "aplQLQueryParse.h"
#include <aplSocketTransport.h>

extern CaplLog m_MainLog;

#define MY_THROW_QP(_err_code) {throw(SaplErrorDescription( _err_code,_T(__FILE__),_T(__DATE__),__LINE__,_T(""),4,_T("")));}


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CaplQLQueryParse::CaplQLQueryParse(CaplStepData *hStepData):
CaplQLQueryParseBase(hStepData)
{
}

void CaplQLQueryParse::LoadCurrUser()
{
	if(m_CurrUser != 0) 
		return;

	CaplNetStepData* data = (CaplNetStepData*)m_data;
	m_CurrUser = data->GetCurrUser();
	if(m_CurrUser != 0)
	{
		aplExtent ext;
		data->GetAttr(m_CurrUser, data->m_attr_apl_user__grop, ext);
		if(ext.GetSize() > 0)
			m_CurrUserGroupe = ext.GetAt(0);

		data->GetAttr(m_CurrUser, data->m_attr_apl_user__pers, m_CurrUserPerson);

	}
}

void CaplQLQueryParse::LoadTypeSrv()
{
	CString VerSrv;
	CaplNetStepData* data = (CaplNetStepData*)m_data;
	data->GetVersionServer(VerSrv, m_TypeSrv);
}


CaplInstance* CaplQLQueryParse::GetExistedInstById(apl_id id)
{
	CaplInstance* inst = 0;
	aplQFindInstIdInExtent(*((aplExtent*)(&m_data->instances)), id ,-1, true, &inst);
	if(inst == 0)
	{
		// ,    
		CaplLoadData ld( (CaplNetStepData*)m_data, DEF_SOURCE);
		ld.AddQuery( _T('a'), (long)id, (long)0, (long)0, true);
		bool old_hm =((CaplNetStepData*)m_data)->SetHideMode(true);
		ld.LoadEx(true, 0, 0, true);
		((CaplNetStepData*)m_data)->SetHideMode(old_hm);
		aplQFindInstIdInExtent(*((aplExtent*)(&m_data->instances)), id, -1 ,true, &inst);
	}
	if(inst != 0)
	{
		if(inst->GetType() == 0)
		{
			return 0;
		}
	}

	return inst;	
}

bool CaplQLQueryParse::LogMessage(LPCTSTR ErrDescr, bool is_warning, bool is_time, bool is_write, bool is_line,
						LPCTSTR funct, LPCTSTR class_info, LPCTSTR ExtDescr,
						LPCTSTR srs_file, LPCTSTR srs_date, DWORD srs_line)
{
	return m_MainLog.LogMessage(ErrDescr, is_warning, is_time, is_write, is_line, funct, class_info, ExtDescr, srs_file, srs_date, srs_line); 
}


