#ifndef CPING_H
#define CPING_H

#include "StdAfx.h"

typedef struct tagIPINFO
{
	u_char Ttl;				// Time To Live
	u_char Tos;				// Type Of Service
	u_char IPFlags;			// IP flags
	u_char OptSize;			// Size of options data
	u_char FAR *Options;	// Options data buffer
}IPINFO;

typedef IPINFO* PIPINFO;

typedef struct tagICMPECHO
{
	u_long Source;			// Source address
	u_long Status;			// IP status
	u_long RTTime;			// Round trip time in milliseconds
	u_short DataSize;		// Reply data size
	u_short Reserved;		// Unknown
	void FAR *pData;		// Reply data buffer
	IPINFO	ipInfo;			// Reply options
}ICMPECHO;

typedef ICMPECHO* PICMPECHO;

class CPing
{
public:
	CPing();
	virtual ~CPing();
	BOOL Ping(LPCTSTR strHost);
private:
	// ICMP.DLL Export Function Pointers
	HANDLE (WINAPI *pIcmpCreateFile)(VOID);
	BOOL (WINAPI *pIcmpCloseHandle)(HANDLE);
	DWORD (WINAPI *pIcmpSendEcho)
		(HANDLE,DWORD,LPVOID,WORD,PIPINFO,LPVOID,DWORD,DWORD);
	HANDLE hndlIcmp;			// LoadLibrary() handle to ICMP.DLL
	BOOL bValid; // if it doesn't construct properly, it won't be valid
};

//    ,        .      

//#define WINSOCK_VERSION 0x0101 //   1.1
#define NO_FLAGS 0 //   
//  RFC 792    ICMP
#define ICMP_ECHO 8 // An ICMP echo message
#define ICMP_ECHOREPLY 0 // An ICMP echo reply message
#define ICMP_HEADERSIZE 8 

struct ip //   IP
{
	BYTE ip_verlen; // Version and header length
	BYTE ip_tos; // Type of service
	WORD ip_len; // Total packet length 
	UINT ip_id; // Datagram identification 
	WORD ip_fragoff; // Fragment offset 
	BYTE ip_ttl; // Time to live 
	BYTE ip_proto; // Protocol
	UINT ip_chksum; // Checksum 
	IN_ADDR ip_src_addr; // Source address 
	IN_ADDR ip_dst_addr; // Destination address 
	BYTE ip_data[1]; // Variable length data area
};

struct icmp //   ICMP
{
	BYTE icmp_type; // Type of message
	BYTE icmp_code; // Type "sub code" (zero for echos)
	WORD icmp_cksum; // 1's complement checksum
	HANDLE icmp_id; // Unique ID (the instance handle)
	WORD icmp_seq; // Tracks multiple pings
	BYTE icmp_data[1]; // The start of optional data
};


#endif