// AutoUpdate.h


#ifndef APL_AUTOUDATE_IMPL
#ifdef _DEBUG
#ifdef UNICODE
#pragma comment (lib,"AutoUpdate_ud.lib")
#else
#pragma comment (lib,"AutoUpdate_d.lib")
#endif
#else
#ifdef UNICODE
#pragma comment (lib,"AutoUpdate_u.lib")
#else
#pragma comment (lib,"AutoUpdate.lib")
#endif
#endif
#endif



class CaplNetStepData;

class AFX_EXT_CLASS CaplAutoUpdate
{
protected:
	CString m_curpath;
	CString m_temp_dir;
public:
	BOOL m_AutoUpdate;
	BOOL m_bForceUpdate; //     
	long m_update_interval;
	CString m_module;
	CString m_folder;
	int m_source;
	CaplNetStepData* m_data;

public:
	CaplAutoUpdate (LPCTSTR module);
	bool LoadOptions();
	bool SetOptions();
	bool SaveOptions();
	bool Update(bool bChekTimeInterval, bool bShowAllMessage, bool bInteractive = true);
	bool CheckUpdate();
protected:
	bool UpdateFiles(bool bChekTimeInterval, bool bShowAllMessage, bool bInteractive = true);
	bool UpdateServer(bool bChekTimeInterval, bool bShowAllMessage, bool bInteractive = true);

	bool CheckFiles(bool bChekTimeInterval, bool bShowAllMessage, bool bInteractive, 
								CStringArray &modified_files, CStringArray &deleted_files, bool &has_exe);
	bool CheckFilesServer(bool bChekTimeInterval, bool bShowAllMessage, bool bInteractive, 
								CStringArray &modified_files, CStringArray &deleted_files, bool &has_exe);

	bool CheckCreateTemp();
	bool CheckNeedUpdate();
	bool CreateParamFiles(bool bInteractive, CStringArray &modified_files, CStringArray &deleted_files, bool has_exe);
	bool StartUpdate(bool bInteractive, bool has_exe);
};