// HtmlGen.h: interface for the CHtmlGen class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HTMLGEN_H__0B718F5F_5D07_47C9_B8AB_28990BE0BFA2__INCLUDED_)
#define AFX_HTMLGEN_H__0B718F5F_5D07_47C9_B8AB_28990BE0BFA2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "apl_gui.h"

#define HG_CREATE_FILE 1
#define HG_ADD_TO_FILE 2
#define HG_ALL_ITEMS 4
#define HG_VISIBLE_ITEMS 8
#define HG_SELECTED_ITEMS 16

class AFX_CLASS_EXPORT CHtmlGen  
{
public:
	static int CreateEmptyPS(CString file_name);
	static int CreateEmptyTitle(CString file_name);
	int AddParam(CString param, CString color=_T("#000000"), CString bkcolor=_T("#FFFFFF"));
	//-----------------------------------------------
	// -  -1      
	//  -2        
	int CreateTitle(CString params = APL_T("##;##;##;##;##;##;##;##;.N .; ; , ; ;.; ;; ();;. .;"));//  
	//      .  
	//   html      ( )
	//      :
	//     ;; ; ;..; ; ;
	//       ;+     ';'
	//         
	int AddRow(CString row=_T("1;2;3;4;5;6;7;8;9;"), COLORREF color=0);// 
	//       ';'
	int CreatePS(CString post_script=_T(""));// 
	//-----------------------------------------------
	BYTE m_items;//   
	BYTE m_rows;//   
	void SetDotName(CString file_name);//   
	bool SetFileName(CString file_name);//   
	char m_sep;//
	CHtmlGen(BYTE items = 17, BYTE rows = 9, CString dot_name = _T("table.htm"), CString file_name = _T("report.htm"), char sep = _T(';'));
	virtual ~CHtmlGen();
	CString m_file_name;//    report.htm
	CString m_dot_name;//    table.htm
	static int ReadHtmlToString(CString *html,CStdioFile &f);
	//  -  
	static CString GetBody(CString *html);
	//        <body>...</body>
	static int WriteStrToFile(LPCTSTR html,CString fname,BYTE flag = HG_CREATE_FILE);
	//   
	/**HG_VISIBLE_ITEMS -      .      HG_ALL_ITEMS
	   HG_ALL_ITEMS -   .      HG_VISIBLE_ITEMS
	   HG_CREATEFILE -    .      HG_ADD_TO_FILE
	   HG_ADD_TO_FILE -         .      HG_CREATE_FILE*/
	static bool GenerateByListCtrl(CListCtrl *ListCtrl, CString m_file_name=_T("report.html"), BYTE flag = HG_VISIBLE_ITEMS | HG_CREATE_FILE, CUIntArray *h_cols = 0);
	//      .    .
	static bool GenerateByListCtrl(CaplTreeListCtrl *ListCtrl, CString m_file_name=_T("report.html"), BYTE flag = HG_VISIBLE_ITEMS | HG_CREATE_FILE, CUIntArray *h_cols = 0);
	//     TreeListCtrl.    .
private:
	static bool AppendItem2Html(CaplTreeListCtrl *ListCtrl,HTREEITEM hItem, CString &html, bool bSelectdOnly, bool bOnlyWithData, int level, CUIntArray *h_cols);
	static bool AddAllRows(CaplTreeListCtrl *ListCtrl, CString &str, HTREEITEM parent, int cols, CUIntArray *h_cols = 0);
	inline CString GetNextString(CString &str);
	CStdioFile m_of;// . 
	CStdioFile m_rf;// . 
	int add_row;
	DWORD m_pos;
	DWORD cur_pos;
};

#endif // !defined(AFX_HTMLGEN_H__0B718F5F_5D07_47C9_B8AB_28990BE0BFA2__INCLUDED_)
