// MenuComboBox.cpp : implementation file
//

#include "stdafx.h"
#include "apl_gui.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMenuComboBox

CMenuComboBox::CMenuComboBox()
{
	m_SelText=_T("");
	m_SelId=0;
	m_ButtonPushed=false;
	m_ShowTollTip=false;
	m_Font = NULL;
	m_ReadOnly=false;
}

CMenuComboBox::~CMenuComboBox()
{
	if(m_Font!=0) delete m_Font;
}

BEGIN_MESSAGE_MAP(CMenuComboBox, CStatic)
	//{{AFX_MSG_MAP(CMenuComboBox)
	ON_WM_PAINT()
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMenuComboBox message handlers
//**************************************************************
void CMenuComboBox::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	// TODO: Add your message handler code here
	CFont * pfNewFont, * pfOldFont;
	pfNewFont = NULL;
	pfOldFont = NULL;
	RECT rect;
	GetClientRect(&rect);
	m_ButtonRect=rect;
	int cy=rect.bottom-rect.top;
	m_ButtonRect.left=m_ButtonRect.right-cy;
	rect.right-=cy;
	UINT state=DFCS_SCROLLRIGHT;
	if(m_ButtonPushed)state|=DFCS_PUSHED;
	dc.FillSolidRect(&rect,GetSysColor(COLOR_WINDOW));
	rect.left+=2;
	UINT style=DT_LEFT|DT_VCENTER|DT_SINGLELINE|DT_EXTERNALLEADING;
	if(m_ShowTollTip) 
		style|=DT_NOCLIP;
	dc.DrawFrameControl(&m_ButtonRect,DFC_SCROLL,state);
	
	if (m_Font != NULL) pfOldFont = (CFont *)dc.SelectObject(m_Font);
	dc.DrawText(m_SelText,&rect,style);
	if (m_Font != NULL) dc.SelectObject(pfOldFont);
	m_FullTextWidth=rect.right+4;
	// Do not call CStatic::OnPaint() for painting messages
}

//**************************************************************
void CMenuComboBox::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if(!m_ButtonPushed)
		if(PtInRect(&m_ButtonRect,POINT(point)))
		{
			if(m_ReadOnly) return;
			m_ButtonPushed=true;
			RECT rect;
			BOOL rez;
			int i;
			GetWindowRect(&rect);
			RedrawWindow();

			CMenu menu;
			CreateMenu(menu);
			rez=menu.TrackPopupMenu(TPM_LEFTALIGN|TPM_RETURNCMD|TPM_NONOTIFY|TPM_RIGHTBUTTON,
				rect.right-2,rect.top,this);
			//CString aaa;
			//aaa.Format("res=%i",rez);
			//AfxMessageBox(aaa);

			//  
			/*bool notfound=true;
			
			for(i=0;i<m_ItemArray.GetSize();i++)
				if(m_ItemArray[i].id==rez)
				{
					notfound=false;
					m_SelText=m_ItemArray[i].text;
					m_SelId=rez;
					break;
				}
			if(notfound) AfxMessageBox(" not found"); else AfxMessageBox("found");
			*/
			if((rez>0)&&(rez<=m_ItemArray.GetSize()))
			{
					m_SelText=m_ItemArray[rez-1].text;
					m_SelId=m_ItemArray[rez-1].id;
			}
			m_ButtonPushed=false;
			RedrawWindow();

			//   
			for(i=0;i<m_ItemArray.GetSize();i++)
				if(m_ItemArray[i].id!=0)
					if(m_ItemArray[i].menu!=0)
					{
						delete m_ItemArray[i].menu;
						m_ItemArray[i].menu=0;;
					}
		}
	CStatic::OnLButtonDown(nFlags, point);
}
//**************************************************************
void CMenuComboBox::CreateMenu(CMenu & menu)
{
	int i,j,k;
	UINT nFlags=0,nIDNewItem=0;
	menu.CreatePopupMenu();
	
	//   
	for(i=0;i<m_ItemArray.GetSize();i++)
	{
		if(m_ItemArray[i].id==0)
			m_ItemArray[i].menu=&menu;
	}

	//           
	for(i=0;i<m_ItemRelations.GetSize();i++)
	{
		k=m_ItemRelations[i].in;
		if(m_ItemArray[k].menu==0)
		{
			m_ItemArray[k].menu=new CMenu;
			m_ItemArray[k].menu->CreatePopupMenu();
		}
	}
	
	//   
	for(i=0;i<m_ItemArray.GetSize();i++)
	{
		
		if(m_ItemArray[i].menu==0)
		{
			nFlags=MF_STRING;
			nIDNewItem=i+1;//m_ItemArray[i].id;
		}
		else
		{
			nFlags=MF_POPUP;
			nIDNewItem=(UINT)(m_ItemArray[i].menu->m_hMenu);
		}

		if(!m_ItemArray[i].can_select)
			if(m_ItemArray[i].menu==0)
				nFlags|=MF_GRAYED;

		bool is_Added=false;

		for(j=0;j<m_ItemRelations.GetSize();j++)
		{
			if(m_ItemRelations[j].out==i)
			{
				is_Added=true;
				m_ItemArray[m_ItemRelations[j].in].menu->AppendMenu
					(nFlags,nIDNewItem,m_ItemArray[i].text);
//				CString aaa;aaa.Format("1   %s  ->   %i (%i)",m_ItemArray[i].text,nIDNewItem,
//					((CaplInstance*)nIDNewItem)->id);
//				CString aaa;aaa.Format("1   %s  ->   %i ",m_ItemArray[i].text,nIDNewItem);
//				AfxMessageBox(aaa);

			}
		}
		if(!is_Added)
			if(m_ItemArray[i].id!=0)
			{
				//CString aaa;aaa.Format("2  %s  ->   %i",m_ItemArray[i].text,nIDNewItem);
				//AfxMessageBox(aaa);
				menu.AppendMenu(nFlags,nIDNewItem,m_ItemArray[i].text);
			}
	}
	
	/*
	CMenu *menu1=new CMenu;
	menu1->CreatePopupMenu();
	menu1->AppendMenu(MF_STRING,1,"1");
	menu1->AppendMenu(MF_STRING,2,"2");
	menu1->AppendMenu(MF_STRING,3,"3");

	menu.AppendMenu(MF_STRING,1,"111");
	menu.AppendMenu(MF_STRING,2,"112");
	menu.AppendMenu(MF_STRING,3,"1113");
	menu.AppendMenu(MF_POPUP,(UINT)(menu1->m_hMenu),"submenu");
	menu1->AppendMenu(MF_POPUP,(UINT)(menu.m_hMenu),"submenu");
	*/
}
//**************************************************************
long CMenuComboBox::AddItem(long id, LPCTSTR text, long parent, bool can_select)
{
	int i,in=-1,out=-1;
	for(i=0;i<m_ItemArray.GetSize();i++)
	{
		if(m_ItemArray[i].id==id) out=i;
		if(m_ItemArray[i].id==parent) in=i;
	}

	if(out==-1)
	{
		MenuComboBoxItem newitem;
		newitem.id=id;
		newitem.text=text;
		newitem.menu=0;
		newitem.can_select=can_select;
		out=m_ItemArray.Add(newitem);
	}
	else m_ItemArray[out].text=text;

	if(parent ==-1)return in;

	if(in==-1)
	{
		MenuComboBoxItem newitem;
		newitem.id=parent;
		newitem.text=_T("");
		newitem.menu=0;
		in=m_ItemArray.Add(newitem);
	}
	MenuComboBoxItemRelation relation;
	relation.in=in;
	relation.out=out;
	m_ItemRelations.Add(relation);
	return in;
}
//**************************************************************
bool CMenuComboBox::AddItemsRelation(long in, long out)
{
	int i,index_in=-1,index_out=-1;
	for(i=0;i<m_ItemArray.GetSize();i++)
	{
		if(m_ItemArray[i].id==in) index_in=i;
		if(m_ItemArray[i].id==out) index_out=i;
	}
	if(index_in==-1) return false;
	if(index_out==-1) return false;

	MenuComboBoxItemRelation relation;
	relation.in=index_in;
	relation.out=index_out;
	m_ItemRelations.Add(relation);
	return true;
}
//**************************************************************

void CMenuComboBox::Clear()
{
	m_ItemRelations.RemoveAll();
	m_ItemArray.RemoveAll();
}
//**************************************************************

LPCTSTR CMenuComboBox::GetSelText(){return (LPCTSTR)m_SelText;}

long CMenuComboBox::GetSelId(){return m_SelId;}

//**************************************************************

void CMenuComboBox::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	CRect rect;
	GetClientRect(&rect);
	rect.DeflateRect(5,5,0,5);
	rect.right=m_ButtonRect.left;
	if(rect.PtInRect(point))
	{
		if(!m_ShowTollTip)
		{
			// 
			m_ShowTollTip=true;
			RedrawWindow();
		}
	}else
	{
		if(m_ShowTollTip)
		{
			m_ShowTollTip=false;
			CRect rect;
			GetWindowRect(rect);
			if(m_FullTextWidth > rect.Width())
			{
				rect.right=rect.left+m_FullTextWidth;
				GetParent()->ScreenToClient(rect);
				GetParent()->InvalidateRect(rect);
				GetParent()->UpdateWindow();
			}
			else if(m_FullTextWidth > m_ButtonRect.left)
					RedrawWindow();
		}
	}
	CStatic::OnMouseMove(nFlags, point);
}

bool CMenuComboBox::SetSelID(long nID)
{
	int i;
	for(i = 0; i < m_ItemArray.GetSize(); i++)
		if(m_ItemArray[i].id == nID)
		{
			m_SelText = m_ItemArray[i].text;
			m_SelId = nID;
			return true;
		}
	return false;
}

bool CMenuComboBox::SetReadOnly( bool bReadOnly)
{
	bool k=m_ReadOnly;
	m_ReadOnly=bReadOnly;
	return k;
}

void CMenuComboBox::LoadFontFromWnd(CWnd *wnd)
{
	if(wnd==0) {if(m_Font!=0) delete m_Font; m_Font=0; return;}
	if(m_Font==0)m_Font=new CFont();

	CFont * pFont = wnd->GetFont();
	if(pFont!=0)
	{
		LOGFONT logfont;
		pFont->GetLogFont(&logfont);
		m_Font->CreateFontIndirect(&logfont);
	} 
	else {delete m_Font; m_Font=0;}
}
