// aplToolBar.cpp : implementation file
//

#include "stdafx.h"
#include "apl_gui.h"


// CaplToolBar

IMPLEMENT_DYNAMIC(CaplToolBar, CToolBar)

CaplToolBar::CaplToolBar()
{

}

CaplToolBar::~CaplToolBar()
{
}


BEGIN_MESSAGE_MAP(CaplToolBar, CToolBar)
	ON_WM_DRAWITEM()
	ON_WM_PAINT()
//	ON_WM_NCPAINT()
//	ON_WM_ERASEBKGND()
	ON_NOTIFY_EX(TTN_NEEDTEXT, 0, &CaplToolBar::OnTtnNeedText)
END_MESSAGE_MAP()



// CaplToolBar message handlers




void CaplToolBar::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	// TODO: Add your message handler code here
	// Do not call CToolBar::OnPaint() for painting messages

	CToolBarCtrl &tbctrl=GetToolBarCtrl(); 
	int img,i,k=tbctrl.GetButtonCount();
	UINT id,style;
	RECT rect;

	//  

	CWnd *parwnd=GetParent();
	if(parwnd!=0)
	{
		if(!parwnd->IsKindOf(RUNTIME_CLASS(CReBar)))
		{
			GetWindowRect(&rect);
			rect.right-=rect.left;
			rect.left=0;
			rect.bottom-=rect.top;
			rect.top=0;
			dc.FillSolidRect(&rect,CaplUIColors::m_color_bk_no_sel);
		}
	}

	CImageList *il=0;
	il=tbctrl.GetImageList( );
	IMAGEINFO ii;
	il->GetImageInfo(0,&ii);
	int icon_cx=ii.rcImage.right-ii.rcImage.left;
	int icon_cy=ii.rcImage.bottom-ii.rcImage.top;

	TBBUTTONINFO btninfo;
	btninfo.cbSize=sizeof(TBBUTTONINFO);
	btninfo.dwMask=TBIF_SIZE|TBIF_STATE;

	int hotitem=tbctrl.GetHotItem();

	for(i=0;i<k;i++)
	{
		GetButtonInfo(i,id,style,img);

		GetItemRect(i,&rect);

		if(style&  TBBS_SEPARATOR)
		{
			int dx=rect.right-rect.left;
			if(dx>10) continue; //         (  6)
			int x=(rect.right+rect.left)/2;
			dc.Draw3dRect(x,rect.top+1,2,rect.bottom-rect.top-2,RGB(128,128,128),RGB(255,255,255));
			continue;
		}

		DWORD drawstyle=ILD_NORMAL|ILD_TRANSPARENT;

		DWORD state=tbctrl.GetState(id);
		if(state&TBSTATE_HIDDEN) continue;

		int dx=(rect.right-rect.left-icon_cx)/2;
		int dy=(rect.bottom-rect.top-icon_cy)/2;
		POINT pt; pt.x=rect.left+dx, pt.y=rect.top+dy;

		if(state&TBSTATE_ENABLED)il=tbctrl.GetImageList();
		else il=tbctrl.GetDisabledImageList();

		if(tbctrl.IsButtonChecked(id))
		{
			il=tbctrl.GetHotImageList();
			if(il==0) il=tbctrl.GetImageList();

			RECT r1;
			r1.left=rect.left;
			r1.top=rect.top;
			r1.bottom=rect.bottom-1;
			r1.right=rect.right-1;
			dc.FillSolidRect(&r1,CaplUIColors::m_color_bk_hotlite);
			dc.Draw3dRect(&rect,RGB(128,128,128),RGB(255,255,255));
			pt.x++; pt.y++;
			//dc.Draw3dRect(&rect,RGB(255,0,0),RGB(255,0,0));
		}

		if(state&TBSTATE_INDETERMINATE) il=tbctrl.GetDisabledImageList();
	  	else if(tbctrl.IsButtonPressed(id))
		{
			il=tbctrl.GetHotImageList();
			if(il==0) il=tbctrl.GetImageList();
			dc.FillSolidRect(&rect,CaplUIColors::m_color_bk_hotlite);
			dc.Draw3dRect(&rect,RGB(128,128,128),RGB(255,255,255));
			pt.x++; pt.y++;
		}
		else if(i==hotitem)
		{
			il=tbctrl.GetHotImageList();
			if(il==0) il=tbctrl.GetImageList();
			RECT r1;
			r1.left=rect.left;
			r1.top=rect.top;
			r1.bottom=rect.bottom-1;
			r1.right=rect.right-1;

			dc.FillSolidRect(&r1,CaplUIColors::m_color_bk_hotlite);
			dc.Draw3dRect(&r1,CaplUIColors::m_color_ramka_sel,CaplUIColors::m_color_ramka_sel);
		}


		if(il==0) //   
		{
			il = tbctrl.GetImageList();
			drawstyle=ILD_MASK|ILD_TRANSPARENT;
		}

		COLORREF oldcolor=dc.SetTextColor(RGB(128,128,128));

		il->Draw(&dc,img,pt,drawstyle);
		dc.SetTextColor(oldcolor);
	}
}

BOOL CaplToolBar::LoadToolBar(UINT nIDResource)
{
	BOOL bRet = __super::LoadToolBar(nIDResource);

	TranslateToolbar();

	return bRet;
}

BOOL CaplToolBar::LoadToolBar(LPCTSTR lpszResourceName)
{
	BOOL bRet = __super::LoadToolBar(lpszResourceName);

	TranslateToolbar();

	return bRet;
}

void CaplToolBar::TranslateToolbar()
{
	if (CaplTranslate::IsNeedTranslate())
	{
		CString sText;

		//   
		CToolBarCtrl &tbCtrl = GetToolBarCtrl();
		for(int i=0; i<tbCtrl.GetButtonCount(); ++i)
		{
			sText = GetButtonText(i);
			if (!sText.IsEmpty())
				SetButtonText(i, CaplTranslate::Translate(sText));
		}
	}
}

BOOL CaplToolBar::OnTtnNeedText(UINT id, NMHDR * pNMHDR, LRESULT * pResult)
{
	TOOLTIPTEXT *pTTT = (TOOLTIPTEXT *)pNMHDR;
	UINT nID = pNMHDR->idFrom;

	if (pTTT->uFlags & TTF_IDISHWND)
	{
		nID = ::GetDlgCtrlID((HWND)nID);
	}

	if (nID)
	{
		CString tooltip_text;
		tooltip_text.LoadString(nID);

		// 
		if (CaplTranslate::IsNeedTranslate())
			tooltip_text = CaplTranslate::Translate(tooltip_text);

		//      \n,    -     ,
		//      -    
		int iSep = -1;
		for(int i=tooltip_text.GetLength()-1; i>-1; --i)
		{
			if (tooltip_text[i]==_T('\n'))
			{
				iSep = i;
				break;
			}
		}
		//   
		if (iSep>-1)
			tooltip_text = tooltip_text.Right(tooltip_text.GetLength()-iSep-1);

		//     
		_strncpy(pTTT->szText, tooltip_text.GetBuffer(), 79);
		pTTT->szText[79] = _T('\0');

		return TRUE;
	}

	return FALSE;
}