// CaplLB_Combobox.cpp : implementation file
//

#include "stdafx.h"
#include "aplguiex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CaplLB_Combobox
IMPLEMENT_DYNAMIC(CaplLB_Combobox, CComboBox)

CaplLB_Combobox::CaplLB_Combobox()
{
}

CaplLB_Combobox::~CaplLB_Combobox()
{
}


BEGIN_MESSAGE_MAP(CaplLB_Combobox, CComboBox)
	//{{AFX_MSG_MAP(CaplLB_Combobox)
	ON_CONTROL_REFLECT(CBN_KILLFOCUS, OnKillfocus)
	ON_CONTROL_REFLECT(CBN_SELCHANGE, OnSelchange)
	ON_WM_LBUTTONDOWN()
	ON_CONTROL_REFLECT(CBN_DROPDOWN, OnDropDown)
	ON_CONTROL_REFLECT(CBN_CLOSEUP, OnCloseUp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CaplLB_Combobox message handlers

void CaplLB_Combobox::OnKillfocus() 
{
	if(GetDroppedState())
	{
		CWnd* parent = GetParent();
		if (parent)
			parent->SetFocus();	
	}
	else
	{
		ReleaseCapture();
	}
}

void CaplLB_Combobox::OnSelchange()
{
	CWnd* parent = GetParent();

	if (parent)
	{
		NMHDR nmHDR;
		memset(&nmHDR, 0, sizeof(NMHDR));
		nmHDR.idFrom = GetDlgCtrlID();
		nmHDR.hwndFrom = m_hWnd;
		nmHDR.code = APL_LC_CBN_SELCHANGE;
		
		parent->SendMessage(WM_NOTIFY, parent->GetDlgCtrlID(), (LPARAM)&nmHDR);
	}
}

void CaplLB_Combobox::OnLButtonDown(UINT nFlags, CPoint point)
{
	CPoint pt(point);
	CRect rect;
	GetWindowRect(rect);
	ClientToScreen(&pt);
	if(!rect.PtInRect(pt))
	{
		CaplListCtrl *pList = (CaplListCtrl*)GetParent();
		if(pList)
		{
			if(::IsWindow(pList->m_hWnd))
			{
				if(pList->EndEdit() && !pList->m_sErrorText.IsEmpty())
				{
					SetCapture();
					return;
				}
				ReleaseCapture();
			}
		}
	}
 	else
 		CComboBox::OnLButtonDown(nFlags, point);
}

void CaplLB_Combobox::OnDropDown()
{
	ReleaseCapture();
}

void CaplLB_Combobox::OnCloseUp()
{
	SetCapture();
	SetFocus();
}