// CaplLB_Edit.cpp : implementation file
//

#include "stdafx.h"
#include "AplGuiEx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CaplLB_Edit
IMPLEMENT_DYNAMIC(CaplLB_Edit, CEdit)

CaplLB_Edit::CaplLB_Edit()
{
}

CaplLB_Edit::~CaplLB_Edit()
{
}


BEGIN_MESSAGE_MAP(CaplLB_Edit, CEdit)
	//{{AFX_MSG_MAP(CaplLB_Edit)
	ON_CONTROL_REFLECT(EN_KILLFOCUS, OnKillfocus)
	ON_WM_KEYDOWN()
	ON_WM_CHAR()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CaplLB_Edit message handlers

void CaplLB_Edit::OnKillfocus() 
{
	CWnd* parent = GetParent();
	if(parent)
		parent->SetFocus();	
}

void CaplLB_Edit::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if(nChar==VK_RETURN)
	{
		CWnd* parent = GetParent();
		if(parent)
			parent->SetFocus();

		return; //   -
	}
	else if(nChar==VK_ESCAPE)
	{
		CWnd* parent = GetParent();
		if(parent)
		{
			if(parent->IsKindOf(RUNTIME_CLASS(CaplListCtrl)))
			{
				((CaplListCtrl*)parent)->EndEdit(false);
			}
		}
		return;
	}
	
	CEdit::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CaplLB_Edit::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if(nChar == VK_RETURN)
		return; //   -
	else if(nChar==VK_ESCAPE)
	{
		return;
	}
	
	CEdit::OnChar(nChar, nRepCnt, nFlags);
}

void CaplLB_Edit::OnLButtonDown(UINT nFlags, CPoint point)
{
	CPoint pt(point);
	CRect rect;
	GetWindowRect(rect);
	ClientToScreen(&pt);
	if(!rect.PtInRect(pt))
	{
		CaplListCtrl *pList = (CaplListCtrl*)GetParent();
		if(pList)
		{
			if(::IsWindow(pList->m_hWnd))
			{
				if(pList->EndEdit() && !pList->m_sErrorText.IsEmpty())
				{
					SetCapture();
					return;
				}
				ReleaseCapture();
			}
		}
	}
	else
		CEdit::OnLButtonDown(nFlags, point);
}
