// aplpacket.h: interface for the CaplPacket class.
//
//////////////////////////////////////////////////////////////////////
#ifndef AFX_APLapl_packet_H__D13DB883_42AD_48CC_9E77_6416CCB5EDBD__INCLUDED_
#define AFX_APLapl_packet_H__D13DB883_42AD_48CC_9E77_6416CCB5EDBD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "StdAfx.h"
#include <apl_gui.h>
#include <aplCryptManager.h>


#ifdef APL_WIN_ETD_EXPIMP
#define APL_WIN_ETD_CLASS_EXPORT __declspec(dllexport)
#else
#define APL_WIN_ETD_CLASS_EXPORT __declspec(dllimport)
#ifdef _DEBUG
#ifdef UNICODE
#pragma comment (lib,"apl_packet_ud.lib")
#else
#pragma comment (lib,"apl_packet_d.lib")
#endif
#else
#ifdef UNICODE
#pragma comment (lib,"apl_packet_u.lib")
#else
#pragma comment (lib,"apl_packet.lib")
#endif
#endif
#endif

#define APL_WIN_ETD	"ETD BIN "					//          ANSI
#define APL_WIN_ETD_VER	"1.0"					//          ANSI
#define APL_WIN_ETD_HEADER "<ETD BIN 1.0>"		//          ANSI

#define APL_WIN_ETD_U	"ETD BINu"				//          ANSI
#define APL_WIN_ETD_HEADER_U "<ETD BINu1.0>"	//          ANSI

//
#define APL_LOAD_DATASETSIGN_FROM_BUF_ERROR		1
#define APL_LOAD_DATASETSIGN_FROM_FILE_ERROR	2
#define APL_SAVE_DATASETSIGN_TO_FILE_ERROR		3
#define APL_SAVE_DATASETSIGN_TO_BUF_ERROR		4
#define APL_LOAD_DATASETPARAM_FROM_BUF_ERROR	5
#define APL_LOAD_DATASETPARAM_FROM_FILE_ERROR	6
#define APL_SAVE_DATASETPARAM_TO_FILE_ERROR		7
#define APL_SAVE_DATASETPARAM_TO_BUF_ERROR		8
#define APL_LOAD_FOLDERDATASET_FROM_FILE_ERROR	9
#define APL_SAVE_FOLDERDATASET_TO_FILE_ERROR	10
#define APL_LOAD_FILERDATASET_FROM_FILE_ERROR	11
#define APL_SAVE_FILERDATASET_TO_FILE_ERROR		12
#define APL_LOAD_PACKET_FROM_FILE_ERROR			13
#define APL_SAVE_PACKET_TO_FILE_ERROR			14
#define APL_UNKNOWN_FILE_FORMAT					15
#define APL_CRC32_ERROR							16
#define APL_INCORRECT_FILE_VERSION				17
#define APL_INCOMPATIBLE_FILE_FORMAT			18
#define APL_UNKNOWN_ERROR						19



class CaplPacket;
class CaplCryptographicManager;
class CaplSignBuf;

class APL_WIN_ETD_CLASS_EXPORT CBinaryFile : public CFile
{
protected:
	//    ansi (true)  unicode (false)
	bool m_bANSI;

public:
	CBinaryFile(bool bANSI = true);

	bool Read(CString &str);
	bool Read(UINT32 &i);
	bool Read(TCHAR& c);
	BYTE Read();

	void Write(CString str);
	void Write(UINT32 i);
	void Write(char c);
	void Write(wchar_t wc);

	bool WriteFromFile(LPCTSTR sFileName);  //       

	bool WriteToFile(LPCTSTR sFileName, UINT nCount);  //      (nCount )

	virtual void Write( const void* lpBuf, UINT nCount ){CFile::Write(lpBuf, nCount);};
	virtual UINT Read(void *lpBuf, UINT nCount)	{return CFile::Read(lpBuf, nCount);};

	bool IsANSI() { return m_bANSI; }
	void SetANSI(bool bANSI) { m_bANSI = bANSI; }
};

class APL_WIN_ETD_CLASS_EXPORT CDataSetParam
{
protected:
	//    ansi (true)  unicode (false)
	bool m_bANSI;

public:
	CDataSetParam(LPCTSTR sName, LPCTSTR sValue, bool bANSI = true);
	CDataSetParam();
	virtual ~CDataSetParam();

	CString		m_sName;
	CString		m_sValue;

	bool Load(CBinaryFile &file);
	bool Save(CBinaryFile &file);
	UINT64 GetBufSize(bool bUseAdditionalParam = true);
	bool SaveToBuf(CaplSignBuf &signBuf, bool bUseAdditionalParam = true);
	virtual bool LoadFromBuf(BYTE *pBuf, int &index);

	bool IsANSI() { return m_bANSI; }
	void SetANSI(bool bANSI) { m_bANSI = bANSI; }
};

class APL_WIN_ETD_CLASS_EXPORT CDataSet
{
protected:
	CaplPacket	*m_pPacket;

	//    ansi (true)  unicode (false)
	bool m_bANSI;

public:
	HTREEITEM	m_item;//    WinETD    !!!

	CDataSet(CaplPacket *pPacket, CDataSet *pParent = NULL, bool bANSI = true);
	virtual ~CDataSet();

	CArray<CDataSetParam*, CDataSetParam*>	m_Parametrs;
	CString		m_sName;
	CString		m_sCompress_method;
	CString		m_sCrypt_method;

	CDataSet*	m_pParent;

	virtual void Clear();
	virtual bool Load(CBinaryFile &file){return false;};
	virtual bool Save(CBinaryFile &file){return false;};
	virtual UINT64 GetBufSize(bool bUseAdditionalParam = true){return 0;};
	virtual bool SaveToBuf(CaplSignBuf &signBuf, bool bUseAdditionalParam = true){return false;};
	virtual bool LoadFromBuf(BYTE *pBuf, int &index){return false;};
	virtual bool IsFolder(){return false;};
	virtual bool View(CString &sPathName, HANDLE &hProc){return false;};
	virtual bool SaveFiles(LPCTSTR lpszPathName = NULL){return false;};
	virtual bool LoadItem(LPCTSTR lpszPath, bool addFileParam = true){return false;};	

	int CheckSigns(bool bShowMessages);
	bool GetParamValueBN(LPCTSTR lpName, CString &sValue);
	bool SetParamValueBN(LPCTSTR lpName, LPCTSTR sValue);

	bool IsANSI() { return m_bANSI; }
	void SetANSI(bool bANSI);
};

class APL_WIN_ETD_CLASS_EXPORT CFolderDataSet : public CDataSet
{
public:
	CFolderDataSet(CaplPacket *pPacket, CDataSet *pParent = NULL, bool bANSI = true);
	virtual ~CFolderDataSet();

	CArray<CDataSet*, CDataSet*>	m_Content;

	virtual void Clear();
	virtual bool Load(CBinaryFile &file);
	virtual bool Save(CBinaryFile &file);
	virtual bool IsFolder(){return true;};
	virtual bool LoadItem(LPCTSTR lpszPath, bool addFileParam = true);
	virtual UINT64 GetBufSize(bool bUseAdditionalParam = true);
	virtual bool SaveToBuf(CaplSignBuf &signBuf, bool bUseAdditionalParam = true);
	virtual bool LoadFromBuf(BYTE *pBuf, int &index);
	virtual bool SaveFiles(LPCTSTR lpszPathName = NULL);
};

class APL_WIN_ETD_CLASS_EXPORT CFileDataSet : public CDataSet
{
public:
	CFileDataSet(CaplPacket *pPacket, CDataSet *pParent = NULL, bool bANSI = true);
	virtual ~CFileDataSet();

	char*	m_pData;   //        ,  m_DataSize>0
	UINT32	m_DataSize;

	//      ,    .
	
	CString m_sTempDataFile; //      
	
	virtual void Clear();
	virtual bool Load(CBinaryFile &file);
	virtual bool Save(CBinaryFile &file);
	virtual bool View(CString &sPathName, HANDLE &hProc);
	virtual bool LoadItem(LPCTSTR lpszPath, bool addFileParam = true);
	virtual UINT64 GetBufSize(bool bUseAdditionalParam = true);
	virtual bool SaveToBuf(CaplSignBuf &signBuf, bool bUseAdditionalParam = true); //     
	virtual bool LoadFromBuf(BYTE *pBuf, int &index);
	virtual bool SaveFiles(LPCTSTR lpszPathName = NULL);	
	virtual bool SaveContentToFile(LPCTSTR lpszPathName); //    . lpszPathName    
};

class APL_WIN_ETD_CLASS_EXPORT CSignSert
{
protected:
	CaplPacket	*m_pPacket;
public:
	CSignSert(CaplPacket	*pPacket);
	virtual ~CSignSert();

	CString m_sPersonName;
	CString m_sCertBS;
	CString m_sCertSN;	

	virtual bool Load(CBinaryFile &file);
	virtual void Save(CBinaryFile &file);
	virtual UINT64 GetBufSize(bool bUseAdditionalParam = true);
	virtual bool SaveToBuf(CaplSignBuf &signBuf, bool bUseAdditionalParam = true);
	virtual bool LoadFromBuf(BYTE *pBuf, int &index);
};

class APL_WIN_ETD_CLASS_EXPORT CDataSetSign
{
protected:
	CaplPacket	*m_pPacket;
public:
	CDataSetSign(CaplPacket *pPacket);
	~CDataSetSign();
	
	CDataSet	*m_pDataSet;
	CSignSert	*m_pSertificate;
	
	CString		m_sStatus;
	CString		m_sRole;
	CString		m_sDate;
	CString		m_sComment;
	
	CString		m_sHashSystem;
	CString		m_sHashBS;
	
	CString		m_sSignSystem;
	CString		m_sSignBS;

	bool		m_bNewSign;

	bool Load(CBinaryFile &file, int ds_offset = 0, int sert_offset = 0);
	bool Save(CBinaryFile &file);
	virtual UINT64 GetBufSize(bool bUseAdditionalParam = true);
	virtual bool SaveToBuf(CaplSignBuf &signBuf, bool bUseAdditionalParam = true);
	virtual bool LoadFromBuf(BYTE *pBuf, int &index, int ds_offset = 0, int sert_offset = 0);
};

class APL_WIN_ETD_CLASS_EXPORT CaplPacket  
{
	friend class CDataSet;
	friend class CFolderDataSet;
	friend class CFileDataSet;
	friend class CDataSetSign;
protected:
	CArray<CDataSet*, CDataSet*>	m_DataSets;

	//    ansi (true)  unicode (false)
	bool m_global_ansi_string;

public:
	void Clear();
	CaplPacket();
	virtual ~CaplPacket();

	UINT Load(LPCTSTR lpszPathName);
	bool Save(LPCTSTR lpszPathName);
	bool SaveAsFiles(LPCTSTR lpszPathName, CStringArray *sFiles);
	int CheckSigns(bool bShowMessages);
	int GetDSCount() {return m_DataSets.GetSize();};

	CDataSet	*m_pRootDataSet;
	CString		m_sId;
	CString		m_sDescr;
	CString		m_sProviderCode;
	CString		m_sLoadState;

	CArray<CSignSert*, CSignSert*>	m_Sertificates;
	CArray<CDataSetSign*,CDataSetSign*> m_DataSetSigns;

	bool IsANSI() { return m_global_ansi_string; }
	void SetANSI(bool bANSI);
};


//       
//            
//            
// (      
//    ,      ,
//       .

class APL_WIN_ETD_CLASS_EXPORT CaplSignBuf
{
public:
	CaplSignBuf();
	virtual ~CaplSignBuf();
	void Clear();  //  

	//     
	UINT32 GetDataSize(); //   ,    ,  0,   
	BYTE *GetData();     //        

	UINT64 GetAllDataSize(); //    

	//    
	bool Add(char c);   //    
	bool Add(UINT32 i); //    
	bool Add(CString &str,  bool bANSI = true);  //    

	//inline bool Add(int i){return Add((UINT32)i);};  

	bool Add(BYTE *addData, UINT32 addDataSize); //     
	bool AddFile(LPCTSTR sFilePath);      //     

protected:

	UINT64 m_DataAllSize;  //    ( +   )
	
	BYTE *m_pBuf;       //  
	UINT32 m_BufSize;   //     
	UINT32 m_DataInBufSize;  //      (   m_DataSize);
	
	bool m_bFileMode;    //     .     .
	CString m_sDataFile; //      

	bool Flush();  //       .  SaveDataToFile

	bool SaveDataToFile(BYTE *addData, UINT32 addDataSize); //    ,    

};


#endif // !defined(AFX_APLapl_packet_H__D13DB883_42AD_48CC_9E77_6416CCB5EDBD__INCLUDED_)
