// RefResearchResultsChildDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RefResearchResultsChildDlg.h"

// CRefResearchResultsChildDlg dialog

IMPLEMENT_DYNAMIC(CRefResearchResultsChildDlg, CaplTranslateDialog)

CRefResearchResultsChildDlg::CRefResearchResultsChildDlg(CaplAPI *api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CRefResearchResultsChildDlg::IDD, pParent)
{
	m_api = api;

	m_ciRef = 0;
	m_ciLab = 0;
	m_ciAct = 0;
	m_ciSector = 0;
	m_ciTestDeduction = 0;
	m_ciCulpritDeduction = 0;

	m_ciOldAct = 0;
	m_ciActAssoc = 0;
}

CRefResearchResultsChildDlg::~CRefResearchResultsChildDlg()
{
}

void CRefResearchResultsChildDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Text(pDX, IDC_LAB, m_sLab);
	DDX_Text(pDX, IDC_ACT, m_sActName);
	DDX_Text(pDX, IDC_SECTOR, m_sSector);
	DDX_Text(pDX, IDC_ACT_NUM, m_sActNum);
	DDX_Text(pDX, IDC_RESULTS, m_sResearchResult);
	DDX_Text(pDX, IDC_TEST_ID, m_sTestDeductionId);	
	DDX_Text(pDX, IDC_TEST_NAME, m_sTestDeductionName);
	DDX_Text(pDX, IDC_CULPRIT_ID, m_sCulpritDeductionId);
	DDX_Text(pDX, IDC_CULPRIT_NAME, m_sCulpritDeductionName);
	DDX_Text(pDX, IDC_NECASSARY_ARR, m_sNecassaryArrangm);

	DDX_Control(pDX, IDC_CHOOSE_LAB, m_choose_lab);
	DDX_Control(pDX, IDC_CLEAR_LAB, m_clear_lab);
	DDX_Control(pDX, IDC_CHOOSE_SECTOR, m_choose_sector);
	DDX_Control(pDX, IDC_CLEAR_SECTOR, m_clear_sector);
	DDX_Control(pDX, IDC_CHOOSE_TEST, m_choose_test);
	DDX_Control(pDX, IDC_CLEAR_TEST, m_clear_test);
	DDX_Control(pDX, IDC_CHOOSE_CULPRIT2, m_choose_culprit);
	DDX_Control(pDX, IDC_CLEAR_CULPRIT2, m_clear_culprit);
	DDX_Control(pDX, IDC_ACT_DATE, m_date_act_date);
	DDX_Control(pDX, IDC_CHOOSE_ACT, m_choose_act);
	DDX_Control(pDX, IDC_CREATE_ACT, m_create_act);
	DDX_Control(pDX, IDC_SHOW_ACT, m_show_act);
	DDX_Control(pDX, IDC_CLEAR_ACT, m_clear_act);
}

BEGIN_MESSAGE_MAP(CRefResearchResultsChildDlg, CaplTranslateDialog)
	
	ON_BN_CLICKED(IDC_CHOOSE_LAB, &CRefResearchResultsChildDlg::OnBnClickedChooseLab)
	ON_BN_CLICKED(IDC_CHOOSE_SECTOR, &CRefResearchResultsChildDlg::OnBnClickedChooseSector)
	ON_BN_CLICKED(IDC_CLEAR_LAB, &CRefResearchResultsChildDlg::OnBnClickedClearLab)
	ON_BN_CLICKED(IDC_CLEAR_SECTOR, &CRefResearchResultsChildDlg::OnBnClickedClearSector)
	ON_BN_CLICKED(IDC_CHOOSE_TEST, &CRefResearchResultsChildDlg::OnBnClickedChooseTest)
	ON_BN_CLICKED(IDC_CHOOSE_CULPRIT2, &CRefResearchResultsChildDlg::OnBnClickedChooseCulprit2)
	ON_BN_CLICKED(IDC_CLEAR_TEST, &CRefResearchResultsChildDlg::OnBnClickedClearTest)
	ON_BN_CLICKED(IDC_CLEAR_CULPRIT2, &CRefResearchResultsChildDlg::OnBnClickedClearCulprit2)
	ON_BN_CLICKED(IDC_CLEAR_ACT, &CRefResearchResultsChildDlg::OnBnClickedClearAct)
	ON_BN_CLICKED(IDC_CHOOSE_ACT, &CRefResearchResultsChildDlg::OnBnClickedChooseAct)
	ON_BN_CLICKED(IDC_CREATE_ACT, &CRefResearchResultsChildDlg::OnBnClickedCreateAct)
	ON_BN_CLICKED(IDC_SHOW_ACT, &CRefResearchResultsChildDlg::OnBnClickedShowAct)
END_MESSAGE_MAP()


// CRefResearchResultsChildDlg message handlers

BOOL CRefResearchResultsChildDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	InitBtns();
	InitInstances();
	FillDataBase();

	return TRUE;
}

void CRefResearchResultsChildDlg::OnCancel()
{

}

void CRefResearchResultsChildDlg::OnOK()
{

}
void CRefResearchResultsChildDlg::SetReadOnly()
{
	 m_choose_lab.EnableWindow(FALSE);
	 m_choose_sector.EnableWindow(FALSE);
	 m_clear_lab.EnableWindow(FALSE);
	 m_clear_sector.EnableWindow(FALSE);
	 m_choose_test.EnableWindow(FALSE);
	 m_choose_culprit.EnableWindow(FALSE);
	 m_clear_test.EnableWindow(FALSE);
	 m_clear_culprit.EnableWindow(FALSE);
	 m_choose_act.EnableWindow(FALSE);
	 m_clear_act.EnableWindow(FALSE);
	 m_create_act.EnableWindow(FALSE);
	 m_show_act.EnableWindow(FALSE);

	m_date_act_date.EnableWindow(FALSE);

	CWnd *wnd;
	wnd=GetDlgItem(IDC_RESULTS);		if(wnd) {((CEdit*)wnd)->SetReadOnly(TRUE);};
	wnd=GetDlgItem(IDC_NECASSARY_ARR);	if(wnd) {((CEdit*)wnd)->SetReadOnly(TRUE);};
	wnd=GetDlgItem(IDC_ACT_NUM);		if(wnd) {((CEdit*)wnd)->SetReadOnly(TRUE);};

}

void CRefResearchResultsChildDlg::InitBtns()
{
	m_choose_lab.SetFlat(TRUE);
	m_choose_lab.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_lab.SetTooltipText(APL_T(" "));

	m_choose_sector.SetFlat(TRUE);	
	m_choose_sector.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_sector.SetTooltipText(APL_T(" "));

	m_clear_lab.SetFlat(TRUE);	
	m_clear_lab.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_lab.SetTooltipText(APL_T(" "));

	m_clear_sector.SetFlat(TRUE);	
	m_clear_sector.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_sector.SetTooltipText(APL_T(" "));

	m_choose_test.SetFlat(TRUE);
	m_choose_test.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_test.SetTooltipText(APL_T("   "));

	m_choose_culprit.SetFlat(TRUE);	
	m_choose_culprit.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_culprit.SetTooltipText(APL_T("   "));

	m_choose_act.SetFlat(TRUE);	
	m_choose_act.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_act.SetTooltipText(APL_T("  "));

	m_create_act.SetFlat(TRUE);	
	m_create_act.SetIcon(aplGetButtonIco(APL_24_PLUS));
	m_create_act.SetTooltipText(APL_T("  "));

	m_show_act.SetFlat(TRUE);	
	m_show_act.SetIcon(aplGetButtonIco(APL_24_VIEW));
	m_show_act.SetTooltipText(APL_T("  "));

	m_clear_act.SetFlat(TRUE);	
	m_clear_act.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_act.SetTooltipText(APL_T(" "));

	m_clear_test.SetFlat(TRUE);	
	m_clear_test.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_test.SetTooltipText(APL_T(" "));

	m_clear_culprit.SetFlat(TRUE);	
	m_clear_culprit.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_culprit.SetTooltipText(APL_T(" "));
}

void CRefResearchResultsChildDlg::InitInstances()
{
	if(!m_ciRef) return;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_research_lab, m_ciLab);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_research_act_obj, m_ciAct);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_research_sector, m_ciSector);	
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_test_deduction, m_ciTestDeduction);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_culprit_deduction, m_ciCulpritDeduction);	

	//     
	m_ciOldAct = m_ciOldAct;

	aplExtent aeRes;
	CaplAttrValue val[2];

	val[0].attr = m_api->m_doc_mgr.a_apl_doc_ref_item;
	val[0].value.Set(m_ciRef);
	val[1].attr = m_api->m_doc_mgr.a_apl_doc_ref_doc;
	val[1].value.Set(m_ciAct);
	m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_doc_mgr.e_apl_doc_ref, 2, &val[0], aeRes, true);
	if(aeRes.Size) m_ciActAssoc = aeRes[0];
}

void CRefResearchResultsChildDlg::FillDataBase()
{
	if(!m_ciRef)
	{
		COleDateTime time;
		time.SetStatus(COleDateTime::null);
		m_date_act_date.SetTime(time);
		return;
	}

	CString buf;
	COleDateTime time;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	UpdateData();

	// 
	if(m_ciLab) m_api->GetItemName(m_ciLab, m_sLab);

	// 
	if(m_ciSector) m_api->GetItemName(m_ciSector, m_sSector);

	//   
	if(m_ciTestDeduction)
	{
		m_api->m_data.GetAttr(m_ciTestDeduction, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sTestDeductionName);
		m_api->m_data.GetAttr(m_ciTestDeduction, m_api->m_classifier_mgr.a_apl_classifier_level_id, m_sTestDeductionId);
	}

	//   ( )
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_necassary_arrangm, m_sNecassaryArrangm);

	//   
	if(m_ciCulpritDeduction)
	{
		m_api->m_data.GetAttr(m_ciCulpritDeduction, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sCulpritDeductionName);
		m_api->m_data.GetAttr(m_ciCulpritDeduction, m_api->m_classifier_mgr.a_apl_classifier_level_id, m_sCulpritDeductionId);
	}

	//  
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_research_result, m_sResearchResult);

	//   
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_research_act_str, m_sActNum);

	//   
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_research_act_date, buf);
	if(buf==_T("")) time.SetStatus(COleDateTime::null);
	else	aplString2Date(buf, time);
	m_date_act_date.SetTime(time);


	//  
	if(m_ciAct) m_api->GetItemName(m_ciAct, m_sActName);

	UpdateData(FALSE);
}

void CRefResearchResultsChildDlg::SaveRefData(CaplInstance *ciRef)
{
	if(!ciRef) return;

	CString buf;
	COleDateTime time;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	UpdateData();
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_research_lab, m_ciLab);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_research_sector, m_ciSector);	
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_test_deduction, m_ciTestDeduction);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_culprit_deduction, m_ciCulpritDeduction);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_research_result, m_sResearchResult);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_necassary_arrangm, m_sNecassaryArrangm);

	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_research_act_str, m_sActNum);
	m_date_act_date.GetTime(time);
	if(time.GetStatus()!=COleDateTime::valid) buf=_T("");
	else aplDate2String(time, buf);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_research_act_date, buf);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_research_act_obj, m_ciAct);
}

void CRefResearchResultsChildDlg::OnBnClickedChooseLab()
{
	UpdateData();

	if(m_api->m_appr_mgr.SelectOrganization(&m_ciLab, APL_T(""))) 
		m_api->GetItemName(m_ciLab, m_sLab);

	UpdateData(FALSE);
}

void CRefResearchResultsChildDlg::OnBnClickedChooseSector()
{
	UpdateData();

	if(m_api->m_appr_mgr.SelectOrganization(&m_ciSector, APL_T(""))) 
		m_api->GetItemName(m_ciSector, m_sSector);

	UpdateData(FALSE);
}

void CRefResearchResultsChildDlg::OnBnClickedClearLab()
{
	UpdateData();

	m_ciLab = NULL;
	m_sLab = _T("");

	UpdateData(FALSE);
}

void CRefResearchResultsChildDlg::OnBnClickedClearSector()
{
	UpdateData();

	m_ciSector = NULL;
	m_sSector = _T("");

	UpdateData(FALSE);
}

void CRefResearchResultsChildDlg::ShowClassificatorNonfoundError(CString sClassifier)
{
	CString sMsg;
	sMsg.Format(APL_T("    \"%s\""), sClassifier);
	MessageBox(sMsg, APL_T(""), MB_ICONERROR);
}

void CRefResearchResultsChildDlg::OnBnClickedChooseTest()
{
	UpdateData();

	CString sName, msg;
	aplExtent aeItems;
	CaplInstance *ciLvl = m_api->m_classifier_mgr.GetClassifierSystemBN(TEST_DEDUCTION_CLASSIFIER_LVL);

	if(!ciLvl)
	{
		ShowClassificatorNonfoundError(TEST_DEDUCTION_CLASSIFIER_LVL);
		return;
	}
	else
	{
		if(m_api->m_classifier_mgr.SelectItem(&m_ciTestDeduction, ciLvl, APL_SELECT_CLASSIFIER_LEVEL, TEST_DEDUCTION_CLASSIFIER_LVL))
		{
			m_api->m_data.GetAttr(m_ciTestDeduction, m_api->m_classifier_mgr.a_apl_classifier_level_id, m_sTestDeductionId);
			m_api->m_data.GetAttr(m_ciTestDeduction, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sTestDeductionName);
		}
		UpdateData(FALSE);
	}
}

void CRefResearchResultsChildDlg::OnBnClickedChooseCulprit2()
{
	UpdateData();

	CString sName, msg;
	aplExtent aeItems;
	CaplInstance *ciLvl = m_api->m_classifier_mgr.GetClassifierSystemBN(CULPRIT_DEDUCTION_CLASSIFIER_LVL);

	if(!ciLvl)
	{
		ShowClassificatorNonfoundError(CULPRIT_DEDUCTION_CLASSIFIER_LVL);
		return;
	}
	else
	{
		if(m_api->m_classifier_mgr.SelectItem(&m_ciCulpritDeduction, ciLvl, APL_SELECT_CLASSIFIER_LEVEL, CULPRIT_DEDUCTION_CLASSIFIER_LVL))
		{
			m_api->m_data.GetAttr(m_ciCulpritDeduction, m_api->m_classifier_mgr.a_apl_classifier_level_id, m_sCulpritDeductionId);
			m_api->m_data.GetAttr(m_ciCulpritDeduction, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sCulpritDeductionName);
		}
		UpdateData(FALSE);
	}
}

void CRefResearchResultsChildDlg::OnBnClickedClearTest()
{
	UpdateData();

	m_ciTestDeduction = 0;
	m_sTestDeductionName = _T("");
	m_sTestDeductionId = _T("");

	UpdateData(FALSE);
}

void CRefResearchResultsChildDlg::OnBnClickedClearCulprit2()
{
	UpdateData();

	m_ciCulpritDeduction = 0;
	m_sCulpritDeductionId = _T("");
	m_sCulpritDeductionName = _T("");

	UpdateData(FALSE);
}

void CRefResearchResultsChildDlg::ClearAct()
{
	UpdateData();

	m_sActName = _T("");
	m_ciAct = 0;

	UpdateData(FALSE);
}

void CRefResearchResultsChildDlg::OnBnClickedClearAct()
{
	if(MessageBox(APL_T(" ?\n(    )"), APL_T(""), MB_ICONQUESTION|MB_YESNO) == IDNO) return;

	if(m_ciAct) m_pDocDlg->DelDocumentAsAttr(m_ciAct);
	ClearAct();
}

void CRefResearchResultsChildDlg::SetAct(CaplInstance *ciDoc, bool bNewDoc)
{
	if(!ciDoc) return;
	if(!UpdateData()) return;
	if(!m_pDocDlg->Check(ciDoc)) return;

	m_ciAct = ciDoc;
	m_api->GetItemName(m_ciAct, m_sActName);
	m_pDocDlg->AddDocument(m_ciAct, true);

	UpdateData(FALSE);
}

void CRefResearchResultsChildDlg::OnBnClickedChooseAct()
{
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	CaplInstance* inst = mgr->SelectInstance(APL_MODE_SELECT_DOC, APL_T("  \" \""));
	if(inst) 
	{
		if(m_ciAct) m_pDocDlg->DelDocumentAsAttr(m_ciAct);
		SetAct(inst, false);
	}
}

void CRefResearchResultsChildDlg::OnBnClickedCreateAct()
{
	CaplInstance *ciDoc = m_api->m_doc_mgr.CreateDocument(_T(""), _T(""), _T(""), 0, _T(""));
	if(ciDoc)
	{
		if(m_ciAct) m_pDocDlg->DelDocumentAsAttr(m_ciAct);
		SetAct(ciDoc, true);
	}
}

void CRefResearchResultsChildDlg::OnBnClickedShowAct()
{
	if(!m_ciAct) return;	
	m_api->m_doc_mgr.View(m_ciAct);
}