// ChildFrame.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "ChildFrame.h"
#include "NavigatorView.h"
#include "PSMDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChildFrame

IMPLEMENT_DYNCREATE(CChildFrame, CMDIChildWnd)

CChildFrame::CChildFrame()
{
}

CChildFrame::~CChildFrame()
{
}


BEGIN_MESSAGE_MAP(CChildFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CChildFrame)
	ON_COMMAND(ID_SPLIT_VERT, OnSplitVert)
	ON_COMMAND(ID_SPLIT_HOR, OnSplitHor)
	ON_WM_CLOSE()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChildFrame message handlers

BOOL CChildFrame::PreCreateWindow(CREATESTRUCT& cs) 
{
	if( !CMDIChildWnd::PreCreateWindow(cs) )
		return FALSE;
	cs.style = WS_CHILD | WS_VISIBLE | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU
		| FWS_ADDTOTITLE | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX |WS_MAXIMIZE;
	cs.style &=~FWS_ADDTOTITLE;
	cs.lpszName = _T("");

	return TRUE;
}

BOOL CChildFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	// TODO: Add your specialized code here and/or call the base class
	return m_wndSplitter.Create( this,
		2, 2,                 // TODO: adjust the number of rows, columns
		CSize( 10, 10 ),      // TODO: adjust the minimum pane size
		pContext,
		WS_CHILD | WS_VISIBLE | SPLS_DYNAMIC_SPLIT /*|WS_HSCROLL | WS_VSCROLL */);
	
//	return CMDIChildWnd::OnCreateClient(lpcs, pContext);

/*
   BOOL bCreateSpltr = m_wndSplitter.CreateStatic( this, 2, 1);
   // COneView and CAnotherView are user-defined views derived from CMDIView
   m_wndSplitter.CreateView(0,0,RUNTIME_CLASS(CNavigatorView), CSize(0,0), 
      pContext);
   m_wndSplitter.CreateView(1,0,RUNTIME_CLASS(CNavigatorView), CSize(0,0), 
      pContext);

   return (bCreateSpltr);
*/
}

void CChildFrame::OnSplitVert() 
{
	if(m_wndSplitter.GetColumnCount()>1) return;
	RECT r;
	GetClientRect(&r);
	int x=(r.right-r.left)/2;
	if (x<10) {AfxMessageBox( APL_T("  ")); return;}
	m_wndSplitter.SplitColumn(x);
	RedrawWindow();
	
}

void CChildFrame::OnSplitHor() 
{
	if(m_wndSplitter.GetRowCount()>1) return;
	RECT r;
	GetClientRect(&r);
	int x=(r.bottom-r.top)/2;
	if (x<10) {AfxMessageBox( APL_T("  ")); return;}
	m_wndSplitter.SplitRow(x);
	RedrawWindow();
}

void CChildFrame::OnClose() 
{
	// TODO: Add your message handler code here and/or call default

	CPSMDoc* doc=(CPSMDoc*)GetActiveDocument( );
	if(doc!=0)
	{
		int i;
		for(i=0;i<doc->m_additional_frames.GetSize();i++)
		{
			if(doc->m_additional_frames[i]==this)
			{
				doc->m_additional_frames.RemoveAt(i);
				break;
			}

		}
	}
	CMDIChildWnd::OnClose();
}

int CChildFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	CPSMDoc*  pPSMDoc = NULL;
	CDocument *pDoc = NULL;
	CWinApp *app = AfxGetApp();
	POSITION pos = app->GetFirstDocTemplatePosition(), doc_pos=0;
	CDocTemplate* pTemplate = NULL;
	while(pos)
	{
		pTemplate = app->GetNextDocTemplate(pos);
		if(pTemplate)
		{
			doc_pos = pTemplate->GetFirstDocPosition();
			while(doc_pos)
			{
				pDoc = pTemplate->GetNextDoc(doc_pos);
				if(pDoc->IsKindOf(RUNTIME_CLASS(CPSMDoc)))
				{
					pPSMDoc = (CPSMDoc*)pDoc;
					break;
				}
			}
		}
		if(pPSMDoc)
			break;
	}
	if(pPSMDoc!=0)
	{
		//     
		if(pPSMDoc->m_pMainChildFrame==NULL)
		{
			pPSMDoc->m_pMainChildFrame = this;
			CMenu* pSysMenu = GetSystemMenu(FALSE);
			if (pSysMenu != NULL)
			{
				pSysMenu->EnableMenuItem(SC_CLOSE, MF_BYCOMMAND | MF_GRAYED );
			}
			SetWindowText(APL_T(" "));
			RedrawWindow();
		}
	}
	CaplMenu::Install(this);
	
	return 0;
}

bool CChildFrame::DeleteSplitters()
{
	int rows, cols, i;
	rows = m_wndSplitter.GetRowCount();
	cols = m_wndSplitter.GetColumnCount();

	for(i=1; i<rows; i++)
		m_wndSplitter.DeleteRow(i);

	for(i=1; i<cols; i++)
		m_wndSplitter.DeleteColumn(i);

	return true;
}
