// SubstListView.cpp: implementation of the CSubstListView class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "psm.h"
#include "SubstListView.h"

#include "PSMDoc.h"
#include "TreeProductItem.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_DYNCREATE(CSubstListView, CaplListView)

CSubstListView::CSubstListView()
{
	SetUniqueName(_T("CSubstListView"));
}

CSubstListView::~CSubstListView()
{

}

BEGIN_MESSAGE_MAP(CSubstListView, CaplListView)
	//{{AFX_MSG_MAP(CSubstListView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSubstListView drawing

void CSubstListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CSubstListView diagnostics

#ifdef _DEBUG
void CSubstListView::AssertValid() const
{
	CListView::AssertValid();
}

void CSubstListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSubstListView message handlers

int CSubstListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	// TODO: Add your specialized creation code here
    ListView_SetExtendedListViewStyle(m_hWnd,
		ListView_GetExtendedListViewStyle(m_hWnd)
                | LVS_EX_FULLROWSELECT|/*LVS_EX_GRIDLINES|*/LVS_EX_INFOTIP);

	LIST.InsertColumn(0, APL_T("."),LVCFMT_LEFT,40);
	LIST.InsertColumn(1, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(2, APL_T(""),LVCFMT_LEFT,120);
	LIST.InsertColumn(3, APL_T(""),LVCFMT_LEFT,50);
	LIST.InsertColumn(4, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(5, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(6, APL_T(" "),LVCFMT_LEFT,100);
	LoadColumnWidths();

	SetColumnNumeric(0);
	SetColumnNumeric(4);

	static CImageList imagelist;
	imagelist.Create(aplGetInstImageList());
	/*CImageList tmp_il;
	int i;
	
	imagelist.Create(IDR_NAVIGATOR_ICON,20,2,RGB(255,0,255));
	imagelist.SetImageCount(300);

	tmp_il.Create(IDR_NAVIGATOR_PRD_ICON,20,2,RGB(255,0,255));
	for(i=0;i<tmp_il.GetImageCount();i++)
		imagelist.Replace(ICON_PRODUCT_INDEX+i,tmp_il.ExtractIcon(i));
	tmp_il.DeleteImageList();

	tmp_il.Create(IDR_NAVIGATOR_WF_ICON,20,2,RGB(255,0,255));
	for(i=0;i<tmp_il.GetImageCount();i++)
		imagelist.Replace(ICON_WF_INDEX+i,tmp_il.ExtractIcon(i));
	tmp_il.DeleteImageList();*/

	LIST.SetImageList(&imagelist,LVSIL_SMALL);//   TVSIL_STATE);
	return 0;
}

void CSubstListView::UpdateTreeItem(CaplTreeItem *item)
{
	m_cur_item=item;
	GetListCtrl().DeleteAllItems();
	if(item==0) return;
	if(item->m_type!=APL_TREE_ITEM_PRODUCT) return;
	
	CaplInstance *m_pdf=((CaplProductTreeItem*)item)->m_pdf;
	if(!m_pdf) return;
	if(m_pdf->GetAccessmode()>aplRO) return;

	CaplInstance *m_nauo=((CaplProductTreeItem*)item)->m_nauo;
	if(!m_nauo) return;
	if(m_nauo->GetAccessmode()>aplRO) return;

	StartBusy();	
	CaplProductManager *prd_mgr=&(item->m_doc->m_api.m_prd_mgr);
	aplExtent ext_rel,ext_pdf;
	if(!prd_mgr->LoadAllSubstitutes(m_nauo,ext_rel,ext_pdf,true)) return;
	SetRedraw(FALSE);
	//
	CaplInstance *i_pdf=0,*i_prd=0,*unit=0;
	CString id,name,ver,buf,buf1,form_type,type_rus;
	int ico,k;
	for(int i=0;i<ext_rel.GetSize();i++)
	{
		if(!ext_rel[i]) continue;
		if(ext_rel[i]->GetAccessmode()>aplRO) continue;
		
		item->m_doc_data.GetAttr(ext_rel[i],prd_mgr->a_pdf_subst_pdf,i_pdf);
		if(!i_pdf) continue;
		if(i_pdf->GetAccessmode()>aplRO) continue;
		item->m_doc_data.GetAttr(i_pdf,prd_mgr->a_pdf_prd,i_prd);

		item->m_doc_data.GetAttr(i_pdf,prd_mgr->a_apl_pdf_type,form_type);
		if(form_type==_T("assembly")){ico=ICON_ASSEMBLY;}
		else if(form_type==_T("material")){ico=ICON_MATERIAL;}
		else if(form_type==_T("kit")){ico=ICON_KIT;}
		else if(form_type==_T("komplex")){ico=ICON_KOMPLEX;}
		else if(form_type==_T("other")){ico=ICON_OTHER;}
		else {ico=ICON_PART;}

		item->m_doc_data.GetAttr(ext_rel[i],prd_mgr->a_pdf_subst_id,id);
		buf.Format(_T("%2s"),LPCTSTR(id));
		k=LIST.InsertItem(-1,buf,ico);
		LIST.SetItemData(k,(long)ext_rel[i]);

		if(i_prd)
		{
			item->m_doc_data.GetAttr(i_prd,prd_mgr->a_prd_id,id);
			LIST.SetItemText(k,1,id);
			item->m_doc_data.GetAttr(i_prd,prd_mgr->a_prd_name,name);
			LIST.SetItemText(k,2,name);
		}

		item->m_doc_data.GetAttr(i_pdf,prd_mgr->a_pdf_id,ver);
		LIST.SetItemText(k,3,ver);
		buf=_T("");
		double count=1;
		item->m_doc_data.GetAttr(ext_rel[i],prd_mgr->a_pdf_subst_value,count);
		item->m_doc_data.GetAttr(ext_rel[i],prd_mgr->a_pdf_subst_unit,unit);
		item->m_doc->m_api.m_charact_mgr.GetUnitName(unit,buf);
		id = Double2Str(count)+ _T(" ")+buf;
//		id.Format(_T("%g %s"),count,buf);
		LIST.SetItemText(k,4,id);

		type_rus=item->m_doc->m_api.m_prd_mgr.StrConvertPdfType2Rus(form_type);
		LIST.SetItemText(k,5,type_rus);

		item->m_doc_data.GetAttr(ext_rel[i],prd_mgr->a_pdf_subst_description,buf);
		LIST.SetItemText(k,6,buf);
	}
	SortColumn(m_aCombinedSortedColumns[0]);
	SortColumn(m_aCombinedSortedColumns[0]);
	SetRedraw(TRUE);
	StopBusy();
}

void CSubstListView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if(m_cur_item!=0)
	{
		int i=LIST.HitTest(point); 
		if(i!=-1)
		{
			CaplProductManager *prd_mgr=0;
			if(m_cur_item) prd_mgr=&(m_cur_item->m_doc->m_api.m_prd_mgr);
			if(!prd_mgr) return;
			CaplInstance *subst=(CaplInstance *)LIST.GetItemData(i);
			if(subst!=0)
			{
				CaplInstance *i_pdf=0,*i_prd=0;
				m_cur_item->m_doc_data.GetAttr(subst,prd_mgr->a_pdf_subst_pdf,i_pdf);
				if(!i_pdf) return;
				m_cur_item->m_doc_data.GetAttr(subst,prd_mgr->a_pdf_prd,i_prd);
				CaplProductTreeItem *prd_item=new CaplProductTreeItem(0,m_cur_item->m_doc,i_prd,i_pdf);
				if(prd_item!=0) 
				{
					prd_item->m_subst=subst;
					prd_item->ShowProperties();
					//    
					for(int i=0;i<m_cur_item->m_doc->m_items.GetSize();i++)
					{
						if(m_cur_item->m_doc->m_items[i]->m_type==APL_TREE_ITEM_PRODUCT)
						{
							CaplProductTreeItem *tree_prd_item=(CaplProductTreeItem*)m_cur_item->m_doc->m_items[i];
							if(tree_prd_item) if(tree_prd_item->m_pdf==i_pdf) tree_prd_item->RefreshItem();
						}
					}

					m_cur_item->m_doc->m_items.Remove(m_cur_item->m_doc->m_items.Find(prd_item));
					UpdateTreeItem(m_cur_item);
				}
			}
		}
	}	
	CListView::OnLButtonDblClk(nFlags, point);
}

LRESULT CSubstListView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			CaplTreeItem* item = (CaplTreeItem*)lParam;
			UpdateTreeItem(item);
		}
	}
	
	return CaplListView::WindowProc(message, wParam, lParam);
}
