#ifndef _APL_MESSAGE_TREE_ITEM_H_
#define _APL_MESSAGE_TREE_ITEM_H_

#include "aplTreeItem.h"
#include "aplValue.h"	// Added by ClassView

class CaplFolderTreeItem;

class CaplMessageTreeItem: public CaplTreeItem
{
	//Attributes
public:
	CaplInstance *m_message;
	
	bool m_bLostMessage;
	bool m_bShowContent;
	CaplFolderTreeItem* m_folderItem;

	CaplInstance *m_folder;
	CaplInstance *m_classifier;
	aplExtent m_items;
	aplExtent m_refMessages;
	
	bool m_bCanReply;
	static bool m_bShowInListCtrl;;

	bool m_bOriginalLetter;
	aplExtent m_copyMessages;

	static int m_iNameFormate;

// 
#define APL_MESSAGE_INCOMING_FORMATE	2
#define APL_MESSAGE_SENDED_FORMATE		1
#define APL_MESSAGE_NON_FORMATE			0
	
	static int m_iShowPropertyEvent;

//    
#define APL_MESSAGE_SEND_EVENT		3 //  
#define APL_MESSAGE_ADD_EVENT		2 // - 
#define APL_MESSAGE_DELETE_EVENT	1 //
#define APL_MESSAGE_NO_EVENT		0 //  

	static bool m_bShowName;
	static bool m_bShowDate;
protected:
	//Methods
public:	
	bool ShowItems();
	void LoadProperties();
    CaplMessageTreeItem(CTreeCtrl *tree=0, CPSMDoc *doc=0,
		CaplInstance *mess=0);
	~CaplMessageTreeItem(){RemoveFromParenContents(m_message);}
    bool GetName(CString &name);
    bool RefreshItem();
	void ShowCmd(long cmd);
	//void ShowToolBarButton(CToolBarCtrl *tb);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);
    bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
    bool CreateTreeItem(HTREEITEM parent_item);
	bool Expand(UINT action);
	bool PasteItem(CaplTreeItem *item, CPoint *point= 0);

	bool ShowInListCtrl(CListCtrl *list);
	void GetAccessedInstances(aplExtent &ext);

	void ShowProperties();	
	void ShowMessageHistory();
			
	/*static*/ bool NewMessageNotify(CPSMDoc* doc);
	
	static bool CreateMessage(CPSMDoc *doc, CaplInstance* recipient, aplExtent &ext);
	static bool ShowAllMessages(CPSMDoc *doc);
	static void RefreshAllMessages(CPSMDoc *doc);
	static bool CheckMessages(CPSMDoc* doc);
	static bool ShowLostMessages(CPSMDoc* doc);
	
	static CString GetMessageSend(CPSMDoc* doc, CaplInstance* message);
	static CString GetMessageRecip(CPSMDoc* doc, CaplInstance* message);
	static bool ReplaceMesInstance(CPSMDoc* doc, CaplInstance** message);
};

#endif //_APL_MESSAGE_TREE_ITEM_H_