// Column.cpp: implementation of the CReportBound class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ReportDict.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CColumn::CColumn(CaplReportMgr *ReportMgr)
{
	ASSERT(ReportMgr);
	
	m_ReportMgr = ReportMgr;
	m_inst = NULL;
	m_ds_column = NULL;
	
	m_ind = -1;
	m_border = 1;
	m_align = AT_LEFT|AT_CENTER;
	m_width = 500;
	m_name = _T("");
	m_show_flag = 0;
	m_fit_to_rect = 0;
	m_ColumnType = aplVALUE;
	m_RowsCount = 1;
	
	m_params = 0;
	
	m_SpacePara = aplSpacePara15;
};

CColumn::~CColumn()
{
}

CColumn& CColumn::operator =(CColumn& Column)
{
	m_name = Column.m_name;
	m_width = Column.m_width;//
	m_ind = Column.m_ind;//
	m_show_flag = Column.m_show_flag;//
	m_align = Column.m_align;// 
	m_border = Column.m_border;//       
	m_fit_to_rect = Column.m_fit_to_rect;//     
	m_ColumnType = Column.m_ColumnType;//     
	m_ds_column = Column.m_ds_column;//   
	m_inst = Column.m_inst;
	m_TextCnst = Column.m_TextCnst;
	m_RowsCount = Column.m_RowsCount;
	m_SpacePara = Column.m_SpacePara;
	m_params = Column.m_params;
	m_sCondition = Column.m_sCondition;

	return (*this);
}

void CColumn::Update(bool set)
{
	if(set)
	{
		if(m_inst==0)
			m_inst = m_ReportMgr->m_data->CreateInstance(m_ReportMgr->e_apl_column);
		CaplInstance* ds_inst=0;
		if(m_ds_column!=0)
		{
			if(m_ds_column->m_inst==0)
				m_ds_column->m_inst = m_ReportMgr->m_data->CreateInstance(m_ReportMgr->e_apl_data_src_col);
			ds_inst = m_ds_column->m_inst;
		}
		else
			ds_inst = NULL;
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_name, m_name);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_width, m_width);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_ds_col, ds_inst);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_fit_text, m_fit_to_rect);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_level, m_show_flag);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_border, m_border);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_align, m_align);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_type, m_ColumnType);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_text_const, m_TextCnst);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_rows, m_RowsCount);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_space_para, m_SpacePara);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_params, m_params);
		m_ReportMgr->m_data->PutAttr(m_inst, m_ReportMgr->a_apl_column_condition, m_sCondition);
	}
	else
	{
		if(m_inst==NULL) return;
		CaplInstance* inst;
		
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_name, m_name);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_width, m_width);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_ds_col, inst);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_condition, m_sCondition);
		
		m_ds_column = m_ReportMgr->FindColumnByInst(inst);
		
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_level, m_show_flag);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_border,m_border);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_align,m_align);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_fit_text,m_fit_to_rect);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_type,m_ColumnType);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_text_const,m_TextCnst);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_rows,m_RowsCount);
		
		m_RowsCount = m_RowsCount>0 ? m_RowsCount : 1;
		
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_space_para,m_SpacePara);
		m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_apl_column_params,m_params);
	}
}

void CColumn::CopyToMem(BYTE* pByte, int &ind, bool bIncludeDSCol)
{
	int i;
	int int_size =sizeof(int);
	int* pInt = NULL;
	DWORD* pDw = NULL;
	TCHAR* pCh = NULL;

	pInt = (int*)&pByte[ind];
	*pInt = m_show_flag;
	ind+=int_size;

	pInt = (int*)&pByte[ind];
	*pInt = m_width;
	ind+=int_size;

	pInt = (int*)&pByte[ind];
	*pInt = m_ind;
	ind+=int_size;

	pInt = (int*)&pByte[ind];
	*pInt = m_border;
	ind+=int_size;

	pInt = (int*)&pByte[ind];
	*pInt = m_fit_to_rect;
	ind+=int_size;

	pInt = (int*)&pByte[ind];
	*pInt = m_SpacePara;
	ind+=int_size;

	pDw = (DWORD*)&pByte[ind];
	*pDw = m_align;
	ind+=sizeof(DWORD);

	pDw = (DWORD*)&pByte[ind];
	*pDw = m_params;
	ind+=sizeof(DWORD);

	pDw = (DWORD*)&pByte[ind];
	*pDw = m_ColumnType;
	ind+=sizeof(DWORD);

	pDw = (DWORD*)&pByte[ind];
	*pDw = m_RowsCount;
	ind+=sizeof(DWORD);

	pInt = (int*)&pByte[ind];//  
	*pInt = m_name.GetLength();
	ind+=int_size;
	for(i=0; i<m_name.GetLength();i++)
	{
		pCh = (TCHAR*)&pByte[ind];
		*pCh = m_name[i];
		ind+=sizeof(TCHAR);
	}

	pInt = (int*)&pByte[ind];//  
	*pInt = m_TextCnst.GetLength();
	ind+=int_size;
	for(i=0; i<m_TextCnst.GetLength();i++)
	{
		pCh = (TCHAR*)&pByte[ind];
		*pCh = m_TextCnst[i];
		ind+=sizeof(TCHAR);
	}

	pInt = (int*)&pByte[ind];// 
	*pInt = m_sCondition.GetLength();
	ind+=int_size;
	for(i=0; i<m_sCondition.GetLength();i++)
	{
		pCh = (TCHAR*)&pByte[ind];
		*pCh = m_sCondition[i];
		ind+=sizeof(TCHAR);
	}

	pInt = (int*)&pByte[ind];
	*pInt = bIncludeDSCol ? 1:0;
	ind+=int_size;

	if(bIncludeDSCol)
	{
		CHeaderColumn** pHeader = (CHeaderColumn**)&pByte[ind];
		*pHeader = m_ds_column;
		ind+=sizeof(CHeaderColumn*);
	}
}

int CColumn::GetMemSize(bool bIncludeDSCol)
{
	int size = 0, int_size= sizeof(int);

	size+=int_size;
	size+=int_size;
	size+=int_size;
	size+=int_size;
	size+=int_size;
	size+=int_size;
	size+=int_size;
	size+=sizeof(DWORD);
	size+=sizeof(DWORD);
	size+=int_size;
	size+=int_size;
	size+=m_name.GetLength()*sizeof(TCHAR);
	size+=int_size;
	size+=m_TextCnst.GetLength()*sizeof(TCHAR);
	size+=int_size;
	size+=m_sCondition.GetLength()*sizeof(TCHAR);

	size+=sizeof(int);//    
	if(bIncludeDSCol)
		size+=sizeof(CHeaderColumn**);
	
	return size;
}

bool CColumn::LoadDataFromMem(BYTE *pByte, int &ind)
{
	int i;
	m_ds_column = NULL;
	
	int int_size =sizeof(int);
	int iVal;
	int* pInt = NULL;
	DWORD* pDw = NULL;
	TCHAR* pCh = NULL;

	pInt = (int*)&pByte[ind];
	m_show_flag = *pInt;
	ind+=int_size;

	pInt = (int*)&pByte[ind];
	m_width = *pInt;
	ind+=int_size;

	pInt = (int*)&pByte[ind];
	m_ind = *pInt;
	ind+=int_size;

	pInt = (int*)&pByte[ind];
	m_border = *pInt;
	ind+=int_size;

	pInt = (int*)&pByte[ind];
	m_fit_to_rect = *pInt;
	ind+=int_size;

	pInt = (int*)&pByte[ind];
	m_SpacePara = *pInt;
	ind+=int_size;
	
	pDw = (DWORD*)&pByte[ind];
	m_align = *pDw;
	ind+=sizeof(DWORD);

	pDw = (DWORD*)&pByte[ind];
	m_params = *pDw;
	ind+=sizeof(DWORD);

	pDw = (DWORD*)&pByte[ind];
	m_ColumnType = *pDw;
	ind+=sizeof(DWORD);

	pDw = (DWORD*)&pByte[ind];
	m_RowsCount = *pDw;
	ind+=sizeof(DWORD);

	pInt = (int*)&pByte[ind];//  
	int cnt = *pInt;
	ind+=int_size;
	for(i=0; i<cnt;i++)
	{
		pCh = (TCHAR*)&pByte[ind];
		m_name+=*pCh;
		ind+=sizeof(TCHAR);
	}
	
	pInt = (int*)&pByte[ind];//  
	cnt = *pInt;
	ind+=int_size;
	for(i=0; i<cnt;i++)
	{
		pCh = (TCHAR*)&pByte[ind];
		m_TextCnst+=*pCh;
		ind+=sizeof(TCHAR);
	}

	pInt = (int*)&pByte[ind];//
	cnt = *pInt;
	ind+=int_size;
	for(i=0; i<cnt;i++)
	{
		pCh = (TCHAR*)&pByte[ind];
		m_sCondition+=*pCh;
		ind+=sizeof(TCHAR);
	}

	//    
	pInt = (int*)&pByte[ind];//  
	iVal = *pInt;
	ind+=int_size;

	if(iVal==1)
	{
		CHeaderColumn* pHeader = *((CHeaderColumn**)&pByte[ind]);
		//    CHeaderColumn   
		if(m_ReportMgr->m_base_query->Find(pHeader)>-1 || m_ReportMgr->m_header->Find(pHeader)>-1)
			m_ds_column = pHeader;
		ind+=sizeof(CHeaderColumn**);
	}

	return true;
}
