// LegendPropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "LegendPropDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLegendPropDlg dialog


CLegendPropDlg::CLegendPropDlg(CWnd* pParent /*=NULL*/)
	: CPageDialog(CLegendPropDlg::IDD, pParent), m_WorkingLegend(NULL)
{
	m_pLegend = NULL;
	//{{AFX_DATA_INIT(CLegendPropDlg)
	m_sFontName = _T("");
	m_iFontSize = 0;
	m_iMode = 0;
	m_bShowLegend = TRUE;
	//}}AFX_DATA_INIT

	m_cur_def_color = 0;
	m_DefColors[0] = RGB(0, 12, 255);
	m_DefColors[1] = RGB(200, 0, 174);
	m_DefColors[2] = RGB(200, 0, 0);
	m_DefColors[3] = RGB(0, 200, 0);
	m_DefColors[4] = RGB(220, 110, 0);
	m_DefColors[5] = RGB(0, 0, 0);
	m_DefColors[6] = RGB(110, 110, 110);
}


void CLegendPropDlg::DoDataExchange(CDataExchange* pDX)
{
	CPageDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLegendPropDlg)
	DDX_Control(pDX, IDC_FONT_COLOR, m_font_color_wnd);
	DDX_Control(pDX, IDC_BROWSE_FONT, m_browse_font_btn);
	DDX_Text(pDX, IDC_FONT_NAME, m_sFontName);
	DDX_Text(pDX, IDC_FONT_SIZE, m_iFontSize);
	DDX_Radio(pDX, IDC_MODE, m_iMode);
	DDX_Control(pDX, IDC_POSITION_2, m_position1);
	DDX_Control(pDX, IDC_POSITION_4, m_position2);
	DDX_Check(pDX, IDC_SHOW_LEGEND, m_bShowLegend);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLegendPropDlg, CPageDialog)
	//{{AFX_MSG_MAP(CLegendPropDlg)
	ON_BN_CLICKED(IDC_SHOW_LEGEND, OnShowLegend)
	ON_BN_CLICKED(IDC_BROWSE_FONT, OnBrowseFont)
	ON_CBN_SELCHANGE(IDC_POSITION_2, OnChangePosition)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLegendPropDlg message handlers

BOOL CLegendPropDlg::OnInitDialog()
{
	CPageDialog::OnInitDialog();

	if(m_pLegend==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	bm_1.LoadBitmap(IDB_LEGEND_MODE_1);
	((CButton*)GetDlgItem(IDC_MODE))->SetBitmap(bm_1);
	bm_2.LoadBitmap(IDB_LEGEND_MODE_2);
	((CButton*)GetDlgItem(IDC_MODE_2))->SetBitmap(bm_2);
	bm_3.LoadBitmap(IDB_LEGEND_MODE_3);
	((CButton*)GetDlgItem(IDC_MODE_3))->SetBitmap(bm_3);

	m_WorkingLegend = *m_pLegend;
	m_sFontName = m_WorkingLegend.m_LogFont.lfFaceName;
	m_iFontSize = m_WorkingLegend.m_LogFont.lfHeight/10;
	m_font_color_wnd.SetBkColor(m_WorkingLegend.m_TextColor);

	m_iMode = m_WorkingLegend.m_LegendMode;
	m_bShowLegend = m_WorkingLegend.m_LegendPosition>0? TRUE:FALSE;

	m_position1.AddString(APL_T(""));
	m_position1.AddString(APL_T(""));
	m_position1.AddString(APL_T(""));
	m_position1.AddString(APL_T(""));
	m_position1.SetCurSel(m_WorkingLegend.m_LegendPosition>0?m_WorkingLegend.m_LegendPosition-1:0);
	OnChangePosition();
	m_position2.SetCurSel(m_WorkingLegend.m_LegendPosition2>=0?m_WorkingLegend.m_LegendPosition2:0);

	UpdateData(FALSE);

	SetReadOnly();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CLegendPropDlg::OnShowLegend() 
{
	UpdateData();

	SetReadOnly();
}

void CLegendPropDlg::OnChangePosition() 
{
	int cur_pos1 = m_position1.GetCurSel();
	if(cur_pos1==CB_ERR) return;
	int cur_pos2 = m_position2.GetCurSel();
	if(cur_pos2==CB_ERR) cur_pos2 = 0;

	if(cur_pos1==0 || cur_pos1==1)
	{
		m_position2.ResetContent();
		m_position2.AddString(APL_T(" "));
		m_position2.AddString(APL_T(" "));
		m_position2.AddString(APL_T(" "));
		m_position2.SetCurSel(cur_pos2);
	}
	if(cur_pos1==2 || cur_pos1==3)
	{
		m_position2.ResetContent();
		m_position2.AddString(APL_T(" "));
		m_position2.AddString(APL_T(" "));
		m_position2.AddString(APL_T(" "));
		m_position2.SetCurSel(cur_pos2);
	}
}

void CLegendPropDlg::OnBrowseFont() 
{
	UpdateData();
	CDC *pDC = GetDC();
	CFontDialog	dlg(&m_WorkingLegend.m_LogFont);
	int old = m_WorkingLegend.m_LogFont.lfHeight;
	m_WorkingLegend.m_LogFont.lfHeight = -MulDiv(-old/10, ::GetDeviceCaps(pDC->m_hDC, LOGPIXELSY), 72);
	dlg.m_cf.Flags |=CF_INITTOLOGFONTSTRUCT|CF_LIMITSIZE;
	dlg.m_cf.nSizeMax = 1638;
	dlg.m_cf.nSizeMin = 1;
	dlg.m_cf.lpLogFont = &m_WorkingLegend.m_LogFont;
	dlg.m_cf.rgbColors = m_WorkingLegend.m_TextColor;
	if(dlg.DoModal()==IDOK)
	{
		m_iFontSize = dlg.GetSize()/10;
		m_sFontName = m_WorkingLegend.m_LogFont.lfFaceName;
		m_WorkingLegend.m_LogFont.lfHeight = dlg.GetSize();
		m_WorkingLegend.m_TextColor = dlg.m_cf.rgbColors;
		m_font_color_wnd.SetBkColor(m_WorkingLegend.m_TextColor);
		UpdateData(FALSE);
	}
	else
		m_WorkingLegend.m_LogFont.lfHeight = old;
	
	ReleaseDC(pDC);
}

void CLegendPropDlg::SetReadOnly()
{
	GetDlgItem(IDC_MODE)->EnableWindow(m_bShowLegend);
	GetDlgItem(IDC_MODE_2)->EnableWindow(m_bShowLegend);
	GetDlgItem(IDC_MODE_3)->EnableWindow(m_bShowLegend);

	GetDlgItem(IDC_POSITION)->EnableWindow(m_bShowLegend);
	GetDlgItem(IDC_POSITION_2)->EnableWindow(m_bShowLegend);
	GetDlgItem(IDC_POSITION_3)->EnableWindow(m_bShowLegend);
	GetDlgItem(IDC_POSITION_4)->EnableWindow(m_bShowLegend);

	GetDlgItem(IDC_FONT_COLOR)->EnableWindow(m_bShowLegend);
	GetDlgItem(IDC_FONT_NAME)->EnableWindow(m_bShowLegend);
	GetDlgItem(IDC_FONT_SIZE)->EnableWindow(m_bShowLegend);

	m_font_color_wnd.EnableWindow(m_bShowLegend);
	m_browse_font_btn.EnableWindow(m_bShowLegend);

}

bool CLegendPropDlg::UpdateDlg()
{
	if(!UpdateData()) return false;

	if(m_bShowLegend==FALSE)
		m_WorkingLegend.m_LegendPosition = 0;
	else
	{
		m_WorkingLegend.m_LegendPosition = m_position1.GetCurSel()+1;
		m_WorkingLegend.m_LegendPosition2 = m_position2.GetCurSel();
	}
	m_WorkingLegend.m_LegendMode = m_iMode;
	*m_pLegend = m_WorkingLegend;
	return true;
}

bool CLegendPropDlg::TestUpdate()
{
	if(!UpdateData()) return false;

	return true;
}
