// SortParamsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SortParamsDlg.h"
#include "ReportDict.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSortParamsDlg dialog


CSortParamsDlg::CSortParamsDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSortParamsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSortParamsDlg)
	m_sColumnName = _T("");
	m_bSortAsString = FALSE;
	m_bSortDirection = FALSE;
	//}}AFX_DATA_INIT
	m_col = NULL;
}


void CSortParamsDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSortParamsDlg)
	DDX_Control(pDX, IDC_IMAGE, m_ImageCtrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Text(pDX, IDC_COLUMN_NAME, m_sColumnName);
	DDX_Check(pDX, IDC_SORT_AS_STRING, m_bSortAsString);
	DDX_Check(pDX, IDC_SORT_DIRECTION, m_bSortDirection);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSortParamsDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSortParamsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSortParamsDlg message handlers

BOOL CSortParamsDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	if(m_col==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	m_sColumnName = m_col->m_column->GetName();
	m_bSortAsString = m_col->m_bSortAsString;
	m_bSortDirection = (m_col->m_SortDirection==aplZA);

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSortParamsDlg::OnOK() 
{
	if(!UpdateData()) return;

	m_col->m_bSortAsString = (m_bSortAsString==TRUE);
	if(m_bSortDirection==TRUE)
		m_col->m_SortDirection = aplZA;
	else
		m_col->m_SortDirection = aplAZ;

	CaplTranslateDialog::OnOK();
}
