// TableMapElement.cpp: implementation of the CTableMapElement class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ReportDict.h"
#include "resource.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTableMapElement::CTableMapElement(CaplReportMgr* dict):CReportElement(dict, E_TABLE_MAP)
{
	m_table = NULL;
	m_name = APL_T(" ");

	HINSTANCE hInst = AfxGetResourceHandle();
	AfxSetResourceHandle(dllInst);
	m_TableMapElement_hIcon = AfxGetApp()->LoadIcon(IDI_TABLEMAP_ELEMENT);
	AfxSetResourceHandle(hInst);
}

CTableMapElement::~CTableMapElement()
{
}

BOOL CTableMapElement::Draw(CDC *pDC, double scale, int draw_mode, UINT flag)
{
	if(pDC==NULL) return FALSE;
	if(scale==0) return FALSE;

	CRect m_rect;
	GetRect(m_rect,scale,pDC->IsPrinting());

	CPen m_obj_pen, *old_p;
	CBrush m_bg_brush, *old_b;
	CString str;
	
	m_obj_pen.CreatePen(PS_SOLID | PS_GEOMETRIC,int(m_line_width*scale),OBJ_COLOR);
	m_bg_brush.CreateSolidBrush(BG_COLOR);

	if(m_line_width==0 && draw_mode==0)
	{
		m_obj_pen.DeleteObject();
		m_obj_pen.CreatePen(PS_SOLID|PS_GEOMETRIC,1,RGB(192,192,192));
	}
	old_p = pDC->SelectObject(&m_obj_pen);
	old_b = pDC->SelectObject(&m_bg_brush);
	if(draw_mode==0)
	{
		m_obj_pen.DeleteObject();
		m_obj_pen.CreatePen(PS_SOLID | PS_GEOMETRIC,int(m_line_width*scale), RGB(192,192,192));
		pDC->SelectObject(&m_obj_pen);
		
		int y = m_rect.bottom-int(m_rect.Height()*0.1);
		pDC->MoveTo(m_rect.left, y);
		pDC->LineTo(m_rect.right, y);
		int x = m_rect.left+int(m_rect.Width()*0.4);
		pDC->MoveTo(x, m_rect.top);
		pDC->LineTo(x, m_rect.bottom);
		x = m_rect.left+int(m_rect.Width()*0.7);
		pDC->MoveTo(x, m_rect.top);
		pDC->LineTo(x, m_rect.bottom);
		
		if(m_rect.Width()>160 && m_rect.Height()>160)
		{
			pDC->DrawState(CPoint(m_rect.left+100, m_rect.top+160), CSize(160,160), m_TableMapElement_hIcon, DST_ICON, (CBrush*)NULL);
		}
		m_obj_pen.DeleteObject();
		m_obj_pen.CreatePen(PS_SOLID | PS_GEOMETRIC,int(m_line_width*scale),OBJ_COLOR);
		pDC->SelectObject(&m_obj_pen);
	}

	if(m_line_width>0 || draw_mode==0)
	{
		pDC->MoveTo(m_rect.TopLeft());
		pDC->LineTo(m_rect.right,m_rect.top);
		pDC->LineTo(m_rect.BottomRight());
		pDC->LineTo(m_rect.left,m_rect.bottom);
		pDC->LineTo(m_rect.TopLeft());
	}
	
	if(m_select && !pDC->IsPrinting() && flag &&DRAW_SEL)
		DrawSelPoints(pDC, scale);

	pDC->SelectObject(old_p);
	pDC->SelectObject(old_b);
	m_obj_pen.DeleteObject();
	m_bg_brush.DeleteObject();

	return true;

}

void CTableMapElement::Delete()
{
	if(m_inst==0) return;
	
	CaplInstance* inst;
	// 
	m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_elem_org_pt, inst);
	if(inst)
		m_ReportMgr->m_data->DeleteInstance(inst);
	m_ReportMgr->m_data->GetAttr(m_inst, m_ReportMgr->a_elem_size, inst);
	if(inst)
		m_ReportMgr->m_data->DeleteInstance(inst);
}

int CTableMapElement::GetMemSize()
{
	int int_size = sizeof(int);
	int dw_size = sizeof(DWORD);
	int size = 4*int_size;// ;
	size+=sizeof(TReportElementType);// ;
	size+=int_size;// ;
	size+=int_size;//;
//	size+=int_size;
	return size;
}	

void CTableMapElement::CopyToMem(BYTE *pByte, int &ind)
{
	int* pInt = NULL;
	int int_size = sizeof(int);
	
	pInt = (int*)&pByte[ind];
	*pInt = m_type;//  ;
	ind+=sizeof(TReportElementType);
	
	pInt = (int*)&pByte[ind];
	*pInt = m_org_pt.x;// x;
	ind+=int_size;
	
	pInt = (int*)&pByte[ind];
	*pInt = m_org_pt.y;// y;
	ind+=int_size;
	
	pInt = (int*)&pByte[ind];
	*pInt = m_size.cx;// cx;
	ind+=int_size;
	
	pInt = (int*)&pByte[ind];
	*pInt = m_size.cy;// cy;
	ind+=int_size;
	
	pInt = (int*)&pByte[ind];
	*pInt = m_line_width;//  ;
	ind+=int_size;
	
	pInt = (int*)&pByte[ind];
	*pInt = 0;
	ind+=int_size;
}


int CTableMapElement::ShowContextMenu(CPoint pt, CWnd *wnd, int mode)
{
	if(wnd == NULL) return false;
	
	wnd->ClientToScreen(&pt);
	
	CMenu menu;
	CMenu *pPopup;
	
	HINSTANCE hInst = AfxGetResourceHandle();
	AfxSetResourceHandle(dllInst);
	menu.LoadMenu(IDR_CONTEXT_MENU);
	pPopup = menu.GetSubMenu(5);
	
	if(mode>0)
	{
		pPopup->EnableMenuItem(ID_DELETE,MF_BYCOMMAND|MF_GRAYED);
		pPopup->EnableMenuItem(ID_FIXED,MF_BYCOMMAND|MF_GRAYED);
	}
	if(m_fixed)
		pPopup->ModifyMenu(ID_FIXED,MF_BYCOMMAND|MF_STRING,ID_FIXED,APL_T(""));
	
	int res = pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_RETURNCMD,pt.x, pt.y, wnd);
	AfxSetResourceHandle(hInst);
	if(res==ID_ALIGN) Align();
	else if(res==ID_FIXED)
	{
		if(m_fixed>0) m_fixed=0;
		else m_fixed=1;
	}
	return ExecuteCmd(res);
}
