#if !defined(AFX_CLASSIFIERSELECTDLG_H__7E769C92_81A3_44BD_8CB5_D588288A0615__INCLUDED_)
#define AFX_CLASSIFIERSELECTDLG_H__7E769C92_81A3_44BD_8CB5_D588288A0615__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ClassifierSelectDlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// ClassifierSelectDlg dialog
#include "resource.h"
#include "apl_api.h"
#include "apl_gui.h"

class CTreeItemData;

typedef CArray<CTreeItemData*, CTreeItemData*> CItemsArray;

class CTreeItemData
{
public:
	bool IsPossibletoselect(UINT mode);
	void Sort(HTREEITEM parent = TVI_ROOT);
	void GetDescription(CString &descr);
	void CollapseItems();
	void Expand(UINT action, UINT mode = 0);
	bool Create(HTREEITEM parent = TVI_ROOT);
	CTreeItemData(CaplAPI* api, CTreeCtrl* tree, CaplInstance* inst, CItemsArray* Arr, int level = 0);
	~CTreeItemData();

	CTreeCtrl*	m_tree;
	HTREEITEM	m_item;
	HTREEITEM	m_fictive_item;
	CaplInstance*	m_inst;
	CaplInstance*	m_system;
	CaplAPI* m_api;
	CItemsArray *m_ItemsArray;
	int m_ItemLevel;
	int m_MaxLevel;
protected:
private:
};

class CClassifierSelectDlg : public CaplTranslateDialog
{
// Construction
private:
	CItemsArray m_ItemsArray;
public:
	bool LoadData();

	CaplAPI* m_api;
	CString m_sTitle;

	CaplInstance* m_BaseClassifierSystem;
	CaplInstance* m_SelectedElement;

	UINT m_SelectMode;


	CClassifierSelectDlg(CaplAPI* api, CWnd* pParent = NULL);   // standard constructor

	static	int CALLBACK CompareHtreeItem(LPARAM lParam1, LPARAM lParam2,LPARAM lParamSort);

// Dialog Data
	//{{AFX_DATA(CClassifierSelectDlg)
	enum { IDD = IDD_CLASSIFIER_SELECT };
	CaplButton	m_ok_btn;
	CaplButton	m_cancel_btn;
	CTreeCtrl	m_TreeCtrl;
	CString	m_sDescr;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CClassifierSelectDlg)
	public:
	virtual BOOL DestroyWindow();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CClassifierSelectDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnItemexpandingTree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchangedTree(NMHDR* pNMHDR, LRESULT* pResult);
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CLASSIFIERSELECTDLG_H__7E769C92_81A3_44BD_8CB5_D588288A0615__INCLUDED_)
