// ClassifierTableItemsView.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "ClassifierTableItemsView.h"
#include "ClassifierTableFrame.h"
#include "SpravFilterPropDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CaplMap map_inst_column_data;
CaplTAggr <CaplDataBuf*,CaplDataBuf*,APLAGGR_AUTOKILLREF> list_inst_column_data;


/////////////////////////////////////////////////////////////////////////////
// CClassifierTableItemsView

IMPLEMENT_DYNCREATE(CClassifierTableItemsView, CView)

CClassifierTableItemsView::CClassifierTableItemsView()
{
	m_api = NULL;
	m_ClassifierElement = NULL;
	m_ClassifierElement = NULL;
	m_ClassifierElementOldDraw = NULL;
	m_DlgId = 0;
	m_ListCtrl.SetUniqueName(_T("ClassifierTableItemsViewListCtrl"));
	m_Mode = 0;
	m_state_show_in_form=true;
	m_state_show_by_filtr=false;
	m_list_char=0;
	m_load_from_bd=true;
	m_filter = NULL;
}

CClassifierTableItemsView::~CClassifierTableItemsView()
{
}


BEGIN_MESSAGE_MAP(CClassifierTableItemsView, CView)
	//{{AFX_MSG_MAP(CClassifierTableItemsView)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_COMMAND(ID_ADD_ITEM, OnAddItem)
	ON_COMMAND(ID_COPY_ITEM, OnCopyItem)
	ON_COMMAND(ID_ADD_ITEM_W_FORM, OnAddItemWForm)
	ON_COMMAND(ID_SHOW_PROP_IN_FORM, OnShowPropInForm)
	ON_COMMAND(ID_SHOW_FILTR_PROP, OnShowFiltrProp)
	ON_COMMAND(ID_SHOW_BY_FILTR, OnShowByFiltr)
	ON_UPDATE_COMMAND_UI(ID_SHOW_FILTR_PROP, OnUpdateFiltr)
	ON_UPDATE_COMMAND_UI(ID_ADD_ITEM, OnUpdateAddItem)
	ON_UPDATE_COMMAND_UI(ID_COPY_ITEM, OnUpdateCopyItem)
	ON_UPDATE_COMMAND_UI(ID_ADD_ITEM_W_FORM, OnUpdateAddItemWF)
	ON_WM_TIMER()
	ON_COMMAND(ID_FIND_ADD, OnFindAdd)
	ON_COMMAND(ID_ITEM_DELETE, OnItemDelete)
	ON_COMMAND(ID_ITEM_PROPERTIES, OnItemProperties)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnListCtrlDblClick)
	ON_COMMAND(ID_ENT_PRODUCT, OnEntProduct)
	ON_COMMAND(ID_ENT_BP, OnEntBp)
	ON_COMMAND(ID_ENT_BPINST, OnEntBpinst)
	ON_COMMAND(ID_ENT_CATEG, OnEntCateg)
	ON_COMMAND(ID_ENT_CHANGE, OnEntChange)
	ON_COMMAND(ID_ENT_DOCUMENT, OnEntDocument)
	ON_COMMAND(ID_ENT_FOLDER, OnEntFolder)
	ON_COMMAND(ID_ENT_PROJECT, OnEntProject)
	ON_COMMAND(ID_ENT_LOT, OnEntLot)
	ON_COMMAND(ID_ENT_ORG, OnEntOrg)
	ON_COMMAND(ID_ENT_PERSON, OnEntPerson)
	ON_COMMAND(ID_ENT_PRDINST, OnEntPrdinst)
	ON_COMMAND(ID_ENT_PRODUCT_VERSION, OnEntProductVersion)
	ON_COMMAND(ID_ENT_PROJET, OnEntProjet)
	ON_UPDATE_COMMAND_UI(ID_ENT_CHANGE, OnUpdateEntChange)
	ON_UPDATE_COMMAND_UI(ID_ENT_PROJET, OnUpdateEntProjet)
	ON_UPDATE_COMMAND_UI(ID_ENT_PERSON, OnUpdateEntPerson)
	ON_UPDATE_COMMAND_UI(ID_ENT_ORG, OnUpdateEntOrg)
	ON_UPDATE_COMMAND_UI(ID_ENT_CATEG, OnUpdateEntCateg)
	ON_COMMAND(ID_COLUMN_SETUP, OnColumnSetup)
	ON_COMMAND(ID_COLUMN_CHARACT_SETUP, OnColumnCharactSetup)
	ON_UPDATE_COMMAND_UI(ID_COLUMN_SETUP, OnUpdateColumnSetup)
	ON_UPDATE_COMMAND_UI(ID_FIND_ADD, OnUpdateFindAdd)
	ON_UPDATE_COMMAND_UI(ID_ITEM_DELETE, OnUpdateItemDelete)
	ON_UPDATE_COMMAND_UI(ID_ITEM_PROPERTIES, OnUpdateItemProperties)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
	ON_WM_ERASEBKGND()
	ON_NOTIFY(LVN_BEGINRDRAG, IDC_LIST, OnBegindrag)
	ON_UPDATE_COMMAND_UI(ID_COLUMN_CHARACT_SETUP, OnUpdateColumnSetup)
	ON_UPDATE_COMMAND_UI(ID_SHOW_PROP_IN_FORM, OnUpdateAddItemWF)
	ON_UPDATE_COMMAND_UI(ID_SHOW_BY_FILTR, OnUpdateFiltr)
	ON_UPDATE_COMMAND_UI(ID_ITEM_VIEW, OnUpdateItemView)
	ON_COMMAND(ID_ITEM_VIEW, OnItemView)
	ON_UPDATE_COMMAND_UI(ID_ITEM_UNDO_CHECKOUT, OnUpdateItemUndoCheckout)
	ON_UPDATE_COMMAND_UI(ID_ITEM_EDIT, OnUpdateItemEdit)
	ON_COMMAND(ID_ITEM_UNDO_CHECKOUT, OnItemUndoCheckout)
	ON_COMMAND(ID_ITEM_EDIT, OnItemEdit)
	ON_UPDATE_COMMAND_UI(ID_ITEM_CHECKOUT, OnUpdateItemCheckout)
	ON_COMMAND(ID_ITEM_CHECKOUT, OnItemCheckout)
	ON_COMMAND(ID_ITEM_CHECKIN, OnItemCheckin)
	ON_UPDATE_COMMAND_UI(ID_ITEM_CHECKIN, OnUpdateItemCheckin)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClassifierTree drawing

void CClassifierTableItemsView::OnDraw(CDC* pDC)
{
}

/////////////////////////////////////////////////////////////////////////////
// CClassifierTableItemsView diagnostics

#ifdef _DEBUG
void CClassifierTableItemsView::AssertValid() const
{
	CView::AssertValid();
}

void CClassifierTableItemsView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CClassifierTableItemsView message handlers

int CClassifierTableItemsView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	CRect rect;
	GetClientRect(&rect);

	if(m_ListCtrl.Create(WS_VISIBLE|WS_CHILD|LVS_SHOWSELALWAYS,rect,this, IDC_LIST,true)!=TRUE)
		return FALSE;
	
	return 0;
}

void CClassifierTableItemsView::OnInitialUpdate() 
{
	if(m_Mode&APL_CLASSIFIER_EDITOR || m_Mode&APL_CLASSIFIER_EXE_EDITOR)
	{
		m_OleDropTarget.Revoke();
		m_OleDropTarget.Register(this);
	}
	long lStyles=::GetWindowLong(m_ListCtrl.m_hWnd,GWL_STYLE);
	lStyles|=LVS_SINGLESEL|LVS_SHOWSELALWAYS;
	::SetWindowLong(m_ListCtrl.m_hWnd,GWL_STYLE,lStyles);

}

bool CClassifierTableItemsView::UpdateTable(CaplInstance *Inst)
{
	CaplDataBuf* column_data=0;

	m_ListCtrl.SaveColumnWidths();

	//       -      
	if(m_ClassifierElementOldDraw!=0){
		column_data=(CaplDataBuf*)map_inst_column_data.QGetPointerByIn((long)m_ClassifierElementOldDraw);
		if(column_data==0){
			column_data=new CaplDataBuf();
			list_inst_column_data.Add(column_data);
			map_inst_column_data.Add((long)m_ClassifierElementOldDraw,(long)column_data);
			map_inst_column_data.SortIn();
		}
		m_ListCtrl.GetColumnData(*column_data);
	}


	m_ListCtrl.DeleteAllItems();
	m_Items.Clear();
	bool flag_end=false;
	bool retval=true;

	bool bShowFind=false;

	if(Inst==NULL) return false;
	
	if(m_api==NULL) return false;

	if(!m_api->m_data.IsDictLoad()) return false;

	if(Inst==(CaplInstance*)-1) 
	{
		m_ClassifierElement = NULL;
		bShowFind=true;
		Inst=0;
	}
	else if(m_api->m_data.IsKindOf(Inst, m_api->m_classifier_mgr.e_apl_classifier_level))
	{
		m_ClassifierElement = Inst;
	}
	else if(m_api->m_data.IsKindOf(Inst, m_api->m_classifier_mgr.e_apl_classifier_system))
	{
		m_ClassifierElement = NULL;
	}
	else
	{
		m_ClassifierElement = NULL;
		flag_end=true;retval=false;
	}
	//  ,      
	if(m_ClassifierElementOldDraw!=m_ClassifierElement)
	{
		m_ClassifierElementOldDraw=m_ClassifierElement;
		m_all_el_charact.Clear();
		m_load_from_bd=true;
	}
	if(flag_end){return retval;}


//	CString buf;
//	buf.Format(_T("ClassifierTableName - %d"), m_ClassifierElement->id);
//	m_ListCtrl.SetUniqueName(buf);
	::SetTimer(m_hWnd, ID_LOAD_ITEM_INFO, 500, NULL);
	aplExtent ext, rels, characts, gr;
	int i,j;
	ElValChar *el_ch;
	CaplInstance* char_val;
	CaplInstance *unit;
	int i_val_q;
	double r_val_q;
	CaplValue val_inst,val_q;
	CaplQLQuery query(&apidata);
	if(bShowFind)
	{
		ext=m_ext_fom_find;
	}
	else 
		m_api->m_classifier_mgr.GetSubItems(Inst, ext, &rels,true,m_load_from_bd);
	m_api->m_charact_mgr.FindAssociatedCharacteristic(ext, characts, gr,false,false,false,m_load_from_bd);
	SItemColumnData *pSID;
	bool in_list;
	for(i=0; i<ext.GetSize(); i++)
	{
		in_list=true;
		if(m_state_show_by_filtr && m_list_char!=0){
			//       ,      
			for(j=0;j<m_list_char->GetSize();j++){
				el_ch=m_list_char->GetAt(j);
				char_val=m_api->m_charact_mgr.FindCharacteristic(ext[i],el_ch->apl_char,el_ch->type,false,m_load_from_bd);
				//     
				if(el_ch->log_relation!=CaplQLQuery::aplNOTEXIST && char_val==0 || 
					el_ch->log_relation==CaplQLQuery::aplNOTEXIST && char_val!=0 )
				{
					in_list=false;break;
				}
				if(el_ch->is_exist && 
					el_ch->log_relation!=CaplQLQuery::aplEXIST && 
					el_ch->log_relation!=CaplQLQuery::aplNOTEXIST)
				{
					//  
					apidata.GetAttrBN(el_ch->apl_char,_T("unit"),unit);
					apidata.GetAttrBN(char_val,_T("val"),val_inst);

					if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_step_unit))
					{
						if(el_ch->log_relation==CaplQLQuery::aplINDIAPAZON){
							r_val_q=__atof(el_ch->val);
							val_q.Set(r_val_q);
							if(!query.Compare(val_inst,0,0,&val_q,CaplQLQuery::aplBIGEQUAL)){in_list=false;break;}
							r_val_q=__atof(el_ch->val_max);
							val_q.Set(r_val_q);
							if(!query.Compare(val_inst,0,0,&val_q,CaplQLQuery::aplSMALLEQUAL)){in_list=false;break;}
						}else{
							if(el_ch->b_val){
								r_val_q=__atof(el_ch->val);
								val_q.Set(r_val_q);
								if(!query.Compare(val_inst,0,0,&val_q,el_ch->log_relation)){in_list=false;break;}
							}
							if(el_ch->b_max){
								r_val_q=__atof(el_ch->val_max);
								val_q.Set(r_val_q);
								if(!query.Compare(val_inst,0,0,&val_q,el_ch->log_relation)){in_list=false;break;}
							}
							if(el_ch->b_min){
								r_val_q=__atof(el_ch->val_min);
								val_q.Set(r_val_q);
								if(!query.Compare(val_inst,0,0,&val_q,el_ch->log_relation)){in_list=false;break;}
							}
						}
					}
					else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_descript_unit)||
						apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_enum_unit) )
					{
						if(el_ch->b_val){
							val_q.Set(el_ch->val);
							if(!query.Compare(val_inst,0,0,&val_q,el_ch->log_relation)){in_list=false;break;}
						}
					}
					else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_monetary_unit))
					{
						if(el_ch->log_relation==CaplQLQuery::aplINDIAPAZON){
							r_val_q=__atof(el_ch->val);
							val_q.Set(r_val_q);
							if(!query.Compare(val_inst,0,0,&val_q,CaplQLQuery::aplBIGEQUAL)){in_list=false;break;}
							r_val_q=__atof(el_ch->val_max);
							val_q.Set(r_val_q);
							if(!query.Compare(val_inst,0,0,&val_q,CaplQLQuery::aplSMALLEQUAL)){in_list=false;break;}
						}else{
							if(el_ch->b_val){
								i_val_q=_atoi(el_ch->val);
								val_q.Set(i_val_q);
								if(!query.Compare(val_inst,0,0,&val_q,el_ch->log_relation)){in_list=false;break;}
							}
						}
					}
					else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_time_unit))
					{
						apidata.GetAttrBN(char_val,_T("val_s"),val_inst);
						if(el_ch->log_relation==CaplQLQuery::aplINDIAPAZON){
							val_q.Set(el_ch->val);
							if(!query.Compare(val_inst,0,0,&val_q,CaplQLQuery::aplBIGEQUAL)){in_list=false;break;}
							val_q.Set(el_ch->val_max);
							if(!query.Compare(val_inst,0,0,&val_q,CaplQLQuery::aplSMALLEQUAL)){in_list=false;break;}
						}else{
							if(el_ch->b_val){
								val_q.Set(el_ch->val);
								if(!query.Compare(val_inst,0,0,&val_q,el_ch->log_relation)){in_list=false;break;}
							}
						}
					}
					else if(apidata.IsKindOf(unit,m_api->m_charact_mgr.e_apl_reference_unit))
					{
						if(el_ch->b_val){
							val_q.Set(el_ch->m_cur_ref_val);
							if(!query.Compare(val_inst,0,0,&val_q,el_ch->log_relation)){in_list=false;break;}
						}
					}
					else
					{//       ""
					}				
				}

				//////////////////////////////////////////
			}
		}
		if(in_list){
			pSID = new SItemColumnData(ext[i]);
			m_Items.Add(pSID);
		}
	}
	m_ListCtrl.m_api=m_api;

	//         -  
	column_data=(CaplDataBuf*)map_inst_column_data.QGetPointerByIn((long)Inst);
	if(column_data!=0){
		m_ListCtrl.SetColumnData(*column_data);
	}

	if(m_ListCtrl.IsVisibleDefault())
	{
		m_ListCtrl.VisibleColumnRemove(0,OBJ_COL_INSTANCE_ID);
		m_ListCtrl.VisibleColumnRemove(0,OBJ_COL_COUNT);
		m_ListCtrl.VisibleColumnRemove(0,OBJ_COL_UNIT);
	}

	m_ListCtrl.SetData(m_Items);

	if(NULL != m_filter)
	{
		m_ListCtrl.m_filter_entity = m_filter->search_entity;
		for(i=0;i<m_filter->display_array.GetSize();i++)
		{
			m_ListCtrl.m_filter_attrs.Add(m_filter->display_array[i]);

		}
		m_ListCtrl.m_sorting_field = m_filter->sorting_field;
	}

	if(column_data==0){
		//       -      
		m_api->m_classifier_mgr.GetClassifierCharacteristic(Inst, characts, true,true,m_load_from_bd);
		m_ListCtrl.SetCharacterysticFromExt(characts,0,false,m_load_from_bd);
	}
	m_ListCtrl.FillTable(false);



	::KillTimer(m_hWnd, ID_LOAD_ITEM_INFO);
	
	if(m_DlgId)
		aplEndWaitDlg(m_DlgId);

	CaplInstance *form=0;
	if(m_state_show_in_form){
		m_api->m_classifier_mgr.GetClassifierForms(m_ClassifierElement,ext);
		form=ext[0];
	}
	m_ListCtrl.SetPropertiesForm(form);
	m_load_from_bd=false;
	return true;
}

void CClassifierTableItemsView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);

	if(::IsWindow(m_ListCtrl.m_hWnd))
		m_ListCtrl.MoveWindow(0, 0, cx, cy);
}

void CClassifierTableItemsView::ShowEmptyList()
{
	CRect rect;
	m_ListCtrl.GetClientRect(&rect);
	m_ListCtrl.DeleteAllItems();
	m_ListCtrl.DeleteAllColumns();
	m_ListCtrl.InsertColumn(0, _T(""), LVCFMT_LEFT, rect.Width());
}

void CClassifierTableItemsView::OnCopyItem()
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(!m_api->m_classifier_mgr.TestObjectLevelOfLevel(m_ClassifierElement))
		return;
	

	int cur, tmp, i,j;
	cur = m_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	if(cur<0) return;
	
	CaplInstance *Inst=NULL, *Inst1=NULL, *Inst2=NULL, *Inst3=NULL;
	CaplInstance *OldPrd=0;
	CaplInstance *InstNew=0;
	aplExtent access_patterns,access_dest;
	aplExtent vers;
	int num_group;
	m_ListCtrl.GetCharacteristicByRC(cur, 0, &Inst, tmp, &Inst1, &Inst2, &Inst3, num_group);
	if(Inst==NULL) return;
	//   ,    
	if(m_api->m_data.IsKindOf(Inst,m_api->m_prd_mgr.e_prd)==TRUE){
		InstNew=m_api->m_prd_mgr.CreateProduct(Inst,aplModeCreateProduct);
		access_patterns.Add(Inst);
		access_dest.Add(InstNew);

	}else if(m_api->m_data.IsKindOf(Inst,m_api->m_prd_mgr.e_pdf)==TRUE){
		m_api->m_data.GetAttr(Inst,m_api->m_prd_mgr.a_pdf_prd,OldPrd);
		InstNew=m_api->m_prd_mgr.CreateProduct(Inst,aplModeCreateProductIfNew);
		if(InstNew)
		{
			m_api->m_data.GetAttr(InstNew,m_api->m_prd_mgr.a_pdf_prd,Inst1);
			access_patterns.Add(Inst);
			access_dest.Add(InstNew);
			if(OldPrd!=Inst1)
			{
				access_patterns.Add(OldPrd);
				access_dest.Add(Inst1);
			}
		}

	}else if(m_api->m_data.IsKindOf(Inst,m_api->m_prd_inst_mgr.e_prd_inst)==TRUE){
		InstNew=m_api->m_prd_inst_mgr.CopyPrdInst(Inst);
		access_patterns.Add(Inst);
		access_dest.Add(InstNew);
	}else {
		//     
		return;
	}
	if(InstNew!=0){
		//       
		m_api->m_classifier_mgr.CreateClassifierAssociation(InstNew, m_ClassifierElement, false);

		//   
		aplExtent out_characts,out_groups;
		CaplInstance *old_charact, *new_charact,*new_group;
		CaplMap inst_map;//  -    -   
		aplExtent new_groups;
		bool flag_error=false;

		m_api->m_charact_mgr.FindAssociatedCharacteristic(Inst,out_characts,out_groups,true);
		for(i=0;i<out_groups.GetSize();i++){
			m_api->m_charact_mgr.CreateCharacteristicGroup(InstNew,&new_group,out_groups[i],false);
			new_groups.Add(new_group);
		}
		//m_api->m_data.SaveToTextFile(_T("d:\\1.std"));
		for(i=0;i<out_characts.GetSize();i++){
			old_charact=out_characts.GetAt(i);
			new_charact=0;
			m_api->m_data.GetAttr(old_charact,m_api->m_charact_mgr.a_apl_charact_val_group,Inst1);
			if(Inst1!=0){
				//      
				continue;
			}
			new_charact=m_api->m_charact_mgr.CreateCopyCharacteristicVal(old_charact,new_charact,&inst_map);
			if(new_charact==0){
				flag_error=true;
				break;
			}
			m_api->m_data.PutAttr(new_charact,m_api->m_charact_mgr.a_apl_charact_val_item,InstNew);
			
		}
		//m_api->m_data.SaveToTextFile(_T("d:\\2.std"));
		if(flag_error){
			int mb_res=IDYES;
			if(m_api->m_ModeInteractive){
				mb_res=AfxMessageBox( APL_T("   !   ?"), MB_YESNO);
			}
			for(j=0;j<inst_map.Size;j++){
				new_charact=(CaplInstance*)inst_map.Data[j].out;
				m_api->m_charact_mgr.DeleteCharacteristic(new_charact);
			}
			for(j=0;j<new_groups.Size;j++){
				new_group=new_groups[j];
				m_api->m_charact_mgr.DeleteCharacteristicGroup(new_group);
			}
			if(mb_res==IDYES){
				if(m_api->m_data.IsKindOf(InstNew,m_api->m_prd_mgr.e_prd)==TRUE){
					m_api->m_data.DeleteInstance(InstNew);
				}else if(m_api->m_data.IsKindOf(InstNew,m_api->m_prd_mgr.e_pdf)==TRUE){
					m_api->m_prd_mgr.DeleteProductVersion(InstNew);
				}else if(m_api->m_data.IsKindOf(Inst,m_api->m_prd_inst_mgr.e_prd_inst)==TRUE){
					//       
				}
			}
		}else{
			m_api->m_data.NET_CopyAccessFromInst2Inst(access_patterns,access_dest,0,-1, -1);

			SItemColumnData *pData = new SItemColumnData(InstNew);
			m_ListCtrl.AddItem(pData);
		}
		if(m_api->m_AutoSave) m_api->SaveChanges();
	}
}

void CClassifierTableItemsView::OnAddItem()
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(!m_api->m_classifier_mgr.TestObjectLevelOfLevel(m_ClassifierElement))
		return;

	CaplInstance *system;
	m_api->m_data.GetAttr(m_ClassifierElement, m_api->m_classifier_mgr.a_apl_classifier_level_system, system);
	if(system)
	{
		bool bHasTypeCtlr = false;
		m_api->m_data.GetAttr(system, m_api->m_classifier_mgr.a_apl_classifier_system_is_type_control, bHasTypeCtlr);
		if(bHasTypeCtlr)
		{
			CString sEntity;
			CaplEntity *pEntity = NULL;
			m_api->m_data.GetAttr(system, m_api->m_classifier_mgr.a_apl_classifier_system_stored_entity, sEntity);
			if(!sEntity.IsEmpty())
			{
				pEntity = m_api->m_data.GetEntityBN(sEntity);
				if(pEntity)
				{
					ShowCreateDialog(pEntity);
				}
			}
		}
		else
		{
			if(GetParentFrame())
			{
				CFrameWnd* pFrame = GetParentFrame();
				if(pFrame->IsKindOf(RUNTIME_CLASS(CClassifierTableFrame)))
				{
					((CClassifierTableFrame*)pFrame)->ShowSelectEntityMenu();
				}
			}
		}
	}
}

void CClassifierTableItemsView::OnShowPropInForm()
{
	if(m_api==NULL) return;
	CaplInstance *form=0;
	aplExtent ext;
	m_state_show_in_form=!m_state_show_in_form;
	if(m_state_show_in_form){
		m_api->m_classifier_mgr.GetClassifierForms(m_ClassifierElement,ext);
		form=ext[0];
	}
	m_ListCtrl.SetPropertiesForm(form);
	
}
void CClassifierTableItemsView::OnShowFiltrProp()
{
	if(m_api==NULL) return;
	//  
	CSpravFilterPropDlg dlg;

	if(m_ClassifierElement==0){
		AfxMessageBox( APL_T("   !"));
		return;
	}
	aplExtent all_charact;
	m_api->m_classifier_mgr.GetClassifierCharacteristic(m_ClassifierElement,all_charact,true,true);
	m_api->m_classifier_mgr.GetClassifierElementFilters(m_ClassifierElement,&m_list_char);

	if(m_list_char==0){
		AfxMessageBox( APL_T("    !"));
		return;
	}

	dlg.m_api=m_api;
	dlg.m_list_char.Clone(m_list_char);
	dlg.m_all_char=&all_charact;
	if(dlg.DoModal()==IDOK){
		m_list_char->Clone(&(dlg.m_list_char));
		// 
		if(m_state_show_by_filtr && m_ClassifierElement!=0){
			UpdateTable(m_ClassifierElement);
		}
	}
}

void CClassifierTableItemsView::OnShowByFiltr()
{
	m_state_show_by_filtr=!m_state_show_by_filtr;
	if(m_ClassifierElement!=0){
		UpdateTable(m_ClassifierElement);
	}
}

void CClassifierTableItemsView::OnAddItemWForm()
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(!m_api->m_classifier_mgr.TestObjectLevelOfLevel(m_ClassifierElement))
		return;
	
	CaplInstance *created_object=0;
	aplExtent created_objects;
	if(m_api->m_classifier_mgr.CreateObjectWithForm(m_ClassifierElement,&created_objects))
	{
		for(int i=0;i<created_objects.GetSize();i++){
			created_object=created_objects[i];
			if(created_object!=0){
				SItemColumnData *pData = new SItemColumnData(created_object);
				m_ListCtrl.AddItem(pData);
			}
		}
	}

}

void CClassifierTableItemsView::OnUpdateFiltr(CCmdUI* pCmdUI) 
{
	if(m_api==NULL) {pCmdUI->Enable(FALSE);return;}
	BOOL bEnable = TRUE;
	if(m_api==NULL) 
		bEnable = FALSE;
	else if(!m_api->m_data.IsDictLoad())
		bEnable = FALSE;
	else if(NULL != m_filter)
		bEnable = FALSE;
//	if(m_Mode&APL_SELECT_CLASSIFIER_ITEM)
//		bEnable = FALSE;
	
	pCmdUI->Enable(bEnable);
}

void CClassifierTableItemsView::OnUpdateAddItem(CCmdUI* pCmdUI) 
{
	if(m_api==NULL) {pCmdUI->Enable(FALSE);return;}
	BOOL bEnable = TRUE;
	if(m_api==NULL) 
		bEnable = FALSE;
	else if(!m_api->m_data.IsDictLoad())
		bEnable = FALSE;
	else if(m_ClassifierElement == NULL)
		bEnable = FALSE;
	else if(!m_api->m_classifier_mgr.TestObjectLevelOfLevel(m_ClassifierElement, true))
		bEnable = FALSE;
//	if(m_Mode&APL_SELECT_CLASSIFIER_ITEM)
//		bEnable = FALSE;
	
	pCmdUI->Enable(bEnable);
}

void CClassifierTableItemsView::OnUpdateCopyItem(CCmdUI* pCmdUI) 
{
	if(m_api==NULL) {pCmdUI->Enable(FALSE);return;}
	BOOL bEnable = TRUE;
	if(m_api==NULL) {
		bEnable = FALSE;
	}else if(!m_api->m_data.IsDictLoad()){
		bEnable = FALSE;
	}else if(m_ClassifierElement == NULL){
		bEnable = FALSE;
// 	}else if(!m_api->m_classifier_mgr.TestObjectLevelOfLevel(m_ClassifierElement, true)){
// 		bEnable = FALSE;
//	}else if(m_Mode&APL_SELECT_CLASSIFIER_ITEM){
//		bEnable = FALSE;
	}else{
		int cur = m_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
		if(cur<0){
			bEnable = FALSE;
		}else{
			CaplInstance *Inst=NULL, *Inst1=NULL, *Inst2=NULL, *Inst3=NULL;
			int num_group,tmp;
			m_ListCtrl.GetCharacteristicByRC(cur, 0, &Inst, tmp, &Inst1, &Inst2, &Inst3, num_group);
			if(Inst==NULL){
				bEnable = FALSE;
			}else{
				//   ,    
				if(m_api->m_data.IsKindOf(Inst,m_api->m_prd_mgr.e_prd)==TRUE){
				}else if(m_api->m_data.IsKindOf(Inst,m_api->m_prd_mgr.e_pdf)==TRUE){
				}else if(m_api->m_data.IsKindOf(Inst,m_api->m_prd_inst_mgr.e_prd_inst)==TRUE){
				}else {
					//     
					bEnable = FALSE;
				}
			}
			
		}
	}
	pCmdUI->Enable(bEnable);
}

void CClassifierTableItemsView::OnUpdateAddItemWF(CCmdUI* pCmdUI) 
{
	if(m_api==NULL) {pCmdUI->Enable(FALSE);return;}
	BOOL bEnable = TRUE;
	aplExtent ext;
	if(m_api==NULL) 
		bEnable = FALSE;
	else if(!m_api->m_data.IsDictLoad())
		bEnable = FALSE;
	else if(m_ClassifierElement == NULL)
		bEnable = FALSE;
	else if(!m_api->m_classifier_mgr.TestObjectLevelOfLevel(m_ClassifierElement, true))
		bEnable = FALSE;
	else{
		m_api->m_classifier_mgr.GetClassifierForms(m_ClassifierElement,ext);
		if(ext.GetSize()==0)
			bEnable = FALSE;
	}
//	if(m_Mode&APL_SELECT_CLASSIFIER_ITEM)
//		bEnable = FALSE;
	
	pCmdUI->Enable(bEnable);
}

void CClassifierTableItemsView::OnTimer(UINT nIDEvent) 
{
	if(nIDEvent==ID_LOAD_ITEM_INFO)
	{
		CString buf;
		buf.LoadString(ID_LOAD_ITEM_INFO);
		m_DlgId = aplStartWaitDlg(buf);
		::KillTimer(m_hWnd, ID_LOAD_ITEM_INFO);
	}
	
	CView::OnTimer(nIDEvent);
}

void CClassifierTableItemsView::OnFindAdd() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;

	if(!m_api->m_classifier_mgr.TestObjectLevelOfLevel(m_ClassifierElement))
		return;

	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString buf = APL_T("    ");
		buf+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		buf+=APL_T("    !");
		AfxMessageBox(buf);
		return;
	}

	long Flags= //APL_MODE_SELECT_CATEGORY|
				APL_MODE_SELECT_FOLDER|
				APL_MODE_SELECT_PRD|
				APL_MODE_SELECT_PDF|
				APL_MODE_SELECT_DOC|
				APL_MODE_SELECT_BP|
				APL_MODE_SELECT_LOT|
				APL_MODE_SELECT_PRDINST|
				APL_MODE_SELECT_DOC_REVISION|
				APL_MODE_SELECT_BP_REVISION|
				//APL_MODE_SELECT_CATEG_REVISION|
				APL_MODE_SELECT_PROJECT|	
				APL_MODE_SELECT_ORG|
				//APL_MODE_SELECT_PERSON|
				//APL_MODE_SELECT_OFFICIAL|
				//APL_MODE_SELECT_CHANGE|
				APL_MODE_SELECT_BPINST
				;
	CaplInstance* system;
	m_api->m_data.GetAttr(m_ClassifierElement, m_api->m_classifier_mgr.a_apl_classifier_level_system, system);
	if(system)
	{
		bool bHasTypeCtlr = false;
		m_api->m_data.GetAttr(system, m_api->m_classifier_mgr.a_apl_classifier_system_is_type_control, bHasTypeCtlr);
		if(bHasTypeCtlr)
		{
			CString sEntity;
			m_api->m_data.GetAttr(system, m_api->m_classifier_mgr.a_apl_classifier_system_stored_entity, sEntity);
			if(!sEntity.IsEmpty())
			{
				if(sEntity.CompareNoCase(m_api->m_prd_mgr.e_prd->name)==0) 
					Flags = APL_MODE_SELECT_PRD;
				else if(sEntity.CompareNoCase(m_api->m_prd_mgr.e_apl_pdf->name)==0) 
					Flags = APL_MODE_SELECT_PDF;
				else if(sEntity.CompareNoCase(m_api->m_doc_mgr.e_apl_doc->name)==0) 
					Flags = APL_MODE_SELECT_DOC;
				else if(sEntity.CompareNoCase(m_api->m_prd_inst_mgr.e_lot->name)==0) 
					Flags = APL_MODE_SELECT_LOT;
				else if(sEntity.CompareNoCase(m_api->m_prd_inst_mgr.e_prd_inst->name)==0) 
					Flags = APL_MODE_SELECT_PRDINST;
				else if(sEntity.CompareNoCase(m_api->m_bp_mgr.e_bp->name)==0) 
					Flags = APL_MODE_SELECT_BP;
				else if(sEntity.CompareNoCase(m_api->m_bp_mgr.e_apl_bp_inst->name)==0) 
					Flags = APL_MODE_SELECT_BPINST;
				else if(sEntity.CompareNoCase(m_api->m_categ_mgr.e_categ->name)==0) 
					Flags = APL_MODE_SELECT_CATEGORY;
				else if(sEntity.CompareNoCase(m_api->m_folder_mgr.e_folder->name)==0) 
					Flags = APL_MODE_SELECT_FOLDER;
				else if(sEntity.CompareNoCase(m_api->m_project_mgr->e_project->name)==0) 
					Flags = APL_MODE_SELECT_PROJECT;
				else if(sEntity.CompareNoCase(m_api->m_appr_mgr.e_person->name)==0) 
					Flags = APL_MODE_SELECT_PERSON;
				else if(sEntity.CompareNoCase(m_api->m_appr_mgr.e_org->name)==0) 
					Flags = APL_MODE_SELECT_ORG;
				else if(sEntity.CompareNoCase(m_api->m_change_mgr.e_chng->name)==0) 
					Flags = APL_MODE_SELECT_CHANGE;
			}
		}
	}

	CaplInstance* associator=0;
	CaplInstance* inst = m_api->m_classifier_mgr.SelectInstance(Flags,  APL_T(" "));
	if(inst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(inst, m_ClassifierElement))
		{
			associator=m_api->m_classifier_mgr.CreateClassifierAssociation(inst, m_ClassifierElement, true);
			if(associator!=0)
			{
				SItemColumnData* pData = new SItemColumnData(inst);
				m_ListCtrl.AddItem(pData);
			}
		}
	}
}

void CClassifierTableItemsView::OnItemDelete()
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsDictLoad()) return;
	if(m_ClassifierElement == NULL) return;

	CUIntArray ext_sel;

	int num_curr= m_ListCtrl.GetNextItem( -1 , LVNI_ALL | LVNI_SELECTED );
	while( num_curr!= -1)
	{
		ext_sel.Add(num_curr);
		num_curr= m_ListCtrl.GetNextItem( num_curr , LVNI_ALL | LVNI_SELECTED );
	}
	if(ext_sel.GetSize()==0) return;
	if(ext_sel.GetSize()==1)
	{
		if(AfxMessageBox( APL_T("    ?"), MB_YESNO|MB_ICONQUESTION)!=IDYES) return;
	}
	else
	{
		if(AfxMessageBox( APL_T("    ?"), MB_YESNO|MB_ICONQUESTION)!=IDYES) return;
	}


	int ind,i;
	SItemColumnData* pData = NULL;
	bool bOldMI = m_api->m_ModeInteractive;
	m_api->m_ModeInteractive = false;

	for(i=ext_sel.GetSize()-1;i>=0;i--)
	{
		ind = (int)m_ListCtrl.GetItemData(ext_sel[i]);
		pData = m_Items.GetAt(ind);
		if(pData==NULL)
		{
			m_Items.Remove(ind);
			m_ListCtrl.DeleteItem(ext_sel[i]);
		}
		else if(m_api->m_classifier_mgr.DeleteClassifierAssociation(pData->m_inst, m_ClassifierElement))
		{
			m_Items.Remove(ind);
			m_ListCtrl.DeleteItem(ext_sel[i]);
		}
	}

	m_api->m_ModeInteractive = bOldMI;
}

void CClassifierTableItemsView::OnItemProperties() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsDictLoad()) return;
	if(m_ClassifierElement == NULL) return;
	
	int cur = m_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	if(cur<0) return;
	
	SItemColumnData* pData = NULL;
	int ind = (int)m_ListCtrl.GetItemData(cur);
	pData = m_Items.GetAt(ind);

	if(pData)
		ShowItemProperties(pData->m_inst);
}

void CClassifierTableItemsView::OnListCtrlDblClick(NMHDR *pNMHDR, LRESULT *pResult)
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;

	if(m_Mode&APL_CLASSIFIER_EXE_EDITOR || m_Mode&APL_CLASSIFIER_EDITOR)	
		m_ListCtrl.EditCell(((LPNMLISTVIEW)pNMHDR)->iItem, ((LPNMLISTVIEW)pNMHDR)->iSubItem);
	*pResult = 0;	
}

void CClassifierTableItemsView::ShowCreateDialog(CaplEntity *pEntity)
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString buf=APL_T("    ");
		buf+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		buf+=APL_T("    !");
		AfxMessageBox( buf  , MB_OK|MB_ICONSTOP);
		return;
	}
	if(pEntity==NULL) return;
	
	CaplInstance *nInst = NULL;
	if(pEntity==m_api->m_doc_mgr.e_apl_doc)
		nInst = m_api->m_doc_mgr.CreateDocument(NULL, NULL, NULL, NULL, NULL);
	else if(pEntity==m_api->m_bp_mgr.e_bp)
		nInst = m_api->m_bp_mgr.CreateBP();
	else if(pEntity==m_api->m_bp_mgr.e_apl_bp_inst)
		nInst = m_api->m_bp_mgr.CreateBPInst();
	else if(pEntity==m_api->m_prd_inst_mgr.e_prd_inst)
		nInst = m_api->m_prd_inst_mgr.CreatePrdInst();
	else if(pEntity==m_api->m_prd_inst_mgr.e_lot)
		nInst = m_api->m_prd_inst_mgr.CreateLot();
	else if(pEntity==m_api->m_folder_mgr.e_folder)
		nInst = m_api->m_folder_mgr.CreateFolder(NULL, NULL, NULL);
	else if(pEntity==m_api->m_categ_mgr.e_categ)
		nInst = m_api->m_categ_mgr.CreateCategory(NULL, NULL, NULL);
	else if(pEntity==m_api->m_appr_mgr.e_person)
		nInst = m_api->m_appr_mgr.CreatePerson(NULL);
	else if(pEntity==m_api->m_appr_mgr.e_org)
		nInst = m_api->m_appr_mgr.CreateOrganization();
	else if(pEntity==m_api->m_prd_mgr.e_prd)
		nInst = m_api->m_prd_mgr.CreateProduct(NULL, aplModeCreateProduct);
	else if(pEntity==m_api->m_prd_mgr.e_pdf || pEntity==m_api->m_prd_mgr.e_apl_pdf)
		nInst = m_api->m_prd_mgr.CreateProduct(NULL, aplModeCreateVersion);
	else if(pEntity==m_api->m_change_mgr.e_chng)
	{
		aplExtent ext;
		nInst = m_api->m_change_mgr.CreateChange(NULL, NULL, NULL, NULL, NULL, ext);
	}
	else if(pEntity==m_api->m_project_mgr->e_project)
		nInst = m_api->m_project_mgr->CreateProject();
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
		else
		{
			AfxMessageBox( APL_T("     !"), MB_OK|MB_ICONINFORMATION);
		}
	}
}

void CClassifierTableItemsView::ShowItemProperties(CaplInstance *Item)
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(Item==NULL) return;

	if(m_api->ShowItemProperties(Item))
		m_ListCtrl.FillTable(true, 0);
}

void CClassifierTableItemsView::OnEntProduct() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString buf=APL_T("    ");
		buf+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		buf+=APL_T("    !");
		AfxMessageBox(buf, MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst = NULL;
	nInst = m_api->m_prd_mgr.CreateProduct(NULL, aplModeCreateProduct);
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntBp() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString buf=APL_T("    ");
		buf+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		buf+=APL_T("    !");
		AfxMessageBox( buf , MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst;
	nInst = m_api->m_bp_mgr.CreateBP();
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntBpinst() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString buf= APL_T("    ");
		buf+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		buf+= APL_T("    !");
		AfxMessageBox( buf , MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst = NULL;
	nInst = m_api->m_bp_mgr.CreateBPInst();
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntCateg() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString buf=APL_T("    ");
		buf+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		buf+=APL_T("    !");
		AfxMessageBox(buf, MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst = NULL;
	nInst = m_api->m_categ_mgr.CreateCategory(NULL, NULL, NULL);
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntChange() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString mes= APL_T("    ");
		mes+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		mes+= APL_T("    !");
		AfxMessageBox( mes , MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst = NULL;
	aplExtent ext;
	nInst = m_api->m_change_mgr.CreateChange(NULL, NULL, NULL, NULL, NULL, ext);
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntDocument() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString mes= APL_T("    ");
		mes+= ACCESS2LEVEL_FOR_OBJECT_DESCR;
		mes+= APL_T("    !");
		AfxMessageBox(mes);
		return;
	}
	
	CaplInstance *nInst = NULL;
	nInst = m_api->m_doc_mgr.CreateDocument(NULL, NULL, NULL, NULL, NULL);

	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntFolder() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString mes= APL_T("    ");
		mes+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		mes+= APL_T("    !");
		AfxMessageBox( mes , MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst = NULL;
	nInst = m_api->m_folder_mgr.CreateFolder(NULL, NULL, NULL);
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntProject() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString mes= APL_T("    ");
		mes+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		mes+= APL_T("    !");
		AfxMessageBox( mes , MB_OK|MB_ICONSTOP);
		return;
	}

	CaplInstance *nInst = NULL;
	nInst = m_api->m_project_mgr->CreateProject();

	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntLot() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString mes= APL_T("    ");
		mes+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		mes+= APL_T("    !");
		AfxMessageBox( mes , MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst = NULL;
	nInst = m_api->m_prd_inst_mgr.CreateLot();
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntOrg() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString mes= APL_T("    ");
		mes+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		mes+= APL_T("    !");
		AfxMessageBox(mes , MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst = NULL;
	nInst = m_api->m_appr_mgr.CreateOrganization();
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntPerson() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString mes= APL_T("    ");
		mes+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		mes+= APL_T("    !");
		AfxMessageBox( mes  , MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst = NULL;
	nInst = m_api->m_appr_mgr.CreatePerson(NULL);
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntPrdinst() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString mes= APL_T("    ");
		mes+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		mes+= APL_T("    !");
		AfxMessageBox(mes , MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst = NULL;
	nInst = m_api->m_prd_inst_mgr.CreatePrdInst();
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntProductVersion() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString mes= APL_T("    ");
		mes+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		mes+= APL_T("    !");
		AfxMessageBox( mes , MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst = NULL;
	nInst = m_api->m_prd_mgr.CreateProduct(NULL, aplModeCreateVersion);
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnEntProjet() 
{
	if(m_api==NULL) return;
	if(!m_api->m_data.IsConnected()) return;
	if(m_ClassifierElement == NULL) return;
	if(m_ClassifierElement->GetAccessmode()>ACCESS2LEVEL_FOR_OBJECT)
	{
		CString mes= APL_T("    ");
		mes+=ACCESS2LEVEL_FOR_OBJECT_DESCR;
		mes+= APL_T("    !");
		
		AfxMessageBox( mes , MB_OK|MB_ICONSTOP);
		return;
	}
	
	CaplInstance *nInst = NULL;
	nInst = m_api->m_project_mgr->CreateProject();
	
	if(nInst)
	{
		if(!m_api->m_classifier_mgr.TestClassifierAssociation(nInst, m_ClassifierElement))
		{
			m_api->m_classifier_mgr.CreateClassifierAssociation(nInst, m_ClassifierElement, false);
			SItemColumnData *pData = new SItemColumnData(nInst);
			m_ListCtrl.AddItem(pData);
		}
	}
}

void CClassifierTableItemsView::OnUpdateEntChange(CCmdUI* pCmdUI)
{
}

void CClassifierTableItemsView::OnUpdateEntProjet(CCmdUI* pCmdUI) 
{
}

void CClassifierTableItemsView::OnUpdateEntPerson(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(FALSE);
}

void CClassifierTableItemsView::OnUpdateEntOrg(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(FALSE);
}

void CClassifierTableItemsView::OnUpdateEntCateg(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(FALSE);
}

void CClassifierTableItemsView::OnColumnSetup() 
{
	m_ListCtrl.SelectColumnsOrder(0);
}

void CClassifierTableItemsView::OnColumnCharactSetup() 
{
	m_ListCtrl.SelectCharacterysticSet(0);
}

void CClassifierTableItemsView::OnUpdateColumnSetup(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(NULL == m_filter && m_ListCtrl.GetItemCount()>0);
}

void CClassifierTableItemsView::OnUpdateFindAdd(CCmdUI* pCmdUI) 
{
	if(m_api==NULL) {pCmdUI->Enable(FALSE);return;}
	BOOL bEnable = TRUE;
	if(m_api==NULL) 
		bEnable = FALSE;
	if(!m_api->m_data.IsDictLoad())
		bEnable = FALSE;
	if(m_ClassifierElement == NULL)
		bEnable = FALSE;
	if(!m_api->m_classifier_mgr.TestObjectLevelOfLevel(m_ClassifierElement, true))
		bEnable = FALSE;
//	if(m_Mode&APL_SELECT_CLASSIFIER_ITEM)
//		bEnable = FALSE;
	
	pCmdUI->Enable(bEnable);
}

void CClassifierTableItemsView::OnUpdateItemDelete(CCmdUI* pCmdUI) 
{
	if(m_api==NULL) {pCmdUI->Enable(FALSE);return;}

	BOOL bEnable = TRUE;
	int cur;

	if(m_api==NULL) 
		bEnable = FALSE;
	if(!m_api->m_data.IsDictLoad())
		bEnable = FALSE;
	if(m_ClassifierElement == NULL)
		bEnable = FALSE;
	if(!m_api->m_classifier_mgr.TestObjectLevelOfLevel(m_ClassifierElement, true))
		bEnable = FALSE;
//	if(m_Mode&APL_SELECT_CLASSIFIER_ITEM)
//		bEnable = FALSE;
	
	cur = m_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	pCmdUI->Enable(bEnable && cur>-1);
}

void CClassifierTableItemsView::OnUpdateItemProperties(CCmdUI* pCmdUI) 
{
	if(m_api==NULL) {pCmdUI->Enable(FALSE);return;}
	BOOL bEnable = TRUE;
	int cur;
	
	if(m_api==NULL) 
		bEnable = FALSE;
	if(!m_api->m_data.IsDictLoad())
		bEnable = FALSE;
	if(m_ClassifierElement == NULL)
		bEnable = FALSE;
	
	cur = m_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	pCmdUI->Enable(bEnable && cur>-1);
}

void CClassifierTableItemsView::OnEditCopy() 
{
	CopyToClipboard();
}

void CClassifierTableItemsView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	if(m_api==NULL) {pCmdUI->Enable(FALSE);return;}
	BOOL bEnable = TRUE;
	int cur;

	if(m_api==NULL) 
		bEnable = FALSE;
	if(!m_api->m_data.IsDictLoad())
		bEnable = FALSE;
	if(m_ClassifierElement == NULL)
		bEnable = FALSE;
	
	cur = m_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	pCmdUI->Enable(bEnable && cur>-1);
}

void CClassifierTableItemsView::OnEditPaste() 
{
	if(m_api==NULL) 
		return;
	if(!m_api->m_data.IsDictLoad())
		return;
	if(m_ClassifierElement == NULL)
		return;
	if(!m_api->m_classifier_mgr.TestObjectLevelOfLevel(m_ClassifierElement, true))
		return;

	// 
	COleDataObject DataObject;
	if(!DataObject.AttachClipboard()) return;
	Paste(&DataObject);
	DataObject.Release();
}

void CClassifierTableItemsView::OnUpdateEditPaste(CCmdUI* pCmdUI) 
{
	if(m_api==NULL) {pCmdUI->Enable(FALSE);return;}
	BOOL bEnable = TRUE;

	if(m_api==NULL) 
		bEnable = FALSE;
	if(!m_api->m_data.IsDictLoad())
		bEnable = FALSE;
	if(m_ClassifierElement == NULL)
		bEnable = FALSE;
	if(!m_api->m_classifier_mgr.TestObjectLevelOfLevel(m_ClassifierElement, true))
		bEnable = FALSE;
	COleDataObject pDataObject;
	if(!pDataObject.AttachClipboard()) return;
	UINT cf_hinst=RegisterClipboardFormat(APL_INSTANCE_CLIPBOARDFORMAT);
	pCmdUI->Enable(pDataObject.IsDataAvailable(cf_hinst));
	pDataObject.Detach();
}

bool CClassifierTableItemsView::CopyToClipboard()
{
	if(m_api==NULL) return false;
	if(!m_api->m_data.IsDictLoad()) return false;
	if(m_ClassifierElement == NULL) return false;
	
	int cur, tmp;
	cur = m_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	if(cur<0) return false;
	
	CaplInstance *Inst=NULL, *Inst1=NULL, *Inst2=NULL, *Inst3=NULL;
	int num_group;
	m_ListCtrl.GetCharacteristicByRC(cur, 0, &Inst, tmp, &Inst1, &Inst2, &Inst3, num_group);
	if(Inst==NULL) return false;

	COleDataSource *pSource = PrepareDatasource(Inst);
	pSource->SetClipboard();

	return true;
}

BOOL CClassifierTableItemsView::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;
}

BOOL CClassifierTableItemsView::OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point) 
{
	if(!(m_Mode&APL_CLASSIFIER_EDITOR || m_Mode&APL_CLASSIFIER_EXE_EDITOR)) return FALSE;

	UINT flag=TVHT_ONITEM|TVHT_ONITEMRIGHT;
	if(pDataObject!=0)
	{
		if(!Paste(pDataObject)) MessageBeep(MB_ICONEXCLAMATION);
	}

	return CView::OnDrop(pDataObject, dropEffect, point);
}

DROPEFFECT CClassifierTableItemsView::OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
{
	if(!(m_Mode&APL_CLASSIFIER_EDITOR || m_Mode&APL_CLASSIFIER_EXE_EDITOR)) return DROPEFFECT_NONE;
	// TODO: Add your specialized code here and/or call the base class
	
	return DROPEFFECT_LINK|DROPEFFECT_COPY;
}

void CClassifierTableItemsView::OnDragLeave() 
{
	if(!(m_Mode&APL_CLASSIFIER_EDITOR || m_Mode&APL_CLASSIFIER_EXE_EDITOR)) return;
	
	CView::OnDragLeave();
}

DROPEFFECT CClassifierTableItemsView::OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
{
	if(!(m_Mode&APL_CLASSIFIER_EDITOR || m_Mode&APL_CLASSIFIER_EXE_EDITOR)) return DROPEFFECT_NONE;

	//  
	CMDIChildWnd *act_frm=((CMDIFrameWnd*)AfxGetMainWnd())->MDIGetActive();
	CWnd *my_frm=this->GetParentFrame();
	if(my_frm==NULL) return DROPEFFECT_NONE;
	my_frm = my_frm->GetParentFrame();
	if(my_frm!=act_frm) ((CMDIFrameWnd*)AfxGetMainWnd())->MDIActivate(my_frm);
	
	return DROPEFFECT_LINK|DROPEFFECT_COPY;
}

bool CClassifierTableItemsView::Paste(COleDataObject *pDataObject)
{
	UINT cf_hinst=RegisterClipboardFormat(APL_INSTANCE_CLIPBOARDFORMAT);
	if(pDataObject->IsDataAvailable(cf_hinst))
	{
		HGLOBAL hGlob=pDataObject->GetGlobalData(cf_hinst);
		if(hGlob==0)
		{
			AfxMessageBox( APL_T("     ."));
			return false;
		}
		BYTE *phItem=(BYTE*)::GlobalLock(hGlob);
		if(phItem==0)
		{
			AfxMessageBox( APL_T("     ."));
			return false;
		}
		
		DWORD procid = GetCurrentProcessId();
		int ind = 0, id;
		DWORD PrcId = *(DWORD*)&phItem[ind];
		if(PrcId!=procid)
		{
			::GlobalUnlock(hGlob);
			return false;
		}
		ind+=sizeof(DWORD);
		id = *(int*)&phItem[ind];
		CaplInstance *inst = m_api->m_data.GetInstById(id), *associator = NULL;
		if(inst==NULL)
		{
			::GlobalUnlock(hGlob);
			return false;
		}
		
		::GlobalUnlock(hGlob);

		if(!m_api->m_classifier_mgr.TestClassifierAssociation(inst, m_ClassifierElement))
		{
			associator=m_api->m_classifier_mgr.CreateClassifierAssociation(inst, m_ClassifierElement, true);
			if(associator!=0)
			{
				SItemColumnData* pData = new SItemColumnData(inst);
				m_ListCtrl.AddItem(pData,true);
			}
		}
	}

	return true;
}

void CClassifierTableItemsView::OnBegindrag(NMHDR* pNMHDR, LRESULT* pResult)
{
	if(!(m_Mode&APL_CLASSIFIER_EDITOR || m_Mode&APL_CLASSIFIER_EXE_EDITOR)) return;

	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	*pResult = 1;

	if(m_api==NULL) 
		return;
	if(!m_api->m_data.IsDictLoad())
		return;
	if(m_ClassifierElement == NULL)
		return;
	
	int cur, tmp;
	cur = m_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	if(cur<0) return;
	
	CaplInstance *Inst=NULL, *Inst1=NULL, *Inst2=NULL, *Inst3=NULL;
	int num_group;
	m_ListCtrl.GetCharacteristicByRC(cur, 0, &Inst, tmp, &Inst1, &Inst2, &Inst3, num_group);
	if(Inst==NULL) return;

	COleDataSource *pDataSource = PrepareDatasource(Inst);
	if(pDataSource)
	{
		pDataSource->DoDragDrop();
		delete pDataSource;
	}
	
	*pResult = 0;
}

BOOL CClassifierTableItemsView::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	if(nID == IDC_LIST)
	{
		AFX_NOTIFY *an = (AFX_NOTIFY*)pExtra;
		if(an)
		{
			NMHDR *pNMHDR = an->pNMHDR;
			if(pNMHDR->code==LVN_BEGINDRAG)
			{
				LRESULT Result;
				OnBegindrag(pNMHDR, &Result);
				return TRUE;
			}
		}
	}
	
	return CView::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

COleDataSource* CClassifierTableItemsView::PrepareDatasource(CaplInstance *Inst)
{
	UINT cf_hinst=RegisterClipboardFormat(APL_INSTANCE_CLIPBOARDFORMAT);
	if(cf_hinst==0)
	{
		AfxMessageBox( APL_T("      (APL_INSTANCE_CLIPBOARDFORMAT)\n     !"), MB_ICONSTOP|MB_OK);
		return 0;
	}
	
	int size = sizeof(int)+sizeof(DWORD);
	HGLOBAL hMem=::GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE|GMEM_ZEROINIT,size);
	if (!hMem) 
		return NULL;

	COleDataSource*	pSource = new COleDataSource();
	if(pSource==NULL) return 0;

	CString text;
	DWORD procid = GetCurrentProcessId();
	BYTE *phItem=(BYTE*)::GlobalLock(hMem);
	int ind = 0, *pInt;
	DWORD *pDword = (DWORD*)&phItem[ind];
	*pDword = procid;
	ind+=sizeof(DWORD);
	pInt = (int*)&phItem[ind];
	*pInt = Inst->GetId();
	::GlobalUnlock(hMem);
	pSource->CacheGlobalData(cf_hinst, hMem);

	m_api->GetItemName(Inst, text);
	hMem=::GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE|GMEM_ZEROINIT,sizeof(TCHAR)*(text.GetLength()+1));
	TCHAR *xxx=(TCHAR*)::GlobalLock(hMem);
	memcpy(xxx,LPCTSTR(text),sizeof(TCHAR)*(text.GetLength()+1));		
	::GlobalUnlock(hMem);
	pSource->CacheGlobalData(CF_TEXT, hMem);

	return pSource;
}

CaplInstance *CClassifierTableItemsView::GetCurInst()
{
	if(m_api==NULL) return 0;
	if(!m_api->m_data.IsDictLoad()) return 0;
	if(m_ClassifierElement == NULL) return 0;
	
	int cur = m_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	if(cur<0) return 0;
	
	SItemColumnData* pData = NULL;
	int ind = (int)m_ListCtrl.GetItemData(cur);
	pData = m_Items.GetAt(ind);

	if(0==pData)return 0;	
	return pData->m_inst;
}

//*************************************************
void CClassifierTableItemsView::OnUpdateItemView(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(FALSE);

	CaplInstance *inst=GetCurInst();
	if(inst==0) return;
	if(!m_api->m_data.IsKindOf(inst,m_api->m_doc_mgr.e_apl_doc)) return;

	pCmdUI->Enable(TRUE);	
}


void CClassifierTableItemsView::OnUpdateItemUndoCheckout(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(FALSE);

	CaplInstance *inst=GetCurInst();
	if(inst==0) return;
	if(!m_api->m_data.IsKindOf(inst,m_api->m_doc_mgr.e_apl_doc)) return;

	CaplInstance *lock;
	m_api->m_data.GetAttr(inst,m_api->m_doc_mgr.a_apl_doc_lock, lock);
	if(lock==0) return ; 

	pCmdUI->Enable(TRUE);	
	
}

void CClassifierTableItemsView::OnUpdateItemEdit(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(FALSE);

	CaplInstance *inst=GetCurInst();
	if(inst==0) return;
	if(!m_api->m_data.IsKindOf(inst,m_api->m_doc_mgr.e_apl_doc)) return;

	CaplInstance *lock;
	m_api->m_data.GetAttr(inst,m_api->m_doc_mgr.a_apl_doc_lock, lock);
	if(lock!=0) return ; 

	pCmdUI->Enable(TRUE);	
	
}

void CClassifierTableItemsView::OnUpdateItemCheckout(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(FALSE);

	CaplInstance *inst=GetCurInst();
	if(inst==0) return;
	if(!m_api->m_data.IsKindOf(inst,m_api->m_doc_mgr.e_apl_doc)) return;

	CaplInstance *lock;
	m_api->m_data.GetAttr(inst,m_api->m_doc_mgr.a_apl_doc_lock, lock);
	if(lock!=0) return ; 

	pCmdUI->Enable(TRUE);	
}
void CClassifierTableItemsView::OnUpdateItemCheckin(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(FALSE);

	CaplInstance *inst=GetCurInst();
	if(inst==0) return;
	if(!m_api->m_data.IsKindOf(inst,m_api->m_doc_mgr.e_apl_doc)) return;

	CaplInstance *lock;
	m_api->m_data.GetAttr(inst,m_api->m_doc_mgr.a_apl_doc_lock, lock);
	if(lock==0) return ; //   


	pCmdUI->Enable(TRUE);	
}


void CClassifierTableItemsView::OnItemView() 
{
	CaplInstance *inst=GetCurInst();
	if(inst==0) return;
	if(!m_api->m_data.IsKindOf(inst,m_api->m_doc_mgr.e_apl_doc)) return;

	m_api->m_doc_mgr.View(inst);
}

void CClassifierTableItemsView::OnItemEdit() 
{
	CaplInstance *inst=GetCurInst();
	if(inst==0) return;
	if(!m_api->m_data.IsKindOf(inst,m_api->m_doc_mgr.e_apl_doc)) return;

	m_api->m_doc_mgr.Edit(inst,0);
	UpdateTable(m_ClassifierElement);
}

void CClassifierTableItemsView::OnItemCheckout() 
{
	CaplInstance *inst=GetCurInst();
	if(inst==0) return;
	if(!m_api->m_data.IsKindOf(inst,m_api->m_doc_mgr.e_apl_doc)) return;

	m_api->m_doc_mgr.CheckOut(inst,0);
	UpdateTable(m_ClassifierElement);
}

void CClassifierTableItemsView::OnItemCheckin() 
{
	CaplInstance *inst=GetCurInst();
	if(inst==0) return;
	if(!m_api->m_data.IsKindOf(inst,m_api->m_doc_mgr.e_apl_doc)) return;

	m_api->m_doc_mgr.CheckIn(inst,0);
	UpdateTable(m_ClassifierElement);
}


void CClassifierTableItemsView::OnItemUndoCheckout() 
{
	CaplInstance *inst=GetCurInst();
	if(inst==0) return;
	if(!m_api->m_data.IsKindOf(inst,m_api->m_doc_mgr.e_apl_doc)) return;

	m_api->m_doc_mgr.UndoCheckOut(inst);
	UpdateTable(m_ClassifierElement);
}






