// EditExtentDlg.cpp : implementation file
//

#include "stdafx.h"
#include "EditExtentDlg.h"


// CEditExtentDlg dialog

IMPLEMENT_DYNAMIC(CEditExtentDlg, CaplTranslateDialog)

CEditExtentDlg::CEditExtentDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CEditExtentDlg::IDD, pParent)
{
	m_title=0;
	m_list_title=0;
	m_api=0;
	m_sprav=0;
}

CEditExtentDlg::~CEditExtentDlg()
{
}

void CEditExtentDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_ADD, m_add_btn);
	DDX_Control(pDX, IDC_DEL, m_del_btn);
	DDX_Control(pDX, IDC_LIST, m_list);
	DDX_Control(pDX, IDC_ST_LIST_TITLE, m_st_list_title);
}


BEGIN_MESSAGE_MAP(CEditExtentDlg, CaplTranslateDialog)
	ON_BN_CLICKED(IDC_ADD, &CEditExtentDlg::OnBnClickedAdd)
	ON_BN_CLICKED(IDC_DEL, &CEditExtentDlg::OnBnClickedDel)
END_MESSAGE_MAP()


// CEditExtentDlg message handlers

BOOL CEditExtentDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	if(0!=m_title) SetWindowText(m_title);
	if(0!=m_list_title) m_st_list_title.SetWindowText(m_list_title);

	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_add_btn.SetIcon(GetAplStdIco16(APLSTDICO_PLUS));
	m_add_btn.SetTooltipText( APL_T(""));
	m_add_btn.SetFlat(FALSE);
	m_del_btn.SetIcon(GetAplStdIco16(APLSTDICO_DELETE));
	m_del_btn.SetFlat(FALSE);

	m_list.SetExtendedStyle(m_list.GetExtendedStyle()|LVS_EX_FULLROWSELECT|LVS_EX_SUBITEMIMAGES);
	m_list.InsertColumn(0,APL_T(""),LVCFMT_LEFT,1000);
	m_list.SetImageList(aplGetInstImageList(),LVSIL_SMALL);

	int i,j,ico;
	CString buf;
	for(i=0;i<m_ext.GetSize();i++)
	{
		CaplInstance *inst=m_ext[i];
		m_api->GetItemName(inst,buf);
		ico=m_api->GetInstIco(inst);

		j=m_list.InsertItem(0,buf,ico);
		m_list.SetItemData(j,(DWORD)inst);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CEditExtentDlg::OnOK()
{
	m_ext.Clear();
	int i;
	for(i=0;i<m_list.GetItemCount();i++)
	{
		m_list.GetItemData(i);
		CaplInstance *inst=(CaplInstance *)m_list.GetItemData(i);
		m_ext.Add(inst);
	}

	CaplTranslateDialog::OnOK();
}

void CEditExtentDlg::OnBnClickedAdd()
{
	CaplInstance *inst=0;
	aplExtent extItems;

	if(0==m_sprav)
	{
		inst=m_api->m_prd_mgr.SelectInstance(m_SelectMode);
		if(0==inst) return;
		extItems.Add(inst);
	}
	else
	{
		if(!m_api->m_classifier_mgr.SelectItem(&inst,m_sprav,APL_SELECT_CLASSIFIER_ITEM,APL_T("  "),0,&extItems)) return;
		if(0==extItems.GetSize() &&0!=inst) extItems.Add(inst);
	}

	if(0==extItems.GetSize()) return;

	int i,j,k;
	for(k=0;k<extItems.GetSize();k++)
	{
		inst=extItems[k];

		for(i=0;i<m_list.GetItemCount();i++)
		{
			CaplInstance *inst1=(CaplInstance *)m_list.GetItemData(i);
			if(inst1==inst){inst=0; break;;}//{AfxMessageBox(APL_T("   !")); return;}
		}
		if(0==inst) continue;
		CString buf;
		m_api->GetItemName(inst,buf);
		int ico=m_api->GetInstIco(inst);
		j=m_list.InsertItem(0,buf,ico);
		m_list.SetItemData(j,(DWORD)inst);
	}

}

void CEditExtentDlg::OnBnClickedDel()
{
	int i= m_list.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
	if(i<0) {AfxMessageBox(APL_T("    !")); return;}
	m_list.DeleteItem(i);
}
