#if !defined(AFX_EFFECTIVITYVIEW_H__45E22B72_3A42_4819_A52C_5E4E5B8D2868__INCLUDED_)
#define AFX_EFFECTIVITYVIEW_H__45E22B72_3A42_4819_A52C_5E4E5B8D2868__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// EffectivityView.h : header file
//
#include "PrdListView.h"
#include "aplAccessView.h"

class CManagerEffGanttDlg;

#define APL_MODE_OPEN      0x00000
#define APL_MODE_EDIT      0x00001
#define APL_MODE_PRINT     0x00002
#define APL_MODE_SAVE      0x00003

//////////////////////////////////////////////////////////////////////////
// 

class CSerialNumberStrMap : public CaplStrMap
{
public:
	CSerialNumberStrMap();
	~CSerialNumberStrMap();
		
	int CompareSN(CString strSN1, CString strSN2);
	void SortSerial();
	int FindSerial(LPCTSTR str);

	static int CallbackCompareSN(const void *arg1, const void *arg2);
};

/////////////////////////////////////////////////////////////////////////////
// CEffectivityView view
class EffItem
{
public:
	EffItem() 
	{
		m_pdf_id=_T("");m_eff_type=0;m_nItem=0;m_rel=0;m_eff=0;
		m_id=_T("");m_b_is_not_active=false;m_start=_T("");m_end=_T("");
		m_item_rect.SetRect(0,0,0,0);m_ass_item_id=_T("");m_b_no_effectivity=false;
	};
	CString m_pdf_id;
	int m_nItem;
	CaplInstance *m_rel;
	CaplInstance *m_eff;
	CString m_id;
	bool m_b_is_not_active;
	CString m_start;
	CString m_end;
	long m_eff_type;
	CRect m_item_rect;
	CString m_ass_item_id;
	bool m_b_no_effectivity;//     
};

class CEffectivityView : public CScrollView
{
protected:
	CEffectivityView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CEffectivityView)

// Attributes
public:
	CaplAPI *m_api;
	CPrdListView *m_prd_view;
	EffItem *m_items; 
	EffItem *m_all_items;

	bool m_bReadOnly;

	int m_items_MaxSize;
	int m_items_size;
	int m_all_items_MaxSize;
	int m_all_items_size;
	
	long m_eff_mode;

	int m_first_eff_offset;
	int m_undef_offset;
	int m_min_pixels_in_item;

	CManagerEffGanttDlg *m_eff_mgr_dlg;

	int m_pixelsInItem;
	int m_nDiagramWidth;
//	CaplStrMap m_eff_map;
	CSerialNumberStrMap m_eff_map;
	CArray<CRect,CRect>m_cal_rect_array;

	CFont m_pFont;

	int m_sel_nItem;
	CRect m_sel_item_rect;

	int m_cur_date_item_index;
	CString m_cur_ass_item_id;
		
	CBrush m_eff_brush,m_eff_border_brush;
	CBrush m_arrow_brush,m_cur_date_brush;
	CBrush m_select_brush;
	CBrush m_inner_code_select_brush;
	CBrush m_inters_brush;

	CPen m_pen;
	CPen m_red_pen;
	CPen m_black_pen;
	
// Operations
public:
	void OnDelete(EffItem *effItem);
	void OnAdd(CaplInstance *pdr,CString &start_value);
	bool ShowEffProperties(EffItem *effItem);
	void AutoResizeDiagram();
	void GetEffRect(EffItem *effItem);
	void Update(bool bUpdateCalendar=false,bool bAutoResize=false);

	int InsertItem(EffItem &new_item,int mode);
	void RemoveAllItems(int mode);
	
protected:
	void UpdateCalendar(bool bAutoResize=false);
	
	bool SetArraySize(int new_size,int mode);

	void PaintDiagram(CDC &dc,long mode);
	void PaintItems(CDC &dc,long mode);
	void PaintHeader(CDC &dc,long mode);
	void PaintIntersection(CDC &dc,long mode);
	void PaintSelection(CDC &dc,long mode);
	
	bool PointToVal(CPoint *point, EffItem **effItem);
	bool PointToVals(CPoint *point, CIntArray &i_itemsArray);
	int Point2PrdItem(CPoint point);
	bool Point2Start(CPoint point,CString &start_value);

	void DisplayToolTip(CPoint point);
protected:
	CaplToolTip m_ToolTip;
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEffectivityView)
public:
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	virtual BOOL PreTranslateMessage(MSG* pMsg);

protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnInitialUpdate();     // first time after construct
	
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CEffectivityView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
	//{{AFX_MSG(CEffectivityView)
	afx_msg void OnPaint();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg int OnMouseActivate( CWnd* pDesktopWnd,UINT nHitTest,UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point); 
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_EFFECTIVITYVIEW_H__45E22B72_3A42_4819_A52C_5E4E5B8D2868__INCLUDED_)
