// EntryPropDlg.cpp : implementation file
//

#include "stdafx.h"
#include "EntryPropDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEntryPropDlg dialog


CEntryPropDlg::CEntryPropDlg(CaplAPI *api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CEntryPropDlg::IDD, pParent)
{
	m_api = api;
	m_ciEntry = NULL;
}


void CEntryPropDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEntryPropDlg)
		DDX_Control(pDX, IDOK, m_ok_btn);
		DDX_Control(pDX, IDCANCEL, m_cancel_btn);
		DDX_Text(pDX, IDC_ID, m_sID);
		DDX_Text(pDX, IDC_NAME, m_sName);
		DDX_Control(pDX, IDC_ENRTY_LOGO, m_st_name);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEntryPropDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CEntryPropDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEntryPropDlg message handlers

BOOL CEntryPropDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	m_ok_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	((CComboBox*)GetDlgItem(IDC_CUR_VAL))->SetWindowText(m_sValue);
	
	if(m_ciEntry)
	{
		CString buf;
		CaplAggr aggr;
		m_api->m_data.GetAttr(m_ciEntry, m_api->m_doc_mgr.a_entry_val, aggr);

		for(int i=0; i<aggr.GetSize(); i++)
		{
			aggr.GetByIndex(i, buf);
			((CComboBox*)GetDlgItem(IDC_CUR_VAL))->InsertString(i, buf);
		}
	}

	UpdateData(FALSE);

	COLORMAP  cm;
	cm.from=RGB(192,192,192);
	//cm.to=GetSysColor(COLOR_WINDOW);
	cm.to=GetSysColor(COLOR_BTNFACE);

	if(aplGetBitPerPixel(this)>8)
		m_name_bmp.LoadMappedBitmap(IDB_ENTRY_NAME,0,&cm,1);
	
	
	HBITMAP hBmpOld=m_st_name.SetBitmap(HBITMAP(m_name_bmp));	
	::DeleteObject(hBmpOld);
		
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEntryPropDlg::OnOK() 
{
	((CComboBox*)GetDlgItem(IDC_CUR_VAL))->GetWindowText(m_sValue);
	
	CaplTranslateDialog::OnOK();
}
