// FileLoadDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"

#include "FileLoadDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFileLoadDlg dialog


CFileLoadDlg::CFileLoadDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CFileLoadDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFileLoadDlg)
	m_path = _T("");
	m_set_ro = FALSE;
	m_set_active = FALSE;
	m_descr = _T("");
	m_save_to_db = FALSE;
	m_use_sub_doc = FALSE;
	m_run_ass_app = FALSE;
	//}}AFX_DATA_INIT
	m_no_set_active=false;
	m_b_no_sub_doc=false;
	m_del_from_disk=FALSE;
	m_bEnableDelFile=false;

	m_api= NULL;
}


void CFileLoadDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFileLoadDlg)
	DDX_Control(pDX, IDC_RUN_ASS_APP, m_run_ass_app_ctrl);
	DDX_Control(pDX, IDC_USE_SUB_DOC, m_use_sub_doc_ctrl);
	DDX_Control(pDX, IDC_SAVE_TO_DB, m_save_to_db_ctrl);
	DDX_Control(pDX, IDC_PATH, m_path_ctrl);
	DDX_Control(pDX, IDC_SET_READ_ONLY, m_set_ro_ctrl);
	DDX_Control(pDX, IDC_SET_ACTIVE, m_set_active_ctrl);
	DDX_Control(pDX, IDC_DESCR, m_descr_ctrl);
	DDX_Text(pDX, IDC_PATH, m_path);
	DDX_Check(pDX, IDC_SET_READ_ONLY, m_set_ro);
	DDX_Check(pDX, IDC_SET_ACTIVE, m_set_active);
	DDX_Text(pDX, IDC_DESCR, m_descr);
	DDX_Check(pDX, IDC_SAVE_TO_DB, m_save_to_db);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Check(pDX, IDC_USE_SUB_DOC, m_use_sub_doc);
	DDX_Check(pDX, IDC_RUN_ASS_APP, m_run_ass_app);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_DEL_FROM_FILE, m_del_from_disk_ctrl);
	DDX_Check(pDX, IDC_DEL_FROM_FILE, m_del_from_disk);
}


BEGIN_MESSAGE_MAP(CFileLoadDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CFileLoadDlg)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_SAVE_TO_DB, &CFileLoadDlg::OnBnClickedSaveToDb)
	ON_BN_CLICKED(IDC_DEL_FROM_FILE, &CFileLoadDlg::OnBnClickedDelFromFile)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFileLoadDlg message handlers

BOOL CFileLoadDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	// TODO: Add extra initialization here checkout
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	if(m_mode==_T("export"))
	{
		m_set_ro_ctrl.SetCheck(TRUE);
		SetWindowText( APL_T("  "));
		m_set_active_ctrl.ShowWindow(SW_HIDE);
		m_descr_ctrl.EnableWindow(FALSE);
		m_save_to_db_ctrl.ShowWindow(SW_HIDE);
		m_run_ass_app_ctrl.ShowWindow(SW_HIDE);

		RECT r0,r1;
		m_set_active_ctrl.GetWindowRect(&r0);
		m_set_ro_ctrl.GetWindowRect(&r1);
		r1.top=r0.top;
		r1.bottom=r0.bottom;
		ScreenToClient(&r1);
		m_set_ro_ctrl.MoveWindow(&r1);
	}
	else if(m_mode==_T("checkout"))
	{
		m_set_ro_ctrl.SetCheck(TRUE);
		SetWindowText( APL_T("    "));
		m_set_active_ctrl.ShowWindow(SW_HIDE);
		m_set_ro_ctrl.ShowWindow(SW_HIDE);
		m_save_to_db_ctrl.ShowWindow(SW_HIDE);
	}
	else if(m_mode==_T("checkin"))
	{
		m_set_ro_ctrl.SetCheck(TRUE);
		m_run_ass_app_ctrl.ShowWindow(SW_HIDE);
		SetWindowText( APL_T(" "));
		//m_set_active_ctrl.SetCheck(TRUE);
		m_set_ro_ctrl.SetCheck(TRUE);
		m_save_to_db_ctrl.SetCheck(TRUE);
		if(m_no_set_active)
		{
			m_set_active_ctrl.SetCheck(0);
			m_set_active_ctrl.EnableWindow(FALSE);
		}
		if(m_bEnableDelFile)	m_del_from_disk_ctrl.ShowWindow(SW_SHOW);
	}
	else if(m_mode==_T("create_revision"))
	{
		m_set_ro_ctrl.SetCheck(TRUE);
		m_run_ass_app_ctrl.ShowWindow(SW_HIDE);
		SetWindowText( APL_T("  "));
		//m_set_active_ctrl.SetCheck(TRUE);
		m_set_ro_ctrl.SetCheck(TRUE);
		m_save_to_db_ctrl.SetCheck(TRUE);
		if(m_no_set_active)
		{
			m_set_active_ctrl.SetCheck(0);
			m_set_active_ctrl.EnableWindow(FALSE);
		}
		if(m_bEnableDelFile)	m_del_from_disk_ctrl.ShowWindow(SW_SHOW);
	}

	if(m_api)
	{
		int iVal;
		m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\   "), iVal, 0);
		if(0!=iVal)
		{
			m_save_to_db_ctrl.EnableWindow(FALSE);		
			m_save_to_db= TRUE;
		}
	}

	if(m_b_no_sub_doc) m_use_sub_doc_ctrl.EnableWindow(FALSE);

	OnBnClickedSaveToDb();
	OnBnClickedDelFromFile();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFileLoadDlg::OnBrowse() 
{
	CString buf;
	m_path_ctrl.GetWindowText(buf);
	BOOL open=TRUE;
	long type;
	if(m_mode==_T("export"))
	{
		open=FALSE;
		type=OFN_HIDEREADONLY|OFN_CREATEPROMPT|OFN_OVERWRITEPROMPT;
	}
	else if(m_mode==_T("checkout"))
	{
		open=FALSE;
		type=OFN_HIDEREADONLY|OFN_CREATEPROMPT|OFN_OVERWRITEPROMPT;
	}
	else if(m_mode==_T("checkin"))
	{
		open=TRUE;
		type=OFN_HIDEREADONLY|OFN_FILEMUSTEXIST;
	}
	CFileDialog dlg(open,0,LPCTSTR(buf),type,_T("All Files (*.*)|*.*||"));
	if(dlg.DoModal()==IDOK)
	{
		if(m_mode==_T("checkin") && m_formats!=_T(""))
		{	
			CString ext=dlg.GetFileExt();
			ext.MakeLower();
			if(m_formats.Find(ext)<0) 
			{
				ext= APL_T("  !\n\n : ");
				ext+=m_formats;
				AfxMessageBox(ext,MB_OK|MB_ICONSTOP);
				return;
			}
		}
		m_path_ctrl.SetWindowText(dlg.GetPathName());
	}
}


void CFileLoadDlg::OnOK() 
{
	UpdateData(TRUE);
	if((m_mode==_T("checkin") || m_mode==_T("create_revision") )  && m_formats!=_T(""))
	{	
		CString file,ext;
		m_path_ctrl.GetWindowText(file);

		int i=file.ReverseFind(_T('.'));
		if(i>1) 
		{
			ext=file.Right(file.GetLength()-i-1);
			if(ext!=_T(""))
			{
				ext.MakeLower();
				if(m_formats.Find(ext)<0) 
				{
					ext= APL_T("  !\n\n : ");
					ext+=m_formats;
					AfxMessageBox(ext,MB_OK|MB_ICONSTOP);
					return;
				}
			}
		}
	}

	if(m_mode!=_T("export") && m_mode!=_T("checkout") && TRUE==m_save_to_db)   //  "    "    
	{
		int iMaxFileSize=0;
		m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\   "), iMaxFileSize, (int)0);
		if(iMaxFileSize>0)
		{
			CString fname;
			m_path_ctrl.GetWindowText(fname);
			CFileStatus rStatus;
			CFile::GetStatus(fname,rStatus);
			if(rStatus.m_size>iMaxFileSize)
			{
				bool bEnableCreate=false;
				CString sRole;

				m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" \\     "), sRole, _T(""));
				if(sRole!=_T("")){if(m_api->m_appr_mgr.CheckPersonRole(0,sRole)) bEnableCreate=true;}

				if(!bEnableCreate)
				{
					CString buf;
					buf.Format( APL_T("   (%i)   (%i)!\n\n    ."),
						(int)rStatus.m_size,iMaxFileSize);
					AfxMessageBox(buf,MB_OK|MB_ICONSTOP);
					return;
				}
			}
		}
	}
	CaplTranslateDialog::OnOK();
}


void CFileLoadDlg::OnBnClickedSaveToDb()
{
	if(m_save_to_db_ctrl.GetCheck()>0) m_del_from_disk_ctrl.EnableWindow(TRUE);
	else m_del_from_disk_ctrl.EnableWindow(FALSE);
}

void CFileLoadDlg::OnBnClickedDelFromFile()
{
	if(m_del_from_disk_ctrl.GetCheck()) m_set_ro_ctrl.EnableWindow(FALSE); else  m_set_ro_ctrl.EnableWindow(TRUE);
}
