// FindPKIDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FindPKIDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFindPKIDlg dialog


CFindPKIDlg::CFindPKIDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CFindPKIDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFindPKIDlg)
	m_sId = _T("");
	//}}AFX_DATA_INIT
	m_api = NULL;
	m_Selected = NULL;
	m_SelectMode = APL_SELECT_PDF;
	m_bIfOneSelect = true;
	m_BindMode = aplSBLeft;
}


void CFindPKIDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindPKIDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Text(pDX, IDC_ID, m_sId);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFindPKIDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CFindPKIDlg)
	ON_BN_CLICKED(IDC_SHOW_BTN, OnShowBtn)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnDblclkList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindPKIDlg message handlers

void CFindPKIDlg::OnShowBtn() 
{
	int i;
	if(!UpdateData())
		return;

	if(m_sId.IsEmpty())
	{
		if(AfxMessageBox( APL_T("        ?"),MB_YESNO|MB_ICONQUESTION)!=IDYES)
			return;
	}
	
	m_ListCtrl.DeleteAllItems();
	aplExtent ext;
	CaplAttrValue tst;
	aplExtent pdfs, tmp;

	tst.attr = m_api->m_prd_mgr.a_prd_id;
	tst.value.Set(m_sId);
	m_api->m_data.NET_FindInstancesWithAttrValues2(m_api->m_prd_mgr.e_prd, 1, &tst, ext, true, false, _T(""), m_BindMode,false,DEF_SOURCE);
	CaplLoadData ld(&m_api->m_data, DEF_SOURCE);
	for(i=0; i<ext.GetSize();i++)
		ld.AddQuery(0, ext[i], true);
	ld.AddQuery(_T('r'), 0, m_api->m_prd_mgr.e_apl_pdf, m_api->m_prd_mgr.a_pdf_prd, true, true);
	
	ld.LoadEx(true, &pdfs);
	aplExtent tmpExt;
	CaplInstance* pdf, *prd;
	tmpExt.Append(pdfs);
	pdfs.Clear();

	for(i=0; i<tmpExt.Size;i++)
	{
		pdf = tmpExt[i];
		if(pdf==0)
			continue;
		if(pdf->GetAccessmode()>aplRO)
			continue;
		if(!m_api->m_data.IsKindOf(pdf, m_api->m_prd_mgr.e_apl_pdf))
			continue;
		m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_prd, prd);
		if(prd==0)
			continue;
		if(prd->GetAccessmode()>aplRO)
			continue;
		pdfs.Add(pdf);
	}
	if(pdfs.GetSize()>100)
	{
		CString buf;
		buf.Format( APL_T(" %d .        . ?"), pdfs.GetSize());
		if(AfxMessageBox(buf, MB_ICONQUESTION|MB_YESNO)!=IDYES) return;
	}
	else if(pdfs.Size==1 && m_bIfOneSelect && m_bFindExecute)
	{
		CString buf;
		buf.Format( APL_T("     \"%s\".  ?"), m_sId);
		if(AfxMessageBox(buf, MB_ICONQUESTION|MB_YESNO)==IDYES)
		{
			m_Selected = pdfs[0];
			EndDialog(IDOK);
			return;
		}
	}
	else if(pdfs.Size==0)
	{
		AfxMessageBox( APL_T("  !"));
	}


	CString name, id, ver, sn;
	int ind = 0;
	for(i=0; i<pdfs.Size;i++)
	{
		pdf = pdfs[i];
		m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_prd, prd);
		m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_id, ver);
		m_api->m_data.GetAttr(prd, m_api->m_prd_mgr.a_prd_id, id);
		m_api->m_data.GetAttr(prd, m_api->m_prd_mgr.a_prd_name, name);
		ind = m_ListCtrl.InsertItem(m_ListCtrl.GetItemCount(), id, m_api->GetInstIco(pdfs[i]));
		m_ListCtrl.SetItemText(ind, 1, name);
		m_ListCtrl.SetItemText(ind, 2, ver);
		m_ListCtrl.SetItemData(ind, (DWORD)pdfs[i]);
	}
}

BOOL CFindPKIDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));
	
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	ASSERT(m_api);

	int i=0;
	CRect rect;
	GetDlgItem(IDC_STATIC_LIST)->GetWindowRect(rect);
	ScreenToClient(rect);
	m_ListCtrl.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_REPORT|LVS_SHOWSELALWAYS|LVS_SINGLESEL|WS_TABSTOP, rect, this, IDC_LIST);

	m_ListCtrl.InsertColumn(i++, APL_T(""), LVCFMT_LEFT, 100);
	m_ListCtrl.InsertColumn(i++, APL_T(""), LVCFMT_LEFT, 200);
	m_ListCtrl.InsertColumn(i++, APL_T(""), LVCFMT_LEFT, 100);
	m_ListCtrl.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	m_ListCtrl.SetImageList(aplGetInstImageList(), LVSIL_SMALL);

	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	AddAnchor(IDC_ID, TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_LIST, TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDCANCEL, BOTTOM_RIGHT);
	AddAnchor(IDOK, BOTTOM_RIGHT);
	AddAnchor(IDC_SHOW_BTN, TOP_RIGHT);

	if(m_bFindExecute && !m_sId.IsEmpty())
		OnShowBtn();

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFindPKIDlg::OnOK() 
{
	int cur = m_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	if(cur<0)
	{
		AfxMessageBox( APL_T("  !"));
		return;
	}

	m_Selected = (CaplInstance*)m_ListCtrl.GetItemData(cur);
	
	CaplResizableDialog::OnOK();
}

void CFindPKIDlg::OnDblclkList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;
	OnOK();
}
