// ManagerEffectivityDlg.cpp : implementation file
//

#include "stdafx.h"
#include <apl_gui.h>
#include "apl_api.h"

#include "ManagerEffGanttDlg.h"
#include "AddRuleDate.h"
#include "AddSerialNum.h"
#include "StepData.h"
#include "PrdListView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
/////////////////////////////////////////////////////////////////////////////
// CManagerEffGanttDlg dialog

//IMPLEMENT_DYNAMIC(CManagerEffGanttDlg, CDialog );

CManagerEffGanttDlg::CManagerEffGanttDlg(CWnd* pParent)
	: CResizableDialog (CManagerEffGanttDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CManagerEffGanttDlg)
	m_width = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_api=0;
	m_pdf=0;
	m_rel=0;

	m_prd_view=0;
	m_eff_view=0;
	m_eff_mode=APL_EFF_DATE;

}

void CManagerEffGanttDlg::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog ::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CManagerEffGanttDlg)
	DDX_Control(pDX, IDC_EFF_BORDER, m_eff_border_ctrl);
	DDX_Control(pDX, IDC_PRD_LIST_BORDER, m_prd_list_border_ctrl);
	DDX_Control(pDX, IDC_SPINWIDTH, m_spinWidth);
	DDX_Control(pDX, IDC_EDIT_VERSION, m_version);
	DDX_Control(pDX, IDC_EDIT_NAME, m_name);
	DDX_Control(pDX, IDC_EDIT_IDENT, m_ident);
	DDX_Control (pDX, IDC_TAB, m_tab);
	DDX_Text(pDX, IDC_EDITWIDTH, m_width);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CManagerEffGanttDlg, CResizableDialog )
	//{{AFX_MSG_MAP(CManagerEffGanttDlg)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB, OnSelchangeTab)
	ON_EN_CHANGE(IDC_EDITWIDTH, OnChangeEditwidth)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPINWIDTH, OnDeltaposSpinwidth)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CManagerEffGanttDlg message handlers

BOOL CManagerEffGanttDlg::OnInitDialog()
{
	CResizableDialog ::OnInitDialog();

	if(m_api==0) return FALSE;
	if(m_pdf==0)  return FALSE;
	if(m_rel==0)  return FALSE;

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);

	//       
	AddAnchor(IDC_STATICGROUP,TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_EDIT_IDENT,TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_EDIT_NAME,TOP_LEFT, TOP_RIGHT);
	AddAnchor(IDC_EDIT_VERSION,TOP_LEFT, TOP_RIGHT);

	AddAnchor(IDC_TAB,TOP_LEFT, TOP_RIGHT);

	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDC_SPINWIDTH,BOTTOM_LEFT);
	AddAnchor(IDC_EDITWIDTH,BOTTOM_LEFT);
	AddAnchor(IDC_STATICWIDTH,BOTTOM_LEFT);
	AddAnchor(IDC_STATICWIDTH2,BOTTOM_LEFT);
	
	CString buf;
	CaplInstance *inst;

	TC_ITEM tci;
	tci.mask = TCIF_TEXT;
	tci.iImage = -1;
	tci.pszText  =  (LPTSTR)APL_T("");
	m_tab.InsertItem(0, &tci);
	tci.pszText =  (LPTSTR)APL_T(" ");
	m_tab.InsertItem(1, &tci);
	/*tci.pszText  = APL_T("");
	m_tab.InsertItem(2, &tci);*/
	//   ,  
	//  
	apidata.GetAttrBN(m_pdf,_T("of_product"),inst);
	apidata.GetAttrBN(inst,_T("id"),buf);

	m_ident.SetWindowText(buf);
	apidata.GetAttrBN(inst,_T("name"),buf);

	m_name.SetWindowText(buf);
	apidata.GetAttrBN(m_pdf,_T("id"), buf);

	m_version.SetWindowText(buf);
	//m_width -     
	m_width=80;

	//       
	m_spinWidth.SetRange( 5, 1000 );
	m_spinWidth.SetPos(m_width);
	UpdateData(false);
	
	CRect rect;
	m_prd_list_border_ctrl.GetWindowRect(&rect);
	ScreenToClient(&rect); 

	m_prd_view = (CPrdListView*)(RUNTIME_CLASS(CPrdListView)->CreateObject());
	ASSERT(m_prd_view);
	m_prd_view->Create(0,0,WS_BORDER|WS_VISIBLE|WS_CHILD|AFX_WS_DEFAULT_VIEW,rect,this,IDC_PRD_LIST_VIEW);
	m_prd_view->m_api=m_api;
	m_prd_view->m_rel=m_rel;
	m_prd_view->m_pdf=m_pdf;
	m_prd_view->OnInitialUpdate();
	m_prd_view->MoveWindow(&rect);

	RECT rect0;
	m_eff_border_ctrl.GetWindowRect(&rect0);
	ScreenToClient(&rect0);
	m_eff_view = (CEffectivityView*)(RUNTIME_CLASS(CEffectivityView)->CreateObject());
	ASSERT(m_eff_view);
	m_eff_view->Create(0,0,WS_BORDER|WS_VISIBLE|WS_CHILD|AFX_WS_DEFAULT_VIEW,rect0,this,IDC_EFF_VIEW);
	CSize sizeTotal;
	sizeTotal.cx = sizeTotal.cy = 100;
	m_eff_view->SetScrollSizes(MM_TEXT, sizeTotal);
	//m_eff_view->m_first_eff_offset=(int)m_width/2;
	m_eff_view->MoveWindow(&rect0);

	m_prd_view->m_eff_view=m_eff_view;
	m_eff_view->m_prd_view=m_prd_view;
	m_eff_view->m_api=m_api;
	m_eff_view->m_eff_mgr_dlg=this;
	m_eff_view->m_eff_mode=m_eff_mode;
	m_eff_view->m_pixelsInItem=m_width;

	if(m_pdf->GetAccessmode()<aplRO)
	{
		CString sState;
		m_api->m_data.GetAttr(m_pdf,m_api->m_prd_mgr.a_apl_pdf_state,sState);
		if(sState==_T("") || sState==_T("working"))  m_eff_view->m_bReadOnly=false;
	}

	CRect r;
	r.top=rect0.top;
	r.bottom = rect0.bottom;
	r.left = rect.right;
	r.right = rect0.left;
	m_wndVSplitterBar.Create(WS_VISIBLE|WS_CHILD,r,this,IDC_SPLITTER);
	m_wndVSplitterBar.SetPanes(m_prd_view,m_eff_view);
	m_wndVSplitterBar.ShowWindow(SW_SHOW);

	AddAnchor(IDC_SPLITTER,TOP_LEFT,BOTTOM_LEFT);
	AddAnchor(IDC_PRD_LIST_VIEW,TOP_LEFT,BOTTOM_LEFT);
	AddAnchor(IDC_EFF_VIEW,TOP_LEFT,BOTTOM_RIGHT);

	m_prd_view->RefreshSubPrdList();
	CRect cl_rect;
	GetWindowRect(cl_rect);
	MoveWindow(cl_rect);
	
	return TRUE;  
}

void CManagerEffGanttDlg::OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int tab_sel=m_tab.GetCurSel();
	if(tab_sel==0) m_eff_mode=APL_EFF_DATE;
	else m_eff_mode=APL_EFF_SN;
	m_eff_view->m_eff_mode=m_eff_mode;
	m_eff_view->Update(true,true);
	
	*pResult = 0;
}

void CManagerEffGanttDlg::OnChangeEditwidth() 
{
	UpdateData(TRUE);
	m_eff_view->m_pixelsInItem=m_width;
	m_eff_view->Update(true);
	
}

void CManagerEffGanttDlg::OnDeltaposSpinwidth(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	pNMUpDown->iDelta*=5;//  5
	//   
	if ((m_width<m_eff_view->m_min_pixels_in_item)&(pNMUpDown->iDelta<0)) return;
	//   
	m_width=m_width+pNMUpDown->iDelta;
	m_eff_view->m_pixelsInItem=m_width;
	UpdateData(false);
	m_eff_view->Update(true);
	*pResult = 0;
}

void CManagerEffGanttDlg::OnCancel() 
{
	m_api->SaveChanges();
	
	CResizableDialog ::OnCancel();
}
