#if !defined(AFX_PRODUCTCOMPARE_H__80491025_6B3F_48BC_BAD8_0720324EBBF5__INCLUDED_)
#define AFX_PRODUCTCOMPARE_H__80491025_6B3F_48BC_BAD8_0720324EBBF5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ProductCompare.h : header file
//
#include "resource.h"
#include <apl_gui.h>
#include "apl_api.h"
#include "ResizableDialog.h" 

/////////////////////////////////////////////////////////////////////////////
// CProductCompare dialog

class CProductCompare : public CResizableDialog
{
protected:
	class CProductCompareItem
	{
	public:
		CaplInstance *pdf;
		CaplInstance *pBasisOrComplectation;
		COleDateTime dt;
		CString sn;
		CaplInstance *context;

		CProductCompareItem(){pdf = NULL; pBasisOrComplectation = NULL; context=0; dt.SetStatus(COleDateTime::null);}
		CProductCompareItem(CaplInstance *inst){pdf = inst; pBasisOrComplectation = NULL; context = NULL; dt.SetStatus(COleDateTime::null);}
	};

	class CProductStructCompareResultItem
	{
	public:
		CaplInstance *pdf;
		CaplInstance *unit;
		CArray <double,double> values;
		CProductStructCompareResultItem(){pdf=0;unit=0;};
	};
	CaplTAggr <CProductStructCompareResultItem*,CProductStructCompareResultItem*,
		APLAGGR_LIST|APLAGGR_AUTOKILLREF> m_struct_res_items;

	class CProductCharactCompareResultItem
	{
	public:
		CaplInstance *charact;
		CaplInstance *type;
		CStringArray values;
		CProductCharactCompareResultItem(){charact=0;type=0;};
	};
	CaplTAggr <CProductCharactCompareResultItem*,CProductCharactCompareResultItem*,
		APLAGGR_LIST|APLAGGR_AUTOKILLREF> m_charact_res_items;

// Construction
public:
	void FillPrd(aplExtent &ext);
	void AddPdf(CaplInstance *pdf);

	void CompareProductChar();
	void CompareProductCount();
	bool MoveRow(int delta);
	CProductCompare(CWnd* pParent = NULL);   // standard constructor

	void DrawStructCompareResult();
	void DrawCharactCompareResult();
// Dialog Data
	//{{AFX_DATA(CProductCompare)
	enum { IDD = IDD_PRODUCTCMP };
	CStatic	m_st_comp_type;
	CComboBox	m_comp_type_ctrl;
	CStatic	m_satic_fon;
	CaplButton	m_bottom_btn;
	CaplButton	m_top_btn;
	CaplButton	m_save_btn;
	CaplButton	m_del_btn;
	CaplButton	m_add_btn;
	CaplButton	m_comp_sel_btn;
	CaplButton	m_cmp_btn;
	CaplButton m_dubl_btn;
	CListCtrl	m_prd_list;
	CButton	m_diff;
	CTabCtrl	m_tab;
	CaplButton	m_cancel_btn;
	//}}AFX_DATA
	CSortListCtrl	m_cmp_prd_sost;
	CSortListCtrl	m_cmp_prd_char;

	CaplAPI *m_api;

	aplExtent inExt;
	aplExtent m_loaded_pdf;
	
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CProductCompare)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	int  m_last_comp_type;
	bool m_bInit, m_bComparedSost,m_bComparedCharact,m_bFromBase;

	void ClearCompareSostResult();

	// Generated message map functions
	//{{AFX_MSG(CProductCompare)
	afx_msg void OnCmp();
	virtual BOOL OnInitDialog();
	afx_msg void OnAdd();
	afx_msg void OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDelete();
	afx_msg void OnDblclkListproduct(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnShowOnlyDiff();
	afx_msg void OnCompareSelected();
	afx_msg void OnSaveToFile();
	afx_msg void OnDestroy();
	afx_msg void OnTop();
	afx_msg void OnBottom();
	afx_msg void OnSelchangeCompType();
	afx_msg void OnDubl();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PRODUCTCOMPARE_H__80491025_6B3F_48BC_BAD8_0720324EBBF5__INCLUDED_)
