#pragma once
#include <afxhtml.h>
#include "Resource.h"
#include "RequirementPropertiesDlg.h"


// CRequirementPropertiesDlgEx dialog
typedef std::set<CaplInstance*> DocsSet;
typedef std::map<CaplInstance*, DocsSet> StageDocMap;

class CRequirementPropertiesDlgEx : public CRequirementPropertiesDlg
{
	DECLARE_DYNAMIC(CRequirementPropertiesDlgEx)

public:
	CRequirementPropertiesDlgEx(CaplAPI *api, CaplInstance *ciReq, CaplInstance *ciParent, CWnd* pParent = NULL);   // standard constructor
	virtual ~CRequirementPropertiesDlgEx();

// Dialog Data
	enum { IDD = IDD_REQUIREMENT_PROP_EX };		

	CFListCtrl m_list;
	aplExtent m_newStages;
	aplExtent m_deletedDocRefs;
	StageDocMap m_stageDocuments;
	CaplInstance *m_cfgObject;

	CEdit m_cfgObjEdit;

	CaplButton m_addStageBtn;
	CaplButton m_propStageBtn;
	CaplButton m_delStageBtn;
	CaplButton m_setCfgObjBtn;
	CaplButton m_delCfgObjBtn;

	void InitButtons();
	void InitList();
	void LoadStages();
	void AddStage(CaplInstance *reqStage, HFROW row);
	void SetCfgObject(CaplInstance *object);
	CaplInstance* GetSystemOfOptions();

protected:	

	virtual void VirtualDDX(CDataExchange* pDX) override;
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void AddAnchorVirtual() override;
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();	

	DECLARE_MESSAGE_MAP()	

	afx_msg void OnAddStage();
	afx_msg void OnBnClickedEditStage();
	afx_msg void OnBnClickedDelStage();
	afx_msg void OnBnClickedChooseCfgObject();
	afx_msg void OnBnClickedDelCfgObject();
};
