// KVZIssueConfirmdlg.cpp : implementation file
//

#include "stdafx.h"
#include "RequirementStageDlg.h"


// CCancelOrderIssueDlg dialog

IMPLEMENT_DYNAMIC(CRequirementStageDlg, CaplResizableDialog)

CRequirementStageDlg::CRequirementStageDlg(CaplAPI *api, CaplInstance *reqStage, aplExtent &documents, CWnd* pParent /*=NULL*/)
:	CaplResizableDialog(CRequirementStageDlg::IDD, pParent), m_api(api), m_reqStage(reqStage), m_documents(documents)
{
	m_project = 0;
}

CRequirementStageDlg::~CRequirementStageDlg()
{
}

void CRequirementStageDlg::DoDataExchange(CDataExchange* pDX)
{
	__super::DoDataExchange(pDX);

	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDC_SELECT_STAGE, m_selectStageBtn);
	DDX_Control(pDX, IDC_ADD_DOC, m_addDocBtn);
	DDX_Control(pDX, IDC_PROP_DOC, m_propDocBtn);
	DDX_Control(pDX, IDC_DEL_DOC, m_delDocBtn);
	DDX_Control(pDX, IDC_STAGE, m_stageEdit);
	DDX_Control(pDX, IDC_CLEAR_STAGE, m_clearStageBtn);
	DDX_Control(pDX, IDC_ADD_EMPTY_DOC, m_addEmptyDocBtn);
	DDX_Control(pDX, IDC_LIST, m_list);
	DDX_Control(pDX, IDC_MOS, m_MOS);
}

BEGIN_MESSAGE_MAP(CRequirementStageDlg, CaplResizableDialog)	
	ON_BN_CLICKED(IDC_SELECT_STAGE, OnBnClickedSelectStage)
	ON_BN_CLICKED(IDC_CLEAR_STAGE, OnBnClickedClearStage)
	ON_BN_CLICKED(IDC_ADD_DOC, OnBnClickedAddDoc)
	ON_BN_CLICKED(IDC_PROP_DOC, OnBnClickedPropDoc)
	ON_BN_CLICKED(IDC_DEL_DOC, OnBnClickedDelDoc)
END_MESSAGE_MAP()

BOOL CRequirementStageDlg::OnInitDialog()
{
	__super::OnInitDialog();

	InitButtons();
	InitList();
	FillMOS();

	LoadMOS();
	LoadStage();
	LoadDocuments();
	
	return TRUE;
}

void CRequirementStageDlg::InitButtons()
{
	InitOkCancelButton(m_okBtn, m_cancelBtn);

	m_selectStageBtn.SetFlat(FALSE);
	m_addDocBtn.SetFlat(FALSE);
	m_propDocBtn.SetFlat(FALSE);
	m_delDocBtn.SetFlat(FALSE);
	m_clearStageBtn.SetFlat(FALSE);
	m_addEmptyDocBtn.SetFlat(FALSE);

	m_selectStageBtn.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_addDocBtn.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_addEmptyDocBtn.SetIcon(aplGetButtonIco(APL_24_PLUS));
	m_propDocBtn.SetIcon(aplGetButtonIco(APL_24_PROPERTIES));
	m_delDocBtn.SetIcon(aplGetButtonIco(APL_24_DELETE));
	m_clearStageBtn.SetIcon(aplGetButtonIco(APL_24_DELETE));
}

void CRequirementStageDlg::FillMOS()
{
	if(0 == m_MOS.GetSafeHwnd())
		return;

	//     
	CaplInstance *option = m_api->m_options_mgr.FindOptionBN(_T("PSS\\\\  "));
	if (option)
	{
		CString clsfID;
		m_api->m_data.GetAttr(option, m_api->m_options_mgr.a_str_value, clsfID);

		if (clsfID.IsEmpty() == false)
		{
			CaplInstance *system =  m_api->m_classifier_mgr.GetClassifierSystemById(clsfID, true);
			if (system)
			{
				aplExtent levels;
				m_api->m_classifier_mgr.LoadSubClassifierLevels(system, levels, false, true);

				std::vector<CString> vec;
				for (int i = 0; i < levels.Size; ++i)
				{
					CString id, name, value;
					m_api->m_data.GetAttr(levels[i], m_api->m_classifier_mgr.a_apl_classifier_level_id, id);
					m_api->m_data.GetAttr(levels[i], m_api->m_classifier_mgr.a_apl_classifier_level_name, name);

					value = id + _T(" - " + name);
					vec.push_back(value);
				}

				for (unsigned int i = 0; i < vec.size(); ++i)
					m_MOS.InsertString(i, vec[i]);

				m_MOS.SetCurSel(0);
				return;
			}
		}
	}

	// ,    
	m_MOS.InsertString(0,  APL_T("0 - .    "));
	m_MOS.InsertString(1,  APL_T("1 - .    "));
	m_MOS.InsertString(2,  APL_T("2 - .  -  / "));
	m_MOS.InsertString(3,  APL_T("3 - .  -  "));
	m_MOS.InsertString(4,  APL_T("4 -  -  / "));
	m_MOS.InsertString(5,  APL_T("5 -  - "));
	m_MOS.InsertString(6,  APL_T("6 -  - "));
	m_MOS.InsertString(7,  APL_T("7 -  - "));
	m_MOS.InsertString(8,  APL_T("8 -  "));
	m_MOS.InsertString(9,  APL_T("9 -  "));

	m_MOS.SetCurSel(0);	
}

void CRequirementStageDlg::LoadMOS()
{
	if(m_reqStage)
	{
		CString mos;
		m_api->m_data.GetAttr(m_reqStage, m_api->m_req_mgr.a_req_stage_mos, mos);
		m_MOS.SelectString(-1, mos);
	}
}

void CRequirementStageDlg::LoadStage()
{
	if(m_reqStage)
	{
		CaplInstance *project = 0;
		m_api->m_data.GetAttr(m_reqStage, m_api->m_req_mgr.a_req_stage_project, project);
		SetProject(project);
	}
}

void CRequirementStageDlg::LoadDocuments()
{
	for(int i=0; i<m_documents.Size; ++i)
		AddDocument(m_documents[i]);
}

void CRequirementStageDlg::SaveDocuments()
{
	m_documents.Clear();
	for(int i=0; i<m_list.GetItemCount(); ++i)
	{
		CaplInstance *document = reinterpret_cast<CaplInstance*>(m_list.GetItemData(i));
		if(0 == document)
			continue;

		m_documents.Add(document);
	}
}

void CRequirementStageDlg::AddDocument(CaplInstance *document)
{
	//           
	for(int i=0; i<m_list.GetItemCount(); ++i)
	{
		if(document == reinterpret_cast<CaplInstance*>(m_list.GetItemData(i)))
			return;
	}
		
	CString id, name;
	m_api->m_data.GetAttr(document, m_api->m_doc_mgr.a_doc_id, id);
	m_api->m_data.GetAttr(document, m_api->m_doc_mgr.a_doc_name, name);

	int index = m_list.InsertItem(m_list.GetItemCount(), _T(""), ICON_DOCUMENT);
	m_list.SetItemData(index, (DWORD)document);

	m_list.SetItemText(index, 0, id);
	m_list.SetItemText(index, 1, name);
}

void CRequirementStageDlg::InitList()
{
	CRect rect;
	m_list.GetClientRect(rect);

	m_list.InsertColumn(0,  APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.4));
	m_list.InsertColumn(1,  APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.5));
	
	m_list.SetExtendedStyle(m_list.GetExtendedStyle()|LVS_EX_FULLROWSELECT|
		LVS_EX_SUBITEMIMAGES | LVS_EX_GRIDLINES);	
}

void CRequirementStageDlg::OnOK()
{
	if(0 == m_reqStage)
	{
		m_reqStage = m_api->m_data.CreateInstance(m_api->m_req_mgr.e_requirement_stage);		
	}

	//  
	CString mos;
	m_MOS.GetWindowText(mos);

	m_api->m_data.PutAttr(m_reqStage, m_api->m_req_mgr.a_req_stage_project, m_project);
	m_api->m_data.PutAttr(m_reqStage, m_api->m_req_mgr.a_req_stage_mos, mos);

	//   
	SaveDocuments();

	m_api->SaveChanges();
	__super::OnOK();
}

void CRequirementStageDlg::SetProject(CaplInstance *project)
{
	m_project = project;

	if(m_project)
	{
		CString id;
		m_api->m_data.GetAttr(project, m_api->m_project_mgr->a_project_id, id);
		m_stageEdit.SetWindowText(id);
	}
	else
	{
		m_stageEdit.SetWindowText(_T(""));
	}
}

void CRequirementStageDlg::OnBnClickedSelectStage()
{
	CaplInstance *project = m_api->m_prd_mgr.SelectInstance(APL_MODE_SELECT_PROJECT, _T(" "));
	SetProject(project);
}

void CRequirementStageDlg::OnBnClickedClearStage()
{
	SetProject(0);
}

void CRequirementStageDlg::OnBnClickedAddDoc()
{
	CaplInstance *document = m_api->m_prd_mgr.SelectInstance(APL_MODE_SELECT_DOC, _T(" "));
	AddDocument(document);
}

void CRequirementStageDlg::OnBnClickedPropDoc()
{
	int index = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(-1 == index)
		return;

	CaplInstance *document = reinterpret_cast<CaplInstance*>(m_list.GetItemData(index));
	if(0 == document)
		return;	

	m_api->m_doc_mgr.ShowDocProperties(document);
}

void CRequirementStageDlg::OnBnClickedDelDoc()
{
	int index = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(-1 == index)
		return;

	CaplInstance *document = reinterpret_cast<CaplInstance*>(m_list.GetItemData(index));
	if(0 == document)
		return;

	if(AfxMessageBox(APL_T("   ?"), MB_ICONSTOP|MB_YESNO) == IDNO)
		return;

	m_list.DeleteItem(index);
}
