#if !defined(AFX_SELECTINSTDLG_H__104C4300_A9B9_4576_B96F_BBD9F26C3145__INCLUDED_)
#define AFX_SELECTINSTDLG_H__104C4300_A9B9_4576_B96F_BBD9F26C3145__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// SelectInstDlg.h : header file
//
#include "resource.h"
#include "apl_api.h"
#include "ResizableDialog.h" 
#include "SelectInstanceView.h"
#include <apl_gui.h>
/////////////////////////////////////////////////////////////////////////////
// CSelectInstDlg dialog
class CaplNetStepData;

class CItemData
{
public:
	CItemData(){inst=0;item=fictive=0;};
	CItemData(CaplInstance *_inst,HTREEITEM _item,HTREEITEM _fictive)
		{inst=_inst;item=_item;fictive=_fictive;};
	~CItemData(){};

	CaplInstance *inst;
	HTREEITEM item;
	HTREEITEM fictive;
	aplExtent ext;
};

class CSelectInstDlg : public CResizableDialog
{
// Construction
public:
	CSelectInstDlg(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CSelectInstDlg)
	enum { IDD = IDD_SECECT_INST };
	CaplButton	m_inst_show_btn;
	CaplButton	m_viewDocBtn;
	CaplButton	m_findBtn;
	CaplButton	m_showVerBtn;
	CaplButton	m_showPrdBtn;
	CaplButton	m_showCharBtn;
	CaplButton	m_showDocsBtn;
	CaplButton	m_showActsBtn;
	CaplButton	m_create_folder_btn;
	CaplButton	m_cancel_btn;
	CaplButton	m_ok_btn;
	CTreeCtrl	m_tree;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSelectInstDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
public:
	void RemoveItemsFromTree(HTREEITEM item, CaplOldSelInstItem *parent=0, bool bSaveItems=false);
	void FillRevisionTree(HTREEITEM item, aplExtent& rev_ext);
	void FillPersonOrgTree(HTREEITEM item);
	void ExpandQueries(HTREEITEM item);

	// Generated message map functions
	//{{AFX_MSG(CSelectInstDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnItemexpandingObjTree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDestroy();
	afx_msg void OnSelchangedObjTree(NMHDR* pNMHDR, LRESULT* pResult);
	virtual void OnOK();
	afx_msg void OnCreateFolder();
	afx_msg void OnShowPrds();
	afx_msg void OnShowChrs();
	afx_msg void OnShowDocs();
	afx_msg void OnShowVers();
	afx_msg void OnShowActs();
	afx_msg void OnFindButton();
	afx_msg void OnViewDocument();
	afx_msg void OnShowInsts();
	afx_msg void OnDblclkObjTree(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

	HTREEITEM m_folders_item;
	HTREEITEM m_pers_folders_item;
	HTREEITEM m_categories_item;
	HTREEITEM m_query_item;
	HTREEITEM m_perorg_item;
	HTREEITEM m_classifier_item;
	CImageList imagelist;
	CImageList m_icons;
	bool m_NoExpand;

	static int CALLBACK CompareHtreeItem(LPARAM lParam1, LPARAM lParam2,LPARAM lParamSort);
	
	static aplObjVertonInfo m_ItemVertionInfo;
	static void SetObjVertionInfo(aplObjVersionType type, int ico, CaplAttr* id, CaplAttr* base, CaplAttr* obj, CaplAttr* active);
	static void ClearObjVertionInfo();

public:

	CaplAPI *m_api;

	aplExtent *m_base_items;
	aplExtent m_query_ext;
	
	CString m_title;
	bool m_show_ass_doc;

	CaplTAggr <CaplOldSelInstItem*,CaplOldSelInstItem*,
			APLAGGR_UNIQUE|APLAGGR_LIST|APLAGGR_AUTOKILLREF> *m_old_items;

	long m_mode;
	CaplInstance *m_sel_inst,*m_cur_inst, *m_sel_doc;

	HTREEITEM InsertPrdInTree(HTREEITEM parent, CaplInstance *prd);
	HTREEITEM InsertPdfInTree(HTREEITEM parent, CaplInstance *pdf);
	HTREEITEM InsertDocInTree(HTREEITEM parent, CaplInstance *doc);
	HTREEITEM InsertActionInTree(HTREEITEM parent, CaplInstance *act);
	HTREEITEM InsertRevisionInTree(HTREEITEM parent, CaplInstance *rev);
	HTREEITEM InsertCharInTree(HTREEITEM parent, CaplInstance *chr_ass);
	HTREEITEM InsertProdInstInTree(HTREEITEM parent, CaplInstance *prd_inst);
	HTREEITEM InsertLotInTree(HTREEITEM parent, CaplInstance *lot);
	HTREEITEM InsertQueryInstInTree(HTREEITEM parent, CaplInstance *query);
	
	void InsertInstInTree(CaplInstance* inst,CItemData* dta);
	HTREEITEM Find(CaplInstance* inst_prev,HTREEITEM item=0);

	CImageList m_btnImglst;
	bool m_bShPrd;
	bool m_bShPdf;
	bool m_bShDoc;
	bool m_bShDocVer;
	bool m_bShAct;

	void InitExpand(HTREEITEM item);
};

HTREEITEM InsertFictiveItem(CTreeCtrl *tree,HTREEITEM  item);

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SELECTINSTDLG_H__104C4300_A9B9_4576_B96F_BBD9F26C3145__INCLUDED_)
