// SelectInstanceFrame.cpp : implementation file
//

#include "stdafx.h"
#include "SelectInstanceFrame.h"
#include "SelectInstanceView.h"
#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectInstanceFrame

IMPLEMENT_DYNCREATE(CSelectInstanceFrame, CFrameWnd)

CSelectInstanceFrame::CSelectInstanceFrame()
	: m_bShowToolBar(true)
{
}

CSelectInstanceFrame::~CSelectInstanceFrame()
{
}


BEGIN_MESSAGE_MAP(CSelectInstanceFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CSelectInstanceFrame)
	ON_WM_CREATE()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectInstanceFrame message handlers

int CSelectInstanceFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (m_bShowToolBar)
	{
		if (!m_wndToolBar.CreateEx(this,TBSTYLE_FLAT, WS_CHILD|WS_VISIBLE| CBRS_TOOLTIPS|CBRS_TOP
			/*!| CBRS_NOALIGN| CBRS_GRIPPER | CBRS_FLYBY | CBRS_SIZE_DYNAMIC*/,
			CRect(0,0,0,0), AFX_IDW_TOOLBAR) ||
			!m_wndToolBar.LoadToolBar(IDR_SELECTINSTANCE_TOOLBAR))
		{
			TRACE0("Failed to create toolbar\n");
			return -1;      // fail to create
		}
		
		m_wndToolBar.EnableToolTips();
		
		CBitmap bm;
		bm.LoadBitmap(IDB_ELEMBAR16);
		m_il.Create(16, 16, ILC_COLOR24|ILC_MASK, 0, 100);
		m_il.Add(&bm, RGB(192,192,192));
		bm.DeleteObject();
	}

//	m_wndToolBar.GetToolBarCtrl().SetImageList(&m_il);
//	HIMAGELIST tmp_il1=aplImageListCopyAsSpecificBlend((HIMAGELIST)(*m_wndToolBar.GetToolBarCtrl().GetImageList()),50,true);//,RGB(255,255,255));
//	m_ild.Attach(tmp_il1);

//	m_wndToolBar.GetToolBarCtrl().SetDisabledImageList(&m_ild);
		
	return 0;
}

BOOL CSelectInstanceFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	CCreateContext context;
	context.m_pNewViewClass = RUNTIME_CLASS(CSelectInstanceView);

	/*POSITION pos=0;
	CWinApp *app=AfxGetApp(); //    ActiveX  0
	if(0!=app) pos= app->GetFirstDocTemplatePosition();
	if(pos)
	{
		CWinApp *app=AfxGetApp(); //    ActiveX  0
		CDocTemplate* docTmpl=0;
		if(0!=app) docTmpl=app->GetNextDocTemplate(pos);
		if(docTmpl)
		{
			pos= docTmpl->GetFirstDocPosition();
			if(pos) 
			{
				CDocument* doc= docTmpl->GetNextDoc(pos);
				if(doc)
				{
					context.m_pCurrentDoc= doc;
					context.m_pNewDocTemplate= docTmpl;
					context.m_pCurrentFrame= this;
				}
			}
		}
	}*/

	CView* pView = (CView*)CreateView(&context, AFX_IDW_PANE_FIRST);
	if(pView == NULL)
		return FALSE;
	
	SetActiveView(pView, FALSE);
	
	return TRUE;
}

void CSelectInstanceFrame::OnSize(UINT nType, int cx, int cy) 
{
	CFrameWnd::OnSize(nType, cx, cy);
}

