#pragma once


#include "resource.h"
#include "apl_gui.h"
#include "aplNetStepData.h"
#include "ResizableDialog.h"

//   
#define ICON_GROUPE 0
#define ICON_USER 1
#define ICON_CUR_GROUPE 4
#define ICON_CUR_USER 5
#define ICON_NON_GROUPE_USERS 6

// CSelectUsersDlg dialog

class CSelectUsersDlg : public CResizableDialog
{
	DECLARE_DYNAMIC(CSelectUsersDlg)

public:
	CSelectUsersDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CSelectUsersDlg();

	CString m_sTitle;
	CaplAPI *m_api;
	long m_mode;			//  

	CaplInstance* m_inst;
	bool m_bDblCl;

	void SetAnchors();
	void FillTree();


// Dialog Data
	enum { IDD = IDD_SELECT_USERS_DIALOG };
	CTreeCtrl	m_treeCtrl;
	CaplButton	m_cancelBtn;
	CaplButton	m_okBtn;
	CString	m_sTreeTitle;
	CaplButton	m_btnFBegin;
	CaplButton	m_btnFBack;
	CaplButton	m_btnFForward;
	CEdit	m_edFindStr;

protected:
	CArray<HTREEITEM,HTREEITEM> m_list_items_group;
	CArray<HTREEITEM,HTREEITEM> m_list_items_users;

public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);

protected:

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnSelchangedAATree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnFindForward();
	afx_msg void OnFindBack();
	afx_msg void OnButton4Beg();

	DECLARE_MESSAGE_MAP()
public:
	virtual BOOL OnInitDialog();
};
