#if !defined(AFX_SHOWALERTSDLG_H__CA6F8FA1_A022_4CAF_B2A2_5F53BD64E729__INCLUDED_)
#define AFX_SHOWALERTSDLG_H__CA6F8FA1_A022_4CAF_B2A2_5F53BD64E729__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ShowAlertsDlg.h : header file
//
#include "resource.h"
#include "apl_gui.h"
#include "apl_api.h"

class CaplInstance;
class CaplAPI;

#define APL_MODE_RECIEVED 0x00000000
#define APL_MODE_GIVEN	  0x00000001
#define APL_MODE_ADMIN	  0x00000002
/////////////////////////////////////////////////////////////////////////////
// CShowAlertsDlg dialog

class CShowAlertsDlg : public CaplResizableDialog
{
// Construction
public:
	CShowAlertsDlg(CWnd* pParent = NULL);   // standard constructor

	CaplAPI *m_api;
	CaplTreeListCtrlView *m_tree_view;

	long m_mode;
	CSortListCtrl m_alerts_ctrl;
	CaplInstance *m_cur_person;
	
	aplExtent m_rec_alerts;
	aplExtent m_given_alerts;
	aplExtent m_all_alerts;
	bool m_read_only;
	bool m_bIsAdmin;
	bool m_bSelectOutOfBoundsProjects;

	void CreateItem(CaplInstance *alert,const char *id=0);
	void CreateAlert();
	void DeleteAlert(CaplInstance *alert,int nItem);
	bool ShowProperties(CaplInstance *alert,int nItem);
	
	void UpdateAlertsList();
	void RefreshItem(int nItem);
	void SetTablesColumns();
	void EnableButtons();
// Dialog Data
	//{{AFX_DATA(CShowAlertsDlg)
	enum { IDD = IDD_SHOWALERTSDLG_DIALOG };
	CStatic	m_border_ctrl;
	CaplButton	m_cancel_btn;
	CaplButton	m_add_btn;
	CaplButton	m_delete_btn;
	CaplButton	m_properties_btn;
	CTabCtrl m_tab_ctrl;
	CButton m_show_completed_check;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CShowAlertsDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//         aplSocketTransport
	CaplParentWndProcesser m_pwp;

	// Generated message map functions
	//{{AFX_MSG(CShowAlertsDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult); 
	afx_msg void OnDblclkItem(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnShowCompleted(); 
	afx_msg void OnAddBtn();
	afx_msg void OnDeleteBtn();
	afx_msg void OnPropertiesBtn();
	afx_msg void OnSelChangedAlert(NMHDR* pNMHDR, LRESULT* pResult); 
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SHOWALERTSDLG_H__CA6F8FA1_A022_4CAF_B2A2_5F53BD64E729__INCLUDED_)
